/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.spring;

import com.vaadin.flow.di.Lookup;
import com.vaadin.flow.di.LookupInitializer;
import com.vaadin.flow.function.VaadinApplicationInitializationBootstrap;
import com.vaadin.flow.server.VaadinContext;
import com.vaadin.flow.server.VaadinServletContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class SpringLookupInitializer
extends LookupInitializer {
    private static final Object LOCK = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize(VaadinContext context, Map<Class<?>, Collection<Class<?>>> services, VaadinApplicationInitializationBootstrap bootstrap) throws ServletException {
        VaadinServletContext servletContext = (VaadinServletContext)context;
        boolean isContextAvailable = false;
        Object object = LOCK;
        synchronized (object) {
            WebApplicationContext appContext = this.getApplicationContext(context);
            boolean bl = isContextAvailable = appContext != null;
            if (!isContextAvailable) {
                context.setAttribute(BootstrapCallable.class, () -> this.doInitialize((VaadinContext)servletContext, services, bootstrap));
            }
        }
        if (isContextAvailable) {
            this.doInitialize((VaadinContext)servletContext, services, bootstrap);
        }
    }

    protected Lookup createLookup(VaadinContext context, Map<Class<?>, Collection<Class<?>>> services) {
        WebApplicationContext appContext = this.getApplicationContext(context);
        return new SpringLookup(appContext, (spi, impl) -> this.instantiate(appContext, (Class)spi, (Class<?>)impl), services);
    }

    private void doInitialize(VaadinContext context, Map<Class<?>, Collection<Class<?>>> services, VaadinApplicationInitializationBootstrap bootstrap) throws ServletException {
        super.initialize(context, services, bootstrap);
    }

    private WebApplicationContext getApplicationContext(VaadinContext context) {
        VaadinServletContext servletContext = (VaadinServletContext)context;
        WebApplicationContext appContext = WebApplicationContextUtils.getWebApplicationContext((ServletContext)servletContext.getContext());
        if (appContext == null) {
            ApplicationContextWrapper wrapper = (ApplicationContextWrapper)context.getAttribute(ApplicationContextWrapper.class);
            appContext = wrapper == null ? null : wrapper.appContext;
        }
        return appContext;
    }

    private <T> T instantiate(WebApplicationContext context, Class<T> serviceClass, Class<?> impl) {
        Collection beans = context.getBeansOfType(serviceClass).values();
        if (beans.stream().anyMatch(bean -> impl.isInstance(bean))) {
            return null;
        }
        return (T)this.instantiate(serviceClass, impl);
    }

    static class SpringApplicationContextInit
    implements ApplicationContextAware {
        SpringApplicationContextInit() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
            BootstrapCallable callable = null;
            if (applicationContext instanceof WebApplicationContext) {
                Object object = LOCK;
                synchronized (object) {
                    ServletContext servletContext = ((WebApplicationContext)applicationContext).getServletContext();
                    VaadinServletContext vaadinServletContext = new VaadinServletContext(servletContext);
                    callable = (BootstrapCallable)vaadinServletContext.getAttribute(BootstrapCallable.class);
                    vaadinServletContext.removeAttribute(BootstrapCallable.class);
                    ApplicationContextWrapper wrapper = new ApplicationContextWrapper();
                    wrapper.appContext = (WebApplicationContext)applicationContext;
                    vaadinServletContext.setAttribute((Object)wrapper);
                }
            }
            if (callable != null) {
                try {
                    callable.execute();
                }
                catch (ServletException exception) {
                    throw new IllegalStateException(exception);
                }
            }
        }
    }

    private static class SpringLookup
    extends LookupInitializer.LookupImpl {
        private final WebApplicationContext context;

        private SpringLookup(WebApplicationContext context, BiFunction<Class<?>, Class<?>, Object> factory, Map<Class<?>, Collection<Class<?>>> services) {
            super(services, factory);
            this.context = context;
        }

        public <T> T lookup(Class<T> serviceClass) {
            Collection allFound;
            Collection beans = this.context.getBeansOfType(serviceClass).values();
            Object service = super.lookup(serviceClass);
            if (service == null || beans.size() > 0 && service.getClass().getPackage().getName().startsWith("com.vaadin.flow")) {
                allFound = beans;
            } else {
                allFound = new ArrayList(beans.size() + 1);
                allFound.addAll(beans);
                allFound.add(service);
            }
            if (allFound.size() == 0) {
                return null;
            }
            if (allFound.size() == 1) {
                return (T)allFound.iterator().next();
            }
            throw new IllegalStateException("Found several implementations in the classpath for " + serviceClass + " SPI: " + allFound + ". Only one implementation should be registered. Use lookupAll to get all instances of the given type.");
        }

        public <T> Collection<T> lookupAll(Class<T> serviceClass) {
            return Stream.concat(this.context.getBeansOfType(serviceClass).values().stream(), super.lookupAll(serviceClass).stream()).collect(Collectors.toList());
        }
    }

    private static class ApplicationContextWrapper {
        private WebApplicationContext appContext;

        private ApplicationContextWrapper() {
        }
    }

    private static interface BootstrapCallable {
        public void execute() throws ServletException;
    }
}

