/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.spreadsheet.testbench;

import com.vaadin.flow.component.spreadsheet.testbench.AddressUtil;
import com.vaadin.flow.component.spreadsheet.testbench.SheetCellElement;
import com.vaadin.flow.component.spreadsheet.testbench.SheetHeaderElement;
import com.vaadin.testbench.TestBenchElement;
import com.vaadin.testbench.commands.TestBenchCommandExecutor;
import com.vaadin.testbench.elementsbase.Element;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.openqa.selenium.By;
import org.openqa.selenium.Dimension;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.Point;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.WebElement;

@Element(value="vaadin-spreadsheet")
public class SpreadsheetElement
extends TestBenchElement {
    private WebElement sTop;
    private WebElement sBottom;
    private WebElement sRight;
    private Point sLocation;
    private Dimension sSize;

    private Optional<TestBenchElement> getSpreadsheetInShadowRoot() {
        return this.$(TestBenchElement.class).all().stream().filter(el -> el.hasClassName("v-spreadsheet")).findFirst();
    }

    private TestBenchElement findElementInShadowRoot(By by) {
        return this.getSpreadsheetInShadowRoot().map(el -> el.findElement(by)).orElse(null);
    }

    private List<WebElement> findElementsInShadowRoot(By by) {
        return this.getSpreadsheetInShadowRoot().map(el -> el.findElements(by)).orElse(Collections.emptyList());
    }

    public SheetCellElement getCellAt(int row, int column) {
        Object cellSelector = String.format(".col%d.row%d.cell", column, row);
        if (this.findElementsInShadowRoot(By.cssSelector((String)cellSelector)).size() > 1) {
            cellSelector = (String)cellSelector + ".merged-cell";
        }
        TestBenchElement cell = this.findElementInShadowRoot(By.cssSelector((String)cellSelector));
        SheetCellElement cellElement = (SheetCellElement)cell.wrap(SheetCellElement.class);
        cellElement.setParent(this);
        return cellElement;
    }

    public SheetCellElement getCellAt(String cellAddress) {
        Point point = AddressUtil.addressToPoint(cellAddress);
        return this.getCellAt(point.getY(), point.getX());
    }

    public SheetHeaderElement getRowHeader(int rowIndex) {
        TestBenchElement cell = this.findElementInShadowRoot(By.cssSelector((String)String.format(".rh.row%d", rowIndex)));
        return (SheetHeaderElement)cell.wrap(SheetHeaderElement.class);
    }

    public SheetHeaderElement getColumnHeader(int columnIndex) {
        TestBenchElement cell = this.findElementInShadowRoot(By.cssSelector((String)String.format(".ch.col%d", columnIndex)));
        return (SheetHeaderElement)cell.wrap(SheetHeaderElement.class);
    }

    public TestBenchElement getAddressField() {
        return this.findElementInShadowRoot(By.className((String)"addressfield"));
    }

    public TestBenchElement getFormulaField() {
        return this.findElementInShadowRoot(By.className((String)"functionfield"));
    }

    public TestBenchElement getInfoLabel() {
        return this.findElementInShadowRoot(By.className((String)"sheet-tabsheet-infolabel"));
    }

    public void scroll(int scrollTop) {
        this.getBottomRightPane().scroll(scrollTop);
    }

    public void scrollLeft(int scrollLeft) {
        this.getBottomRightPane().scrollLeft(scrollLeft);
    }

    public void scrollSheetsToStart() {
        this.findElementInShadowRoot(By.className((String)"scroll-tabs-beginning")).click();
    }

    public void scrollSheetsToEnd() {
        this.findElementInShadowRoot(By.className((String)"scroll-tabs-end")).click();
    }

    public void scrollSheets(int amount) {
        TestBenchElement target = this.findElementInShadowRoot(By.className((String)(amount > 0 ? "scroll-tabs-right" : "scroll-tabs-left")));
        for (int i = 0; i < amount; ++i) {
            target.click();
        }
    }

    public void selectSheetAt(int sheetIndex) {
        TestBenchElement tabContainer = this.findElementInShadowRoot(By.className((String)"sheet-tabsheet-container"));
        List tabs = tabContainer.findElements(By.cssSelector((String)"*"));
        WebElement target = (WebElement)tabs.get(sheetIndex);
        this.scrollSheetVisible(target);
        target.click();
    }

    public void selectSheet(String sheetName) {
        TestBenchElement tabContainer = this.findElementInShadowRoot(By.className((String)"sheet-tabsheet-container"));
        List tabs = tabContainer.findElements(By.cssSelector((String)"*"));
        for (WebElement tab : tabs) {
            if (!tab.getText().equals(sheetName)) continue;
            this.scrollSheetVisible(tab);
            tab.click();
            break;
        }
    }

    public void addSheet() {
        this.findElementInShadowRoot(By.className((String)"add-new-tab")).click();
    }

    public ContextMenuElement getContextMenu() {
        try {
            WebElement cm = this.getDriver().findElement(By.className((String)"v-contextmenu"));
            return (ContextMenuElement)SpreadsheetElement.wrapElement((WebElement)cm, (TestBenchCommandExecutor)this.getCommandExecutor()).wrap(ContextMenuElement.class);
        }
        catch (WebDriverException e) {
            throw new NoSuchElementException("Context menu not found", (Throwable)e);
        }
    }

    private void scrollSheetVisible(WebElement targetSheet) {
        if (!targetSheet.isDisplayed()) {
            this.scrollSheetsToStart();
            while (!targetSheet.isDisplayed()) {
                this.scrollSheets(1);
            }
        }
    }

    boolean isElementSelected(WebElement element) {
        this.updateSelectionLocationAndSize();
        Point location = element.getLocation();
        int centerX = location.x + element.getSize().getWidth() / 2;
        int centerY = location.y + element.getSize().getHeight() / 2;
        return this.isInSelection(centerX, centerY) || this.isNonCoherentlySelected(element);
    }

    private void findSelectionOutline() {
        this.waitUntil(e -> this.findElementInShadowRoot(By.className((String)"s-top")) != null);
        this.sTop = this.findElementInShadowRoot(By.className((String)"s-top"));
        this.sBottom = this.findElementInShadowRoot(By.className((String)"s-bottom"));
        this.findElementInShadowRoot(By.className((String)"s-left"));
        this.sRight = this.findElementInShadowRoot(By.className((String)"s-right"));
    }

    private boolean isNonCoherentlySelected(WebElement element) {
        return Optional.ofNullable(element.getDomAttribute("class")).orElse("").contains("cell-range") || "solid".equals(element.getCssValue("outline-style"));
    }

    private void updateSelectionLocationAndSize() {
        if (this.sTop == null) {
            this.findSelectionOutline();
        }
        this.sLocation = this.sTop.getLocation();
        int bottomY = this.sBottom.getLocation().getY();
        int bottomH = this.sBottom.getSize().getHeight();
        int rightX = this.sRight.getLocation().getX();
        int rightW = this.sRight.getSize().getWidth();
        this.sSize = new Dimension(rightX + rightW - this.sLocation.getX(), bottomY + bottomH - this.sLocation.getY());
    }

    private boolean isInSelection(int locationX, int locationY) {
        if (locationX < this.sLocation.getX() || locationY < this.sLocation.getY()) {
            return false;
        }
        return locationX - this.sLocation.getX() <= this.sSize.getWidth() && locationY - this.sLocation.getY() <= this.sSize.getHeight();
    }

    public WebElement getCellValueInput() {
        return this.findElementInShadowRoot(By.id((String)"cellinput"));
    }

    public boolean isPopupButtonPopupVisible() {
        List elements = this.getDriver().findElements(By.className((String)"v-spreadsheet-popupbutton-overlay"));
        return !elements.isEmpty();
    }

    private TestBenchElement getBottomRightPane() {
        return SpreadsheetElement.wrapElement((WebElement)this.findElementInShadowRoot(By.className((String)"bottom-right-pane")), (TestBenchCommandExecutor)this.getCommandExecutor());
    }

    public static class ContextMenuElement
    extends TestBenchElement {
        public WebElement getItem(String text) {
            return this.findElement(By.xpath((String)(".//table//tr[*]//td//div[contains(text(), \"" + text + "\")]")));
        }
    }
}

