/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.spreadsheet.testbench;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openqa.selenium.Point;

public class AddressUtil
implements Serializable {
    private static final Pattern ADDRESS_RANGE_PATTERN = Pattern.compile("([A-Z]+)(\\d+):([A-Z]+)(\\d+)");
    private static final Pattern ADDRESS_PATTERN = Pattern.compile("([A-Z]+)(\\d+)");

    public static Point addressToPoint(String address) {
        Matcher m = ADDRESS_PATTERN.matcher(address);
        m.find();
        int col = AddressUtil.charAddressToInt(m.group(1));
        int row = Integer.parseInt(m.group(2));
        return new Point(col, row);
    }

    public static Set<Point> addressRangeToPoints(String addressRange) {
        Matcher m = ADDRESS_RANGE_PATTERN.matcher(addressRange);
        m.find();
        int left = AddressUtil.charAddressToInt(m.group(1));
        int top = Integer.parseInt(m.group(2));
        int right = AddressUtil.charAddressToInt(m.group(3));
        int bottom = Integer.parseInt(m.group(4));
        HashSet<Point> points = new HashSet<Point>();
        for (int col = left; col <= right; ++col) {
            for (int row = top; row <= bottom; ++row) {
                points.add(new Point(col, row));
            }
        }
        return points;
    }

    private static int charAddressToInt(String address) {
        int result = 0;
        String reversed = new StringBuffer(address.toUpperCase()).reverse().toString();
        for (int i = 0; i < reversed.length(); ++i) {
            result = (int)((double)result + (double)(reversed.charAt(i) - 65 + 1) * Math.pow(26.0, i));
        }
        return result;
    }
}

