/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.spreadsheet.charts.converter.xssfreader;

import com.vaadin.flow.component.spreadsheet.Spreadsheet;
import com.vaadin.flow.component.spreadsheet.charts.converter.Utils;
import com.vaadin.flow.component.spreadsheet.charts.converter.chartdata.BarSeriesData;
import com.vaadin.flow.component.spreadsheet.charts.converter.chartdata.ColumnSeriesData;
import com.vaadin.flow.component.spreadsheet.charts.converter.chartdata.Stacking;
import com.vaadin.flow.component.spreadsheet.charts.converter.xssfreader.AbstractSeriesReader;
import org.apache.xmlbeans.XmlObject;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTBar3DChart;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTBarChart;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTBarDir;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTBarGrouping;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTBarSer;
import org.openxmlformats.schemas.drawingml.x2006.chart.STBarDir;
import org.openxmlformats.schemas.drawingml.x2006.chart.STBarGrouping;

public class BarSeriesReader
extends AbstractSeriesReader<CTBarSer, ColumnSeriesData> {
    public BarSeriesReader(CTBarChart ctChart, Spreadsheet spreadsheet, boolean showDataInHiddenCells) {
        super((XmlObject)ctChart, spreadsheet, showDataInHiddenCells);
    }

    public BarSeriesReader(CTBar3DChart ctChart, Spreadsheet spreadsheet, boolean showDataInHiddenCells) {
        super((XmlObject)ctChart, spreadsheet, true, showDataInHiddenCells);
    }

    private CTBarDir getBarDir() {
        return (CTBarDir)Utils.callMethodUsingReflection(this.getChart(), "getBarDir");
    }

    private CTBarGrouping getGrouping() {
        return (CTBarGrouping)Utils.callMethodUsingReflection(this.getChart(), "getGrouping");
    }

    @Override
    protected ColumnSeriesData createSeriesDataObject(CTBarSer serie) {
        if (this.getBarDir().getVal() == STBarDir.BAR) {
            return new BarSeriesData();
        }
        return new ColumnSeriesData();
    }

    @Override
    protected void fillSeriesData(ColumnSeriesData seriesData, CTBarSer serie) {
        CTBar3DChart chart;
        super.fillSeriesData(seriesData, serie);
        if (this.getChart() instanceof CTBarChart) {
            CTBarChart chart2 = (CTBarChart)this.getChart();
            if (chart2.getVaryColors() != null && chart2.getVaryColors().getVal()) {
                seriesData.isColorByPoint = true;
            }
        } else if (this.getChart() instanceof CTBar3DChart && (chart = (CTBar3DChart)this.getChart()).getVaryColors() != null && chart.getVaryColors().getVal()) {
            seriesData.isColorByPoint = true;
        }
        seriesData.stacking = this.getStacking(this.getGrouping().getVal());
    }

    private Stacking getStacking(STBarGrouping.Enum grouping) {
        if (grouping == STBarGrouping.PERCENT_STACKED) {
            return Stacking.PERCENT;
        }
        if (grouping != STBarGrouping.CLUSTERED && grouping != STBarGrouping.STANDARD && grouping == STBarGrouping.STACKED) {
            return Stacking.NORMAL;
        }
        return Stacking.NONE;
    }
}

