/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.spreadsheet.charts.converter.confwriter;

import com.vaadin.flow.component.charts.model.Configuration;
import com.vaadin.flow.component.charts.model.DataSeries;
import com.vaadin.flow.component.charts.model.Pane;
import com.vaadin.flow.component.charts.model.YAxis;
import com.vaadin.flow.component.charts.model.style.Color;
import com.vaadin.flow.component.charts.model.style.SolidColor;
import com.vaadin.flow.component.charts.model.style.Style;
import com.vaadin.flow.component.spreadsheet.charts.converter.chartdata.RadarSeriesData;
import com.vaadin.flow.component.spreadsheet.charts.converter.confwriter.AreaSeriesDataWriter;
import com.vaadin.flow.component.spreadsheet.charts.converter.confwriter.LineSeriesWriterUtils;

public class RadarSeriesWriter
extends AreaSeriesDataWriter {
    public RadarSeriesWriter(RadarSeriesData series) {
        super(series);
    }

    @Override
    protected void configureChart(Configuration conf) {
        super.configureChart(conf);
        conf.getChart().setPolar(Boolean.valueOf(true));
        Pane pane = new Pane();
        pane.setSize("60%");
        conf.addPane(pane);
        YAxis yaxs = new YAxis();
        conf.addyAxis(yaxs);
        yaxs.setGridLineInterpolation("polygon");
        Style style = new Style();
        style.setFontSize("75%");
        conf.getxAxis().getLabels().setStyle(style);
    }

    @Override
    protected void configureDataSeries(DataSeries dataSeriesForWriting) {
        super.configureDataSeries(dataSeriesForWriting);
        if (!this.getSeriesData().filled) {
            this.getPlotOptions().setFillColor((Color)new SolidColor(0, 0, 0, 0.0));
        }
        this.getPlotOptions().setDashStyle(LineSeriesWriterUtils.getDashStyle(this.getSeriesData().dashStyle));
        this.getPlotOptions().setMarker(LineSeriesWriterUtils.getMarker(this.getSeriesData().markerSymbol));
    }
}

