/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.spreadsheet;

import com.vaadin.flow.component.spreadsheet.ColorConverter;
import com.vaadin.flow.component.spreadsheet.ColorConverterUtil;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.apache.poi.ss.usermodel.BorderFormatting;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.ConditionalFormattingRule;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.xssf.model.ThemesTable;
import org.apache.poi.xssf.usermodel.XSSFBorderFormatting;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFColor;
import org.apache.poi.xssf.usermodel.XSSFConditionalFormattingRule;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.apache.poi.xssf.usermodel.extensions.XSSFCellBorder;
import org.apache.poi.xssf.usermodel.extensions.XSSFCellFill;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTBorder;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTColor;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTDxf;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTFont;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTXf;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XSSFColorConverter
implements ColorConverter {
    private static final Logger LOGGER = LoggerFactory.getLogger(XSSFColorConverter.class);
    private String defaultBackgroundColor;
    private String defaultColor;
    private XSSFWorkbook workbook;

    public XSSFColorConverter(XSSFWorkbook workbook) {
        this.workbook = workbook;
        workbook.getTheme();
    }

    @Override
    public void colorStyles(CellStyle cellStyle, StringBuilder sb) {
        String color;
        XSSFColor xssfColor;
        XSSFCellStyle cs = (XSSFCellStyle)cellStyle;
        XSSFColor fillBackgroundXSSFColor = cs.getFillBackgroundXSSFColor();
        XSSFColor fillForegroundXSSFColor = cs.getFillForegroundXSSFColor();
        String backgroundColor = null;
        if (fillForegroundXSSFColor != null && !fillForegroundXSSFColor.isAuto()) {
            backgroundColor = this.styleColor(fillForegroundXSSFColor);
        } else if (fillBackgroundXSSFColor != null && !fillBackgroundXSSFColor.isAuto()) {
            backgroundColor = this.styleColor(fillBackgroundXSSFColor);
        }
        if (backgroundColor != null && !backgroundColor.equals(this.defaultBackgroundColor)) {
            sb.append("background-color:");
            sb.append(backgroundColor);
        }
        if ((xssfColor = cs.getFont().getXSSFColor()) != null && (color = this.styleColor(xssfColor)) != null && !color.equals(this.defaultColor)) {
            sb.append("color:");
            sb.append(color);
        }
    }

    @Override
    public String getBorderColorCSS(XSSFCellBorder.BorderSide borderSide, String attr, CellStyle cellStyle) {
        StringBuilder sb = new StringBuilder();
        XSSFColor color = cellStyle instanceof XSSFCellStyle && !((XSSFCellStyle)cellStyle).getCoreXf().getApplyBorder() ? this.getBorderColor((XSSFCellStyle)cellStyle, borderSide) : ((XSSFCellStyle)cellStyle).getBorderColor(borderSide);
        sb.append(attr);
        sb.append(":");
        if (color == null || color.isAuto()) {
            sb.append("var(--default-color);");
            return sb.toString();
        }
        byte[] argb = color.getARGB();
        if (argb == null) {
            sb.append("var(--default-color);");
            return sb.toString();
        }
        double tint = color.getTint();
        if (tint != 0.0) {
            argb[1] = this.applyTint(argb[1] & 0xFF, tint);
            argb[2] = this.applyTint(argb[2] & 0xFF, tint);
            argb[3] = this.applyTint(argb[3] & 0xFF, tint);
        }
        try {
            String temp = ColorConverterUtil.toRGBA(argb);
            sb.append(temp);
        }
        catch (NumberFormatException nfe) {
            LOGGER.trace(nfe.getMessage() + " " + String.valueOf(nfe.getCause()), (Throwable)nfe);
            sb.append(String.format("#%02x%02x%02x;", argb[1], argb[2], argb[3]));
        }
        return sb.toString();
    }

    @Override
    public String getBorderColorCSS(XSSFCellBorder.BorderSide borderSide, String attr, BorderFormatting format) {
        byte[] argb;
        XSSFBorderFormatting casted = (XSSFBorderFormatting)format;
        CTColor color = this.getBorderColor(casted, borderSide);
        StringBuilder sb = new StringBuilder();
        sb.append(attr);
        sb.append(":");
        if (color == null || color.getAuto()) {
            sb.append("var(--default-color);");
            return sb.toString();
        }
        if (color.isSetTheme()) {
            XSSFColor themeColor = this.workbook.getTheme().getThemeColor((int)color.getTheme());
            argb = themeColor.getARGB();
        } else {
            argb = color.getRgb();
        }
        if (argb == null) {
            sb.append("var(--default-color);");
            return sb.toString();
        }
        double tint = color.getTint();
        if (tint != 0.0) {
            argb[1] = this.applyTint(argb[1] & 0xFF, tint);
            argb[2] = this.applyTint(argb[2] & 0xFF, tint);
            argb[3] = this.applyTint(argb[3] & 0xFF, tint);
        }
        try {
            String temp = ColorConverterUtil.toRGBA(argb);
            sb.append(temp);
        }
        catch (NumberFormatException nfe) {
            LOGGER.trace(nfe.getMessage() + " " + String.valueOf(nfe.getCause()), (Throwable)nfe);
            sb.append(String.format("#%02x%02x%02x;", argb[1], argb[2], argb[3]));
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private CTColor getBorderColor(XSSFBorderFormatting casted, XSSFCellBorder.BorderSide borderSide) {
        Field declaredField = null;
        try {
            declaredField = casted.getClass().getDeclaredField("_border");
            declaredField.setAccessible(true);
            CTBorder object = (CTBorder)declaredField.get(casted);
            switch (borderSide) {
                case BOTTOM: {
                    CTColor cTColor = object.getBottom().getColor();
                    return cTColor;
                }
                case LEFT: {
                    CTColor cTColor = object.getLeft().getColor();
                    return cTColor;
                }
                case RIGHT: {
                    CTColor cTColor = object.getRight().getColor();
                    return cTColor;
                }
                case TOP: {
                    CTColor cTColor = object.getTop().getColor();
                    return cTColor;
                }
            }
            return null;
        }
        catch (IllegalArgumentException e) {
            LOGGER.error("Incompatible POI implementation; unable to parse border color", (Throwable)e);
            return null;
        }
        catch (IllegalAccessException e) {
            LOGGER.error("Incompatible POI implementation; unable to parse border color", (Throwable)e);
            return null;
        }
        catch (NoSuchFieldException e) {
            LOGGER.error("Incompatible POI implementation; unable to parse border color", (Throwable)e);
            return null;
        }
        catch (SecurityException e) {
            LOGGER.error("Incompatible POI implementation; unable to parse border color", (Throwable)e);
            return null;
        }
        finally {
            if (declaredField != null) {
                declaredField.setAccessible(false);
            }
        }
    }

    @Override
    public void defaultColorStyles(CellStyle cellStyle, StringBuilder sb) {
        XSSFCellStyle cs = (XSSFCellStyle)cellStyle;
        XSSFColor fillForegroundColorColor = cs.getFillForegroundColorColor();
        XSSFColor fillBackgroundColorColor = cs.getFillBackgroundColorColor();
        this.defaultBackgroundColor = this.styleColor(fillForegroundColorColor);
        this.defaultBackgroundColor = this.styleColor(fillBackgroundColorColor);
        if (this.defaultBackgroundColor == null) {
            this.defaultBackgroundColor = "var(--default-background-color);";
        }
        sb.append("background-color:");
        sb.append(this.defaultBackgroundColor);
        XSSFColor xssfColor = cs.getFont().getXSSFColor();
        this.defaultColor = this.styleColor(xssfColor);
        if (this.defaultColor == null || this.defaultColor.equals("rgba(0, 0, 0, 1.0);")) {
            this.defaultColor = "var(--default-color);";
        }
        sb.append("color:");
        sb.append(this.defaultColor);
    }

    @Override
    public boolean hasBackgroundColor(CellStyle cellStyle) {
        XSSFCellStyle cs = (XSSFCellStyle)cellStyle;
        XSSFColor fillBackgroundXSSFColor = cs.getFillBackgroundXSSFColor();
        XSSFColor fillForegroundXSSFColor = cs.getFillForegroundXSSFColor();
        if (fillForegroundXSSFColor != null && !fillForegroundXSSFColor.isAuto()) {
            return true;
        }
        return fillBackgroundXSSFColor != null && !fillBackgroundXSSFColor.isAuto();
    }

    @Override
    public String getBackgroundColorCSS(ConditionalFormattingRule rule) {
        XSSFConditionalFormattingRule r = (XSSFConditionalFormattingRule)rule;
        CTDxf dxf = this.getXMLColorDataWithReflection(r);
        if (dxf != null && dxf.isSetFill() && dxf.getFill().isSetPatternFill() && dxf.getFill().getPatternFill().isSetBgColor()) {
            CTColor bgColor = dxf.getFill().getPatternFill().getBgColor();
            if (bgColor.isSetTheme()) {
                XSSFColor themeColor = this.workbook.getTheme().getThemeColor((int)bgColor.getTheme());
                return this.styleColor(themeColor, bgColor.getTint());
            }
            if (bgColor.isSetIndexed()) {
                XSSFColor mappedColor = new XSSFColor(IndexedColors.fromInt((int)((int)bgColor.getIndexed())), this.workbook.getStylesSource().getIndexedColors());
                return this.styleColor(mappedColor, bgColor.getTint());
            }
            byte[] rgb = bgColor.getRgb();
            return rgb == null ? null : ColorConverterUtil.toRGBA(rgb);
        }
        return null;
    }

    @Override
    public String getFontColorCSS(ConditionalFormattingRule rule) {
        XSSFConditionalFormattingRule r = (XSSFConditionalFormattingRule)rule;
        CTDxf dxf = this.getXMLColorDataWithReflection(r);
        if (dxf == null) {
            return null;
        }
        CTFont font = dxf.getFont();
        if (font.getColorList() == null || font.getColorList().isEmpty()) {
            return null;
        }
        CTColor ctColor = (CTColor)font.getColorList().get(0);
        if (ctColor.isSetTheme()) {
            XSSFColor themeColor = this.workbook.getTheme().getThemeColor((int)ctColor.getTheme());
            return this.styleColor(themeColor, ctColor.getTint());
        }
        if (ctColor.isSetIndexed()) {
            XSSFColor mappedColor = new XSSFColor(IndexedColors.fromInt((int)((int)ctColor.getIndexed())), this.workbook.getStylesSource().getIndexedColors());
            return this.styleColor(mappedColor, ctColor.getTint());
        }
        byte[] rgb = ctColor.getRgb();
        return rgb == null ? null : ColorConverterUtil.toRGBA(rgb);
    }

    private XSSFColor getFillColor(XSSFCellStyle cs) {
        CTXf _cellXf = cs.getCoreXf();
        int fillIndex = (int)_cellXf.getFillId();
        XSSFCellFill fg = this.workbook.getStylesSource().getFillAt(fillIndex);
        ThemesTable _theme = this.workbook.getTheme();
        XSSFColor fillForegroundColor = fg.getFillForegroundColor();
        if (fillForegroundColor != null && _theme != null) {
            _theme.inheritFromThemeAsRequired(fillForegroundColor);
        }
        XSSFColor fillBackgroundColor = fg.getFillBackgroundColor();
        if (fillForegroundColor == null) {
            if (fillBackgroundColor != null && _theme != null) {
                _theme.inheritFromThemeAsRequired(fillBackgroundColor);
            }
            return fillBackgroundColor;
        }
        return fillForegroundColor;
    }

    private XSSFColor getBorderColor(XSSFCellStyle cs, XSSFCellBorder.BorderSide borderSide) {
        int idx = (int)cs.getCoreXf().getBorderId();
        XSSFCellBorder border = this.workbook.getStylesSource().getBorderAt(idx);
        return border.getBorderColor(borderSide);
    }

    private String styleColor(XSSFColor color) {
        return this.styleColor(color, color == null ? 0.0 : color.getTint());
    }

    private String styleColor(XSSFColor color, double tint) {
        if (color == null || color.isAuto()) {
            return null;
        }
        byte[] argb = color.getARGB();
        if (argb == null) {
            return null;
        }
        if (tint != 0.0) {
            argb[1] = this.applyTint(argb[1] & 0xFF, tint);
            argb[2] = this.applyTint(argb[2] & 0xFF, tint);
            argb[3] = this.applyTint(argb[3] & 0xFF, tint);
        }
        try {
            String temp = ColorConverterUtil.toRGBA(argb);
            return temp;
        }
        catch (NumberFormatException nfe) {
            LOGGER.trace(nfe.getMessage() + " " + String.valueOf(nfe.getCause()), (Throwable)nfe);
            return String.format("#%02x%02x%02x;", argb[1], argb[2], argb[3]);
        }
    }

    private byte applyTint(int lum, double tint) {
        if (tint > 0.0) {
            return (byte)((double)lum * (1.0 - tint) + (255.0 - 255.0 * (1.0 - tint)));
        }
        if (tint < 0.0) {
            return (byte)((double)lum * (1.0 + tint));
        }
        return (byte)lum;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CTDxf getXMLColorDataWithReflection(XSSFConditionalFormattingRule rule) {
        Method declaredMethod = null;
        try {
            declaredMethod = rule.getClass().getDeclaredMethod("getDxf", Boolean.TYPE);
            declaredMethod.setAccessible(true);
            CTDxf cTDxf = (CTDxf)declaredMethod.invoke((Object)rule, false);
            return cTDxf;
        }
        catch (Exception e) {
            LOGGER.debug(e.getMessage());
            CTDxf cTDxf = null;
            return cTDxf;
        }
        finally {
            if (declaredMethod != null) {
                declaredMethod.setAccessible(false);
            }
        }
    }
}

