/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.spreadsheet.action;

import com.vaadin.flow.component.spreadsheet.Spreadsheet;
import com.vaadin.flow.component.spreadsheet.SpreadsheetFilterTable;
import com.vaadin.flow.component.spreadsheet.SpreadsheetTable;
import com.vaadin.flow.component.spreadsheet.action.SpreadsheetAction;
import java.util.List;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.ss.util.CellRangeUtil;

public class InsertTableAction
extends SpreadsheetAction {
    public InsertTableAction() {
        super("");
    }

    @Override
    public boolean isApplicableForSelection(Spreadsheet spreadsheet, Spreadsheet.SelectionChangeEvent event) {
        if (!spreadsheet.getActiveSheet().getProtect() && event.getIndividualSelectedCells().size() == 0 && event.getCellRangeAddresses().size() == 1) {
            List<CellRangeAddress> cras = event.getCellRangeAddresses();
            CellRangeAddress cra = cras.get(0);
            List<SpreadsheetTable> tablesForActiveSheet = spreadsheet.getTablesForActiveSheet();
            for (SpreadsheetTable table : tablesForActiveSheet) {
                if (CellRangeUtil.intersect((CellRangeAddress)cra, (CellRangeAddress)table.getFullTableRegion()) == 1) continue;
                return false;
            }
            if (cra.getFirstRow() != cra.getLastRow()) {
                this.setCaption("Create Table on " + cra.formatAsString());
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isApplicableForHeader(Spreadsheet spreadsheet, CellRangeAddress headerRange) {
        return false;
    }

    @Override
    public void executeActionOnSelection(Spreadsheet spreadsheet, Spreadsheet.SelectionChangeEvent event) {
        SpreadsheetFilterTable table = new SpreadsheetFilterTable(spreadsheet, spreadsheet.getActiveSheet(), event.getCellRangeAddresses().get(0));
        spreadsheet.registerTable(table);
    }

    @Override
    public void executeActionOnHeader(Spreadsheet spreadsheet, CellRangeAddress headerRange) {
        throw new UnsupportedOperationException("Insert table action can't be executed against a header range.");
    }
}

