/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.spreadsheet;

import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.spreadsheet.CellSelectionManager;
import com.vaadin.flow.component.spreadsheet.CellValueFormatter;
import com.vaadin.flow.component.spreadsheet.CustomDataFormatter;
import com.vaadin.flow.component.spreadsheet.FormulaFormatter;
import com.vaadin.flow.component.spreadsheet.Spreadsheet;
import com.vaadin.flow.component.spreadsheet.SpreadsheetStyleFactory;
import com.vaadin.flow.component.spreadsheet.SpreadsheetUtil;
import com.vaadin.flow.component.spreadsheet.client.CellData;
import com.vaadin.flow.component.spreadsheet.command.CellValueCommand;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.Format;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.apache.poi.hssf.model.InternalSheet;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFHyperlink;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.ss.formula.ConditionalFormattingEvaluator;
import org.apache.poi.ss.formula.FormulaParseException;
import org.apache.poi.ss.formula.eval.ErrorEval;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.DataFormatter;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.FormulaEvaluator;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellAddress;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.ss.util.CellReference;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CellValueManager
implements Serializable {
    private static final Logger LOGGER = LoggerFactory.getLogger(CellValueManager.class);
    private static final String EXCEL_FORMULA_BAR_DECIMAL_FORMAT = "###.################";
    private static final String ZERO_AS_STRING = "0";
    private short hyperlinkStyleIndex = (short)-1;
    protected final Spreadsheet spreadsheet;
    private Spreadsheet.CellValueHandler customCellValueHandler;
    private Spreadsheet.CellDeletionHandler customCellDeletionHandler;
    private DataFormatter formatter = new CustomDataFormatter();
    private final HashSet<String> sentCells = new HashSet();
    private final HashSet<String> sentFormulaCells = new HashSet();
    private final HashSet<CellData> removedCells = new HashSet();
    private final HashSet<String> markedCells = new HashSet();
    private HashSet<CellReference> changedFormulaCells = new HashSet();
    private boolean topLeftCellsLoaded;
    private HashMap<Integer, Float> cellStyleWidthRatioMap;
    private FormulaFormatter formulaFormatter = new FormulaFormatter();
    private CellValueFormatter cellValueFormatter = new CellValueFormatter();
    private DecimalFormat originalValueDecimalFormat = new DecimalFormat("###.################");
    private DecimalFormatSymbols localeDecimalSymbols = DecimalFormatSymbols.getInstance();

    public CellValueManager(Spreadsheet spreadsheet) {
        this.spreadsheet = spreadsheet;
        UI current = UI.getCurrent();
        if (current != null) {
            this.updateLocale(current.getLocale());
        }
    }

    private CellSelectionManager getCellSelectionManager() {
        return this.spreadsheet.getCellSelectionManager();
    }

    public void clearCachedContent() {
        this.markedCells.clear();
        this.sentCells.clear();
        this.removedCells.clear();
        this.sentFormulaCells.clear();
        this.hyperlinkStyleIndex = (short)-1;
        this.topLeftCellsLoaded = false;
    }

    public DataFormatter getDataFormatter() {
        return this.formatter;
    }

    public void setDataFormatter(DataFormatter dataFormatter) {
        this.formatter = dataFormatter;
    }

    public DecimalFormat getOriginalValueDecimalFormat() {
        return this.originalValueDecimalFormat;
    }

    protected void updateLocale(Locale locale) {
        this.formatter = new CustomDataFormatter(locale);
        this.localeDecimalSymbols = DecimalFormatSymbols.getInstance(locale);
        this.originalValueDecimalFormat = new DecimalFormat(EXCEL_FORMULA_BAR_DECIMAL_FORMAT, this.localeDecimalSymbols);
        this.cellValueFormatter.setLocaleDecimalSymbols(this.localeDecimalSymbols);
    }

    protected FormulaEvaluator getFormulaEvaluator() {
        return this.spreadsheet.getFormulaEvaluator();
    }

    protected ConditionalFormattingEvaluator getConditionalFormattingEvaluator() {
        return this.spreadsheet.getConditionalFormattingEvaluator();
    }

    private String getCachedFormulaCellValue(Cell formulaCell) {
        String result = null;
        switch (formulaCell.getCachedFormulaResultType()) {
            case BLANK: 
            case FORMULA: 
            case _NONE: 
            case STRING: {
                result = formulaCell.getStringCellValue();
                break;
            }
            case BOOLEAN: {
                result = String.valueOf(formulaCell.getBooleanCellValue());
                break;
            }
            case ERROR: {
                result = ErrorEval.getText((int)formulaCell.getErrorCellValue());
                break;
            }
            case NUMERIC: {
                CellStyle style = formulaCell.getCellStyle();
                result = this.formatter.formatRawCellContents(formulaCell.getNumericCellValue(), (int)style.getDataFormat(), style.getDataFormatString());
            }
        }
        return result;
    }

    protected CellData createCellDataForCell(Cell cell) {
        CellData cellData = new CellData();
        cellData.row = cell.getRowIndex() + 1;
        cellData.col = cell.getColumnIndex() + 1;
        CellStyle cellStyle = cell.getCellStyle();
        cellData.cellStyle = "cs" + cellStyle.getIndex();
        cellData.locked = this.spreadsheet.isCellLocked(cell.getAddress());
        try {
            Set<Integer> cellFormattingIndexes;
            if (!this.spreadsheet.isCellHidden(cell) && cell.getCellType() == CellType.FORMULA) {
                cellData.formulaValue = this.formulaFormatter.reFormatFormulaValue(cell.getCellFormula(), this.spreadsheet.getLocale());
                try {
                    String oldValue = this.getCachedFormulaCellValue(cell);
                    String newValue = this.formatter.formatCellValue(cell, this.getFormulaEvaluator(), this.getConditionalFormattingEvaluator());
                    if (!newValue.equals(oldValue)) {
                        this.changedFormulaCells.add(new CellReference(cell));
                    }
                }
                catch (RuntimeException rte) {
                    String formulaValue = cell.getCellFormula();
                    cell.setCellValue(formulaValue);
                    this.spreadsheet.markInvalidFormula(cell.getColumnIndex() + 1, cell.getRowIndex() + 1);
                }
            }
            if (cell.getCellStyle().getDataFormatString().contains("%")) {
                cellData.isPercentage = true;
            }
            String formattedCellValue = this.formatter.formatCellValue(cell, this.getFormulaEvaluator(), this.getConditionalFormattingEvaluator());
            if (!(this.spreadsheet.isCellHidden(cell) || cell.getCellType() != CellType.FORMULA && cell.getCellType() != CellType.NUMERIC)) {
                formattedCellValue = formattedCellValue.replaceAll("^-(?=0(.0*)?$)", "");
            }
            if (this.spreadsheet.isMarkedAsInvalidFormula(cellData.col, cellData.row)) {
                if (cell.getStringCellValue().charAt(0) == '+' || cell.getStringCellValue().charAt(0) == '=') {
                    cellData.formulaValue = cell.getStringCellValue().substring(1);
                }
                formattedCellValue = "#VALUE!";
            }
            if (formattedCellValue != null && !formattedCellValue.isEmpty() || cellStyle.getIndex() != 0) {
                cellData.value = formattedCellValue;
                cellData.needsMeasure = false;
                if (!cellStyle.getWrapText() && (!SpreadsheetUtil.cellContainsDate(cell) && cell.getCellType() == CellType.NUMERIC || cell.getCellType() == CellType.STRING || cell.getCellType() == CellType.FORMULA && !cell.getCellFormula().startsWith("HYPERLINK")) && !this.doesValueFit(cell, formattedCellValue)) {
                    if (this.valueContainsOnlyNumbers(formattedCellValue) && this.isGenerallCell(cell)) {
                        cellData.value = this.cellValueFormatter.getScientificNotationStringForNumericCell(cell.getNumericCellValue(), formattedCellValue, this.cellStyleWidthRatioMap.get(cell.getCellStyle().getIndex()).floatValue(), this.getCellWidth(cell) - 10);
                    } else if (cell.getCellType() != CellType.STRING && cell.getCellType() == CellType.FORMULA && cell.getCachedFormulaResultType() != CellType.STRING) {
                        cellData.needsMeasure = true;
                    }
                }
                if (cellStyle.getAlignment() == HorizontalAlignment.RIGHT) {
                    cellData.cellStyle = cellData.cellStyle + " r";
                } else if (cellStyle.getAlignment() == HorizontalAlignment.GENERAL && (SpreadsheetUtil.cellContainsDate(cell) || cell.getCellType() == CellType.NUMERIC || cell.getCellType() == CellType.FORMULA && !cell.getCellFormula().startsWith("HYPERLINK") && cell.getCachedFormulaResultType() != CellType.STRING)) {
                    cellData.cellStyle = cellData.cellStyle + " r";
                }
            }
            if ((cellFormattingIndexes = this.spreadsheet.getConditionalFormatter().getCellFormattingIndex(cell)) != null) {
                for (Integer i : cellFormattingIndexes) {
                    cellData.cellStyle = cellData.cellStyle + " cf" + i;
                }
                this.markedCells.add(SpreadsheetUtil.toKey(cell));
            }
            cellData.originalValue = cell.getCellType() == CellType.NUMERIC && DateUtil.isCellDateFormatted((Cell)cell) ? cellData.value : this.getOriginalCellValue(cell);
            this.handleIsDisplayZeroPreference(cell, cellData);
        }
        catch (RuntimeException rte) {
            LOGGER.trace(rte.getMessage(), (Throwable)rte);
            cellData.value = "#VALUE!";
        }
        return cellData;
    }

    private void setLeadingQuoteStyle(Cell cell, boolean leadingQuote) {
        if (cell instanceof XSSFCell) {
            ((XSSFCell)cell).getCellStyle().getCoreXf().setQuotePrefix(leadingQuote);
        }
    }

    private void handleIsDisplayZeroPreference(Cell cell, CellData cellData) {
        boolean isCellNumeric = cell.getCellType() == CellType.NUMERIC;
        boolean isCellFormula = cell.getCellType() == CellType.FORMULA;
        boolean isApplicableCellType = isCellNumeric || isCellFormula;
        boolean displayZeroAsBlank = !cell.getSheet().isDisplayZeros();
        boolean valueIsZero = ZERO_AS_STRING.equals(cellData.value);
        if (isApplicableCellType && displayZeroAsBlank && valueIsZero) {
            cellData.value = "";
        }
    }

    private boolean isGenerallCell(Cell cell) {
        return cell.getCellType() == CellType.NUMERIC && cell.getCellStyle().getDataFormatString().contains("General");
    }

    public String getOriginalCellValue(Cell cell) {
        if (cell == null) {
            return "";
        }
        CellType cellType = cell.getCellType();
        switch (cellType) {
            case FORMULA: {
                return cell.getCellFormula();
            }
            case NUMERIC: {
                if (DateUtil.isCellDateFormatted((Cell)cell)) {
                    Date dateCellValue = cell.getDateCellValue();
                    if (dateCellValue != null) {
                        return new SimpleDateFormat().format(dateCellValue);
                    }
                    return "";
                }
                return this.originalValueDecimalFormat.format(cell.getNumericCellValue());
            }
            case STRING: {
                String stringCellValue = cell.getStringCellValue();
                if (SpreadsheetUtil.needsLeadingQuote(cell)) {
                    return "'" + stringCellValue;
                }
                return stringCellValue;
            }
            case BOOLEAN: {
                return String.valueOf(cell.getBooleanCellValue());
            }
            case BLANK: {
                return "";
            }
            case ERROR: {
                return String.valueOf(cell.getErrorCellValue());
            }
        }
        return "";
    }

    private boolean valueContainsOnlyNumbers(String value) {
        return value.matches("^-?\\d+(" + this.localeDecimalSymbols.getDecimalSeparator() + "\\d+)?$");
    }

    private boolean doesValueFit(Cell cell, String value) {
        BigDecimal columnWidth;
        Float r = this.cellStyleWidthRatioMap.get(cell.getCellStyle().getIndex());
        if (r == null) {
            return true;
        }
        BigDecimal ratio = BigDecimal.valueOf(r.floatValue());
        BigDecimal stringPixels = ratio.multiply(BigDecimal.valueOf(value.length()));
        return stringPixels.compareTo(columnWidth = BigDecimal.valueOf((double)this.getCellWidth(cell) - 4.0)) <= 0;
    }

    protected int getCellWidth(Cell cell) {
        for (CellRangeAddress range : cell.getSheet().getMergedRegions()) {
            if (!range.isInRange(cell)) continue;
            int w = 0;
            for (int c = range.getFirstColumn(); c <= range.getLastColumn(); ++c) {
                w += this.spreadsheet.getColW()[c];
            }
            return w;
        }
        return this.spreadsheet.getColW()[cell.getColumnIndex()];
    }

    public Spreadsheet.CellValueHandler getCustomCellValueHandler() {
        return this.customCellValueHandler;
    }

    public void setCustomCellValueHandler(Spreadsheet.CellValueHandler customCellValueHandler) {
        this.customCellValueHandler = customCellValueHandler;
    }

    public Spreadsheet.CellDeletionHandler getCustomCellDeletionHandler() {
        return this.customCellDeletionHandler;
    }

    public void setCustomCellDeletionHandler(Spreadsheet.CellDeletionHandler customCellDeletionHandler) {
        this.customCellDeletionHandler = customCellDeletionHandler;
    }

    protected void cellUpdated(Cell cell) {
        this.getFormulaEvaluator().notifyUpdateCell(cell);
        this.markCellForUpdate(cell);
    }

    protected void markCellForUpdate(Cell cell) {
        this.markedCells.add(SpreadsheetUtil.toKey(cell));
    }

    protected void cellDeleted(Cell cell) {
        this.getFormulaEvaluator().notifyDeleteCell(cell);
        this.spreadsheet.removeInvalidFormulaMark(cell.getColumnIndex() + 1, cell.getRowIndex() + 1);
        this.markCellForRemove(cell);
    }

    protected void markCellForRemove(Cell cell) {
        String cellKey = SpreadsheetUtil.toKey(cell);
        CellData cd = new CellData();
        cd.col = cell.getColumnIndex() + 1;
        cd.row = cell.getRowIndex() + 1;
        this.removedCells.add(cd);
        this.clearCellCache(cellKey);
    }

    protected void clearCellCache(String cellKey) {
        if (!this.sentCells.remove(cellKey)) {
            this.sentFormulaCells.remove(cellKey);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onCellValueChange(int col, int row, String value) {
        Workbook workbook = this.spreadsheet.getWorkbook();
        Sheet activeSheet = workbook.getSheetAt(workbook.getActiveSheetIndex());
        Row r = activeSheet.getRow(row - 1);
        if (r == null) {
            r = activeSheet.createRow(row - 1);
        }
        Cell cell = r.getCell(col - 1);
        String formattedCellValue = null;
        CellType oldCellType = CellType._NONE;
        CellValueCommand command = new CellValueCommand(this.spreadsheet);
        command.captureCellValues(new CellReference(this.spreadsheet.getActiveSheet().getSheetName(), row - 1, col - 1, false, false));
        this.spreadsheet.getSpreadsheetHistoryManager().addCommand(command);
        boolean updateHyperlinks = false;
        boolean formulaChanged = false;
        if (this.getCustomCellValueHandler() == null || this.getCustomCellValueHandler().cellValueUpdated(cell, activeSheet, col - 1, row - 1, value, this.getFormulaEvaluator(), this.formatter, this.getConditionalFormattingEvaluator())) {
            Throwable exception = null;
            try {
                SpreadsheetStyleFactory styler = this.spreadsheet.getSpreadsheetStyleFactory();
                Locale spreadsheetLocale = this.spreadsheet.getLocale();
                if (cell == null) {
                    cell = r.createCell(col - 1);
                } else {
                    formattedCellValue = this.getFormattedCellValue(cell);
                    String key = SpreadsheetUtil.toKey(col, row);
                    oldCellType = cell.getCellType();
                    if (!this.sentCells.remove(key)) {
                        this.sentFormulaCells.remove(key);
                    }
                    if (cell.getCellType() == CellType.FORMULA && cell.getCellFormula().startsWith("HYPERLINK")) {
                        updateHyperlinks = true;
                    }
                    this.setLeadingQuoteStyle(cell, false);
                }
                if (this.formulaFormatter.isFormulaFormat(value)) {
                    if (this.formulaFormatter.isValidFormulaFormat(value, spreadsheetLocale)) {
                        this.spreadsheet.removeInvalidFormulaMark(col, row);
                        this.getFormulaEvaluator().notifyUpdateCell(cell);
                        String newFormula = this.formulaFormatter.unFormatFormulaValue(value.substring(1), spreadsheetLocale);
                        formulaChanged = cell.getCellType() == CellType.FORMULA && !newFormula.equals(cell.getCellFormula());
                        cell.setCellFormula(newFormula);
                        this.getFormulaEvaluator().notifySetFormula(cell);
                        if (value.startsWith("=HYPERLINK(") && cell.getCellStyle().getIndex() != this.hyperlinkStyleIndex) {
                            CellStyle hyperlinkCellStyle;
                            if (this.hyperlinkStyleIndex == -1) {
                                hyperlinkCellStyle = styler.createHyperlinkCellStyle();
                                this.hyperlinkStyleIndex = (short)-1;
                            } else {
                                hyperlinkCellStyle = workbook.getCellStyleAt((int)this.hyperlinkStyleIndex);
                            }
                            cell.setCellStyle(hyperlinkCellStyle);
                            styler.cellStyleUpdated(cell, true);
                            updateHyperlinks = true;
                        }
                    } else {
                        cell.setCellValue(value);
                        this.spreadsheet.markInvalidFormula(col, row);
                    }
                } else {
                    if (oldCellType == CellType.FORMULA) {
                        cell.setBlank();
                    }
                    this.spreadsheet.removeInvalidFormulaMark(col, row);
                    Double percentage = SpreadsheetUtil.parsePercentage(value, spreadsheetLocale);
                    Double numVal = SpreadsheetUtil.parseNumber(cell, value, spreadsheetLocale);
                    if (value.isEmpty()) {
                        cell.setBlank();
                    } else if (percentage != null) {
                        CellStyle cs = cell.getCellStyle();
                        if (cs == null || cs.getIndex() == 0) {
                            cs = workbook.createCellStyle();
                            cell.setCellStyle(cs);
                        }
                        if (cs.getDataFormatString() != null && !cs.getDataFormatString().contains("%")) {
                            cs.setDataFormat(workbook.createDataFormat().getFormat(this.spreadsheet.getDefaultPercentageFormat()));
                            styler.cellStyleUpdated(cell, true);
                        }
                        cell.setCellValue(percentage.doubleValue());
                    } else if (numVal != null) {
                        cell.setCellValue(numVal.doubleValue());
                    } else if (oldCellType == CellType.BOOLEAN) {
                        cell.setCellValue(Boolean.parseBoolean(value));
                    } else {
                        if (value.startsWith("'")) {
                            value = value.substring(1, value.length());
                            this.setLeadingQuoteStyle(cell, true);
                        }
                        cell.setCellValue(value);
                    }
                }
            }
            catch (FormulaParseException fpe) {
                try {
                    exception = fpe;
                    cell.setCellFormula(value.substring(1).replace(" ", ""));
                }
                catch (FormulaParseException fpe2) {
                    exception = fpe2;
                    cell.setCellValue(value);
                    this.spreadsheet.markInvalidFormula(col, row);
                }
            }
            catch (NumberFormatException nfe) {
                exception = nfe;
                cell.setCellValue(value);
            }
            catch (Exception e) {
                exception = e;
                cell.setCellValue(value);
            }
            finally {
                this.getFormulaEvaluator().notifyUpdateCell(cell);
            }
            if (cell != null) {
                this.markCellForUpdate(cell);
                if (formattedCellValue == null || !formattedCellValue.equals(this.getFormattedCellValue(cell)) || oldCellType != cell.getCellType() || formulaChanged) {
                    this.fireCellValueChangeEvent(cell);
                }
            }
            if (exception != null) {
                LOGGER.trace("Failed to parse cell value for cell at col " + col + " row " + row + " (" + exception.getMessage() + ")", exception);
            }
        }
        this.spreadsheet.updateMarkedCells();
        if (updateHyperlinks) {
            this.spreadsheet.loadHyperLinks();
        }
    }

    private String getFormattedCellValue(Cell cell) {
        try {
            return this.formatter.formatCellValue(cell, this.getFormulaEvaluator(), this.getConditionalFormattingEvaluator());
        }
        catch (RuntimeException rte) {
            return null;
        }
    }

    private void fireCellValueChangeEvent(Cell cell) {
        HashSet<CellReference> cells = new HashSet<CellReference>();
        CellReference ref = new CellReference(cell);
        cells.add(ref);
        this.spreadsheet.fireEvent(new Spreadsheet.CellValueChangeEvent(this.spreadsheet, cells));
    }

    private void fireFormulaValueChangeEvent(Set<CellReference> changedCells) {
        this.spreadsheet.fireEvent(new Spreadsheet.FormulaValueChangeEvent(this.spreadsheet, changedCells));
    }

    private void fireCellValueChangeEvent(Set<CellReference> changedCells) {
        this.spreadsheet.fireEvent(new Spreadsheet.CellValueChangeEvent(this.spreadsheet, changedCells));
    }

    public void onDeleteSelectedCells() {
        boolean individualCellsDeletionCheckPassed;
        boolean cellDeletionCheckPassed;
        Row row;
        Sheet activeSheet = this.spreadsheet.getActiveSheet();
        CellReference selectedCellReference = this.getCellSelectionManager().getSelectedCellReference();
        if (selectedCellReference != null && (row = activeSheet.getRow(selectedCellReference.getRow())) != null && this.spreadsheet.isCellLocked(new CellAddress(selectedCellReference.getRow(), (int)selectedCellReference.getCol()))) {
            return;
        }
        List<CellReference> individualSelectedCells = this.getCellSelectionManager().getIndividualSelectedCells();
        for (CellReference cellReference : individualSelectedCells) {
            Row row2 = activeSheet.getRow(cellReference.getRow());
            if (row2 == null || !this.spreadsheet.isCellLocked(new CellAddress(cellReference.getRow(), (int)cellReference.getCol()))) continue;
            return;
        }
        List<CellRangeAddress> cellRangeAddresses = this.getCellSelectionManager().getCellRangeAddresses();
        for (CellRangeAddress range : cellRangeAddresses) {
            if (this.spreadsheet.isRangeEditable(range)) continue;
            return;
        }
        boolean bl = this.selectedIsInRange(selectedCellReference, cellRangeAddresses);
        boolean bl2 = cellDeletionCheckPassed = !bl && individualSelectedCells.isEmpty() && this.passesDeletionCheck(selectedCellReference);
        if (selectedCellReference == null) {
            individualCellsDeletionCheckPassed = this.passesDeletionCheck(individualSelectedCells);
        } else if (!bl && !individualSelectedCells.isEmpty()) {
            ArrayList<CellReference> individualSelectedCellsIncludingCurrentSelection = new ArrayList<CellReference>(individualSelectedCells);
            individualSelectedCellsIncludingCurrentSelection.add(selectedCellReference);
            cellDeletionCheckPassed = individualCellsDeletionCheckPassed = this.passesDeletionCheck(individualSelectedCellsIncludingCurrentSelection);
        } else {
            individualCellsDeletionCheckPassed = this.passesDeletionCheck(individualSelectedCells);
        }
        boolean cellRangeDeletionCheckPassed = this.passesRangeDeletionCheck(cellRangeAddresses);
        if (!(selectedCellReference != null && cellDeletionCheckPassed || !individualSelectedCells.isEmpty() && individualCellsDeletionCheckPassed || !cellRangeAddresses.isEmpty() && cellRangeDeletionCheckPassed)) {
            return;
        }
        if (!cellDeletionCheckPassed) {
            selectedCellReference = null;
        }
        if (!individualCellsDeletionCheckPassed) {
            individualSelectedCells.clear();
        }
        if (!cellRangeDeletionCheckPassed) {
            cellRangeAddresses.clear();
        }
        CellValueCommand command = new CellValueCommand(this.spreadsheet);
        if (selectedCellReference != null && !bl) {
            command.captureCellValues(selectedCellReference);
        }
        for (CellReference cr : individualSelectedCells) {
            command.captureCellValues(cr);
        }
        for (CellRangeAddress range : cellRangeAddresses) {
            command.captureCellRangeValues(range);
        }
        if (selectedCellReference != null && !bl) {
            this.removeCell(selectedCellReference.getRow() + 1, selectedCellReference.getCol() + 1, false);
        }
        for (CellReference cr : individualSelectedCells) {
            this.removeCell(cr.getRow() + 1, cr.getCol() + 1, false);
        }
        for (CellRangeAddress range : cellRangeAddresses) {
            this.removeCells(range.getFirstRow() + 1, range.getFirstColumn() + 1, range.getLastRow() + 1, range.getLastColumn() + 1, false);
        }
        this.spreadsheet.getSpreadsheetHistoryManager().addCommand(command);
        this.fireCellValueChangeEvent(this.spreadsheet.getSelectedCellReferences());
        this.spreadsheet.updateMarkedCells();
        this.spreadsheet.loadHyperLinks();
    }

    private boolean selectedIsInRange(CellReference cell, List<CellRangeAddress> cellRangeAddresses) {
        for (CellRangeAddress range : cellRangeAddresses) {
            if (!range.isInRange(cell.getRow(), (int)cell.getCol())) continue;
            return true;
        }
        return false;
    }

    private boolean passesDeletionCheck(CellReference selectedCellReference) {
        short colIndex;
        Cell cell;
        int rowIndex;
        if (selectedCellReference == null || this.customCellDeletionHandler == null) {
            return true;
        }
        Workbook workbook = this.spreadsheet.getWorkbook();
        Sheet activeSheet = workbook.getSheetAt(workbook.getActiveSheetIndex());
        Row row = activeSheet.getRow(rowIndex = selectedCellReference.getRow());
        if (row != null && (cell = row.getCell((int)(colIndex = selectedCellReference.getCol()))) != null) {
            return this.customCellDeletionHandler.cellDeleted(cell, activeSheet, colIndex, rowIndex, this.getFormulaEvaluator(), this.formatter, this.getConditionalFormattingEvaluator());
        }
        return true;
    }

    private boolean passesDeletionCheck(List<CellReference> individualSelectedCells) {
        if (individualSelectedCells.isEmpty() || this.customCellDeletionHandler == null) {
            return true;
        }
        Workbook workbook = this.spreadsheet.getWorkbook();
        Sheet activeSheet = workbook.getSheetAt(workbook.getActiveSheetIndex());
        return this.customCellDeletionHandler.individualSelectedCellsDeleted(individualSelectedCells, activeSheet, this.getFormulaEvaluator(), this.formatter, this.getConditionalFormattingEvaluator());
    }

    private boolean passesRangeDeletionCheck(List<CellRangeAddress> cellRangeAddresses) {
        if (cellRangeAddresses.isEmpty() || this.customCellDeletionHandler == null) {
            return true;
        }
        Workbook workbook = this.spreadsheet.getWorkbook();
        Sheet activeSheet = workbook.getSheetAt(workbook.getActiveSheetIndex());
        return this.customCellDeletionHandler.cellRangeDeleted(cellRangeAddresses, activeSheet, this.getFormulaEvaluator(), this.formatter, this.getConditionalFormattingEvaluator());
    }

    protected void parseValueIntoNumericCell(Cell cell, String value) {
        Format oldFormat = this.formatter.createFormat(cell);
        if (oldFormat != null) {
            try {
                Object parsedObject = oldFormat.parseObject(value);
                if (parsedObject instanceof Date) {
                    cell.setCellValue((Date)parsedObject);
                } else if (parsedObject instanceof Calendar) {
                    cell.setCellValue((Calendar)parsedObject);
                } else if (parsedObject instanceof Number) {
                    cell.setCellValue(((Number)parsedObject).doubleValue());
                } else {
                    cell.setCellValue(Double.parseDouble(value));
                }
            }
            catch (ParseException pe) {
                LOGGER.trace("Could not parse String to format, " + String.valueOf(oldFormat.getClass()) + ", " + cell.getCellStyle().getDataFormatString() + " : " + pe.getMessage(), (Throwable)pe);
                try {
                    cell.setCellValue(Double.parseDouble(value));
                }
                catch (NumberFormatException nfe) {
                    LOGGER.trace("Could not parse String to Double: " + nfe.getMessage(), (Throwable)nfe);
                    cell.setCellValue(value);
                }
            }
            catch (NumberFormatException nfe) {
                LOGGER.trace("Could not parse String to Double: " + nfe.getMessage(), (Throwable)nfe);
                cell.setCellValue(value);
            }
        }
    }

    protected void loadCellData(int firstRow, int firstColumn, int lastRow, int lastColumn) {
        try {
            ArrayList<CellData> bottomRightData;
            ArrayList<CellData> bottomLeftData;
            ArrayList<CellData> topRightData;
            int verticalSplitPosition = this.spreadsheet.getLastFrozenRow();
            int horizontalSplitPosition = this.spreadsheet.getLastFrozenColumn();
            if (verticalSplitPosition > 0 && horizontalSplitPosition > 0 && !this.topLeftCellsLoaded) {
                ArrayList<CellData> topLeftData = this.loadCellDataForRowAndColumnRange(1, 1, verticalSplitPosition, horizontalSplitPosition);
                this.topLeftCellsLoaded = true;
                if (!topLeftData.isEmpty()) {
                    this.spreadsheet.getRpcProxy().updateTopLeftCellValues(topLeftData);
                }
            }
            if (verticalSplitPosition > 0 && !(topRightData = this.loadCellDataForRowAndColumnRange(1, firstColumn, verticalSplitPosition, lastColumn)).isEmpty()) {
                this.spreadsheet.getRpcProxy().updateTopRightCellValues(topRightData);
            }
            if (horizontalSplitPosition > 0 && !(bottomLeftData = this.loadCellDataForRowAndColumnRange(firstRow, 1, lastRow, horizontalSplitPosition)).isEmpty()) {
                this.spreadsheet.getRpcProxy().updateBottomLeftCellValues(bottomLeftData);
            }
            if (!(bottomRightData = this.loadCellDataForRowAndColumnRange(firstRow, firstColumn, lastRow, lastColumn)).isEmpty()) {
                this.spreadsheet.getRpcProxy().updateBottomRightCellValues(bottomRightData);
            }
        }
        catch (NullPointerException npe) {
            LOGGER.trace(npe.getMessage(), (Throwable)npe);
        }
    }

    protected ArrayList<CellData> loadCellDataForRowAndColumnRange(int firstRow, int firstColumn, int lastRow, int lastColumn) {
        ArrayList<CellData> cellData = new ArrayList<CellData>();
        Workbook workbook = this.spreadsheet.getWorkbook();
        Sheet activeSheet = workbook.getSheetAt(workbook.getActiveSheetIndex());
        HashMap<String, String> componentIDtoCellKeysMap = this.spreadsheet.getComponentIDtoCellKeysMap();
        Collection<Object> customComponentCells = componentIDtoCellKeysMap == null ? Collections.emptyList() : componentIDtoCellKeysMap.values();
        for (int r = firstRow - 1; r < lastRow; ++r) {
            Row row = activeSheet.getRow(r);
            if (row == null || row.getLastCellNum() == -1 || row.getLastCellNum() < firstColumn) continue;
            for (int c = firstColumn - 1; c < lastColumn; ++c) {
                CellData cd;
                Cell cell;
                String key = SpreadsheetUtil.toKey(c + 1, r + 1);
                if (customComponentCells.contains(key) || this.sentCells.contains(key) || this.sentFormulaCells.contains(key) || (cell = row.getCell(c)) == null || (cd = this.createCellDataForCell(cell)) == null) continue;
                CellType cellType = cell.getCellType();
                if (cellType == CellType.FORMULA) {
                    this.sentFormulaCells.add(key);
                } else {
                    this.sentCells.add(key);
                }
                cellData.add(cd);
            }
        }
        return cellData;
    }

    protected void updateVisibleCellValues() {
        this.loadCellData(this.spreadsheet.getFirstRow(), this.spreadsheet.getFirstColumn(), this.spreadsheet.getLastRow(), this.spreadsheet.getLastColumn());
    }

    protected void updateMarkedCellValues() {
        ArrayList<CellData> updatedCellData = new ArrayList<CellData>();
        Sheet sheet = this.spreadsheet.getActiveSheet();
        Iterator rows = sheet.rowIterator();
        while (rows.hasNext()) {
            Row r = (Row)rows.next();
            Iterator cells = r.cellIterator();
            while (cells.hasNext()) {
                Cell cell = (Cell)cells.next();
                int rowIndex = cell.getRowIndex();
                int columnIndex = cell.getColumnIndex();
                String key = SpreadsheetUtil.toKey(columnIndex + 1, rowIndex + 1);
                if (this.spreadsheet.getConditionalFormatter().getCellFormattingIndex(cell) != null) {
                    this.markedCells.add(key);
                }
                if (cell.getCellType() == CellType.FORMULA) {
                    if (!this.sentFormulaCells.contains(key) && !this.markedCells.contains(key)) continue;
                    CellData cd = this.createCellDataForCell(cell);
                    if (cd == null) {
                        cd = new CellData();
                        cd.col = columnIndex + 1;
                        cd.row = rowIndex + 1;
                        cd.cellStyle = "" + cell.getCellStyle().getIndex();
                    }
                    this.sentFormulaCells.add(key);
                    updatedCellData.add(cd);
                    continue;
                }
                if (!this.markedCells.contains(key)) continue;
                this.sentCells.add(key);
                updatedCellData.add(this.createCellDataForCell(cell));
            }
        }
        if (!this.changedFormulaCells.isEmpty()) {
            this.fireFormulaValueChangeEvent(this.changedFormulaCells);
            this.changedFormulaCells = new HashSet();
        }
        updatedCellData.addAll(this.removedCells);
        if (!updatedCellData.isEmpty()) {
            this.spreadsheet.getRpcProxy().cellsUpdated(updatedCellData);
            this.spreadsheet.getRpcProxy().refreshCellStyles();
        }
        this.markedCells.clear();
        this.removedCells.clear();
    }

    protected void updateDeletedRowsInClientCache(int startRow, int endRow) {
        for (int i = startRow; i <= endRow; ++i) {
            CellData cd;
            String key;
            String rowKey = "row" + i;
            Iterator<String> iterator = this.sentCells.iterator();
            while (iterator.hasNext()) {
                key = iterator.next();
                if (!key.endsWith(rowKey)) continue;
                iterator.remove();
                cd = new CellData();
                cd.col = SpreadsheetUtil.getColumnIndexFromKey(key);
                cd.row = i;
                this.removedCells.add(cd);
            }
            iterator = this.sentFormulaCells.iterator();
            while (iterator.hasNext()) {
                key = iterator.next();
                if (!key.endsWith(rowKey)) continue;
                iterator.remove();
                cd = new CellData();
                cd.col = SpreadsheetUtil.getColumnIndexFromKey(key);
                cd.row = i;
                this.removedCells.add(cd);
            }
        }
    }

    protected void removeCells(int firstRow, int firstColumn, int lastRow, int lastColumn, boolean clearRemovedCellStyle) {
        Workbook workbook = this.spreadsheet.getWorkbook();
        Sheet activeSheet = workbook.getSheetAt(workbook.getActiveSheetIndex());
        for (int i = firstRow - 1; i < lastRow; ++i) {
            Row row = activeSheet.getRow(i);
            if (row == null) continue;
            for (int j = firstColumn - 1; j < lastColumn; ++j) {
                Cell cell = row.getCell(j);
                if (cell == null) continue;
                String key = SpreadsheetUtil.toKey(j + 1, i + 1);
                if (cell.getCellType() == CellType.FORMULA) {
                    this.sentFormulaCells.remove(key);
                } else {
                    this.sentCells.remove(key);
                }
                if (cell.getHyperlink() != null) {
                    this.removeHyperlink(cell, activeSheet);
                }
                if (clearRemovedCellStyle) {
                    cell.setCellStyle(null);
                    this.spreadsheet.getSpreadsheetStyleFactory().cellStyleUpdated(cell, true);
                }
                if (clearRemovedCellStyle || cell.getCellStyle().getIndex() == 0) {
                    CellData cd = new CellData();
                    cd.col = j + 1;
                    cd.row = i + 1;
                    this.removedCells.add(cd);
                } else {
                    this.markedCells.add(key);
                }
                cell.setCellValue((String)null);
                this.getFormulaEvaluator().notifyUpdateCell(cell);
                this.spreadsheet.removeInvalidFormulaMark(cell.getColumnIndex() + 1, cell.getRowIndex() + 1);
            }
        }
    }

    protected void removeCell(int rowIndex, int colIndex, boolean clearRemovedCellStyle) {
        Cell cell;
        Workbook workbook = this.spreadsheet.getWorkbook();
        Sheet activeSheet = workbook.getSheetAt(workbook.getActiveSheetIndex());
        Row row = activeSheet.getRow(rowIndex - 1);
        if (row != null && (cell = row.getCell(colIndex - 1)) != null) {
            CellData cd = new CellData();
            cd.col = colIndex;
            cd.row = rowIndex;
            String key = SpreadsheetUtil.toKey(colIndex, rowIndex);
            if (clearRemovedCellStyle || cell.getCellStyle().getIndex() == 0) {
                this.removedCells.add(cd);
            } else {
                this.markedCells.add(key);
            }
            if (cell.getCellType() == CellType.FORMULA) {
                this.sentFormulaCells.remove(key);
            } else {
                this.sentCells.remove(key);
            }
            if (cell.getHyperlink() != null) {
                this.removeHyperlink(cell, activeSheet);
            }
            if (clearRemovedCellStyle) {
                cell.setCellStyle(null);
                this.spreadsheet.getSpreadsheetStyleFactory().cellStyleUpdated(cell, true);
            }
            cell.setCellValue((String)null);
            this.getFormulaEvaluator().notifyUpdateCell(cell);
            this.spreadsheet.removeInvalidFormulaMark(cell.getColumnIndex() + 1, cell.getRowIndex() + 1);
        }
    }

    protected void removeHyperlink(Cell cell, Sheet sheet) {
        try {
            if (sheet instanceof XSSFSheet) {
                Field f = XSSFSheet.class.getDeclaredField("hyperlinks");
                f.setAccessible(true);
                List hyperlinks = (List)f.get(sheet);
                hyperlinks.remove(cell.getHyperlink());
                f.setAccessible(false);
            } else if (sheet instanceof HSSFSheet && cell instanceof HSSFCell) {
                HSSFHyperlink link = (HSSFHyperlink)cell.getHyperlink();
                Field sheetField = HSSFSheet.class.getDeclaredField("_sheet");
                sheetField.setAccessible(true);
                InternalSheet internalsheet = (InternalSheet)sheetField.get(sheet);
                List records = internalsheet.getRecords();
                Field recordField = HSSFHyperlink.class.getDeclaredField("record");
                recordField.setAccessible(true);
                records.remove(recordField.get(link));
                sheetField.setAccessible(false);
                recordField.setAccessible(false);
            }
        }
        catch (SecurityException e) {
            LOGGER.trace(e.getMessage(), (Throwable)e);
        }
        catch (NoSuchFieldException e) {
            LOGGER.trace(e.getMessage(), (Throwable)e);
        }
        catch (IllegalArgumentException e) {
            LOGGER.trace(e.getMessage(), (Throwable)e);
        }
        catch (IllegalAccessException e) {
            LOGGER.trace(e.getMessage(), (Throwable)e);
        }
    }

    public void onCellStyleWidthRatioUpdate(HashMap<Integer, Float> cellStyleWidthRatioMap) {
        this.cellStyleWidthRatioMap = cellStyleWidthRatioMap;
    }

    public void clearCacheForColumn(int indexColumn) {
        String key;
        String columnKey = "col" + indexColumn + " r";
        Iterator<String> iterator = this.sentCells.iterator();
        while (iterator.hasNext()) {
            key = iterator.next();
            if (!key.startsWith(columnKey)) continue;
            iterator.remove();
        }
        iterator = this.sentFormulaCells.iterator();
        while (iterator.hasNext()) {
            key = iterator.next();
            if (!key.startsWith(columnKey)) continue;
            iterator.remove();
        }
    }
}

