/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.spreadsheet.charts.converter;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.charts.Chart;
import com.vaadin.flow.component.charts.model.Configuration;
import com.vaadin.flow.component.charts.model.Series;
import com.vaadin.flow.component.spreadsheet.ChartCreator;
import com.vaadin.flow.component.spreadsheet.Spreadsheet;
import com.vaadin.flow.component.spreadsheet.charts.converter.chartdata.ChartData;
import com.vaadin.flow.component.spreadsheet.charts.converter.confwriter.ChartDataToVaadinConfigWriter;
import com.vaadin.flow.component.spreadsheet.charts.converter.confwriter.SelectListeningDataSeries;
import com.vaadin.flow.component.spreadsheet.charts.converter.xssfreader.XSSFChartReader;
import java.io.Serializable;
import org.apache.poi.xssf.usermodel.XSSFChart;

public class DefaultChartCreator
implements ChartCreator {
    private ChartDataToVaadinConfigWriter chartDataToVaadinConfigWriter = new ChartDataToVaadinConfigWriter();

    @Override
    public Component createChart(XSSFChart chartXml, Spreadsheet spreadsheet) {
        ChartData chartDefinition = new XSSFChartReader(spreadsheet, chartXml).readXSSFChart();
        Configuration conf = this.chartDataToVaadinConfigWriter.createConfigurationFromChartData(chartDefinition);
        Chart chart = new Chart();
        chart.setConfiguration(conf);
        chart.addPointSelectListener((ComponentEventListener & Serializable)event -> {
            Series series = event.getSeries();
            if (series instanceof SelectListeningDataSeries) {
                ((SelectListeningDataSeries)series).getSelectListener().selected();
            }
        });
        return chart;
    }
}

