/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.spreadsheet.action;

import com.vaadin.flow.component.spreadsheet.Spreadsheet;
import com.vaadin.flow.component.spreadsheet.action.SpreadsheetAction;
import com.vaadin.flow.component.spreadsheet.command.RowInsertOrDeleteCommand;
import org.apache.poi.ss.util.CellRangeAddress;

public class InsertNewRowAction
extends SpreadsheetAction {
    public InsertNewRowAction() {
        super("");
    }

    @Override
    public boolean isApplicableForSelection(Spreadsheet spreadsheet, Spreadsheet.SelectionChangeEvent event) {
        return false;
    }

    @Override
    public boolean isApplicableForHeader(Spreadsheet spreadsheet, CellRangeAddress headerRange) {
        if (!this.isSheetProtected(spreadsheet) && headerRange.isFullRowRange()) {
            this.setCaption("Insert new row");
            return true;
        }
        return false;
    }

    @Override
    public void executeActionOnSelection(Spreadsheet spreadsheet, Spreadsheet.SelectionChangeEvent event) {
        throw new UnsupportedOperationException("Insert new row action can't be executed against a selection.");
    }

    @Override
    public void executeActionOnHeader(Spreadsheet spreadsheet, CellRangeAddress headerRange) {
        RowInsertOrDeleteCommand command = new RowInsertOrDeleteCommand(spreadsheet, headerRange);
        command.insertNewRow();
        spreadsheet.getSpreadsheetHistoryManager().addCommand(command);
    }
}

