/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.spreadsheet;

import com.fasterxml.jackson.annotation.JsonInclude;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tools.jackson.core.JacksonException;
import tools.jackson.databind.ObjectMapper;
import tools.jackson.databind.json.JsonMapper;

class Serializer {
    private static final ObjectMapper objectMapper;
    private static final Logger LOGGER;

    Serializer() {
    }

    static String serialize(Object value) {
        try {
            return value == null ? "" : objectMapper.writeValueAsString(value);
        }
        catch (JacksonException e) {
            LOGGER.error("Error when serializing to JSON value: {}", value, (Object)e);
            return null;
        }
    }

    static {
        LOGGER = LoggerFactory.getLogger(Serializer.class);
        objectMapper = ((JsonMapper.Builder)JsonMapper.builder().changeDefaultPropertyInclusion(handler -> handler.withValueInclusion(JsonInclude.Include.NON_DEFAULT))).build();
    }
}

