/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.spreadsheet.action;

import com.vaadin.flow.component.spreadsheet.Spreadsheet;
import com.vaadin.flow.component.spreadsheet.action.SpreadsheetAction;
import org.apache.poi.ss.usermodel.Comment;
import org.apache.poi.ss.util.CellAddress;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.ss.util.CellReference;

public class EditCellCommentAction
extends SpreadsheetAction {
    public EditCellCommentAction() {
        super("Edit comment");
    }

    @Override
    public boolean isApplicableForSelection(Spreadsheet spreadsheet, Spreadsheet.SelectionChangeEvent event) {
        if (!spreadsheet.getActiveSheet().getProtect() && event.getCellRangeAddresses().size() == 0 && event.getIndividualSelectedCells().size() == 0) {
            CellReference cr = event.getSelectedCellReference();
            Comment cellComment = spreadsheet.getActiveSheet().getCellComment(new CellAddress(cr.getRow(), (int)cr.getCol()));
            if (cellComment != null) {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isApplicableForHeader(Spreadsheet spreadsheet, CellRangeAddress headerRange) {
        return false;
    }

    @Override
    public void executeActionOnSelection(Spreadsheet spreadsheet, Spreadsheet.SelectionChangeEvent event) {
        CellReference cr = event.getSelectedCellReference();
        spreadsheet.editCellComment(cr);
    }

    @Override
    public void executeActionOnHeader(Spreadsheet spreadsheet, CellRangeAddress headerRange) {
        throw new UnsupportedOperationException("Cell comment actions can't be executed against a header range.");
    }
}

