/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.spreadsheet.charts.converter.xssfreader;

import com.vaadin.flow.component.spreadsheet.Spreadsheet;
import com.vaadin.flow.component.spreadsheet.charts.converter.Utils;
import com.vaadin.flow.component.spreadsheet.charts.converter.chartdata.AbstractSeriesData;
import com.vaadin.flow.component.spreadsheet.charts.converter.chartdata.ChartData;
import com.vaadin.flow.component.spreadsheet.charts.converter.xssfreader.AreaSeriesReader;
import com.vaadin.flow.component.spreadsheet.charts.converter.xssfreader.BarSeriesReader;
import com.vaadin.flow.component.spreadsheet.charts.converter.xssfreader.BubbleSeriesReader;
import com.vaadin.flow.component.spreadsheet.charts.converter.xssfreader.ChartStylesReader;
import com.vaadin.flow.component.spreadsheet.charts.converter.xssfreader.LineSeriesReader;
import com.vaadin.flow.component.spreadsheet.charts.converter.xssfreader.PieSeriesReader;
import com.vaadin.flow.component.spreadsheet.charts.converter.xssfreader.RadarSeriesReader;
import com.vaadin.flow.component.spreadsheet.charts.converter.xssfreader.ScatterSeriesReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import org.apache.poi.xssf.usermodel.XSSFChart;
import org.apache.xmlbeans.XmlObject;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTAreaChart;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTBar3DChart;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTBarChart;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTChart;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTDoughnutChart;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTLineChart;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTPie3DChart;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTPieChart;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTPlotArea;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTRadarChart;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTScatterChart;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTUnsignedInt;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTView3D;
import org.openxmlformats.schemas.drawingml.x2006.chart.STDispBlanksAs;
import org.openxmlformats.schemas.drawingml.x2006.chart.STLegendPos;

public class XSSFChartReader {
    private final XSSFChart xssfChart;
    private final Spreadsheet spreadsheet;
    private final ChartStylesReader stylesReader;
    private LinkedHashMap<Long, ChartData.AxisProperties> yAxes;

    public XSSFChartReader(Spreadsheet spreadsheet, XSSFChart xssfChart) {
        this.spreadsheet = spreadsheet;
        this.xssfChart = xssfChart;
        this.stylesReader = new ChartStylesReader(spreadsheet, xssfChart);
    }

    public ChartData readXSSFChart() {
        ChartData chartData = new ChartData();
        CTPlotArea plotArea = this.xssfChart.getCTChart().getPlotArea();
        this.yAxes = this.stylesReader.getYAxisProperties();
        chartData.plotData = this.readPlotData(plotArea);
        chartData.title = this.getTitle(this.xssfChart, chartData.plotData);
        CTView3D view3d = this.xssfChart.getCTChart().getView3D();
        if (view3d != null) {
            chartData.view3dData = new ChartData.View3dData();
            if (view3d.getRotX() != null) {
                chartData.view3dData.rotation3dAngleA = view3d.getRotX().getVal();
            }
            if (view3d.getRotY() != null) {
                chartData.view3dData.rotation3dAngleB = view3d.getRotY().getVal();
            }
        }
        chartData.legendProperties = this.getLegendProperties();
        chartData.borderStyle = this.stylesReader.getBorderStyle();
        chartData.background = this.stylesReader.getBackgroundProperties();
        chartData.titleStyle = this.stylesReader.getTitleProperties();
        chartData.xAxisProperties = this.stylesReader.getXAxisProperties();
        chartData.yAxesProperties = new ArrayList<ChartData.AxisProperties>(this.yAxes.values());
        chartData.blanksAsZeros = this.getDisplayBlanksAs();
        return chartData;
    }

    private boolean getDisplayBlanksAs() {
        try {
            STDispBlanksAs.Enum blanksAs = this.xssfChart.getCTChart().getDispBlanksAs().getVal();
            return blanksAs == STDispBlanksAs.ZERO;
        }
        catch (NullPointerException e) {
            return false;
        }
    }

    private ChartData.LegendProperties getLegendProperties() {
        ChartData.LegendProperties result = new ChartData.LegendProperties();
        result.position = this.getLegendPosition();
        result.textProperties = this.stylesReader.getLegendTextProperties();
        return result;
    }

    private ChartData.LegendPosition getLegendPosition() {
        HashMap<STLegendPos.Enum, ChartData.LegendPosition> translationMap = new HashMap<STLegendPos.Enum, ChartData.LegendPosition>();
        translationMap.put(STLegendPos.B, ChartData.LegendPosition.BOTTOM);
        translationMap.put(STLegendPos.L, ChartData.LegendPosition.LEFT);
        translationMap.put(STLegendPos.T, ChartData.LegendPosition.TOP);
        translationMap.put(STLegendPos.TR, ChartData.LegendPosition.TOP_RIGHT);
        translationMap.put(STLegendPos.R, ChartData.LegendPosition.RIGHT);
        try {
            STLegendPos.Enum legendPos = this.xssfChart.getCTChart().getLegend().getLegendPos().getVal();
            return (ChartData.LegendPosition)((Object)translationMap.get(legendPos));
        }
        catch (NullPointerException e) {
            return ChartData.LegendPosition.NONE;
        }
    }

    private List<AbstractSeriesData> readPlotData(CTPlotArea plotArea) {
        boolean showDataInHiddenCells = this.getShowDataInHiddenCells();
        ArrayList<AbstractSeriesData> list = new ArrayList<AbstractSeriesData>();
        for (CTBarChart ctChart : plotArea.getBarChartList()) {
            list.addAll(this.addYAxis(new BarSeriesReader(ctChart, this.spreadsheet, showDataInHiddenCells).getSeries(), this.getAxIdList((XmlObject)ctChart)));
        }
        for (CTBarChart ctChart : plotArea.getBar3DChartList()) {
            list.addAll(this.addYAxis(new BarSeriesReader((CTBar3DChart)ctChart, this.spreadsheet, showDataInHiddenCells).getSeries(), this.getAxIdList((XmlObject)ctChart)));
        }
        for (CTBarChart ctChart : plotArea.getPieChartList()) {
            list.addAll(new PieSeriesReader((CTPieChart)ctChart, this.spreadsheet, showDataInHiddenCells).getSeries());
        }
        for (CTBarChart ctChart : plotArea.getPie3DChartList()) {
            list.addAll(new PieSeriesReader((CTPie3DChart)ctChart, this.spreadsheet, showDataInHiddenCells).getSeries());
        }
        for (CTBarChart ctChart : plotArea.getAreaChartList()) {
            list.addAll(this.addYAxis(new AreaSeriesReader((CTAreaChart)ctChart, this.spreadsheet, showDataInHiddenCells).getSeries(), this.getAxIdList((XmlObject)ctChart)));
        }
        for (CTBarChart ctChart : plotArea.getBubbleChartList()) {
            list.addAll(this.addYAxis(new BubbleSeriesReader((XmlObject)ctChart, this.spreadsheet, showDataInHiddenCells).getSeries(), this.getAxIdList((XmlObject)ctChart)));
        }
        for (CTBarChart ctChart : plotArea.getLineChartList()) {
            list.addAll(this.addYAxis(new LineSeriesReader((CTLineChart)ctChart, this.spreadsheet, showDataInHiddenCells).getSeries(), this.getAxIdList((XmlObject)ctChart)));
        }
        for (CTBarChart ctChart : plotArea.getRadarChartList()) {
            list.addAll(this.addYAxis(new RadarSeriesReader((CTRadarChart)ctChart, this.spreadsheet, showDataInHiddenCells).getSeries(), this.getAxIdList((XmlObject)ctChart)));
        }
        for (CTBarChart ctChart : plotArea.getScatterChartList()) {
            list.addAll(this.addYAxis(new ScatterSeriesReader((CTScatterChart)ctChart, this.spreadsheet, showDataInHiddenCells).getSeries(), this.getAxIdList((XmlObject)ctChart)));
        }
        for (CTBarChart ctChart : plotArea.getDoughnutChartList()) {
            list.addAll(new PieSeriesReader((CTDoughnutChart)ctChart, this.spreadsheet, showDataInHiddenCells).getSeries());
        }
        return list;
    }

    private boolean getShowDataInHiddenCells() {
        try {
            return !this.xssfChart.getCTChart().getPlotVisOnly().getVal();
        }
        catch (NullPointerException e) {
            return false;
        }
    }

    private Collection<? extends AbstractSeriesData> addYAxis(Collection<? extends AbstractSeriesData> seriesList, List<CTUnsignedInt> axIdList) {
        ArrayList<Long> axisIds = new ArrayList<Long>(this.yAxes.keySet());
        block0: for (Long axisId : axisIds) {
            for (CTUnsignedInt id : axIdList) {
                if (id.getVal() != axisId.longValue()) continue;
                for (AbstractSeriesData abstractSeriesData : seriesList) {
                    abstractSeriesData.yAxis = axisIds.indexOf(axisId);
                }
                continue block0;
            }
        }
        return seriesList;
    }

    private List<CTUnsignedInt> getAxIdList(XmlObject ctChart) {
        return (List)Utils.callMethodUsingReflection(ctChart, "getAxIdList");
    }

    private String getTitle(XSSFChart chart, List<AbstractSeriesData> plotData) {
        Object title = "";
        CTChart ctChart = chart.getCTChart();
        if (ctChart.isSetTitle() && ((String)(title = String.valueOf(chart.getTitleText()))).isEmpty() && plotData.size() > 0 && plotData.get((int)0).name != null) {
            title = plotData.get((int)0).name;
        }
        return title;
    }
}

