/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.spreadsheet;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.button.ButtonVariant;
import com.vaadin.flow.component.html.Div;
import com.vaadin.flow.component.shared.ThemeVariant;
import com.vaadin.flow.component.spreadsheet.ItemFilter;
import com.vaadin.flow.component.spreadsheet.PopupButton;
import com.vaadin.flow.component.spreadsheet.Spreadsheet;
import com.vaadin.flow.component.spreadsheet.SpreadsheetFilter;
import com.vaadin.flow.component.spreadsheet.SpreadsheetTable;
import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.usermodel.XSSFTable;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTAutoFilter;

public class SpreadsheetFilterTable
extends SpreadsheetTable {
    public static final String CLEAR_FILTERS_BUTTON_CLASSNAME = "clear-filters-button";
    public static final String FILTER_TABLE_CONTENT_CLASSNAME = "spreadsheet-filter-table-content";
    protected final Map<PopupButton, HashSet<SpreadsheetFilter>> popupButtonToFiltersMap = new HashMap<PopupButton, HashSet<SpreadsheetFilter>>();
    protected final Map<PopupButton, Button> popupButtonToClearButtonMap = new HashMap<PopupButton, Button>();
    protected CellRangeAddress filteringRegion;

    public SpreadsheetFilterTable(Spreadsheet spreadsheet, CellRangeAddress fullTableRegion) {
        this(spreadsheet, spreadsheet.getActiveSheet(), fullTableRegion);
    }

    public SpreadsheetFilterTable(Spreadsheet spreadsheet, Sheet sheet, CellRangeAddress fullTableRegion) {
        this(spreadsheet, spreadsheet.getActiveSheet(), fullTableRegion, null, null);
    }

    public SpreadsheetFilterTable(Spreadsheet spreadsheet, Sheet sheet, CellRangeAddress fullTableRegion, CTAutoFilter ctWorksheetAutoFilter, XSSFTable xssfTable) {
        super(spreadsheet, sheet, fullTableRegion, ctWorksheetAutoFilter, xssfTable);
        this.filteringRegion = new CellRangeAddress(fullTableRegion.getFirstRow() + 1, fullTableRegion.getLastRow(), fullTableRegion.getFirstColumn(), fullTableRegion.getLastColumn());
        if (this.isTableSheetCurrentlyActive()) {
            this.initFilters();
            this.initClearAllButtons();
        }
    }

    @Override
    public void reload() {
        super.reload();
        if (this.isTableSheetCurrentlyActive()) {
            if (this.popupButtonToFiltersMap.isEmpty()) {
                this.initFilters();
            }
            if (this.popupButtonToClearButtonMap.isEmpty()) {
                this.initClearAllButtons();
            }
        }
    }

    @Override
    public void clear() {
        super.clear();
        this.popupButtonToClearButtonMap.clear();
        this.popupButtonToFiltersMap.clear();
    }

    public void clearAllFilters() {
        for (Map.Entry<PopupButton, HashSet<SpreadsheetFilter>> entry : this.popupButtonToFiltersMap.entrySet()) {
            PopupButton popupButton = entry.getKey();
            HashSet<SpreadsheetFilter> filters = entry.getValue();
            for (SpreadsheetFilter filter : filters) {
                filter.clearFilter();
            }
            this.popupButtonToClearButtonMap.get((Object)popupButton).setEnabled(false);
            popupButton.markActive(false);
        }
        this.getSpreadsheet().setRowsHidden(IntStream.range(this.filteringRegion.getFirstRow(), this.filteringRegion.getLastRow() + 1).boxed().collect(Collectors.toMap(Function.identity(), index -> false)));
    }

    protected void initClearAllButtons() {
        for (PopupButton popupButton : this.getPopupButtons()) {
            Button clearButton = this.createClearButton();
            this.addComponentToPopup(popupButton, (Component)clearButton);
            this.popupButtonToClearButtonMap.put(popupButton, clearButton);
        }
    }

    protected void initFilters() {
        this.initItemFilters();
    }

    protected void initItemFilters() {
        int firstRow = this.filteringRegion.getFirstRow();
        int lastRow = this.filteringRegion.getLastRow();
        for (PopupButton popupButton : this.getPopupButtons()) {
            int column = popupButton.getColumn();
            ItemFilter itemFilter = new ItemFilter(new CellRangeAddress(firstRow, lastRow, column, column), this.getSpreadsheet(), popupButton, this);
            this.addComponentToPopup(popupButton, (Component)itemFilter);
            this.registerFilter(popupButton, itemFilter);
        }
    }

    private void addComponentToPopup(PopupButton popupButton, Component component) {
        if (popupButton.getContent() == null) {
            Div content = new Div();
            content.addClassName(FILTER_TABLE_CONTENT_CLASSNAME);
            popupButton.setContent((Component)content);
        }
        ((Div)popupButton.getContent()).add(new Component[]{component});
    }

    protected Button createClearButton() {
        Button button = new Button("Clear filters");
        button.setDisableOnClick(true);
        button.setEnabled(false);
        button.addThemeVariants((ThemeVariant[])new ButtonVariant[]{ButtonVariant.LUMO_TERTIARY, ButtonVariant.LUMO_SMALL});
        button.addClassName(CLEAR_FILTERS_BUTTON_CLASSNAME);
        button.addClickListener((ComponentEventListener & Serializable)event -> this.clearAllFilters());
        return button;
    }

    public CellRangeAddress getFilteringRegion() {
        return this.filteringRegion;
    }

    public void onFiltersUpdated() {
        HashSet filteredRows = new HashSet();
        for (Map.Entry<PopupButton, HashSet<SpreadsheetFilter>> entry : this.popupButtonToFiltersMap.entrySet()) {
            PopupButton popupButton = entry.getKey();
            HashSet<SpreadsheetFilter> filters = entry.getValue();
            HashSet<Integer> temp = new HashSet<Integer>();
            for (SpreadsheetFilter filter : filters) {
                temp.addAll(filter.getFilteredRows());
            }
            this.popupButtonToClearButtonMap.get((Object)popupButton).setEnabled(!temp.isEmpty());
            popupButton.markActive(!temp.isEmpty());
            filteredRows.addAll(temp);
        }
        this.getSpreadsheet().setRowsHidden(IntStream.range(this.filteringRegion.getFirstRow(), this.filteringRegion.getLastRow() + 1).boxed().collect(Collectors.toMap(Function.identity(), filteredRows::contains)));
    }

    public void registerFilter(PopupButton popupButton, SpreadsheetFilter filter) {
        if (this.getPopupButtons().contains((Object)popupButton)) {
            if (this.popupButtonToFiltersMap.containsKey((Object)popupButton)) {
                this.popupButtonToFiltersMap.get((Object)popupButton).add(filter);
            } else {
                HashSet<SpreadsheetFilter> filters = new HashSet<SpreadsheetFilter>();
                filters.add(filter);
                this.popupButtonToFiltersMap.put(popupButton, filters);
            }
        } else {
            throw new IllegalArgumentException("PopupButton is not inside this filterable Table");
        }
    }

    public void unRegisterFilter(PopupButton popupButton, SpreadsheetFilter filter) {
        HashSet<SpreadsheetFilter> filters = this.popupButtonToFiltersMap.get((Object)popupButton);
        filters.remove(filter);
        if (filters.isEmpty()) {
            this.popupButtonToFiltersMap.remove((Object)popupButton);
        }
    }
}

