/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.spreadsheet.charts.converter.confwriter;

import com.vaadin.flow.component.charts.model.AbstractPlotOptions;
import com.vaadin.flow.component.charts.model.Configuration;
import com.vaadin.flow.component.charts.model.DataSeries;
import com.vaadin.flow.component.charts.model.DataSeriesItem;
import com.vaadin.flow.component.charts.model.DataSeriesItem3d;
import com.vaadin.flow.component.charts.model.Series;
import com.vaadin.flow.component.spreadsheet.charts.converter.chartdata.AbstractSeriesData;
import com.vaadin.flow.component.spreadsheet.charts.converter.confwriter.SelectListeningDataSeries;

public abstract class AbstractSeriesDataWriter {
    private final AbstractSeriesData series;
    private AbstractPlotOptions plotOptions;

    public AbstractSeriesDataWriter(AbstractSeriesData series) {
        this.series = series;
    }

    public Series convertSeries(final boolean blanksAsZeros) {
        final SelectListeningDataSeries dataSeries = new SelectListeningDataSeries(this.getSeriesData().name, () -> this.getSeriesData().dataSelectListener.dataSelected());
        this.configureDataSeries(dataSeries);
        dataSeries.setyAxis(this.series.yAxis);
        for (AbstractSeriesData.SeriesPoint point : this.series.seriesData) {
            dataSeries.add(this.createDataSeriesItem(point, blanksAsZeros));
        }
        this.series.dataUpdateListener = new AbstractSeriesData.DataUpdateListener(){

            @Override
            public void xDataModified(int i, Double cellValue) {
                DataSeriesItem item = dataSeries.get(i);
                if (blanksAsZeros && cellValue == null) {
                    item.setX((Number)0.0);
                } else {
                    item.setX((Number)cellValue);
                }
                dataSeries.update(item);
            }

            @Override
            public void yDataModified(int i, Double cellValue) {
                DataSeriesItem item = dataSeries.get(i);
                if (blanksAsZeros && cellValue == null) {
                    item.setY((Number)0.0);
                } else {
                    item.setY((Number)cellValue);
                }
                dataSeries.update(item);
            }

            @Override
            public void zDataModified(int i, Double cellValue) {
                DataSeriesItem3d item = (DataSeriesItem3d)dataSeries.get(i);
                if (blanksAsZeros && cellValue == null) {
                    item.setZ((Number)0.0);
                } else {
                    item.setZ((Number)cellValue);
                }
                dataSeries.update((DataSeriesItem)item);
            }

            @Override
            public void categoryModified(int i, String cellValue) {
                DataSeriesItem item = dataSeries.get(i);
                item.setName(cellValue);
                dataSeries.update(item);
            }
        };
        return dataSeries;
    }

    protected AbstractSeriesData getSeriesData() {
        return this.series;
    }

    protected AbstractPlotOptions getPlotOptions() {
        if (this.plotOptions == null) {
            this.plotOptions = this.createPlotOptions();
        }
        return this.plotOptions;
    }

    protected DataSeriesItem createDataSeriesItem(AbstractSeriesData.SeriesPoint point, boolean blanksAsZeros) {
        DataSeriesItem result = null;
        result = point.yValue == null && blanksAsZeros ? new DataSeriesItem(point.xValue, (Number)0.0) : new DataSeriesItem(point.xValue, point.yValue);
        if (this.getSeriesData().categories.size() > point.xValue.intValue()) {
            result.setName(this.getSeriesData().categories.get(point.xValue.intValue()));
        }
        return result;
    }

    protected void configureDataSeries(DataSeries dataSeriesForWriting) {
        dataSeriesForWriting.setPlotOptions(this.getPlotOptions());
    }

    protected abstract AbstractPlotOptions createPlotOptions();

    protected void configureChart(Configuration conf) {
    }
}

