/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.spreadsheet.charts.converter.xssfreader;

import com.vaadin.flow.component.spreadsheet.Spreadsheet;
import com.vaadin.flow.component.spreadsheet.charts.converter.chartdata.AreaSeriesData;
import com.vaadin.flow.component.spreadsheet.charts.converter.chartdata.Stacking;
import com.vaadin.flow.component.spreadsheet.charts.converter.xssfreader.AbstractSeriesReader;
import org.apache.xmlbeans.XmlObject;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTAreaChart;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTAreaSer;
import org.openxmlformats.schemas.drawingml.x2006.chart.STGrouping;

public class AreaSeriesReader
extends AbstractSeriesReader<CTAreaSer, AreaSeriesData> {
    public AreaSeriesReader(CTAreaChart ctChart, Spreadsheet spreadsheet, boolean showDataInHiddenCells) {
        super((XmlObject)ctChart, spreadsheet, showDataInHiddenCells);
    }

    @Override
    protected AreaSeriesData createSeriesDataObject(CTAreaSer serie) {
        return new AreaSeriesData();
    }

    @Override
    protected void fillSeriesData(AreaSeriesData seriesData, CTAreaSer serie) {
        super.fillSeriesData(seriesData, serie);
        CTAreaChart chart = (CTAreaChart)this.getChart();
        if (chart.isSetGrouping()) {
            seriesData.stacking = this.getStacking(chart.getGrouping().getVal());
        }
    }

    private Stacking getStacking(STGrouping.Enum grouping) {
        if (grouping == STGrouping.PERCENT_STACKED) {
            return Stacking.PERCENT;
        }
        if (grouping == STGrouping.STANDARD) {
            return Stacking.NONE;
        }
        if (grouping == STGrouping.STACKED) {
            return Stacking.NORMAL;
        }
        return Stacking.NONE;
    }
}

