/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.spreadsheet;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.spreadsheet.client.OverlayInfo;
import com.vaadin.flow.server.streams.DownloadHandler;
import java.io.Serializable;
import org.apache.poi.ss.usermodel.ClientAnchor;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.xssf.usermodel.XSSFClientAnchor;

public abstract class SheetOverlayWrapper
implements Serializable {
    private static long counter;
    private final ClientAnchor anchor;
    private final String id;
    private boolean visible;

    public SheetOverlayWrapper(ClientAnchor anchor) {
        this.anchor = anchor;
        this.id = "sheet-overlay-" + counter;
        ++counter;
    }

    public void setOverlayChangeListener(OverlayChangeListener listener) {
    }

    public boolean isVisible(int r1, int c1, int r2, int c2) {
        int col1 = this.anchor.getCol1() + 1;
        int col2 = this.anchor.getCol2() + 1;
        int row1 = this.anchor.getRow1() + 1;
        int row2 = this.anchor.getRow2() + 1;
        if (r2 - r1 < 0 || c2 - c1 < 0) {
            return false;
        }
        boolean col1isBetweenc1andc2 = c1 <= col1 && col1 <= c2;
        boolean col2isBetweenc1andc2 = c1 <= col2 && col2 <= c2;
        boolean inColumnRange = col1isBetweenc1andc2 || col2isBetweenc1andc2;
        boolean row1isBetweenr1andr2 = r1 <= row1 && row1 <= r2;
        boolean row2isBetweenr1andr2 = r1 <= row2 && row2 <= r2;
        boolean inRowRange = row1isBetweenr1andr2 || row2isBetweenr1andr2;
        return inColumnRange && inRowRange;
    }

    float getDx1(Sheet sheet) {
        if (this.anchor instanceof XSSFClientAnchor) {
            return (float)this.anchor.getDx1() / 9525.0f;
        }
        return sheet.getColumnWidthInPixels((int)this.anchor.getCol1()) * (float)this.anchor.getDx1() / 1023.0f;
    }

    private float getDx2(Sheet sheet) {
        if (this.anchor instanceof XSSFClientAnchor) {
            return (float)this.anchor.getDx2() / 9525.0f;
        }
        return sheet.getColumnWidthInPixels((int)this.anchor.getCol2()) * (float)this.anchor.getDx2() / 1023.0f;
    }

    float getDy1(Sheet sheet) {
        if (this.anchor instanceof XSSFClientAnchor) {
            return (float)this.anchor.getDy1() / 12700.0f;
        }
        Row row = sheet.getRow(this.anchor.getRow1());
        return (row == null ? sheet.getDefaultRowHeightInPoints() : row.getHeightInPoints()) * (float)this.anchor.getDy1() / 255.0f;
    }

    private float getDy2(Sheet sheet) {
        if (this.anchor instanceof XSSFClientAnchor) {
            return (float)this.anchor.getDy2() / 12700.0f;
        }
        Row row = sheet.getRow(this.anchor.getRow2());
        return (row == null ? sheet.getDefaultRowHeightInPoints() : row.getHeightInPoints()) * (float)this.anchor.getDy2() / 255.0f;
    }

    public float getWidth(Sheet sheet, int[] colW, int defaultColumnWidthPX) {
        int col1 = this.anchor.getCol1();
        short col2 = this.anchor.getCol2();
        float width = this.getDx2(sheet) - this.getDx1(sheet);
        if (col1 < col2) {
            for (int i = col1; i < col2; ++i) {
                if (sheet.isColumnHidden(i)) continue;
                if (i < colW.length) {
                    width += (float)colW[i];
                    continue;
                }
                width += (float)defaultColumnWidthPX;
            }
        } else if (col1 > col2) {
            width = -1.0f;
        }
        return width;
    }

    public float getHeight(Sheet sheet, float[] rowH) {
        int row1 = this.anchor.getRow1();
        int row2 = this.anchor.getRow2();
        float height = this.getDy2(sheet) - this.getDy1(sheet);
        if (row1 < row2) {
            for (int i = row1; i < row2; ++i) {
                Row row = sheet.getRow(i);
                if (row != null && row.getZeroHeight()) continue;
                if (i < rowH.length) {
                    height += rowH[i];
                    continue;
                }
                height += sheet.getDefaultRowHeightInPoints();
            }
        } else if (row1 > row2) {
            height = -1.0f;
        }
        return height;
    }

    public String getId() {
        return this.id;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    public ClientAnchor getAnchor() {
        return this.anchor;
    }

    public DownloadHandler getResourceHandler() {
        return null;
    }

    public Component getComponent(boolean init) {
        return null;
    }

    public abstract OverlayInfo.Type getType();

    public String toString() {
        Object anchor = ", anchor=null";
        if (this.getAnchor() != null) {
            anchor = ", col1=" + this.getAnchor().getCol1() + ", col2=" + this.getAnchor().getCol2() + ", row1=" + this.getAnchor().getRow1() + ", row2=" + this.getAnchor().getRow2() + ", dx1=" + this.getAnchor().getDx1() + ", dx2=" + this.getAnchor().getDx2() + ", dy1=" + this.getAnchor().getDy1() + ", dy2=" + this.getAnchor().getDy2() + ", type=" + this.getAnchor().getAnchorType();
        }
        return "OverlayData [resourceKey=" + this.getId() + (String)anchor + "]";
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SheetOverlayWrapper other = (SheetOverlayWrapper)obj;
        if (this.getAnchor() == null ? other.getAnchor() != null : !this.getAnchor().equals(other.getAnchor())) {
            return false;
        }
        return !(this.id == null ? other.id != null : !this.id.equals(other.id));
    }

    public static interface OverlayChangeListener
    extends Serializable {
        public void overlayChanged();
    }
}

