/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.spreadsheet;

import com.vaadin.flow.component.spreadsheet.CellSelectionManager;
import com.vaadin.flow.component.spreadsheet.Spreadsheet;
import com.vaadin.flow.component.spreadsheet.SpreadsheetFactory;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import org.apache.poi.ss.SpreadsheetVersion;
import org.apache.poi.ss.usermodel.Name;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.ss.util.CellReference;

class NamedRangeUtils
implements Serializable {
    private Spreadsheet spreadsheet;

    public NamedRangeUtils(Spreadsheet spreadsheet) {
        this.spreadsheet = spreadsheet;
    }

    private CellSelectionManager getSelectionManager() {
        return this.spreadsheet.getCellSelectionManager();
    }

    public String getNameForFormulaIfExists(CellRangeAddress cra) {
        String sheetName = this.spreadsheet.getActiveSheet().getSheetName();
        String formula = cra.formatAsString(sheetName, true);
        for (Name name : this.spreadsheet.getWorkbook().getAllNames()) {
            boolean nameRefersToThisSheet;
            boolean globalName = name.getSheetIndex() == -1;
            boolean bl = nameRefersToThisSheet = name.getSheetIndex() == this.spreadsheet.getActiveSheetIndex();
            if (!globalName && !nameRefersToThisSheet || !formula.equals(name.getRefersToFormula())) continue;
            return name.getNameName();
        }
        return null;
    }

    public boolean isCellReference(String value) {
        CellReference.NameType nameType = this.getCellReferenceType(value);
        List<CellReference.NameType> cellColRowTypes = Arrays.asList(CellReference.NameType.CELL, CellReference.NameType.COLUMN, CellReference.NameType.ROW);
        return cellColRowTypes.contains(nameType);
    }

    public void onNamedRange(String value) {
        Workbook workbook = this.spreadsheet.getWorkbook();
        Name name = workbook.getName(value);
        if (name == null) {
            this.createNewNamedRange(value);
        } else {
            this.selectExistingNameRange(name);
        }
    }

    public boolean isNamedRange(String value) {
        CellReference.NameType nameType = this.getCellReferenceType(value);
        return CellReference.NameType.NAMED_RANGE.equals((Object)nameType);
    }

    private CellReference.NameType getCellReferenceType(String value) {
        SpreadsheetVersion spreadsheetVersion = this.getSpreadsheetVersion();
        return CellReference.classifyCellReference((String)value, (SpreadsheetVersion)spreadsheetVersion);
    }

    private SpreadsheetVersion getSpreadsheetVersion() {
        return this.spreadsheet.getWorkbook().getSpreadsheetVersion();
    }

    private void createNewNamedRange(String newName) {
        Workbook workbook = this.spreadsheet.getWorkbook();
        Name name = workbook.createName();
        name.setNameName(newName);
        name.setRefersToFormula(this.getSelectedRangeFormula());
        SpreadsheetFactory.loadNamedRanges(this.spreadsheet);
    }

    private String getSelectedRangeFormula() {
        String sheetName = this.spreadsheet.getActiveSheet().getSheetName();
        return this.getSelectionManager().getSelectedCellRange().formatAsString(sheetName, true);
    }

    private void selectExistingNameRange(Name name) {
        boolean rangeIsOnDifferentSheet;
        String rangeFormula = name.getRefersToFormula();
        String formulaSheet = name.getSheetName();
        boolean bl = rangeIsOnDifferentSheet = !name.getSheetName().equals(this.spreadsheet.getActiveSheet().getSheetName());
        if (rangeIsOnDifferentSheet) {
            this.switchSheet(formulaSheet, rangeFormula);
        } else {
            this.selectFormula(rangeFormula, name.getNameName());
        }
    }

    private void switchSheet(String formulaSheet, String range) {
        if (!this.spreadsheet.getActiveSheet().getSheetName().equals(formulaSheet)) {
            int sheetIndex = this.spreadsheet.getWorkbook().getSheetIndex(formulaSheet);
            this.spreadsheet.setActiveSheetIndex(sheetIndex);
            this.spreadsheet.initialSheetSelection = range;
        }
    }

    private void selectFormula(String formula, String name) {
        if (formula.indexOf(":") == -1) {
            CellReference cell = new CellReference(formula);
            this.getSelectionManager().handleCellAddressChange(cell.getRow() + 1, cell.getCol() + 1, false, name);
        } else {
            CellRangeAddress cra = this.spreadsheet.createCorrectCellRangeAddress(formula);
            this.getSelectionManager().handleCellRangeSelection(name, cra);
        }
    }
}

