/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.spreadsheet.charts.converter.xssfreader;

import com.vaadin.flow.component.spreadsheet.Spreadsheet;
import com.vaadin.flow.component.spreadsheet.charts.converter.chartdata.LineSeriesData;
import com.vaadin.flow.component.spreadsheet.charts.converter.chartdata.SplineSeriesData;
import com.vaadin.flow.component.spreadsheet.charts.converter.xssfreader.AbstractSeriesReader;
import com.vaadin.flow.component.spreadsheet.charts.converter.xssfreader.LineSeriesReaderUtils;
import org.apache.xmlbeans.XmlObject;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTLineChart;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTLineSer;

public class LineSeriesReader
extends AbstractSeriesReader<CTLineSer, LineSeriesData> {
    public LineSeriesReader(CTLineChart ctChart, Spreadsheet spreadsheet, boolean showDataInHiddenCells) {
        super((XmlObject)ctChart, spreadsheet, showDataInHiddenCells);
    }

    @Override
    protected LineSeriesData createSeriesDataObject(CTLineSer serie) {
        if (serie.getSmooth().getVal()) {
            return new SplineSeriesData();
        }
        return new LineSeriesData();
    }

    @Override
    protected void fillSeriesData(LineSeriesData seriesData, CTLineSer serie) {
        super.fillSeriesData(seriesData, serie);
        if (serie.getMarker() != null) {
            LineSeriesReaderUtils.setMarkerForData(seriesData, serie.getMarker());
        }
        if (serie.getSpPr() != null) {
            LineSeriesReaderUtils.setDashStyleForData(seriesData, serie.getSpPr());
        }
    }
}

