/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.spreadsheet;

import java.io.Serializable;
import java.util.Locale;
import java.util.regex.Pattern;
import org.apache.poi.ss.format.CellFormat;
import org.apache.poi.ss.formula.ConditionalFormattingEvaluator;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.DataFormatter;
import org.apache.poi.ss.usermodel.FormulaEvaluator;

class CustomDataFormatter
extends DataFormatter
implements Serializable {
    private static final Pattern NUMBER_PATTERN = Pattern.compile("[0#]+");
    private final int POSITIVE_FORMAT_INDEX = 0;
    private final int NEGATIVE_FORMAT_INDEX = 1;
    private final int ZERO_FORMAT_INDEX = 2;
    private final int TEXT_FORMAT_INDEX = 3;
    private Locale locale;

    public CustomDataFormatter() {
    }

    public CustomDataFormatter(Locale locale) {
        super(locale);
        this.locale = locale;
    }

    public String formatCellValue(Cell cell, FormulaEvaluator evaluator, ConditionalFormattingEvaluator cfEvaluator) {
        if (cell == null || cell.getCellStyle() == null) {
            return super.formatCellValue(cell, evaluator, cfEvaluator);
        }
        String dataFormatString = cell.getCellStyle().getDataFormatString();
        if (this.isGeneralFormat(dataFormatString)) {
            return super.formatCellValue(cell, evaluator, cfEvaluator);
        }
        String[] parts = dataFormatString.split(";", -1);
        CellType cellType = this.getCellType(cell, evaluator);
        if (cellType == CellType.NUMERIC) {
            return this.formatNumericValueUsingFormatPart(cell, evaluator, cfEvaluator, parts);
        }
        if (cellType == CellType.STRING && parts.length == 4) {
            return this.formatStringCellValue(cell, dataFormatString, parts);
        }
        return super.formatCellValue(cell, evaluator, cfEvaluator);
    }

    public void updateLocale(Locale newLocale) {
        super.updateLocale(newLocale);
        this.locale = newLocale;
    }

    private CellType getCellType(Cell cell, FormulaEvaluator evaluator) {
        CellType cellType = cell.getCellType();
        if (cellType == CellType.FORMULA) {
            cellType = evaluator.evaluateFormulaCell(cell);
        }
        return cellType;
    }

    private String formatNumericValueUsingFormatPart(Cell cell, FormulaEvaluator evaluator, ConditionalFormattingEvaluator cfEvaluator, String[] formatParts) {
        double value = cell.getNumericCellValue();
        String format = this.getNumericFormat(value, formatParts);
        if (format.isEmpty()) {
            return "";
        }
        if (this.isOnlyLiteralFormat(format)) {
            return this.formatTextUsingCellFormat(cell, format);
        }
        return super.formatCellValue(cell, evaluator, cfEvaluator);
    }

    private String formatTextUsingCellFormat(Cell cell, String format) {
        return CellFormat.getInstance((Locale)this.locale, (String)format).apply((Cell)cell).text;
    }

    private String getNumericFormat(double value, String[] formatParts) {
        switch (formatParts.length) {
            case 3: 
            case 4: {
                if (value == 0.0) {
                    return formatParts[2];
                }
            }
            case 2: {
                if (value < 0.0) {
                    return formatParts[1];
                }
            }
            case 1: {
                if (!(value < 0.0)) break;
                return "-" + formatParts[0];
            }
        }
        return formatParts[0];
    }

    private boolean isOnlyLiteralFormat(String format) {
        return !NUMBER_PATTERN.matcher(format).find();
    }

    private boolean isGeneralFormat(String format) {
        return "General".equals(format);
    }

    private String formatStringCellValue(Cell cell, String formatString, String[] parts) {
        if (parts[3].isEmpty()) {
            return "";
        }
        return this.formatTextUsingCellFormat(cell, formatString);
    }
}

