/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.spreadsheet.action;

import com.vaadin.flow.component.spreadsheet.Spreadsheet;
import com.vaadin.flow.component.spreadsheet.framework.Action;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.util.CellRangeAddress;

public abstract class SpreadsheetAction
extends Action {
    public SpreadsheetAction(String caption) {
        super(caption);
    }

    public abstract boolean isApplicableForSelection(Spreadsheet var1, Spreadsheet.SelectionChangeEvent var2);

    public abstract boolean isApplicableForHeader(Spreadsheet var1, CellRangeAddress var2);

    public abstract void executeActionOnSelection(Spreadsheet var1, Spreadsheet.SelectionChangeEvent var2);

    public abstract void executeActionOnHeader(Spreadsheet var1, CellRangeAddress var2);

    protected boolean isSheetProtected(Spreadsheet spreadsheet) {
        return spreadsheet.getActiveSheet().getProtect();
    }

    protected boolean isSheetProtected(Sheet sheet) {
        return sheet.getProtect();
    }

    protected boolean isCellLocked(Cell cell) {
        return cell.getSheet().getProtect() && cell.getCellStyle().getLocked();
    }

    protected String getColumnHeader(int col) {
        Object h = "";
        while (col > 0) {
            h = (char)(65 + (col - 1) % 26) + (String)h;
            col = (col - 1) / 26;
        }
        return h;
    }
}

