/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.spreadsheet.charts.converter.xssfreader;

import com.vaadin.flow.component.spreadsheet.Spreadsheet;
import com.vaadin.flow.component.spreadsheet.charts.converter.Utils;
import com.vaadin.flow.component.spreadsheet.charts.converter.chartdata.AbstractSeriesData;
import com.vaadin.flow.component.spreadsheet.charts.converter.chartdata.BubbleSeriesData;
import com.vaadin.flow.component.spreadsheet.charts.converter.xssfreader.AbstractSeriesReader;
import java.util.ArrayList;
import java.util.List;
import org.apache.poi.ss.util.CellReference;
import org.apache.xmlbeans.XmlObject;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTAxDataSource;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTBubbleSer;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTNumDataSource;

public class BubbleSeriesReader
extends AbstractSeriesReader<CTBubbleSer, BubbleSeriesData> {
    public BubbleSeriesReader(XmlObject ctChart, Spreadsheet spreadsheet, boolean showDataInHiddenCells) {
        super(ctChart, spreadsheet, showDataInHiddenCells);
    }

    @Override
    protected BubbleSeriesData createSeriesDataObject(CTBubbleSer serie) {
        return new BubbleSeriesData();
    }

    @Override
    protected void fillSeriesData(BubbleSeriesData seriesData, CTBubbleSer serie) {
        seriesData.name = this.tryGetSeriesName(serie.getTx());
        if (serie.getXVal() == null) {
            this.createSeriesDataPoints(serie.getYVal(), seriesData);
        } else {
            this.createSeriesDataPointsForBubble(serie.getXVal(), serie.getYVal(), serie.getBubbleSize(), seriesData);
        }
    }

    private void createSeriesDataPointsForBubble(CTAxDataSource xVal, CTNumDataSource yVal, CTNumDataSource bubbleSize, BubbleSeriesData seriesData) {
        List<CellReference> ptListX = Utils.getAllReferencedCells(xVal.getNumRef().getF(), this.getSpreadsheet(), this.showDataInHiddenCells);
        final String formulaY = yVal.getNumRef().getF();
        List<CellReference> ptListY = Utils.getAllReferencedCells(formulaY, this.getSpreadsheet(), this.showDataInHiddenCells);
        ArrayList<Double> sizes = new ArrayList<Double>();
        List<Object> ptListSize = new ArrayList();
        if (bubbleSize.getNumRef() == null) {
            for (i = 0; i < ptListY.size(); ++i) {
                sizes.add(1.0);
            }
        } else {
            ptListSize = Utils.getAllReferencedCells(bubbleSize.getNumRef().getF(), this.getSpreadsheet(), this.showDataInHiddenCells);
            for (i = 0; i < ptListSize.size(); ++i) {
                sizes.add(this.getNumericValueFromCellRef((CellReference)ptListSize.get(i)));
            }
        }
        ArrayList<AbstractSeriesData.SeriesPoint> list = new ArrayList<AbstractSeriesData.SeriesPoint>();
        for (int i = 0; i < ptListY.size(); ++i) {
            list.add(new AbstractSeriesData.SeriesPoint(this.getNumericValueFromCellRef(ptListX.get(i)), this.getNumericValueFromCellRef(ptListY.get(i)), (Number)sizes.get(i)));
        }
        seriesData.seriesData = list;
        this.handleReferencedValueUpdates(ptListX, seriesData, AbstractSeriesReader.ValueUpdateMode.X_VALUES);
        this.handleReferencedValueUpdates(ptListY, seriesData, AbstractSeriesReader.ValueUpdateMode.Y_VALUES);
        this.handleReferencedValueUpdates(ptListSize, seriesData, AbstractSeriesReader.ValueUpdateMode.Z_VALUES);
        seriesData.dataSelectListener = new AbstractSeriesData.DataSelectListener(){

            @Override
            public void dataSelected() {
                BubbleSeriesReader.this.getSpreadsheet().setSelection(formulaY);
            }
        };
    }
}

