/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.spreadsheet.command;

import com.vaadin.flow.component.spreadsheet.Spreadsheet;
import com.vaadin.flow.component.spreadsheet.command.SpreadsheetCommand;
import com.vaadin.flow.component.spreadsheet.command.ValueChangeCommand;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.poi.ss.formula.FormulaParseException;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.ss.util.CellReference;

public class CellValueCommand
extends SpreadsheetCommand
implements ValueChangeCommand {
    protected final List<Object> values = new ArrayList<Object>();
    protected final int selectedCellRow;
    protected final int selectedcellCol;
    protected final int[] selectedCellRange;

    public CellValueCommand(Spreadsheet spreadsheet) {
        super(spreadsheet);
        CellReference selectedCellReference = spreadsheet.getSelectedCellReference();
        this.selectedCellRow = selectedCellReference.getRow();
        this.selectedcellCol = selectedCellReference.getCol();
        CellRangeAddress paintedCellRange = spreadsheet.getCellSelectionManager().getSelectedCellRange();
        this.selectedCellRange = (int[])(paintedCellRange != null && (paintedCellRange.getFirstColumn() != paintedCellRange.getLastColumn() || paintedCellRange.getFirstRow() != paintedCellRange.getLastRow()) ? new int[]{paintedCellRange.getFirstRow(), paintedCellRange.getLastRow(), paintedCellRange.getFirstColumn(), paintedCellRange.getLastColumn()} : null);
    }

    public void clearValues() {
        this.values.clear();
    }

    public void captureCellValues(CellReference ... cellReferences) {
        for (CellReference cr : cellReferences) {
            this.values.add(new CellValue(cr.getRow(), cr.getCol(), this.getCellValue(cr)));
        }
    }

    public void captureCellRangeValues(CellRangeAddress ... cellRanges) {
        for (CellRangeAddress cra : cellRanges) {
            if (cra == null) continue;
            int h = cra.getLastRow() - cra.getFirstRow() + 1;
            int w = cra.getLastColumn() - cra.getFirstColumn() + 1;
            Object[] v = new Object[h * w];
            int i = 0;
            for (int r = cra.getFirstRow(); r <= cra.getLastRow(); ++r) {
                for (int c = cra.getFirstColumn(); c <= cra.getLastColumn(); ++c) {
                    v[i++] = this.getCellValue(r, c);
                }
            }
            this.values.add(new CellRangeValue(cra.getFirstRow(), cra.getLastRow(), cra.getFirstColumn(), cra.getLastColumn(), v));
        }
    }

    @Override
    public CellReference getSelectedCellReference() {
        return new CellReference(this.getSheet().getSheetName(), this.selectedCellRow, this.selectedcellCol, false, false);
    }

    @Override
    public CellRangeAddress getPaintedCellRange() {
        return this.selectedCellRange == null ? null : new CellRangeAddress(this.selectedCellRange[0], this.selectedCellRange[1], this.selectedCellRange[2], this.selectedCellRange[3]);
    }

    @Override
    public void execute() {
        this.updateValues();
    }

    private void updateValues() {
        ArrayList<Cell> cellsToUpdate = new ArrayList<Cell>();
        for (Object o : this.values) {
            if (o instanceof CellValue) {
                CellValue cellValue = (CellValue)o;
                cellValue.value = this.updateCellValue(cellValue.row, cellValue.col, cellValue.value, cellsToUpdate);
                continue;
            }
            CellRangeValue cellRangeValue = (CellRangeValue)o;
            int i = 0;
            for (int r = cellRangeValue.row1; r <= cellRangeValue.row2; ++r) {
                for (int c = cellRangeValue.col1; c <= cellRangeValue.col2; ++c) {
                    cellRangeValue.values[i] = this.updateCellValue(r, c, cellRangeValue.values[i], cellsToUpdate);
                    ++i;
                }
            }
        }
        if (!this.spreadsheet.isRerenderPending()) {
            this.spreadsheet.refreshCells(cellsToUpdate);
        }
    }

    protected Object updateCellValue(int row, int col, Object value, List<Cell> cellsToUpdate) {
        Cell cell = this.getCell(row, col);
        Object oldValue = this.getCellValue(cell);
        if (value == null && cell == null) {
            return null;
        }
        if (cell == null && value != null) {
            Row row2 = this.getSheet().getRow(row);
            if (row2 == null) {
                row2 = this.getSheet().createRow(row);
            }
            cell = row2.createCell(col);
        }
        if (value == null) {
            if (cell == null || cell.getCellStyle().getIndex() == 0) {
                if (!this.spreadsheet.isRerenderPending()) {
                    this.spreadsheet.markCellAsDeleted(cell, false);
                }
                this.getSheet().getRow(row).removeCell(cell);
            } else {
                cell.setCellValue((String)null);
                if (!this.spreadsheet.isRerenderPending()) {
                    cellsToUpdate.add(cell);
                }
            }
        } else {
            if (value instanceof String) {
                if (((String)value).startsWith("=")) {
                    try {
                        cell.setCellFormula(((String)value).substring(1));
                    }
                    catch (FormulaParseException fpe) {
                        cell.setCellValue((String)value);
                    }
                } else {
                    cell.setCellValue((String)value);
                }
            } else if (value instanceof Byte) {
                cell.setCellErrorValue(((Byte)value).byteValue());
            } else if (value instanceof Double) {
                cell.setCellValue(((Double)value).doubleValue());
            } else if (value instanceof Boolean) {
                cell.setCellValue(((Boolean)value).booleanValue());
            }
            if (!this.spreadsheet.isRerenderPending()) {
                cellsToUpdate.add(cell);
            }
        }
        return oldValue;
    }

    protected Object getCellValue(CellReference cell) {
        return this.getCellValue(cell.getRow(), cell.getCol());
    }

    protected Object getCellValue(int r, int c) {
        return this.getCellValue(this.getCell(r, c));
    }

    protected Object getCellValue(Cell cell) {
        if (cell == null) {
            return null;
        }
        switch (cell.getCellType()) {
            case BOOLEAN: {
                return cell.getBooleanCellValue();
            }
            case ERROR: {
                return cell.getErrorCellValue();
            }
            case FORMULA: {
                return "=" + cell.getCellFormula();
            }
            case NUMERIC: {
                return cell.getNumericCellValue();
            }
            case STRING: {
                return cell.getStringCellValue();
            }
        }
        return null;
    }

    protected Cell getCell(int r, int c) {
        Row row = this.getSheet().getRow(r);
        if (row == null) {
            return null;
        }
        Cell cell = row.getCell(c);
        if (cell == null) {
            return null;
        }
        return cell;
    }

    @Override
    public Set<CellReference> getChangedCells() {
        HashSet<CellReference> changedCells = new HashSet<CellReference>();
        for (Object o : this.values) {
            if (o instanceof CellValue) {
                CellValue cellValue = (CellValue)o;
                changedCells.add(new CellReference(this.getSheet().getSheetName(), cellValue.row, cellValue.col, false, false));
                continue;
            }
            CellRangeValue cellRangeValue = (CellRangeValue)o;
            for (int r = cellRangeValue.row1; r <= cellRangeValue.row2; ++r) {
                for (int c = cellRangeValue.col1; c <= cellRangeValue.col2; ++c) {
                    changedCells.add(new CellReference(this.getSheet().getSheetName(), r, c, false, false));
                }
            }
        }
        return changedCells;
    }

    class CellValue
    implements Serializable {
        public final int row;
        public final int col;
        public Object value;

        public CellValue(int row, int col, Object value) {
            this.row = row;
            this.col = col;
            this.value = value;
        }
    }

    class CellRangeValue
    implements Serializable {
        public final int row1;
        public final int row2;
        public final int col1;
        public final int col2;
        public final Object[] values;

        public CellRangeValue(int row1, int row2, int col1, int col2, Object[] values) {
            this.row1 = row1;
            this.row2 = row2;
            this.col1 = col1;
            this.col2 = col2;
            this.values = values;
        }
    }
}

