/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.spreadsheet;

import com.vaadin.flow.component.spreadsheet.SheetOverlayWrapper;
import com.vaadin.flow.component.spreadsheet.client.OverlayInfo;
import com.vaadin.flow.server.streams.DownloadHandler;
import com.vaadin.flow.server.streams.DownloadResponse;
import com.vaadin.flow.server.streams.InputStreamDownloadCallback;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Serializable;
import org.apache.poi.ss.usermodel.ClientAnchor;

public class SheetImageWrapper
extends SheetOverlayWrapper
implements Serializable {
    private DownloadHandler handler;
    private final byte[] data;
    private final String MIMEType;

    public SheetImageWrapper(ClientAnchor anchor, String MIMEType, byte[] data) {
        super(anchor);
        this.MIMEType = MIMEType;
        this.data = data;
    }

    @Override
    public DownloadHandler getResourceHandler() {
        if (this.handler == null) {
            this.handler = DownloadHandler.fromInputStream((InputStreamDownloadCallback & Serializable)downloadEvent -> new DownloadResponse((InputStream)new ByteArrayInputStream(this.data), "download", this.MIMEType, (long)this.data.length)).inline();
        }
        return this.handler;
    }

    @Override
    public OverlayInfo.Type getType() {
        return OverlayInfo.Type.IMAGE;
    }
}

