/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.spreadsheet;

import com.vaadin.flow.component.spreadsheet.NamedRangeUtils;
import com.vaadin.flow.component.spreadsheet.Spreadsheet;
import com.vaadin.flow.component.spreadsheet.SpreadsheetUtil;
import com.vaadin.flow.component.spreadsheet.client.MergedRegion;
import com.vaadin.flow.component.spreadsheet.client.MergedRegionUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellAddress;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.ss.util.CellRangeUtil;
import org.apache.poi.ss.util.CellReference;

public class CellSelectionManager
implements Serializable {
    private final Spreadsheet spreadsheet;
    private CellReference selectedCellReference;
    private CellRangeAddress paintedCellRange;
    private Spreadsheet.SelectionChangeEvent latestSelectionEvent;
    private final NamedRangeUtils namedRangeUtils;
    private final ArrayList<CellRangeAddress> cellRangeAddresses = new ArrayList();
    private final ArrayList<CellReference> individualSelectedCells = new ArrayList();

    public CellSelectionManager(Spreadsheet spreadsheet) {
        this.spreadsheet = spreadsheet;
        this.namedRangeUtils = new NamedRangeUtils(spreadsheet);
    }

    public void clear() {
        this.selectedCellReference = null;
        this.paintedCellRange = null;
        this.cellRangeAddresses.clear();
        this.individualSelectedCells.clear();
        this.latestSelectionEvent = null;
    }

    public CellReference getSelectedCellReference() {
        return this.selectedCellReference;
    }

    public CellRangeAddress getSelectedCellRange() {
        return this.paintedCellRange;
    }

    public List<CellReference> getIndividualSelectedCells() {
        return this.individualSelectedCells;
    }

    public List<CellRangeAddress> getCellRangeAddresses() {
        return this.cellRangeAddresses;
    }

    public Spreadsheet.SelectionChangeEvent getLatestSelectionEvent() {
        return this.latestSelectionEvent;
    }

    boolean isCellInsideSelection(int row, int column) {
        boolean inside;
        CellReference cellReference = new CellReference(this.spreadsheet.getActiveSheet().getSheetName(), row - 1, column - 1, false, false);
        boolean bl = inside = cellReference.equals((Object)this.selectedCellReference) || this.individualSelectedCells.contains(cellReference);
        if (!inside) {
            for (CellRangeAddress cra : this.cellRangeAddresses) {
                if (!cra.isInRange(row - 1, column - 1)) continue;
                inside = true;
                break;
            }
        }
        return inside;
    }

    protected void reloadCurrentSelection() {
        this.cellRangeAddresses.clear();
        this.individualSelectedCells.clear();
        if (this.paintedCellRange != null) {
            if (this.selectedCellReference != null) {
                if (this.paintedCellRange.isInRange(this.selectedCellReference.getRow(), (int)this.selectedCellReference.getCol())) {
                    this.handleCellRangeSelection(this.selectedCellReference, this.paintedCellRange, true);
                } else {
                    this.paintedCellRange = null;
                    this.handleCellAddressChange(this.selectedCellReference.getRow() + 1, this.selectedCellReference.getCol() + 1, false);
                }
            } else {
                this.handleCellRangeSelection(this.paintedCellRange);
            }
        } else if (this.selectedCellReference != null) {
            this.handleCellAddressChange(this.selectedCellReference.getRow() + 1, this.selectedCellReference.getCol() + 1, false);
        } else {
            this.handleCellAddressChange(1, 1, false);
        }
    }

    protected void onCellSelected(int row, int column, boolean discardOldRangeSelection) {
        CellReference previousCellReference;
        CellReference cellReference = new CellReference(this.spreadsheet.getActiveSheet().getSheetName(), row - 1, column - 1, false, false);
        if (!cellReference.equals((Object)(previousCellReference = this.selectedCellReference)) || discardOldRangeSelection && (!this.cellRangeAddresses.isEmpty() || !this.individualSelectedCells.isEmpty())) {
            this.handleCellSelection(row, column);
            this.selectedCellReference = cellReference;
            this.spreadsheet.loadCustomEditorOnSelectedCell();
            if (discardOldRangeSelection) {
                this.cellRangeAddresses.clear();
                this.individualSelectedCells.clear();
                this.paintedCellRange = this.spreadsheet.createCorrectCellRangeAddress(row, column, row, column);
            }
            this.ensureClientHasSelectionData();
            this.fireNewSelectionChangeEvent();
        }
    }

    protected void onSheetAddressChanged(String value, boolean initialSelection) {
        try {
            if (this.namedRangeUtils.isNamedRange(value)) {
                this.namedRangeUtils.onNamedRange(value);
            } else if (value.contains(":")) {
                CellRangeAddress cra = this.spreadsheet.createCorrectCellRangeAddress(value);
                MergedRegion region = MergedRegionUtil.findIncreasingSelection(this.spreadsheet.getMergedRegionContainer(), cra.getFirstRow() + 1, cra.getLastRow() + 1, cra.getFirstColumn() + 1, cra.getLastColumn() + 1);
                if (region != null) {
                    cra = new CellRangeAddress(region.row1 - 1, region.row2 - 1, region.col1 - 1, region.col2 - 1);
                }
                this.handleCellRangeSelection(cra);
                this.selectedCellReference = new CellReference(this.spreadsheet.getActiveSheet().getSheetName(), cra.getFirstRow(), cra.getFirstColumn(), false, false);
                this.paintedCellRange = cra;
                this.cellRangeAddresses.clear();
                this.cellRangeAddresses.add(cra);
            } else if (this.namedRangeUtils.isCellReference(value)) {
                CellReference cellReference = new CellReference(value);
                MergedRegion region = MergedRegionUtil.findIncreasingSelection(this.spreadsheet.getMergedRegionContainer(), cellReference.getRow() + 1, cellReference.getRow() + 1, cellReference.getCol() + 1, cellReference.getCol() + 1);
                if (region != null && (region.col1 != region.col2 || region.row1 != region.row2)) {
                    CellRangeAddress cra = this.spreadsheet.createCorrectCellRangeAddress(region.row1, region.col1, region.row2, region.col2);
                    this.handleCellRangeSelection(cra);
                    this.selectedCellReference = new CellReference(this.spreadsheet.getActiveSheet().getSheetName(), cra.getFirstRow(), cra.getFirstColumn(), false, false);
                    this.paintedCellRange = cra;
                    this.cellRangeAddresses.clear();
                    this.cellRangeAddresses.add(cra);
                } else {
                    CellReference cellReferenceWithSheetName;
                    this.handleCellAddressChange(cellReference.getRow() + 1, cellReference.getCol() + 1, initialSelection);
                    this.paintedCellRange = this.spreadsheet.createCorrectCellRangeAddress(cellReference.getRow() + 1, cellReference.getCol() + 1, cellReference.getRow() + 1, cellReference.getCol() + 1);
                    this.selectedCellReference = cellReferenceWithSheetName = new CellReference(this.spreadsheet.getActiveSheet().getSheetName(), cellReference.getRow(), (int)cellReference.getCol(), false, false);
                    this.cellRangeAddresses.clear();
                }
            }
            this.individualSelectedCells.clear();
            this.spreadsheet.loadCustomEditorOnSelectedCell();
            this.ensureClientHasSelectionData();
            this.fireNewSelectionChangeEvent();
        }
        catch (Exception e) {
            this.spreadsheet.getRpcProxy().invalidCellAddress();
        }
    }

    private void handleCellAddressChange(int rowIndex, int colIndex, boolean initialSelection) {
        this.handleCellAddressChange(rowIndex, colIndex, initialSelection, null);
    }

    void handleCellAddressChange(int rowIndex, int colIndex, boolean initialSelection, String name) {
        if (rowIndex >= this.spreadsheet.getRows()) {
            rowIndex = this.spreadsheet.getRows();
        }
        if (colIndex >= this.spreadsheet.getCols()) {
            colIndex = this.spreadsheet.getCols();
        }
        MergedRegion region = MergedRegionUtil.findIncreasingSelection(this.spreadsheet.getMergedRegionContainer(), rowIndex, rowIndex, colIndex, colIndex);
        if (region.col1 != region.col2 || region.row1 != region.row2) {
            this.handleCellRangeSelection(new CellRangeAddress(region.row1 - 1, region.row2 - 1, region.col1 - 1, region.col2 - 1));
        } else {
            rowIndex = region.row1;
            colIndex = region.col1;
            Workbook workbook = this.spreadsheet.getWorkbook();
            Row row = workbook.getSheetAt(workbook.getActiveSheetIndex()).getRow(rowIndex - 1);
            if (row != null) {
                Cell cell = row.getCell(colIndex - 1);
                if (cell != null) {
                    boolean formula;
                    Object value = "";
                    boolean bl = formula = cell.getCellType() == CellType.FORMULA;
                    if (!this.spreadsheet.isCellHidden(cell)) {
                        value = formula ? cell.getCellFormula() : (SpreadsheetUtil.needsLeadingQuote(cell) ? "'" + this.spreadsheet.getCellValue(cell) : this.spreadsheet.getCellValue(cell));
                    }
                    this.spreadsheet.getRpcProxy().showSelectedCell(name, colIndex, rowIndex, (String)value, formula, this.spreadsheet.isCellLocked(cell.getAddress()), initialSelection);
                } else {
                    this.spreadsheet.getRpcProxy().showSelectedCell(name, colIndex, rowIndex, "", false, this.spreadsheet.isCellLocked(new CellAddress(rowIndex, colIndex)), initialSelection);
                }
            } else {
                this.spreadsheet.getRpcProxy().showSelectedCell(name, colIndex, rowIndex, "", false, this.spreadsheet.isActiveSheetProtected(), initialSelection);
            }
        }
    }

    protected void reSelectSelectedCell() {
        if (this.selectedCellReference != null) {
            this.handleCellSelection(this.selectedCellReference);
        }
    }

    protected void handleCellSelection(CellReference cellReference) {
        this.handleCellSelection(cellReference.getRow() + 1, cellReference.getCol() + 1);
    }

    private void handleCellSelection(int rowIndex, int columnIndex) {
        this.spreadsheet.getRpcProxy().updateFormulaBar(null, columnIndex, rowIndex);
    }

    private void handleCellSelection(int rowIndex, int columnIndex, CellRangeAddress cra) {
        String possibleName = this.namedRangeUtils.getNameForFormulaIfExists(cra);
        this.spreadsheet.getRpcProxy().updateFormulaBar(possibleName, columnIndex, rowIndex);
    }

    protected void handleCellRangeSelection(CellRangeAddress cra) {
        String possibleName = this.namedRangeUtils.getNameForFormulaIfExists(cra);
        this.handleCellRangeSelection(possibleName, cra);
    }

    protected void handleCellRangeSelection(String name, CellRangeAddress cra) {
        CellReference firstCell = new CellReference(this.spreadsheet.getActiveSheet().getSheetName(), cra.getFirstRow(), cra.getFirstColumn(), false, false);
        this.handleCellRangeSelection(name, firstCell, cra, true);
    }

    protected void handleCellRangeSelection(CellReference startingPoint, CellRangeAddress cellsToSelect, boolean scroll) {
        CellReference startingPointWithSheetName = new CellReference(this.spreadsheet.getActiveSheet().getSheetName(), startingPoint.getRow(), (int)startingPoint.getCol(), false, false);
        this.handleCellRangeSelection(null, startingPointWithSheetName, cellsToSelect, scroll);
    }

    private void handleCellRangeSelection(String name, CellReference startingPoint, CellRangeAddress cellsToSelect, boolean scroll) {
        int row1 = cellsToSelect.getFirstRow() + 1;
        int row2 = cellsToSelect.getLastRow() + 1;
        int col1 = cellsToSelect.getFirstColumn() + 1;
        int col2 = cellsToSelect.getLastColumn() + 1;
        this.spreadsheet.getRpcProxy().setSelectedCellAndRange(name, startingPoint.getCol() + 1, startingPoint.getRow() + 1, col1, col2, row1, row2, scroll);
        this.selectedCellReference = startingPoint;
        this.cellRangeAddresses.clear();
        this.individualSelectedCells.clear();
        this.paintedCellRange = cellsToSelect;
        if (col1 != col2 || row1 != row2) {
            this.cellRangeAddresses.add(cellsToSelect);
        }
        this.ensureClientHasSelectionData();
        this.fireNewSelectionChangeEvent();
    }

    protected void onCellRangeSelected(int row1, int col1, int row2, int col2) {
        CellRangeAddress cra;
        this.cellRangeAddresses.clear();
        this.individualSelectedCells.clear();
        this.paintedCellRange = cra = this.spreadsheet.createCorrectCellRangeAddress(row1, col1, row2, col2);
        if (col1 != col2 || row1 != row2) {
            this.cellRangeAddresses.add(cra);
        }
        this.ensureClientHasSelectionData();
        this.fireNewSelectionChangeEvent();
    }

    protected void onCellRangePainted(int selectedCellRow, int selectedCellColumn, int row1, int col1, int row2, int col2) {
        this.cellRangeAddresses.clear();
        this.individualSelectedCells.clear();
        this.selectedCellReference = new CellReference(this.spreadsheet.getActiveSheet().getSheetName(), selectedCellRow - 1, selectedCellColumn - 1, false, false);
        CellRangeAddress cra = this.spreadsheet.createCorrectCellRangeAddress(row1, col1, row2, col2);
        this.handleCellSelection(selectedCellRow, selectedCellColumn, cra);
        this.paintedCellRange = cra;
        this.cellRangeAddresses.add(cra);
        this.ensureClientHasSelectionData();
        this.fireNewSelectionChangeEvent();
    }

    protected void onCellAddToSelectionAndSelected(int row, int column) {
        boolean oldSelectedCellInRange = false;
        for (CellRangeAddress range : this.cellRangeAddresses) {
            if (!range.isInRange(this.selectedCellReference.getRow(), (int)this.selectedCellReference.getCol())) continue;
            oldSelectedCellInRange = true;
            break;
        }
        boolean oldSelectedCellInIndividual = false;
        for (CellReference cell : this.individualSelectedCells) {
            if (!cell.equals((Object)this.selectedCellReference)) continue;
            oldSelectedCellInIndividual = true;
            break;
        }
        if (!oldSelectedCellInRange && !oldSelectedCellInIndividual) {
            this.individualSelectedCells.add(this.selectedCellReference);
        }
        this.handleCellSelection(row, column);
        this.selectedCellReference = new CellReference(this.spreadsheet.getActiveSheet().getSheetName(), row - 1, column - 1, false, false);
        this.spreadsheet.loadCustomEditorOnSelectedCell();
        if (this.individualSelectedCells.contains(this.selectedCellReference)) {
            this.individualSelectedCells.remove(this.individualSelectedCells.indexOf(this.selectedCellReference));
        }
        this.paintedCellRange = null;
        this.ensureClientHasSelectionData();
        this.fireNewSelectionChangeEvent();
    }

    protected void onCellsAddedToRangeSelection(int row1, int col1, int row2, int col2) {
        CellRangeAddress newRange = this.spreadsheet.createCorrectCellRangeAddress(row1, col1, row2, col2);
        Iterator<CellReference> i = this.individualSelectedCells.iterator();
        while (i.hasNext()) {
            CellReference cell = i.next();
            if (!newRange.isInRange(cell.getRow(), (int)cell.getCol())) continue;
            i.remove();
        }
        this.cellRangeAddresses.add(newRange);
        this.paintedCellRange = null;
        this.ensureClientHasSelectionData();
        this.fireNewSelectionChangeEvent();
    }

    protected void onRowSelected(int row, int firstColumnIndex) {
        CellRangeAddress cra;
        this.handleCellSelection(row, firstColumnIndex);
        this.selectedCellReference = new CellReference(this.spreadsheet.getActiveSheet().getSheetName(), row - 1, firstColumnIndex - 1, false, false);
        this.spreadsheet.loadCustomEditorOnSelectedCell();
        this.cellRangeAddresses.clear();
        this.individualSelectedCells.clear();
        this.paintedCellRange = cra = this.spreadsheet.createCorrectCellRangeAddress(row, 1, row, this.spreadsheet.getColumns());
        this.cellRangeAddresses.add(cra);
        this.ensureClientHasSelectionData();
        this.fireNewSelectionChangeEvent();
    }

    protected void onRowAddedToRangeSelection(int row, int firstColumnIndex) {
        boolean oldSelectedCellInRange = false;
        for (CellRangeAddress range : this.cellRangeAddresses) {
            if (!range.isInRange(this.selectedCellReference.getRow(), (int)this.selectedCellReference.getCol())) continue;
            oldSelectedCellInRange = true;
            break;
        }
        if (!oldSelectedCellInRange) {
            this.individualSelectedCells.add(this.selectedCellReference);
        }
        this.handleCellSelection(row, firstColumnIndex);
        this.selectedCellReference = new CellReference(this.spreadsheet.getActiveSheet().getSheetName(), row - 1, firstColumnIndex - 1, false, false);
        this.spreadsheet.loadCustomEditorOnSelectedCell();
        this.cellRangeAddresses.add(this.spreadsheet.createCorrectCellRangeAddress(row, 1, row, this.spreadsheet.getColumns()));
        this.paintedCellRange = null;
        this.ensureClientHasSelectionData();
        this.fireNewSelectionChangeEvent();
    }

    protected void onColumnSelected(int firstRowIndex, int column) {
        CellRangeAddress cra;
        this.handleCellSelection(firstRowIndex, column);
        this.selectedCellReference = new CellReference(this.spreadsheet.getActiveSheet().getSheetName(), firstRowIndex - 1, column - 1, false, false);
        this.spreadsheet.loadCustomEditorOnSelectedCell();
        this.cellRangeAddresses.clear();
        this.individualSelectedCells.clear();
        this.paintedCellRange = cra = this.spreadsheet.createCorrectCellRangeAddress(1, column, this.spreadsheet.getRows(), column);
        this.cellRangeAddresses.add(cra);
        this.ensureClientHasSelectionData();
        this.fireNewSelectionChangeEvent();
    }

    protected void onColumnAddedToSelection(int firstRowIndex, int column) {
        boolean oldSelectedCellInRange = false;
        for (CellRangeAddress range : this.cellRangeAddresses) {
            if (!range.isInRange(this.selectedCellReference.getRow(), (int)this.selectedCellReference.getCol())) continue;
            oldSelectedCellInRange = true;
            break;
        }
        if (!oldSelectedCellInRange) {
            this.individualSelectedCells.add(this.selectedCellReference);
        }
        this.handleCellSelection(firstRowIndex, column);
        this.selectedCellReference = new CellReference(this.spreadsheet.getActiveSheet().getSheetName(), firstRowIndex - 1, column - 1, false, false);
        this.spreadsheet.loadCustomEditorOnSelectedCell();
        this.cellRangeAddresses.add(this.spreadsheet.createCorrectCellRangeAddress(1, column, this.spreadsheet.getRows(), column));
        this.paintedCellRange = null;
        this.ensureClientHasSelectionData();
        this.fireNewSelectionChangeEvent();
    }

    protected void mergedRegionAdded(CellRangeAddress region) {
        if (this.selectedCellReference == null) {
            return;
        }
        boolean fire = false;
        if (region.isInRange(this.selectedCellReference.getRow(), (int)this.selectedCellReference.getCol())) {
            if (this.selectedCellReference.getCol() != region.getFirstColumn() || this.selectedCellReference.getRow() != region.getFirstRow()) {
                this.handleCellAddressChange(region.getFirstRow() + 1, region.getFirstColumn() + 1, false);
            }
            this.selectedCellReference = new CellReference(this.spreadsheet.getActiveSheet().getSheetName(), region.getFirstRow(), region.getFirstColumn(), false, false);
            fire = true;
        }
        Iterator<CellRangeAddress> i = this.cellRangeAddresses.iterator();
        while (i.hasNext()) {
            CellRangeAddress cra = i.next();
            if (!CellRangeUtil.contains((CellRangeAddress)region, (CellRangeAddress)cra)) continue;
            i.remove();
            fire = true;
        }
        i = this.individualSelectedCells.iterator();
        while (i.hasNext()) {
            CellReference cr = (CellReference)i.next();
            if (!region.isInRange(cr.getRow(), (int)cr.getCol())) continue;
            i.remove();
            fire = true;
        }
        if (fire) {
            this.fireNewSelectionChangeEvent();
        }
    }

    protected void mergedRegionRemoved(CellRangeAddress region) {
        if (this.selectedCellReference == null) {
            return;
        }
        if (region.isInRange(this.selectedCellReference.getRow(), (int)this.selectedCellReference.getCol())) {
            this.cellRangeAddresses.add(region);
            this.ensureClientHasSelectionData();
            this.fireNewSelectionChangeEvent();
        }
    }

    private void ensureClientHasSelectionData() {
        for (CellRangeAddress cellRangeAddress : this.cellRangeAddresses) {
            this.spreadsheet.loadCells(cellRangeAddress.getFirstRow() + 1, cellRangeAddress.getFirstColumn() + 1, cellRangeAddress.getLastRow() + 1, cellRangeAddress.getLastColumn() + 1);
        }
    }

    private void fireNewSelectionChangeEvent() {
        CellRangeAddress selectedCellMergedRegion = null;
        MergedRegion region = this.spreadsheet.getMergedRegionContainer().getMergedRegionStartingFrom(this.selectedCellReference.getCol() + 1, this.selectedCellReference.getRow() + 1);
        if (region != null) {
            selectedCellMergedRegion = new CellRangeAddress(region.row1 - 1, region.row2 - 1, region.col1 - 1, region.col2 - 1);
            if (this.cellRangeAddresses.size() == 1 && this.cellRangeAddresses.get(0).formatAsString().equals(selectedCellMergedRegion.formatAsString())) {
                this.cellRangeAddresses.clear();
            }
        }
        if (this.latestSelectionEvent != null) {
            CellRangeAddress previouSelectedCellMergedRegion;
            boolean changed = false;
            if (!this.latestSelectionEvent.getSelectedCellReference().equals((Object)this.selectedCellReference)) {
                changed = true;
            }
            if (!changed) {
                if (this.latestSelectionEvent.getIndividualSelectedCells().size() != this.individualSelectedCells.size()) {
                    changed = true;
                } else {
                    for (CellReference cr : this.latestSelectionEvent.getIndividualSelectedCells()) {
                        if (this.individualSelectedCells.contains(cr)) continue;
                        changed = true;
                        break;
                    }
                }
            }
            if (!changed) {
                if (this.latestSelectionEvent.getCellRangeAddresses().size() != this.cellRangeAddresses.size()) {
                    changed = true;
                } else {
                    for (CellRangeAddress cra : this.latestSelectionEvent.getCellRangeAddresses()) {
                        if (this.cellRangeAddresses.contains(cra)) continue;
                        changed = true;
                        break;
                    }
                }
            }
            if (!changed && ((previouSelectedCellMergedRegion = this.latestSelectionEvent.getSelectedCellMergedRegion()) == null && selectedCellMergedRegion != null || previouSelectedCellMergedRegion != null && !previouSelectedCellMergedRegion.equals((Object)selectedCellMergedRegion))) {
                changed = true;
            }
            if (!changed) {
                return;
            }
        }
        ArrayList<CellReference> cellRefCopy = new ArrayList<CellReference>(this.individualSelectedCells);
        ArrayList<CellRangeAddress> rangeCopy = new ArrayList<CellRangeAddress>(this.cellRangeAddresses);
        this.latestSelectionEvent = new Spreadsheet.SelectionChangeEvent(this.spreadsheet, this.selectedCellReference, cellRefCopy, selectedCellMergedRegion, rangeCopy);
        this.spreadsheet.fireEvent(this.latestSelectionEvent);
    }
}

