/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.spreadsheet;

import com.vaadin.flow.component.spreadsheet.PopupButton;
import com.vaadin.flow.component.spreadsheet.Spreadsheet;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.ss.util.CellReference;
import org.apache.poi.xssf.usermodel.XSSFTable;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTAutoFilter;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTTable;

public class SpreadsheetTable
implements Serializable {
    private final CellRangeAddress fullTableRegion;
    private final Sheet sheet;
    private final Spreadsheet spreadsheet;
    protected final Map<CellReference, PopupButton> popupButtons;
    private transient CTAutoFilter ctWorksheetAutoFilter;
    private transient XSSFTable xssfTable;

    public SpreadsheetTable(Spreadsheet spreadsheet, CellRangeAddress tableRegion) {
        this(spreadsheet, spreadsheet.getActiveSheet(), tableRegion);
    }

    public SpreadsheetTable(Spreadsheet spreadsheet, Sheet sheet, CellRangeAddress fullTableRegion) {
        this(spreadsheet, sheet, fullTableRegion, null, null);
    }

    public SpreadsheetTable(Spreadsheet spreadsheet, Sheet sheet, CellRangeAddress fullTableRegion, CTAutoFilter ctWorksheetAutoFilter, XSSFTable xssfTable) {
        this.spreadsheet = spreadsheet;
        this.sheet = sheet;
        this.fullTableRegion = fullTableRegion;
        this.xssfTable = xssfTable;
        this.ctWorksheetAutoFilter = ctWorksheetAutoFilter;
        this.popupButtons = new HashMap<CellReference, PopupButton>();
        if (this.isTableSheetCurrentlyActive()) {
            this.initPopupButtons();
        }
    }

    public void reload() {
        if (this.isTableSheetCurrentlyActive()) {
            if (this.popupButtons.isEmpty()) {
                this.initPopupButtons();
            } else {
                for (PopupButton popupButton : this.popupButtons.values()) {
                    this.spreadsheet.setPopup(popupButton.getCellReference(), popupButton);
                }
            }
        }
    }

    public void clear() {
        for (PopupButton popupButton : this.popupButtons.values()) {
            popupButton.setContent(null);
        }
        this.popupButtons.clear();
    }

    public boolean isTableSheetCurrentlyActive() {
        return this.spreadsheet.getActiveSheet().equals((Object)this.sheet);
    }

    protected void initPopupButtons() {
        if (this.isActiveSheet(this.sheet)) {
            List<CellReference> targetCells = this.resolveCellsForPopupButtonCreation();
            for (CellReference popupButtonTargetCell : targetCells) {
                PopupButton popupButton = new PopupButton();
                this.popupButtons.put(popupButtonTargetCell, popupButton);
                this.spreadsheet.setPopup(popupButtonTargetCell, popupButton);
            }
        }
    }

    private List<CellReference> resolveCellsForPopupButtonCreation() {
        if (this.xssfTable != null) {
            return this.resolveCellsForPopupButtonCreation(this.xssfTable.getCTTable());
        }
        return this.getAllHeaderRowCells();
    }

    private List<CellReference> resolveCellsForPopupButtonCreation(CTTable table) {
        if (table.isSetAutoFilter()) {
            return this.getVisibleAutoFilterPopupButtonsCells(table);
        }
        return Collections.emptyList();
    }

    private List<CellReference> getVisibleAutoFilterPopupButtonsCells(CTTable table) {
        if (table.getAutoFilter().getFilterColumnList().isEmpty()) {
            return this.getAllHeaderRowCells();
        }
        return table.getAutoFilter().getFilterColumnList().stream().filter(filterColumn -> !filterColumn.isSetHiddenButton()).map(filterColumn -> new CellReference(this.sheet.getSheetName(), this.fullTableRegion.getFirstRow(), (int)filterColumn.getColId(), true, true)).collect(Collectors.toList());
    }

    private List<CellReference> getAllHeaderRowCells() {
        ArrayList<CellReference> result = new ArrayList<CellReference>();
        for (int c = this.fullTableRegion.getFirstColumn(); c <= this.fullTableRegion.getLastColumn(); ++c) {
            CellReference popupButtonCellReference = new CellReference(this.sheet.getSheetName(), this.fullTableRegion.getFirstRow(), c, true, true);
            result.add(popupButtonCellReference);
        }
        return result;
    }

    private boolean isActiveSheet(Sheet sheet) {
        return sheet.equals((Object)this.spreadsheet.getActiveSheet());
    }

    public Sheet getSheet() {
        return this.sheet;
    }

    public Spreadsheet getSpreadsheet() {
        return this.spreadsheet;
    }

    public CellRangeAddress getFullTableRegion() {
        return this.fullTableRegion;
    }

    public PopupButton getPopupButton(int col) {
        for (PopupButton button : this.popupButtons.values()) {
            if (button.getColumn() != col) continue;
            return button;
        }
        return null;
    }

    public PopupButton getPopupButton(CellReference filterCellReference) {
        return this.popupButtons.get(filterCellReference);
    }

    public Collection<PopupButton> getPopupButtons() {
        return Collections.unmodifiableCollection(this.popupButtons.values());
    }

    protected void setCtWorksheetAutoFilter(CTAutoFilter ctWorksheetAutoFilter) {
        this.ctWorksheetAutoFilter = ctWorksheetAutoFilter;
    }

    public CTAutoFilter getCtWorksheetAutoFilter() {
        return this.ctWorksheetAutoFilter;
    }

    protected void setXssfTable(XSSFTable xssfTable) {
        this.xssfTable = xssfTable;
    }

    public XSSFTable getXssfTable() {
        return this.xssfTable;
    }
}

