/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.spreadsheet.command;

import com.vaadin.flow.component.spreadsheet.Spreadsheet;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.ClientAnchor;
import org.apache.poi.ss.usermodel.Comment;
import org.apache.poi.ss.usermodel.CreationHelper;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.Drawing;
import org.apache.poi.ss.usermodel.Hyperlink;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.util.CellAddress;
import org.apache.poi.ss.util.CellRangeAddress;

class RowData
implements Serializable {
    private final List<CellData> cellsData = new ArrayList<CellData>();
    private final List<CommentData> commentsWithoutCell = new ArrayList<CommentData>();
    private final List<CellRangeAddress> mergedCells = new ArrayList<CellRangeAddress>();
    private boolean isCopied;
    private int maxCol;
    private Spreadsheet spreadsheet;
    private Float height;
    private int rowIndex;

    public RowData(Spreadsheet spreadsheet) {
        this.spreadsheet = spreadsheet;
    }

    public void copy(int rowIndex) {
        this.isCopied = true;
        this.rowIndex = rowIndex;
        this.maxCol = this.spreadsheet.getLastColumn();
        this.cellsData.clear();
        this.mergedCells.clear();
        this.commentsWithoutCell.clear();
        Row row = this.spreadsheet.getActiveSheet().getRow(rowIndex);
        Float f = row == null ? null : (this.height = Float.valueOf(row.getZeroHeight() ? 0.0f : row.getHeightInPoints()));
        if (row != null) {
            this.copyCellsData(row);
        }
        Sheet sheet = this.spreadsheet.getActiveSheet();
        for (int i = 0; i < sheet.getNumMergedRegions(); ++i) {
            CellRangeAddress mergedRegion = sheet.getMergedRegion(i);
            if (mergedRegion.getFirstRow() != rowIndex) continue;
            this.mergedCells.add(mergedRegion);
        }
    }

    private void copyCellsData(Row row) {
        for (Cell cell : row) {
            if (cell == null) continue;
            CellData cellData = new CellData(this.spreadsheet);
            cellData.read(cell);
            this.cellsData.add(cellData);
        }
        for (int i = 0; i < this.maxCol; ++i) {
            Comment cellComment = row.getSheet().getCellComment(new CellAddress(row.getRowNum(), i));
            Cell cell = row.getCell(i);
            if (cellComment == null || cell != null) continue;
            CommentData commenData = new CommentData();
            commenData.read(cellComment);
            this.commentsWithoutCell.add(commenData);
        }
    }

    public boolean isCopied() {
        return this.isCopied;
    }

    public void writeTo(Row row) {
        for (CellData cellData : this.cellsData) {
            if (cellData == null) continue;
            int col = cellData.getColumnIndex();
            Cell cell = row.getCell(col);
            if (cell == null) {
                cell = row.createCell(col);
            }
            cellData.writeTo(cell);
        }
        for (CommentData comment : this.commentsWithoutCell) {
            Cell cell = row.createCell(comment.getColumn());
            comment.writeTo(cell);
        }
        for (CellRangeAddress mergedRegion : this.mergedCells) {
            this.spreadsheet.addMergedRegion(mergedRegion);
        }
        if (this.height != null) {
            this.spreadsheet.setRowHeight(this.rowIndex, this.height.floatValue());
        }
        this.isCopied = false;
    }

    private static class CellData
    implements Serializable {
        private int columnIndex;
        private int rowIndex;
        private CellType cellType;
        private String cellFormula;
        private double numericCellValue;
        private Date dateCellValue;
        private RichTextString richTextCellValue;
        private String stringCellValue;
        private boolean booleanCellValue;
        private byte errorCellValue;
        private CommentData cellComment;
        private Hyperlink hyperlink;
        private CellStyle cellStyle;
        private Spreadsheet spreadsheet;

        public CellData(Spreadsheet spreadsheet) {
            this.spreadsheet = spreadsheet;
        }

        public int getRowIndex() {
            return this.rowIndex;
        }

        public int getColumnIndex() {
            return this.columnIndex;
        }

        public void read(Cell cell) {
            this.columnIndex = cell.getColumnIndex();
            this.rowIndex = cell.getRowIndex();
            if (cell.getCellComment() != null) {
                CommentData commenData = new CommentData();
                commenData.read(cell.getCellComment());
                this.cellComment = commenData;
            }
            this.hyperlink = cell.getHyperlink();
            this.cellStyle = cell.getCellStyle();
            this.cellType = cell.getCellType();
            switch (this.cellType) {
                case _NONE: 
                case BLANK: {
                    this.stringCellValue = cell.getStringCellValue();
                    break;
                }
                case BOOLEAN: {
                    this.booleanCellValue = cell.getBooleanCellValue();
                    break;
                }
                case ERROR: {
                    this.errorCellValue = cell.getErrorCellValue();
                    break;
                }
                case FORMULA: {
                    this.cellFormula = cell.getCellFormula();
                    break;
                }
                case NUMERIC: {
                    if (DateUtil.isCellDateFormatted((Cell)cell)) {
                        if (!DateUtil.isCellDateFormatted((Cell)cell)) break;
                        this.dateCellValue = cell.getDateCellValue();
                        break;
                    }
                    this.numericCellValue = cell.getNumericCellValue();
                    break;
                }
                case STRING: {
                    this.richTextCellValue = cell.getRichStringCellValue();
                }
            }
        }

        public void writeTo(Cell cell) {
            if (this.cellComment != null) {
                this.cellComment.writeTo(cell);
            }
            if (this.hyperlink != null) {
                cell.setHyperlink(this.hyperlink);
            }
            cell.setCellStyle(this.cellStyle);
            switch (this.cellType) {
                case _NONE: 
                case BLANK: {
                    cell.setBlank();
                    break;
                }
                case BOOLEAN: {
                    cell.setCellValue(this.booleanCellValue);
                    break;
                }
                case ERROR: {
                    cell.setCellErrorValue(this.errorCellValue);
                    break;
                }
                case FORMULA: {
                    cell.setCellFormula(this.cellFormula);
                    break;
                }
                case NUMERIC: {
                    if (this.dateCellValue != null) {
                        cell.setCellValue(this.dateCellValue);
                        break;
                    }
                    cell.setCellValue(this.numericCellValue);
                    break;
                }
                case STRING: {
                    cell.setCellValue(this.richTextCellValue);
                }
            }
        }
    }

    private static class CommentData
    implements Serializable {
        private ClientAnchor clientAnchor;
        private String author;
        private String text;
        private boolean visible;
        private int row;
        private int column;

        private CommentData() {
        }

        public void read(Comment cellComment) {
            this.clientAnchor = cellComment.getClientAnchor();
            this.author = cellComment.getAuthor();
            this.text = cellComment.getString().getString();
            this.visible = cellComment.isVisible();
            this.row = cellComment.getRow();
            this.column = cellComment.getColumn();
        }

        public void writeTo(Cell cell) {
            Drawing drawingPatriarch = cell.getSheet().createDrawingPatriarch();
            CreationHelper factory = cell.getSheet().getWorkbook().getCreationHelper();
            Comment newCellComment = drawingPatriarch.createCellComment(this.clientAnchor);
            newCellComment.setAuthor(this.author);
            RichTextString richTextString = factory.createRichTextString(this.text);
            newCellComment.setString(richTextString);
            newCellComment.setVisible(this.visible);
            cell.setCellComment(newCellComment);
        }

        public int getRow() {
            return this.row;
        }

        public int getColumn() {
            return this.column;
        }
    }
}

