/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.spreadsheet.action;

import com.vaadin.flow.component.spreadsheet.Spreadsheet;
import com.vaadin.flow.component.spreadsheet.action.DeleteRowAction;
import com.vaadin.flow.component.spreadsheet.action.DeleteTableAction;
import com.vaadin.flow.component.spreadsheet.action.EditCellCommentAction;
import com.vaadin.flow.component.spreadsheet.action.HideHeaderAction;
import com.vaadin.flow.component.spreadsheet.action.InsertDeleteCellCommentAction;
import com.vaadin.flow.component.spreadsheet.action.InsertNewRowAction;
import com.vaadin.flow.component.spreadsheet.action.InsertTableAction;
import com.vaadin.flow.component.spreadsheet.action.MergeCellsAction;
import com.vaadin.flow.component.spreadsheet.action.ShowHideCellCommentAction;
import com.vaadin.flow.component.spreadsheet.action.SpreadsheetAction;
import com.vaadin.flow.component.spreadsheet.action.UnHideHeadersAction;
import com.vaadin.flow.component.spreadsheet.action.UnMergeCellsAction;
import com.vaadin.flow.component.spreadsheet.framework.Action;
import java.util.ArrayList;
import java.util.List;
import org.apache.poi.ss.util.CellRangeAddress;

public class SpreadsheetDefaultActionHandler
implements Action.Handler {
    private final List<SpreadsheetAction> defaultActions = new ArrayList<SpreadsheetAction>();

    public SpreadsheetDefaultActionHandler() {
        this.defaultActions.add(new HideHeaderAction());
        this.defaultActions.add(new UnHideHeadersAction());
        this.defaultActions.add(new MergeCellsAction());
        this.defaultActions.add(new UnMergeCellsAction());
        this.defaultActions.add(new InsertDeleteCellCommentAction());
        this.defaultActions.add(new EditCellCommentAction());
        this.defaultActions.add(new ShowHideCellCommentAction());
        this.defaultActions.add(new InsertNewRowAction());
        this.defaultActions.add(new DeleteRowAction());
        this.defaultActions.add(new InsertTableAction());
        this.defaultActions.add(new DeleteTableAction());
    }

    public void addSpreadsheetAction(SpreadsheetAction action) {
        this.defaultActions.add(action);
    }

    public boolean removeSpreadsheetAction(SpreadsheetAction action) {
        return this.defaultActions.remove(action);
    }

    @Override
    public Action[] getActions(Object target, Object sender) {
        ArrayList<SpreadsheetAction> temp;
        block3: {
            Spreadsheet spreadsheet;
            block2: {
                temp = new ArrayList<SpreadsheetAction>();
                spreadsheet = (Spreadsheet)sender;
                if (!(target instanceof Spreadsheet.SelectionChangeEvent)) break block2;
                for (SpreadsheetAction action : this.defaultActions) {
                    if (!action.isApplicableForSelection(spreadsheet, (Spreadsheet.SelectionChangeEvent)((Object)target))) continue;
                    temp.add(action);
                }
                break block3;
            }
            if (!(target instanceof CellRangeAddress)) break block3;
            for (SpreadsheetAction action : this.defaultActions) {
                if (!action.isApplicableForHeader(spreadsheet, (CellRangeAddress)target)) continue;
                temp.add(action);
            }
        }
        return temp.toArray(new Action[temp.size()]);
    }

    @Override
    public void handleAction(Action action, Object sender, Object target) {
        if (action instanceof SpreadsheetAction) {
            if (target instanceof Spreadsheet.SelectionChangeEvent) {
                ((SpreadsheetAction)action).executeActionOnSelection((Spreadsheet)sender, (Spreadsheet.SelectionChangeEvent)((Object)target));
            } else if (target instanceof CellRangeAddress) {
                ((SpreadsheetAction)action).executeActionOnHeader((Spreadsheet)sender, (CellRangeAddress)target);
            }
        }
    }
}

