/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.spreadsheet;

import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import java.util.Queue;

class IteratorChain<E>
implements Iterator<E>,
Serializable {
    private final Queue<Iterator<? extends E>> iteratorChain = new LinkedList<Iterator<? extends E>>();
    private Iterator<? extends E> currentIterator = null;

    public IteratorChain(Collection<Iterator<? extends E>> iterators) {
        this.iteratorChain.addAll(iterators);
    }

    private void updateCurrentIterator() {
        if (this.currentIterator == null) {
            this.currentIterator = this.iteratorChain.isEmpty() ? new EmptyIterator<E>() : this.iteratorChain.remove();
        }
        while (!this.currentIterator.hasNext() && !this.iteratorChain.isEmpty()) {
            this.currentIterator = this.iteratorChain.remove();
        }
    }

    @Override
    public boolean hasNext() {
        this.updateCurrentIterator();
        return this.currentIterator.hasNext();
    }

    @Override
    public E next() {
        this.updateCurrentIterator();
        return this.currentIterator.next();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("remove");
    }

    private static class EmptyIterator<E>
    implements Iterator<E>,
    Serializable {
        private EmptyIterator() {
        }

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public E next() {
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove");
        }
    }
}

