/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.spreadsheet.command;

import com.vaadin.flow.component.spreadsheet.Spreadsheet;
import com.vaadin.flow.component.spreadsheet.command.RowData;
import com.vaadin.flow.component.spreadsheet.command.SpreadsheetCommand;
import java.util.ArrayList;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.ss.util.CellReference;

public class RowInsertOrDeleteCommand
extends SpreadsheetCommand {
    private final int row;
    private boolean wasDeleted = false;
    private RowData rowData;

    public RowInsertOrDeleteCommand(Spreadsheet spreadsheet, CellRangeAddress headerRange) {
        super(spreadsheet);
        this.row = headerRange.getFirstRow();
        this.rowData = new RowData(spreadsheet);
    }

    @Override
    public void execute() {
        if (this.wasDeleted) {
            this.insertNewRow();
        } else {
            this.deleteRow();
        }
    }

    @Override
    public CellReference getSelectedCellReference() {
        return new CellReference(this.getSheet().getSheetName(), this.row, 0, false, false);
    }

    @Override
    public CellRangeAddress getPaintedCellRange() {
        return new CellRangeAddress(this.row, this.row, 0, this.spreadsheet.getLastColumn());
    }

    public void insertNewRow() {
        this.wasDeleted = false;
        int rows = this.spreadsheet.getRows();
        this.spreadsheet.shiftRows(this.row, rows - 1, 1, true, true);
        this.spreadsheet.setMaxRows(rows + 1);
        this.restoreOldCellValues();
        this.spreadsheet.refreshAllCellValues();
    }

    public void deleteRow() {
        this.wasDeleted = true;
        int rows = this.spreadsheet.getRows();
        this.captureOldValues();
        if (this.row + 1 > rows - 1) {
            this.spreadsheet.deleteRows(this.row, this.row);
        } else {
            this.spreadsheet.shiftRows(this.row + 1, rows - 1, -1, true, true);
        }
        this.spreadsheet.setMaxRows(rows - 1);
    }

    private void captureOldValues() {
        this.rowData.copy(this.row);
    }

    private void restoreOldCellValues() {
        if (this.rowData.isCopied()) {
            Row row = this.getSheet().getRow(this.row);
            if (row == null) {
                row = this.getSheet().createRow(this.row);
            }
            this.rowData.writeTo(row);
            if (!this.spreadsheet.isRerenderPending()) {
                ArrayList<Cell> modifiedCells = new ArrayList<Cell>();
                for (Cell cell : row) {
                    if (cell == null) continue;
                    modifiedCells.add(cell);
                }
                this.spreadsheet.refreshCells(modifiedCells);
            }
        }
    }
}

