/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.spreadsheet;

import com.vaadin.flow.component.spreadsheet.Spreadsheet;
import java.io.Serializable;
import java.lang.reflect.Method;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTCol;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTCols;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTRow;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class GroupingUtil
implements Serializable {
    private static final Logger LOGGER = LoggerFactory.getLogger(GroupingUtil.class);

    private GroupingUtil() {
    }

    public static void expandRow(XSSFSheet sheet, int rowNumber) {
        if (rowNumber == -1) {
            return;
        }
        XSSFRow row = sheet.getRow(rowNumber);
        if (!row.getCTRow().isSetHidden()) {
            return;
        }
        int startIdx = GroupingUtil.findStartOfRowOutlineGroup(sheet, rowNumber);
        int endIdx = GroupingUtil.findEndOfRowOutlineGroup(sheet, rowNumber);
        short level = row.getCTRow().getOutlineLevel();
        if (!GroupingUtil.isRowGroupHiddenByParent(sheet, rowNumber)) {
            for (int i = ++startIdx; i < endIdx; ++i) {
                XSSFRow r = sheet.getRow(i);
                if (level == r.getCTRow().getOutlineLevel()) {
                    r.getCTRow().unsetHidden();
                    continue;
                }
                if (GroupingUtil.isRowGroupOrParentCollapsed(sheet, i, level)) continue;
                r.getCTRow().unsetHidden();
            }
        }
        if (GroupingUtil.isRowsInverted(sheet)) {
            XSSFRow r = sheet.getRow(startIdx - 1);
            if (r != null && r.getCTRow().getCollapsed()) {
                r.getCTRow().unsetCollapsed();
            }
        } else {
            CTRow ctRow = sheet.getRow(endIdx).getCTRow();
            if (ctRow.getCollapsed()) {
                ctRow.unsetCollapsed();
            }
        }
    }

    private static int findEndOfRowOutlineGroup(XSSFSheet sheet, int row) {
        XSSFRow row2;
        int currentRow;
        short level = sheet.getRow(row).getCTRow().getOutlineLevel();
        int lastRowNum = sheet.getLastRowNum() + 1;
        for (currentRow = row; currentRow < lastRowNum && (row2 = sheet.getRow(currentRow)) != null && row2.getCTRow().getOutlineLevel() >= level; ++currentRow) {
        }
        return currentRow;
    }

    private static boolean isRowGroupOrParentCollapsed(XSSFSheet sheet, int row, int originalLevel) {
        short level = sheet.getRow(row).getCTRow().getOutlineLevel();
        while (level > originalLevel) {
            int collapseRow;
            if (GroupingUtil.isRowsInverted(sheet)) {
                collapseRow = GroupingUtil.findStartOfRowOutlineGroup(sheet, row);
                --row;
            } else {
                collapseRow = GroupingUtil.findEndOfRowOutlineGroup(sheet, row);
                ++row;
            }
            if (sheet.getRow(collapseRow) == null) continue;
            CTRow ctRow = sheet.getRow(collapseRow).getCTRow();
            level = ctRow.getOutlineLevel();
            boolean collapsed = ctRow.getCollapsed();
            if (!collapsed || ctRow.getOutlineLevel() < originalLevel) continue;
            return true;
        }
        return false;
    }

    private static boolean isRowGroupHiddenByParent(XSSFSheet sheet, int row) {
        boolean startHidden;
        short startLevel;
        boolean endHidden;
        short endLevel;
        int endOfOutlineGroupIdx = GroupingUtil.findEndOfRowOutlineGroup(sheet, row);
        if (sheet.getRow(endOfOutlineGroupIdx) == null) {
            endLevel = 0;
            endHidden = false;
        } else {
            endLevel = sheet.getRow(endOfOutlineGroupIdx).getCTRow().getOutlineLevel();
            endHidden = sheet.getRow(endOfOutlineGroupIdx).getCTRow().getHidden();
        }
        int startOfOutlineGroupIdx = GroupingUtil.findStartOfRowOutlineGroup(sheet, row);
        if (startOfOutlineGroupIdx < 0 || sheet.getRow(startOfOutlineGroupIdx) == null) {
            startLevel = 0;
            startHidden = false;
        } else {
            startLevel = sheet.getRow(startOfOutlineGroupIdx).getCTRow().getOutlineLevel();
            startHidden = sheet.getRow(startOfOutlineGroupIdx).getCTRow().getHidden();
        }
        if (endLevel > startLevel) {
            return endHidden;
        }
        return startHidden;
    }

    private static boolean isColumnGroupHiddenByParent(XSSFSheet sheet, int idx) {
        CTCol[] colArray;
        CTCols cols = sheet.getCTWorksheet().getColsArray(0);
        short endLevel = 0;
        boolean endHidden = false;
        int endOfOutlineGroupIdx = (Integer)GroupingUtil.callSheetMethod("findEndOfColumnOutlineGroup", sheet, idx);
        if (endOfOutlineGroupIdx + 1 < (colArray = cols.getColArray()).length) {
            CTCol nextInfo = colArray[endOfOutlineGroupIdx + 1];
            if (((Boolean)GroupingUtil.callSheetMethod("isAdjacentBefore", sheet, colArray[endOfOutlineGroupIdx], nextInfo)).booleanValue()) {
                endLevel = nextInfo.getOutlineLevel();
                endHidden = nextInfo.getHidden();
            }
        }
        short startLevel = 0;
        boolean startHidden = false;
        int startOfOutlineGroupIdx = (Integer)GroupingUtil.callSheetMethod("findStartOfColumnOutlineGroup", sheet, idx);
        if (startOfOutlineGroupIdx > 0) {
            CTCol prevInfo = colArray[startOfOutlineGroupIdx - 1];
            if (((Boolean)GroupingUtil.callSheetMethod("isAdjacentBefore", sheet, prevInfo, colArray[startOfOutlineGroupIdx])).booleanValue()) {
                startLevel = prevInfo.getOutlineLevel();
                startHidden = prevInfo.getHidden();
            }
        }
        if (endLevel > startLevel) {
            return endHidden;
        }
        return startHidden;
    }

    private static int findStartOfRowOutlineGroup(XSSFSheet sheet, int rowIndex) {
        short level = sheet.getRow(rowIndex).getCTRow().getOutlineLevel();
        int currentRow = rowIndex;
        while (sheet.getRow(currentRow) != null) {
            if (sheet.getRow(currentRow).getCTRow().getOutlineLevel() < level) {
                return currentRow;
            }
            --currentRow;
        }
        return currentRow;
    }

    public static void collapseRow(XSSFSheet sheet, int rowIndex) {
        XSSFRow row = sheet.getRow(rowIndex);
        if (row != null) {
            int startRow = GroupingUtil.findStartOfRowOutlineGroup(sheet, rowIndex);
            int lastRow = GroupingUtil.writeHidden(sheet, row, startRow, true);
            if (GroupingUtil.isRowsInverted(sheet)) {
                if (sheet.getRow(startRow) != null) {
                    sheet.getRow(startRow).getCTRow().setCollapsed(true);
                } else if (startRow >= 0) {
                    XSSFRow newRow = sheet.createRow(startRow);
                    newRow.getCTRow().setCollapsed(true);
                }
            } else if (sheet.getRow(lastRow) != null) {
                sheet.getRow(lastRow).getCTRow().setCollapsed(true);
            } else {
                XSSFRow newRow = sheet.createRow(lastRow);
                newRow.getCTRow().setCollapsed(true);
            }
        }
    }

    private static boolean isRowsInverted(XSSFSheet sheet) {
        boolean inverted = false;
        try {
            inverted = sheet.getCTWorksheet().getSheetPr().getOutlinePr().isSetSummaryBelow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return inverted;
    }

    private static int writeHidden(XSSFSheet sheet, XSSFRow xRow, int rowIndex, boolean hidden) {
        short outlineLevel;
        XSSFRow row;
        short level = xRow.getCTRow().getOutlineLevel();
        ++rowIndex;
        while ((row = sheet.getRow(rowIndex)) != null && (outlineLevel = row.getCTRow().getOutlineLevel()) >= level) {
            row.getCTRow().setHidden(hidden);
            ++rowIndex;
        }
        return rowIndex;
    }

    public static void collapseColumn(XSSFSheet sheet, int columnNumber) {
        CTCols cols = sheet.getCTWorksheet().getColsArray(0);
        CTCol col = sheet.getColumnHelper().getColumn((long)columnNumber, false);
        int colInfoIx = sheet.getColumnHelper().getIndexOfColumn(cols, col);
        if (colInfoIx == -1) {
            return;
        }
        int groupStartColInfoIx = (Integer)GroupingUtil.callSheetMethod("findStartOfColumnOutlineGroup", sheet, colInfoIx);
        int lastColMax = (Integer)GroupingUtil.callSheetMethod("setGroupHidden", sheet, groupStartColInfoIx, col.getOutlineLevel(), true);
        GroupingUtil.callSheetMethod("setColumn", sheet, lastColMax + 1, 0, null, null, Boolean.TRUE);
    }

    public static short expandColumn(XSSFSheet sheet, int columnIndex) {
        CTCols cols = sheet.getCTWorksheet().getColsArray(0);
        CTCol col = sheet.getColumnHelper().getColumn((long)columnIndex, false);
        int colInfoIx = sheet.getColumnHelper().getIndexOfColumn(cols, col);
        int idx = (Integer)GroupingUtil.callSheetMethod("findColInfoIdx", sheet, (int)col.getMax(), colInfoIx);
        if (idx == -1) {
            return -1;
        }
        if (!GroupingUtil.isColumnGroupCollapsed(sheet, idx)) {
            return -1;
        }
        int startIdx = (Integer)GroupingUtil.callSheetMethod("findStartOfColumnOutlineGroup", sheet, idx);
        int endIdx = (Integer)GroupingUtil.callSheetMethod("findEndOfColumnOutlineGroup", sheet, idx);
        CTCol[] colArray = cols.getColArray();
        CTCol columnInfo = colArray[endIdx];
        short expandedLevel = -1;
        if (!GroupingUtil.isColumnGroupHiddenByParent(sheet, idx)) {
            short outlineLevel = col.getOutlineLevel();
            boolean nestedGroup = false;
            for (int i = startIdx; i <= endIdx; ++i) {
                CTCol ci = colArray[i];
                if (outlineLevel == ci.getOutlineLevel()) {
                    ci.unsetHidden();
                    if (nestedGroup) {
                        nestedGroup = false;
                        ci.setCollapsed(true);
                    }
                    expandedLevel = outlineLevel;
                    continue;
                }
                nestedGroup = true;
            }
        }
        return expandedLevel;
    }

    private static boolean isColumnGroupCollapsed(XSSFSheet sheet, int idx) {
        CTCols cols = sheet.getCTWorksheet().getColsArray(0);
        CTCol col = cols.getColArray(idx);
        return col.isSetHidden();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Object callSheetMethod(String methodname, XSSFSheet sheet, Object ... params) {
        Class[] paramtypes = new Class[params.length];
        for (int i = 0; i < params.length; ++i) {
            paramtypes[i] = params[i] == null ? Object.class : params[i].getClass();
        }
        Method method = null;
        try {
            for (Method m : XSSFSheet.class.getDeclaredMethods()) {
                if (!m.getName().equals(methodname)) continue;
                method = m;
            }
            if (method != null) {
                method.setAccessible(true);
                Object object = method.invoke((Object)sheet, params);
                return object;
            }
        }
        catch (Exception exception) {
            LOGGER.info("Error accessing method: " + String.valueOf(method), (Throwable)exception);
        }
        finally {
            if (method != null) {
                method.setAccessible(false);
            }
        }
        return null;
    }

    public static long findUniqueColIndex(CTCols colsArray, CTCol col, short lastlevel) {
        for (int index = colsArray.getColList().indexOf(col); index < colsArray.sizeOfColArray(); ++index) {
            CTCol current = colsArray.getColArray(index);
            if (current.getOutlineLevel() != lastlevel) continue;
            return current.getMin();
        }
        return -1L;
    }

    public static long findUniqueRowIndex(Spreadsheet sheet, int start, int end, int lastlevel) {
        for (int i = start; i <= end; ++i) {
            XSSFRow current = (XSSFRow)sheet.getActiveSheet().getRow(i);
            if (current.getCTRow().getOutlineLevel() != lastlevel) continue;
            return i;
        }
        return -1L;
    }

    public static boolean checkHidden(CTCols colsArray, CTCol col, short lastlevel) {
        for (int index = colsArray.getColList().indexOf(col); index < colsArray.sizeOfColArray(); ++index) {
            CTCol current = colsArray.getColArray(index);
            if (current.getOutlineLevel() != lastlevel) continue;
            return current.isSetHidden();
        }
        return false;
    }

    public static long findEndOfRowGroup(Spreadsheet sheet, int rowindex, XSSFRow row, short level) {
        while (rowindex < sheet.getRows()) {
            XSSFRow r = (XSSFRow)sheet.getActiveSheet().getRow(rowindex);
            if (r == null || r.getCTRow().getOutlineLevel() < level) {
                return (long)rowindex - 1L;
            }
            ++rowindex;
        }
        return -1L;
    }

    public static long findEndOfColGroup(CTCols colsArray, CTCol col, short level) {
        CTCol previous = null;
        for (int index = colsArray.getColList().indexOf(col); index < colsArray.sizeOfColArray(); ++index) {
            boolean hasBreak;
            CTCol c = colsArray.getColArray(index);
            boolean bl = hasBreak = previous != null && c.getMin() - previous.getMax() > 1L;
            if (hasBreak || c.getOutlineLevel() < level) break;
            previous = c;
        }
        return previous == null ? 0L : previous.getMax();
    }
}

