/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.spreadsheet.action;

import com.vaadin.flow.component.spreadsheet.Spreadsheet;
import com.vaadin.flow.component.spreadsheet.action.SpreadsheetAction;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.util.CellRangeAddress;

public class UnMergeCellsAction
extends SpreadsheetAction {
    public UnMergeCellsAction() {
        super("Unmerge cells");
    }

    @Override
    public boolean isApplicableForSelection(Spreadsheet spreadsheet, Spreadsheet.SelectionChangeEvent event) {
        if (event.getSelectedCellMergedRegion() != null && event.getIndividualSelectedCells().size() == 0 && event.getCellRangeAddresses().size() == 0) {
            Sheet sheet = spreadsheet.getActiveSheet();
            if (this.isSheetProtected(sheet)) {
                CellRangeAddress mergedCell = event.getSelectedCellMergedRegion();
                Row row = sheet.getRow(mergedCell.getFirstRow());
                if (row != null) {
                    Cell cell = row.getCell(mergedCell.getFirstColumn());
                    if (this.isCellLocked(cell)) {
                        return false;
                    }
                } else {
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean isApplicableForHeader(Spreadsheet spreadsheet, CellRangeAddress headerRange) {
        return false;
    }

    @Override
    public void executeActionOnSelection(Spreadsheet spreadsheet, Spreadsheet.SelectionChangeEvent event) {
        CellRangeAddress selectedCellReference = event.getSelectedCellMergedRegion();
        Sheet sheet = spreadsheet.getActiveSheet();
        for (int i = 0; i < sheet.getNumMergedRegions(); ++i) {
            CellRangeAddress mergedRegion = sheet.getMergedRegion(i);
            if (selectedCellReference.getFirstColumn() != mergedRegion.getFirstColumn() || selectedCellReference.getFirstRow() != mergedRegion.getFirstRow()) continue;
            spreadsheet.removeMergedRegion(i);
        }
    }

    @Override
    public void executeActionOnHeader(Spreadsheet spreadsheet, CellRangeAddress headerRange) {
        throw new UnsupportedOperationException("Unmerge action can't be executed against a header range.");
    }
}

