/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.spreadsheet;

import com.vaadin.flow.component.spreadsheet.Spreadsheet;
import com.vaadin.flow.component.spreadsheet.client.SpreadsheetActionDetails;
import com.vaadin.flow.component.spreadsheet.framework.Action;
import com.vaadin.flow.data.provider.KeyMapper;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedList;
import org.apache.poi.ss.util.CellRangeAddress;
import org.jsoup.Jsoup;
import org.jsoup.safety.Safelist;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContextMenuManager
implements Serializable {
    private static final Logger LOGGER = LoggerFactory.getLogger(ContextMenuManager.class);
    private LinkedList<Action.Handler> actionHandlers;
    private KeyMapper<Action> actionMapper;
    private final Spreadsheet spreadsheet;
    private int contextMenuHeaderIndex = -1;

    public ContextMenuManager(Spreadsheet spreadsheet) {
        this.spreadsheet = spreadsheet;
    }

    public void addActionHandler(Action.Handler actionHandler) {
        if (actionHandler != null) {
            if (this.actionHandlers == null) {
                this.actionHandlers = new LinkedList();
                this.actionMapper = new KeyMapper();
            }
            if (!this.actionHandlers.contains(actionHandler)) {
                this.actionHandlers.add(actionHandler);
            }
        }
    }

    public void removeActionHandler(Action.Handler actionHandler) {
        if (this.actionHandlers != null && this.actionHandlers.contains(actionHandler)) {
            this.actionHandlers.remove(actionHandler);
            if (this.actionHandlers.isEmpty()) {
                this.actionHandlers = null;
                this.actionMapper = null;
            }
        }
    }

    public boolean hasActionHandlers() {
        return this.actionHandlers != null && this.actionHandlers.size() > 0;
    }

    public void onContextMenuOpenOnSelection(int row, int column) {
        try {
            ArrayList<SpreadsheetActionDetails> actions;
            boolean keepSelection = this.spreadsheet.getCellSelectionManager().isCellInsideSelection(row, column);
            if (!keepSelection) {
                this.spreadsheet.getCellSelectionManager().onCellSelected(row, column, true);
            }
            if (!(actions = this.createActionsListForSelection()).isEmpty()) {
                this.spreadsheet.getRpcProxy().showActions(actions);
            }
        }
        catch (Exception e) {
            LOGGER.trace(e.getMessage(), (Throwable)e);
        }
    }

    public void onRowHeaderContextMenuOpen(int rowIndex) {
        ArrayList<SpreadsheetActionDetails> actions = this.createActionsListForRow(rowIndex);
        if (!actions.isEmpty()) {
            this.spreadsheet.getRpcProxy().showActions(actions);
            this.contextMenuHeaderIndex = rowIndex;
        }
    }

    public void onColumnHeaderContextMenuOpen(int columnIndex) {
        ArrayList<SpreadsheetActionDetails> actions = this.createActionsListForColumn(columnIndex);
        if (!actions.isEmpty()) {
            this.spreadsheet.getRpcProxy().showActions(actions);
            this.contextMenuHeaderIndex = columnIndex;
        }
    }

    public void onActionOnCurrentSelection(String actionKey) {
        Action action = (Action)this.actionMapper.get(actionKey);
        for (Action.Handler ah : this.actionHandlers) {
            ah.handleAction(action, this.spreadsheet, (Object)this.spreadsheet.getCellSelectionManager().getLatestSelectionEvent());
        }
    }

    public void onActionOnRowHeader(String actionKey) {
        Action action = (Action)this.actionMapper.get(actionKey);
        CellRangeAddress row = new CellRangeAddress(this.contextMenuHeaderIndex - 1, this.contextMenuHeaderIndex - 1, -1, -1);
        for (Action.Handler ah : this.actionHandlers) {
            ah.handleAction(action, this.spreadsheet, row);
        }
    }

    public void onActionOnColumnHeader(String actionKey) {
        Action action = (Action)this.actionMapper.get(actionKey);
        CellRangeAddress column = new CellRangeAddress(-1, -1, this.contextMenuHeaderIndex - 1, this.contextMenuHeaderIndex - 1);
        for (Action.Handler ah : this.actionHandlers) {
            ah.handleAction(action, this.spreadsheet, column);
        }
    }

    protected ArrayList<SpreadsheetActionDetails> createActionsListForSelection() {
        ArrayList<SpreadsheetActionDetails> actions = new ArrayList<SpreadsheetActionDetails>();
        for (Action.Handler handler : this.actionHandlers) {
            Action[] handlerActions = handler.getActions((Object)this.spreadsheet.getCellSelectionManager().getLatestSelectionEvent(), this.spreadsheet);
            actions.addAll(this.createActionDetailsList(handlerActions, ActionType.CELL));
        }
        return actions;
    }

    protected ArrayList<SpreadsheetActionDetails> createActionsListForColumn(int columnIndex) {
        ArrayList<SpreadsheetActionDetails> actions = new ArrayList<SpreadsheetActionDetails>();
        CellRangeAddress column = new CellRangeAddress(-1, -1, columnIndex - 1, columnIndex - 1);
        for (Action.Handler handler : this.actionHandlers) {
            Action[] handlerActions = handler.getActions(column, this.spreadsheet);
            actions.addAll(this.createActionDetailsList(handlerActions, ActionType.COLUMN));
        }
        return actions;
    }

    protected ArrayList<SpreadsheetActionDetails> createActionsListForRow(int rowIndex) {
        ArrayList<SpreadsheetActionDetails> actions = new ArrayList<SpreadsheetActionDetails>();
        CellRangeAddress row = new CellRangeAddress(rowIndex - 1, rowIndex - 1, -1, -1);
        for (Action.Handler handler : this.actionHandlers) {
            Action[] handlerActions = handler.getActions(row, this.spreadsheet);
            actions.addAll(this.createActionDetailsList(handlerActions, ActionType.ROW));
        }
        return actions;
    }

    private ArrayList<SpreadsheetActionDetails> createActionDetailsList(Action[] actions, ActionType actionType) {
        ArrayList<SpreadsheetActionDetails> actionDetailsList = new ArrayList<SpreadsheetActionDetails>();
        if (actions != null) {
            for (Action action : actions) {
                String key = this.actionMapper.key((Object)action);
                SpreadsheetActionDetails spreadsheetActionDetails = new SpreadsheetActionDetails();
                String caption = action.getCaption();
                if (caption == null) {
                    caption = "";
                }
                spreadsheetActionDetails.caption = Jsoup.clean((String)caption, (Safelist)Safelist.relaxed());
                spreadsheetActionDetails.key = key;
                spreadsheetActionDetails.type = actionType.getValue();
                actionDetailsList.add(spreadsheetActionDetails);
            }
        }
        return actionDetailsList;
    }

    static enum ActionType {
        CELL(0),
        ROW(1),
        COLUMN(2);

        private final int value;

        private ActionType(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }
}

