/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.spreadsheet;

import com.vaadin.flow.component.spreadsheet.GroupingUtil;
import com.vaadin.flow.component.spreadsheet.SheetChartWrapper;
import com.vaadin.flow.component.spreadsheet.SheetImageWrapper;
import com.vaadin.flow.component.spreadsheet.SheetOverlayWrapper;
import com.vaadin.flow.component.spreadsheet.Spreadsheet;
import com.vaadin.flow.component.spreadsheet.SpreadsheetFilterTable;
import com.vaadin.flow.component.spreadsheet.SpreadsheetTable;
import com.vaadin.flow.component.spreadsheet.SpreadsheetUtil;
import com.vaadin.flow.component.spreadsheet.client.MergedRegion;
import com.vaadin.flow.component.spreadsheet.shared.GroupingData;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Stack;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.poi.hssf.usermodel.HSSFClientAnchor;
import org.apache.poi.hssf.usermodel.HSSFPatriarch;
import org.apache.poi.hssf.usermodel.HSSFPicture;
import org.apache.poi.hssf.usermodel.HSSFPictureData;
import org.apache.poi.hssf.usermodel.HSSFShape;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ooxml.POIXMLException;
import org.apache.poi.ss.usermodel.ClientAnchor;
import org.apache.poi.ss.usermodel.Drawing;
import org.apache.poi.ss.usermodel.Name;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.apache.poi.ss.util.AreaReference;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.ss.util.PaneInformation;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.apache.poi.xssf.usermodel.XSSFChart;
import org.apache.poi.xssf.usermodel.XSSFClientAnchor;
import org.apache.poi.xssf.usermodel.XSSFDrawing;
import org.apache.poi.xssf.usermodel.XSSFGraphicFrame;
import org.apache.poi.xssf.usermodel.XSSFPicture;
import org.apache.poi.xssf.usermodel.XSSFPictureData;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFShape;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFTable;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlObject;
import org.openxmlformats.schemas.drawingml.x2006.spreadsheetDrawing.CTOneCellAnchor;
import org.openxmlformats.schemas.drawingml.x2006.spreadsheetDrawing.CTTwoCellAnchor;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTAutoFilter;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTCol;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTCols;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTFilterColumn;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTOutlinePr;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTSheetProtection;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTWorksheet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpreadsheetFactory
implements Serializable {
    private static final Logger LOGGER = LoggerFactory.getLogger(SpreadsheetFactory.class);
    public static final int DEFAULT_COL_WIDTH_UNITS = 10;
    public static final float DEFAULT_ROW_HEIGHT_POINTS = 12.75f;
    public static final int DEFAULT_COLUMNS = 52;
    public static final int DEFAULT_ROWS = 200;
    private static boolean LOG_MEMORY = false;

    static void loadSpreadsheetWith(Spreadsheet spreadsheet, Workbook workbook, int rowCount, int columnCount) {
        spreadsheet.clearSheetServerSide();
        if (workbook == null) {
            workbook = new XSSFWorkbook();
            Sheet sheet = SpreadsheetFactory.createNewSheet(workbook);
            spreadsheet.setInternalWorkbook(workbook);
            SpreadsheetFactory.generateNewSpreadsheet(spreadsheet, sheet, rowCount, columnCount);
        } else {
            int activeSheetIndex = workbook.getActiveSheetIndex();
            if (workbook.isSheetHidden(activeSheetIndex) || workbook.isSheetVeryHidden(activeSheetIndex)) {
                workbook.setActiveSheet(SpreadsheetUtil.getFirstVisibleSheetPOIIndex(workbook));
            }
            Sheet sheet = workbook.getSheetAt(activeSheetIndex);
            spreadsheet.setInternalWorkbook(workbook);
            SpreadsheetFactory.reloadSpreadsheetData(spreadsheet, sheet);
        }
        SpreadsheetFactory.loadWorkbookStyles(spreadsheet);
    }

    static void loadNewXLSXSpreadsheet(Spreadsheet spreadsheet) {
        Workbook workbook = spreadsheet.getWorkbook();
        if (workbook != null && workbook instanceof SXSSFWorkbook) {
            ((SXSSFWorkbook)workbook).dispose();
        }
        XSSFWorkbook newWorkbook = new XSSFWorkbook();
        Sheet sheet = SpreadsheetFactory.createNewSheet((Workbook)newWorkbook);
        spreadsheet.clearSheetServerSide();
        spreadsheet.setInternalWorkbook((Workbook)newWorkbook);
        SpreadsheetFactory.generateNewSpreadsheet(spreadsheet, sheet, 200, 52);
        SpreadsheetFactory.setDefaultRowHeight(spreadsheet, sheet);
        SpreadsheetFactory.loadWorkbookStyles(spreadsheet);
    }

    static void addNewSheet(Spreadsheet spreadsheet, Workbook workbook, String sheetName, int rows, int columns) {
        Sheet sheet = sheetName == null ? SpreadsheetFactory.createNewSheet(workbook) : workbook.createSheet(sheetName);
        int sheetIndex = workbook.getSheetIndex(sheet);
        workbook.setActiveSheet(sheetIndex);
        spreadsheet.reloadActiveSheetData();
        spreadsheet.reloadActiveSheetStyles();
        int[] verticalScrollPositions = Arrays.copyOf(spreadsheet.getVerticalScrollPositions(), spreadsheet.getSheetNames().length);
        int[] horizontalScrollPositions = Arrays.copyOf(spreadsheet.getHorizontalScrollPositions(), spreadsheet.getSheetNames().length);
        spreadsheet.setVerticalScrollPositions(verticalScrollPositions);
        spreadsheet.setHorizontalScrollPositions(horizontalScrollPositions);
        SpreadsheetFactory.generateNewSpreadsheet(spreadsheet, sheet, rows, columns);
    }

    static void reloadSpreadsheetComponent(Spreadsheet spreadsheet, File spreadsheetFile) throws IOException {
        try {
            Workbook workbook = WorkbookFactory.create((File)spreadsheetFile);
            SpreadsheetFactory.reloadSpreadsheetComponent(spreadsheet, workbook);
        }
        catch (POIXMLException e) {
            throw new IOException(e);
        }
    }

    static void reloadSpreadsheetComponent(Spreadsheet spreadsheet, InputStream inputStream) throws IOException {
        SpreadsheetFactory.reloadSpreadsheetComponent(spreadsheet, WorkbookFactory.create((InputStream)inputStream));
    }

    static void reloadSpreadsheetComponent(Spreadsheet spreadsheet, Workbook workbook) {
        Workbook oldWorkbook = spreadsheet.getWorkbook();
        if (oldWorkbook != null) {
            spreadsheet.clearSheetServerSide();
            if (oldWorkbook instanceof SXSSFWorkbook) {
                ((SXSSFWorkbook)oldWorkbook).dispose();
            }
        }
        Sheet sheet = workbook.getSheetAt(workbook.getActiveSheetIndex());
        spreadsheet.setInternalWorkbook(workbook);
        SpreadsheetFactory.reloadSpreadsheetData(spreadsheet, sheet);
        SpreadsheetFactory.loadWorkbookStyles(spreadsheet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static File write(Spreadsheet spreadsheet, String fileName) throws FileNotFoundException, IOException {
        File file;
        Workbook workbook = spreadsheet.getWorkbook();
        if (!((String)fileName).endsWith(".xlsx") && !((String)fileName).endsWith(".xls")) {
            fileName = workbook instanceof HSSFWorkbook ? (String)fileName + ".xls" : (String)fileName + ".xlsx";
        }
        if ((file = new File((String)fileName)).exists()) {
            file.delete();
        }
        try (FileOutputStream fos = null;){
            fos = new FileOutputStream(file);
            workbook.write((OutputStream)fos);
            fos.close();
            if (workbook instanceof SXSSFWorkbook) {
                ((SXSSFWorkbook)workbook).dispose();
            }
        }
        Workbook wb = WorkbookFactory.create((File)file);
        spreadsheet.setInternalWorkbook(wb);
        return file;
    }

    static void write(Spreadsheet spreadsheet, OutputStream stream) throws IOException {
        Workbook workbook = spreadsheet.getWorkbook();
        try {
            workbook.write(stream);
            stream.close();
            stream = null;
            if (workbook instanceof SXSSFWorkbook) {
                ((SXSSFWorkbook)workbook).dispose();
            }
        }
        finally {
            if (stream != null) {
                stream.close();
            }
        }
    }

    static void loadWorkbookStyles(Spreadsheet spreadsheet) {
        spreadsheet.getSpreadsheetStyleFactory().reloadWorkbookStyles();
        spreadsheet.getSpreadsheetStyleFactory().reloadActiveSheetCellStyles();
    }

    static void generateNewSpreadsheet(Spreadsheet spreadsheet, Sheet sheet, int rows, int columns) {
        sheet.createRow(rows - 1).createCell(columns - 1);
        SpreadsheetFactory.setDefaultRowHeight(spreadsheet, sheet);
        sheet.setDefaultColumnWidth(10);
        SpreadsheetFactory.reloadSpreadsheetData(spreadsheet, sheet);
    }

    static void reloadSpreadsheetData(Spreadsheet spreadsheet, Sheet sheet) {
        SpreadsheetFactory.logMemoryUsage();
        try {
            SpreadsheetFactory.setDefaultRowHeight(spreadsheet, sheet);
            SpreadsheetFactory.setDefaultColumnWidth(spreadsheet, sheet);
            SpreadsheetFactory.calculateSheetSizes(spreadsheet, sheet);
            SpreadsheetFactory.loadSheetOverlays(spreadsheet);
            SpreadsheetFactory.loadSheetTables(spreadsheet);
            SpreadsheetFactory.loadMergedRegions(spreadsheet);
            SpreadsheetFactory.loadFreezePane(spreadsheet);
            SpreadsheetFactory.loadGrouping(spreadsheet);
            SpreadsheetFactory.loadNamedRanges(spreadsheet);
        }
        catch (NullPointerException npe) {
            LOGGER.warn(npe.getMessage(), (Throwable)npe);
        }
        SpreadsheetFactory.logMemoryUsage();
    }

    static void loadNamedRanges(Spreadsheet spreadsheet) {
        List namedRanges = spreadsheet.getWorkbook().getAllNames();
        ArrayList<String> names = new ArrayList<String>();
        for (Name name : namedRanges) {
            if (!SpreadsheetFactory.isNameSelectable(name)) continue;
            int nameLocalTo = name.getSheetIndex();
            int activeSheet = spreadsheet.getWorkbook().getActiveSheetIndex();
            if (nameLocalTo != -1 && nameLocalTo != activeSheet) continue;
            names.add(name.getNameName());
        }
        spreadsheet.setNamedRanges(names);
    }

    private static boolean isNameSelectable(Name name) {
        if (name.isFunctionName()) {
            return false;
        }
        if (!AreaReference.isContiguous((String)name.getRefersToFormula())) {
            return false;
        }
        try {
            name.getSheetName();
            return true;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    private static void loadSheetTables(Spreadsheet spreadsheet) {
        if (spreadsheet.getActiveSheet() instanceof HSSFSheet) {
            return;
        }
        XSSFSheet sheet = (XSSFSheet)spreadsheet.getActiveSheet();
        CTAutoFilter autoFilter = sheet.getCTWorksheet().getAutoFilter();
        if (autoFilter != null && !SpreadsheetFactory.tableForCTAutoFilterAlreadyLoaded(spreadsheet, autoFilter)) {
            SpreadsheetFilterTable sheetFilterTable = new SpreadsheetFilterTable(spreadsheet, spreadsheet.getActiveSheet(), CellRangeAddress.valueOf((String)autoFilter.getRef()), autoFilter, null);
            spreadsheet.registerTable(sheetFilterTable);
            SpreadsheetFactory.markActiveButtons(sheetFilterTable, autoFilter);
        }
        for (XSSFTable table : sheet.getTables()) {
            if (SpreadsheetFactory.tableForXSSFTableAlreadyLoaded(spreadsheet, table)) continue;
            SpreadsheetFilterTable spreadsheetTable = new SpreadsheetFilterTable(spreadsheet, spreadsheet.getActiveSheet(), CellRangeAddress.valueOf((String)table.getCTTable().getRef()), null, table);
            spreadsheet.registerTable(spreadsheetTable);
        }
    }

    private static boolean tableForXSSFTableAlreadyLoaded(Spreadsheet spreadsheet, XSSFTable table) {
        return spreadsheet.getTables().stream().anyMatch(it -> it.getXssfTable() == table);
    }

    private static boolean tableForCTAutoFilterAlreadyLoaded(Spreadsheet spreadsheet, CTAutoFilter autoFilter) {
        return spreadsheet.getTables().stream().anyMatch(it -> it.getCtWorksheetAutoFilter() == autoFilter);
    }

    private static void markActiveButtons(SpreadsheetTable sheetFilterTable, CTAutoFilter autoFilter) {
        int offset = sheetFilterTable.getFullTableRegion().getFirstColumn();
        for (CTFilterColumn column : autoFilter.getFilterColumnList()) {
            int colId = offset + (int)column.getColId();
            sheetFilterTable.getPopupButton(colId).markActive(true);
        }
    }

    static void calculateSheetSizes(Spreadsheet spreadsheet, Sheet sheet) {
        int i;
        int rows = sheet.getLastRowNum() + 1;
        if (rows < spreadsheet.getDefaultRowCount()) {
            rows = spreadsheet.getDefaultRowCount();
        }
        spreadsheet.setRows(rows);
        float[] rowHeights = new float[rows];
        int cols = 0;
        int tempRowIndex = -1;
        ArrayList<Integer> hiddenRowIndexes = new ArrayList<Integer>();
        for (Row row : sheet) {
            short c;
            int rIndex = row.getRowNum();
            while (++tempRowIndex != rIndex) {
                rowHeights[tempRowIndex] = spreadsheet.getDefRowH();
            }
            if (row.getZeroHeight()) {
                rowHeights[rIndex] = 0.0f;
                hiddenRowIndexes.add(rIndex + 1);
            } else {
                rowHeights[rIndex] = row.getHeightInPoints();
            }
            if ((c = row.getLastCellNum()) <= cols) continue;
            cols = c;
        }
        if (rows > sheet.getLastRowNum() + 1) {
            float defaultRowHeightInPoints = sheet.getDefaultRowHeightInPoints();
            int lastRowNum = sheet.getLastRowNum();
            if (lastRowNum == 0) {
                rowHeights[0] = defaultRowHeightInPoints;
            }
            for (i = lastRowNum + 1; i < rows; ++i) {
                rowHeights[i] = defaultRowHeightInPoints;
            }
        }
        spreadsheet.setHiddenRowIndexes(hiddenRowIndexes);
        spreadsheet.setRowH(rowHeights);
        if (cols < spreadsheet.getDefaultColumnCount()) {
            cols = spreadsheet.getDefaultColumnCount();
        }
        spreadsheet.setCols(cols);
        int[] colWidths = new int[cols];
        ArrayList<Integer> hiddenColumnIndexes = new ArrayList<Integer>();
        for (i = 0; i < cols; ++i) {
            if (sheet.isColumnHidden(i)) {
                colWidths[i] = 0;
                hiddenColumnIndexes.add(i + 1);
                continue;
            }
            colWidths[i] = (int)sheet.getColumnWidthInPixels(i);
        }
        spreadsheet.setHiddenColumnIndexes(hiddenColumnIndexes);
        spreadsheet.setColW(colWidths);
    }

    static void loadGrouping(Spreadsheet spreadsheet) {
        int i;
        if (spreadsheet.getActiveSheet() instanceof HSSFSheet) {
            return;
        }
        CTWorksheet ctWorksheet = ((XSSFSheet)spreadsheet.getActiveSheet()).getCTWorksheet();
        CTSheetProtection sheetProtection = ctWorksheet.getSheetProtection();
        if (sheetProtection != null) {
            spreadsheet.setLockFormatColumns(sheetProtection.getFormatColumns());
            spreadsheet.setLockFormatRows(sheetProtection.getFormatRows());
        }
        spreadsheet.setColGroupingMax(0);
        spreadsheet.setRowGroupingMax(0);
        if (ctWorksheet.getSheetPr() != null && ctWorksheet.getSheetPr().getOutlinePr() != null) {
            CTOutlinePr outlinePr = ctWorksheet.getSheetPr().getOutlinePr();
            spreadsheet.setColGroupingInversed(!outlinePr.getSummaryRight());
            spreadsheet.setRowGroupingInversed(!outlinePr.getSummaryBelow());
        } else {
            spreadsheet.setColGroupingInversed(false);
            spreadsheet.setRowGroupingInversed(false);
        }
        CTCols colsArray = ctWorksheet.getColsArray(0);
        ArrayList<GroupingData> data = new ArrayList<GroupingData>();
        short lastlevel = 0;
        CTCol prev = null;
        for (CTCol col : colsArray.getColList()) {
            if (prev != null && prev.getMax() + 1L < col.getMin()) {
                lastlevel = 0;
            }
            if (col.getOutlineLevel() > lastlevel) {
                while (lastlevel != col.getOutlineLevel()) {
                    lastlevel = (short)(lastlevel + 1);
                    if (spreadsheet.getColGroupingMax() < lastlevel) {
                        spreadsheet.setColGroupingMax(lastlevel);
                    }
                    if (!data.isEmpty()) {
                        GroupingData previous = (GroupingData)data.get(data.size() - 1);
                        if (previous.collapsed && (long)previous.endIndex >= col.getMin() && previous.level < col.getOutlineLevel()) continue;
                    }
                    boolean columnHidden = GroupingUtil.checkHidden(colsArray, col, lastlevel);
                    long end = GroupingUtil.findEndOfColGroup(colsArray, col, lastlevel) - 1L;
                    long unique = GroupingUtil.findUniqueColIndex(colsArray, col, lastlevel) - 1L;
                    GroupingData d = new GroupingData(col.getMin() - 1L, end, lastlevel, unique, columnHidden);
                    data.add(d);
                }
            } else if (col.getOutlineLevel() < lastlevel) {
                lastlevel = col.getOutlineLevel();
            }
            prev = col;
        }
        HashSet<GroupingData> toRemove = new HashSet<GroupingData>();
        for (int i2 = 0; i2 < data.size(); ++i2) {
            for (int j = i2 + 1; j < data.size(); ++j) {
                GroupingData d1 = (GroupingData)data.get(i2);
                GroupingData d2 = (GroupingData)data.get(j);
                if (spreadsheet.isColGroupingInversed()) {
                    if (d1.startIndex != d2.startIndex) continue;
                    toRemove.add(d2);
                    continue;
                }
                if (d1.endIndex != d2.endIndex) continue;
                toRemove.add(d2);
            }
        }
        data.removeAll(toRemove);
        spreadsheet.setColGroupingData(data);
        data = new ArrayList();
        Stack<GroupingData> rows = new Stack<GroupingData>();
        lastlevel = 0;
        for (i = 0; i <= spreadsheet.getRows(); ++i) {
            short level;
            XSSFRow row = (XSSFRow)spreadsheet.getActiveSheet().getRow(i);
            if (row == null || row.getCTRow().getOutlineLevel() < lastlevel) {
                level = row == null ? (short)0 : row.getCTRow().getOutlineLevel();
                GroupingData g = null;
                while (level != lastlevel) {
                    g = (GroupingData)rows.pop();
                    lastlevel = (short)(lastlevel - 1);
                    boolean collapsed = false;
                    if (spreadsheet.isRowGroupingInversed()) {
                        XSSFRow r = (XSSFRow)spreadsheet.getActiveSheet().getRow(g.startIndex - 1);
                        if (r != null) {
                            collapsed = r.getCTRow().getCollapsed();
                        }
                    } else if (row != null) {
                        collapsed = row.getCTRow().getCollapsed();
                    }
                    g.collapsed = collapsed;
                    if (collapsed) {
                        toRemove = new HashSet();
                        for (GroupingData d : data) {
                            if (d.startIndex < g.startIndex || d.endIndex > g.endIndex || d.level <= g.level) continue;
                            toRemove.add(d);
                        }
                        data.removeAll(toRemove);
                    }
                    data.add(g);
                }
                continue;
            }
            level = row.getCTRow().getOutlineLevel();
            if (level <= lastlevel) continue;
            while (level != lastlevel) {
                GroupingData d;
                lastlevel = (short)(lastlevel + 1);
                int end = (int)GroupingUtil.findEndOfRowGroup(spreadsheet, i, row, lastlevel);
                long uniqueIndex = GroupingUtil.findUniqueRowIndex(spreadsheet, i, end, lastlevel);
                d = new GroupingData((long)i, (long)end, lastlevel, uniqueIndex, false);
                rows.push(d);
                if (spreadsheet.getRowGroupingMax() >= d.level) continue;
                spreadsheet.setRowGroupingMax(d.level);
            }
        }
        toRemove = new HashSet();
        for (i = 0; i < data.size(); ++i) {
            for (int j = i + 1; j < data.size(); ++j) {
                GroupingData d1 = (GroupingData)data.get(i);
                GroupingData d2 = (GroupingData)data.get(j);
                if (spreadsheet.isRowGroupingInversed()) {
                    if (d1.startIndex != d2.startIndex) continue;
                    toRemove.add(d2);
                    continue;
                }
                if (d1.endIndex != d2.endIndex) continue;
                toRemove.add(d2);
            }
        }
        data.removeAll(toRemove);
        spreadsheet.setRowGroupingData(data);
    }

    static void loadSheetOverlays(Spreadsheet spreadsheet) {
        block6: {
            Drawing<?> drawing;
            block5: {
                Sheet sheet = spreadsheet.getActiveSheet();
                drawing = SpreadsheetFactory.getDrawingPatriarch(sheet);
                if (!(drawing instanceof XSSFDrawing)) break block5;
                for (XSSFShape shape : ((XSSFDrawing)drawing).getShapes()) {
                    SheetOverlayWrapper overlayWrapper = null;
                    if (spreadsheet.isChartsEnabled() && shape instanceof XSSFGraphicFrame) {
                        overlayWrapper = SpreadsheetFactory.tryLoadChart(spreadsheet, drawing, (XSSFGraphicFrame)shape);
                    }
                    if (shape instanceof XSSFPicture) {
                        overlayWrapper = SpreadsheetFactory.loadXSSFPicture((XSSFPicture)shape);
                    }
                    if (overlayWrapper == null) continue;
                    if (overlayWrapper.getAnchor() != null) {
                        spreadsheet.addSheetOverlay(overlayWrapper);
                        continue;
                    }
                    LOGGER.debug("IMAGE WITHOUT ANCHOR: " + overlayWrapper);
                }
                break block6;
            }
            if (!(drawing instanceof HSSFPatriarch)) break block6;
            for (HSSFShape shape : ((HSSFPatriarch)drawing).getChildren()) {
                if (!(shape instanceof HSSFPicture)) continue;
                SpreadsheetFactory.loadHSSFPicture(spreadsheet, shape);
            }
        }
    }

    private static void loadHSSFPicture(Spreadsheet spreadsheet, HSSFShape shape) {
        HSSFClientAnchor anchor = (HSSFClientAnchor)shape.getAnchor();
        HSSFPictureData pictureData = ((HSSFPicture)shape).getPictureData();
        if (anchor != null) {
            SheetImageWrapper image = new SheetImageWrapper((ClientAnchor)anchor, pictureData.getMimeType(), pictureData.getData());
            spreadsheet.addSheetOverlay(image);
        } else {
            LOGGER.debug("IMAGE WITHOUT ANCHOR: " + pictureData.toString());
        }
    }

    private static SheetImageWrapper loadXSSFPicture(XSSFPicture shape) {
        XSSFClientAnchor anchor = (XSSFClientAnchor)shape.getAnchor();
        XSSFPictureData pictureData = shape.getPictureData();
        SheetImageWrapper image = new SheetImageWrapper((ClientAnchor)anchor, pictureData.getMimeType(), pictureData.getData());
        return image;
    }

    private static SheetChartWrapper tryLoadChart(Spreadsheet spreadsheet, Drawing<?> drawing, XSSFGraphicFrame frame) {
        try {
            XSSFChart chartXml = SpreadsheetFactory.getChartForFrame((XSSFDrawing)drawing, frame);
            if (chartXml != null) {
                return new SheetChartWrapper(chartXml, spreadsheet);
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return null;
    }

    private static XSSFClientAnchor getAnchorFromParent(XmlObject obj) {
        XSSFClientAnchor anchor = null;
        XmlObject parentXbean = null;
        XmlCursor cursor = obj.newCursor();
        if (cursor.toParent()) {
            parentXbean = cursor.getObject();
        }
        cursor.dispose();
        if (parentXbean != null) {
            if (parentXbean instanceof CTTwoCellAnchor) {
                CTTwoCellAnchor ct = (CTTwoCellAnchor)parentXbean;
                anchor = new XSSFClientAnchor(((Integer)ct.getFrom().getColOff()).intValue(), ((Integer)ct.getFrom().getRowOff()).intValue(), ((Integer)ct.getTo().getColOff()).intValue(), ((Integer)ct.getTo().getRowOff()).intValue(), ct.getFrom().getCol(), ct.getFrom().getRow(), ct.getTo().getCol(), ct.getTo().getRow());
            } else if (parentXbean instanceof CTOneCellAnchor) {
                CTOneCellAnchor ct = (CTOneCellAnchor)parentXbean;
                anchor = new XSSFClientAnchor(((Integer)ct.getFrom().getColOff()).intValue(), ((Integer)ct.getFrom().getRowOff()).intValue(), 0, 0, ct.getFrom().getCol(), ct.getFrom().getRow(), 0, 0);
            }
        }
        return anchor;
    }

    private static XSSFChart getChartForFrame(XSSFDrawing drawing, XSSFGraphicFrame frame) {
        return (XSSFChart)drawing.getRelationById(SpreadsheetFactory.getChartId(frame));
    }

    private static String getChartId(XSSFGraphicFrame frame) {
        return frame.getCTGraphicalObjectFrame().getGraphic().getGraphicData().getDomNode().getChildNodes().item(0).getAttributes().getNamedItem("r:id").getNodeValue();
    }

    private static Drawing<?> getDrawingPatriarch(Sheet sheet) {
        if (sheet instanceof XSSFSheet) {
            return ((XSSFSheet)sheet).getDrawingPatriarch();
        }
        if (sheet instanceof HSSFSheet) {
            return ((HSSFSheet)sheet).getDrawingPatriarch();
        }
        return null;
    }

    static void loadMergedRegions(Spreadsheet spreadsheet) {
        Sheet sheet = spreadsheet.getActiveSheet();
        spreadsheet.setMergedRegions(null);
        spreadsheet.mergedRegionCounter = 0;
        int numMergedRegions = sheet.getNumMergedRegions();
        if (numMergedRegions > 0) {
            ArrayList<MergedRegion> _mergedRegions = new ArrayList<MergedRegion>(numMergedRegions);
            for (int i = 0; i < numMergedRegions; ++i) {
                CellRangeAddress cra = sheet.getMergedRegion(i);
                MergedRegion mergedRegion = new MergedRegion();
                mergedRegion.col1 = cra.getFirstColumn() + 1;
                mergedRegion.col2 = cra.getLastColumn() + 1;
                mergedRegion.row1 = cra.getFirstRow() + 1;
                mergedRegion.row2 = cra.getLastRow() + 1;
                ++spreadsheet.mergedRegionCounter;
                mergedRegion.id = mergedRegion.id;
                _mergedRegions.add(mergedRegion);
            }
            spreadsheet.setMergedRegions(_mergedRegions);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    static void loadFreezePane(Spreadsheet spreadsheet) {
        Sheet sheet = spreadsheet.getActiveSheet();
        PaneInformation paneInformation = sheet.getPaneInformation();
        if (paneInformation != null && paneInformation.isFreezePane()) {
            int topRow = Math.max(0, sheet.getTopRow());
            int leftCol = Math.max(0, sheet.getLeftCol());
            short vSplit = paneInformation.getVerticalSplitPosition();
            short hSplit = paneInformation.getHorizontalSplitPosition();
            if (vSplit > 0) {
                spreadsheet.setHorizontalSplitPosition(vSplit + leftCol);
                if (leftCol > 0) {
                    spreadsheet.setColumnsHidden(IntStream.range(0, leftCol).boxed().collect(Collectors.toMap(Function.identity(), index -> true)));
                }
            } else if (leftCol > 0) {
                // empty if block
            }
            if (hSplit > 0) {
                spreadsheet.setVerticalSplitPosition(hSplit + topRow);
                if (topRow <= 0) return;
                spreadsheet.setRowsHidden(IntStream.range(0, topRow).boxed().collect(Collectors.toMap(Function.identity(), index -> true)));
                return;
            }
            if (topRow <= 0) return;
            return;
        }
        spreadsheet.setVerticalSplitPosition(0);
        spreadsheet.setHorizontalSplitPosition(0);
    }

    private static Sheet createNewSheet(Workbook workbook) {
        int idx = workbook.getNumberOfSheets() + 1;
        String sheetname = "Sheet" + idx;
        while (workbook.getSheet(sheetname) != null) {
            sheetname = "Sheet" + ++idx;
        }
        return workbook.createSheet(sheetname);
    }

    private static void setDefaultRowHeight(Spreadsheet spreadsheet, Sheet sheet) {
        float defaultRowHeightInPoints = sheet.getDefaultRowHeightInPoints();
        if (defaultRowHeightInPoints <= 0.0f) {
            sheet.setDefaultRowHeightInPoints(12.75f);
            spreadsheet.setDefRowH(12.75f);
        } else {
            spreadsheet.setDefRowH(defaultRowHeightInPoints);
        }
    }

    private static void setDefaultColumnWidth(Spreadsheet spreadsheet, Sheet sheet) {
        int charactersToPixels = (int)((double)sheet.getDefaultColumnWidth() / 256.0 * (double)7.0017f);
        if (charactersToPixels > 0) {
            spreadsheet.setDefColW(charactersToPixels);
        } else {
            spreadsheet.setDefColW(SpreadsheetUtil.getDefaultColumnWidthInPx());
            sheet.setDefaultColumnWidth(10);
        }
    }

    public static void logMemoryUsage() {
        if (LOG_MEMORY) {
            Runtime runtime = Runtime.getRuntime();
            runtime.gc();
            long tot = runtime.totalMemory();
            long free = runtime.freeMemory();
            LOGGER.info("Total: " + tot / 1000000L + " Free: " + free / 1000000L + " Usage: " + (tot - free) / 1000000L);
        }
    }
}

