/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.spreadsheet.charts.converter.xssfreader;

import com.vaadin.flow.component.spreadsheet.Spreadsheet;
import com.vaadin.flow.component.spreadsheet.charts.converter.chartdata.PieSeriesData;
import com.vaadin.flow.component.spreadsheet.charts.converter.xssfreader.AbstractSeriesReader;
import org.apache.xmlbeans.XmlObject;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTDoughnutChart;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTPie3DChart;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTPieChart;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTPieSer;

public class PieSeriesReader
extends AbstractSeriesReader<CTPieSer, PieSeriesData> {
    private boolean isDoughnut = false;
    private boolean isExplodedDoughnutHandled = false;

    public PieSeriesReader(CTPieChart ctChart, Spreadsheet spreadsheet, boolean showDataInHiddenCells) {
        super((XmlObject)ctChart, spreadsheet, showDataInHiddenCells);
    }

    public PieSeriesReader(CTDoughnutChart ctChart, Spreadsheet spreadsheet, boolean showDataInHiddenCells) {
        super((XmlObject)ctChart, spreadsheet, showDataInHiddenCells);
        this.isDoughnut = true;
    }

    public PieSeriesReader(CTPie3DChart ctChart, Spreadsheet spreadsheet, boolean showDataInHiddenCells) {
        super((XmlObject)ctChart, spreadsheet, true, showDataInHiddenCells);
    }

    @Override
    protected PieSeriesData createSeriesDataObject(CTPieSer serie) {
        return new PieSeriesData();
    }

    @Override
    protected void fillSeriesData(PieSeriesData seriesData, CTPieSer serie) {
        super.fillSeriesData(seriesData, serie);
        if (!this.isDoughnut || !this.isExplodedDoughnutHandled) {
            seriesData.isExploded = serie.isSetExplosion();
        }
        if (this.isDoughnut) {
            this.isExplodedDoughnutHandled = true;
            seriesData.isDonut = true;
            seriesData.donutHoleSizePercent = (Short)((CTDoughnutChart)this.getChart()).getHoleSize().getVal();
        }
    }
}

