/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.spreadsheet.charts.converter.xssfreader;

import com.vaadin.flow.component.spreadsheet.charts.converter.chartdata.LineSeriesData;
import java.util.HashMap;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTMarker;
import org.openxmlformats.schemas.drawingml.x2006.chart.STMarkerStyle;
import org.openxmlformats.schemas.drawingml.x2006.main.CTShapeProperties;
import org.openxmlformats.schemas.drawingml.x2006.main.STPresetLineDashVal;

public class LineSeriesReaderUtils {
    public static void setDashStyleForData(LineSeriesData seriesData, CTShapeProperties ctShapeProperties) {
        try {
            seriesData.dashStyle = ctShapeProperties.getLn().getNoFill() != null ? "" : LineSeriesReaderUtils.getDashStyleString(ctShapeProperties.getLn().getPrstDash().getVal());
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public static void setLineWidthForData(LineSeriesData seriesData, CTShapeProperties ctShapeProperties) {
        try {
            if (ctShapeProperties.getLn().isSetNoFill()) {
                seriesData.lineWidth = 0;
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public static void setMarkerForData(LineSeriesData seriesData, CTMarker marker) {
        try {
            if (marker.getSymbol().getVal() != STMarkerStyle.NONE) {
                seriesData.markerSymbol = marker.getSymbol().getVal().toString().toUpperCase();
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    private static String getDashStyleString(STPresetLineDashVal.Enum val) {
        HashMap<STPresetLineDashVal.Enum, String> map = new HashMap<STPresetLineDashVal.Enum, String>();
        map.put(STPresetLineDashVal.SOLID, "SOLID");
        map.put(STPresetLineDashVal.DASH, "DASH");
        map.put(STPresetLineDashVal.DASH_DOT, "DASHDOT");
        map.put(STPresetLineDashVal.LG_DASH, "LONGDASH");
        map.put(STPresetLineDashVal.LG_DASH_DOT, "LONGDASHDOT");
        map.put(STPresetLineDashVal.LG_DASH_DOT_DOT, "LONGDASHDOTDOT");
        map.put(STPresetLineDashVal.SYS_DASH, "SHORTDASH");
        map.put(STPresetLineDashVal.SYS_DASH_DOT, "SHORTDASHDOT");
        map.put(STPresetLineDashVal.SYS_DASH_DOT_DOT, "SHORTDASHDOTDOT");
        map.put(STPresetLineDashVal.DOT, "DOT");
        map.put(STPresetLineDashVal.SYS_DOT, "SHORTDOT");
        if (map.containsKey(val)) {
            return (String)map.get(val);
        }
        return "";
    }
}

