/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.spreadsheet.charts.converter.xssfreader;

import com.vaadin.flow.component.spreadsheet.Spreadsheet;
import com.vaadin.flow.component.spreadsheet.charts.converter.chartdata.ChartData;
import com.vaadin.flow.component.spreadsheet.charts.converter.xssfreader.ColorUtils;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.apache.poi.xssf.model.ThemesTable;
import org.apache.poi.xssf.usermodel.XSSFChart;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.apache.xmlbeans.XmlException;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTCatAx;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTScaling;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTTitle;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTValAx;
import org.openxmlformats.schemas.drawingml.x2006.main.CTBaseStyles;
import org.openxmlformats.schemas.drawingml.x2006.main.CTLineProperties;
import org.openxmlformats.schemas.drawingml.x2006.main.CTRegularTextRun;
import org.openxmlformats.schemas.drawingml.x2006.main.CTShapeProperties;
import org.openxmlformats.schemas.drawingml.x2006.main.CTTextCharacterProperties;
import org.openxmlformats.schemas.drawingml.x2006.main.CTTextParagraph;
import org.openxmlformats.schemas.drawingml.x2006.main.ThemeDocument;

class ChartStylesReader {
    private static final double DEFAULT_BORDER_WIDTH = 0.75;
    private static final double FONT_SIZE_FACTOR = 100.0;
    private static final int EXCEL_BORDER_RADIUS = 8;
    private static final double EMU_PER_PT = 12700.0;
    private final Spreadsheet spreadsheet;
    private XSSFChart xssfChart;
    private CTBaseStyles themeElements;
    private Map<String, byte[]> colorMap;
    private static Logger logger = Logger.getLogger(ChartStylesReader.class.getName());

    public ChartStylesReader(Spreadsheet spreadsheet, XSSFChart xssfChart) {
        this.spreadsheet = spreadsheet;
        this.xssfChart = xssfChart;
    }

    public ChartData.BackgroundProperties getBackgroundProperties() {
        CTShapeProperties spPr = this.xssfChart.getCTChartSpace().getSpPr();
        if (spPr == null) {
            return null;
        }
        ChartData.BackgroundProperties backgroundProperties = new ChartData.BackgroundProperties();
        if (spPr.isSetNoFill()) {
            backgroundProperties.color = new ChartData.ColorProperties(new int[]{255, 255, 255}, 0.0);
        } else if (spPr.isSetSolidFill()) {
            backgroundProperties.color = ColorUtils.createColorPropertiesFromFill(spPr.getSolidFill(), this.getColorMap());
        } else if (spPr.isSetGradFill()) {
            backgroundProperties.gradient = ColorUtils.createGradientProperties(spPr.getGradFill(), this.getColorMap());
        } else {
            boolean onlyBorderIsSet;
            boolean bl = onlyBorderIsSet = spPr.getDomNode().getChildNodes().getLength() == 1 && spPr.isSetLn();
            if (!onlyBorderIsSet) {
                logger.warning("Unsupported fill for shape " + spPr);
            }
        }
        return backgroundProperties;
    }

    public ChartData.TitleProperties getTitleProperties() {
        ChartData.TitleProperties result = new ChartData.TitleProperties();
        try {
            CTTitle ctTitle = this.xssfChart.getCTChart().getTitle();
            CTTextCharacterProperties textProp = ctTitle.isSetTx() ? ((CTTextParagraph)ctTitle.getTx().getRich().getPList().get(0)).getPPr().getDefRPr() : ((CTTextParagraph)ctTitle.getTxPr().getPList().get(0)).getPPr().getDefRPr();
            result.textProperties = this.createFontProperties(textProp);
            result.isFloating = ctTitle.getOverlay().getVal();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return result;
    }

    public ChartData.TextProperties getLegendTextProperties() {
        try {
            CTTextCharacterProperties defRPr = this.xssfChart.getCTChart().getLegend().getTxPr().getPArray(0).getPPr().getDefRPr();
            return this.createFontProperties(defRPr);
        }
        catch (NullPointerException e) {
            return null;
        }
    }

    public LinkedHashMap<Long, ChartData.AxisProperties> getYAxisProperties() {
        LinkedHashMap<Long, ChartData.AxisProperties> result = new LinkedHashMap<Long, ChartData.AxisProperties>();
        List valAxList = this.xssfChart.getCTChart().getPlotArea().getValAxList();
        for (CTValAx valAx : valAxList) {
            result.put(valAx.getAxId().getVal(), this.getAxisProperties(valAx));
        }
        return result;
    }

    public ChartData.AxisProperties getXAxisProperties() {
        List catAxList = this.xssfChart.getCTChart().getPlotArea().getCatAxList();
        if (catAxList.size() > 0) {
            return this.getAxisProperties((CTCatAx)catAxList.get(0));
        }
        return null;
    }

    public ChartData.BorderStyle getBorderStyle() {
        try {
            ChartData.BorderStyle result = new ChartData.BorderStyle();
            CTLineProperties borderLineProp = this.xssfChart.getCTChartSpace().getSpPr().getLn();
            if (borderLineProp.isSetNoFill()) {
                return result;
            }
            if (this.xssfChart.getCTChartSpace().getRoundedCorners().getVal()) {
                result.radius = 8;
            }
            result.width = borderLineProp.isSetW() ? (double)borderLineProp.getW() / 12700.0 : 0.75;
            result.color = ColorUtils.createColorPropertiesFromFill(borderLineProp.getSolidFill(), this.getColorMap());
            return result;
        }
        catch (NullPointerException e) {
            return new ChartData.BorderStyle(){
                {
                    this.width = 0.75;
                }
            };
        }
    }

    protected ChartData.AxisProperties getAxisProperties(CTValAx yAx) {
        ChartData.AxisProperties axisProperties = new ChartData.AxisProperties();
        this.readAxisTitle(yAx.getTitle(), axisProperties);
        CTScaling scaling = yAx.getScaling();
        if (scaling != null && scaling.isSetMin()) {
            axisProperties.minVal = scaling.getMin().getVal();
        }
        if (scaling != null && scaling.isSetMax()) {
            axisProperties.maxVal = scaling.getMax().getVal();
        }
        return axisProperties;
    }

    protected ChartData.AxisProperties getAxisProperties(CTCatAx xAx) {
        ChartData.AxisProperties axisProperties = new ChartData.AxisProperties();
        this.readAxisTitle(xAx.getTitle(), axisProperties);
        CTScaling scaling = xAx.getScaling();
        if (scaling != null && scaling.isSetMin()) {
            axisProperties.minVal = scaling.getMin().getVal();
        }
        if (scaling != null && scaling.isSetMax()) {
            axisProperties.maxVal = scaling.getMax().getVal();
        }
        return axisProperties;
    }

    private void readAxisTitle(CTTitle title, ChartData.AxisProperties axisProperties) {
        try {
            CTTextParagraph p = title.getTx().getRich().getPArray(0);
            axisProperties.title = "";
            for (CTRegularTextRun r : p.getRList()) {
                axisProperties.title = axisProperties.title + r.getT();
            }
            axisProperties.textProperties = this.createFontProperties(p.getPPr().getDefRPr());
            if (axisProperties.textProperties == null) {
                axisProperties.textProperties = new ChartData.TextProperties();
                axisProperties.textProperties.bold = true;
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    private CTBaseStyles getThemeElements() {
        if (this.themeElements == null) {
            ThemeDocument themeDocument;
            ThemesTable theme = ((XSSFWorkbook)this.spreadsheet.getWorkbook()).getTheme();
            if (theme == null) {
                return null;
            }
            try {
                themeDocument = (ThemeDocument)ThemeDocument.Factory.parse(theme.getPackagePart().getInputStream());
            }
            catch (XmlException e) {
                return null;
            }
            catch (IOException e) {
                return null;
            }
            this.themeElements = themeDocument.getTheme().getThemeElements();
        }
        return this.themeElements;
    }

    private String getFontFamilyConsideringTheme(CTTextCharacterProperties pPr) {
        try {
            String fontString = pPr.getLatin().getTypeface();
            if (fontString.startsWith("+mj")) {
                return this.getMajorFont();
            }
            if (fontString.startsWith("+mn")) {
                return this.getMinorFont();
            }
            return fontString;
        }
        catch (NullPointerException e) {
            return null;
        }
    }

    private String getMinorFont() {
        if (this.getThemeElements() == null) {
            return "";
        }
        try {
            return this.getThemeElements().getFontScheme().getMinorFont().getLatin().getTypeface();
        }
        catch (NullPointerException e) {
            return "";
        }
    }

    private String getMajorFont() {
        if (this.getThemeElements() == null) {
            return "";
        }
        try {
            return this.getThemeElements().getFontScheme().getMajorFont().getLatin().getTypeface();
        }
        catch (NullPointerException e) {
            return "";
        }
    }

    private ChartData.TextProperties createFontProperties(CTTextCharacterProperties pPr) {
        try {
            ChartData.TextProperties result = new ChartData.TextProperties();
            result.fontFamily = this.getFontFamilyConsideringTheme(pPr);
            result.size = (double)pPr.getSz() / 100.0;
            result.bold = pPr.getB();
            result.italics = pPr.getI();
            result.color = ColorUtils.createColorPropertiesFromFill(pPr.getSolidFill(), this.getColorMap());
            return result;
        }
        catch (NullPointerException e) {
            return null;
        }
    }

    private Map<String, byte[]> getColorMap() {
        if (this.colorMap == null) {
            if (this.getThemeElements() == null) {
                return new HashMap<String, byte[]>();
            }
            this.colorMap = ColorUtils.createColorMap(this.getThemeElements().getClrScheme());
        }
        return this.colorMap;
    }
}

