/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.spreadsheet;

import com.vaadin.flow.component.spreadsheet.ColorConverter;
import com.vaadin.flow.component.spreadsheet.HSSFColorConverter;
import com.vaadin.flow.component.spreadsheet.Spreadsheet;
import com.vaadin.flow.component.spreadsheet.XSSFColorConverter;
import com.vaadin.flow.component.spreadsheet.client.MergedRegion;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.FontFamily;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.apache.poi.xssf.usermodel.extensions.XSSFCellBorder;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTBorder;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTXf;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.STBorderStyle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpreadsheetStyleFactory
implements Serializable {
    private static final Logger LOGGER = LoggerFactory.getLogger(SpreadsheetStyleFactory.class);
    private static final Map<HorizontalAlignment, String> ALIGN = SpreadsheetStyleFactory.mapFor(HorizontalAlignment.LEFT, "left", HorizontalAlignment.CENTER, "center", HorizontalAlignment.RIGHT, "right", HorizontalAlignment.FILL, "left", HorizontalAlignment.JUSTIFY, "left", HorizontalAlignment.CENTER_SELECTION, "center");
    private static final Map<VerticalAlignment, String> VERTICAL_ALIGN = SpreadsheetStyleFactory.mapFor(VerticalAlignment.BOTTOM, "flex-end", VerticalAlignment.CENTER, "center", VerticalAlignment.TOP, "flex-start");
    static final Map<org.apache.poi.ss.usermodel.BorderStyle, BorderStyle> BORDER = SpreadsheetStyleFactory.mapFor(new Object[]{org.apache.poi.ss.usermodel.BorderStyle.DASH_DOT, BorderStyle.DASHED_THIN, org.apache.poi.ss.usermodel.BorderStyle.DASH_DOT_DOT, BorderStyle.DASHED_THIN, org.apache.poi.ss.usermodel.BorderStyle.DASHED, BorderStyle.DASHED_THIN, org.apache.poi.ss.usermodel.BorderStyle.DOTTED, BorderStyle.DOTTED_THIN, org.apache.poi.ss.usermodel.BorderStyle.DOUBLE, BorderStyle.DOUBLE, org.apache.poi.ss.usermodel.BorderStyle.HAIR, BorderStyle.SOLID_THIN, org.apache.poi.ss.usermodel.BorderStyle.MEDIUM, BorderStyle.SOLID_MEDIUM, org.apache.poi.ss.usermodel.BorderStyle.MEDIUM_DASH_DOT, BorderStyle.DASHED_MEDIUM, org.apache.poi.ss.usermodel.BorderStyle.MEDIUM_DASH_DOT_DOT, BorderStyle.DASHED_MEDIUM, org.apache.poi.ss.usermodel.BorderStyle.MEDIUM_DASHED, BorderStyle.DASHED_MEDIUM, org.apache.poi.ss.usermodel.BorderStyle.NONE, BorderStyle.NONE, null, BorderStyle.NONE, org.apache.poi.ss.usermodel.BorderStyle.SLANTED_DASH_DOT, BorderStyle.DASHED_MEDIUM, org.apache.poi.ss.usermodel.BorderStyle.THICK, BorderStyle.SOLID_THICK, org.apache.poi.ss.usermodel.BorderStyle.THIN, BorderStyle.SOLID_THIN});
    private final HashMap<Integer, String> shiftedBorderTopStyles = new HashMap();
    private final HashMap<Integer, String> shiftedBorderLeftStyles = new HashMap();
    private final HashMap<String, String> mergedCellBorders = new HashMap();
    private final HashMap<Integer, HashMap<Integer, HashSet<Integer>>> shiftedBorderTopStylesMap = new HashMap();
    private final HashMap<Integer, HashMap<Integer, HashSet<Integer>>> shiftedBorderLeftStylesMap = new HashMap();
    private ColorConverter colorConverter;
    private Spreadsheet spreadsheet;
    private Font defaultFont;
    private HorizontalAlignment defaultTextAlign;
    private short defaultFontHeightInPoints;
    private String defaultFontFamily;

    public SpreadsheetStyleFactory(Spreadsheet spreadsheet) {
        this.spreadsheet = spreadsheet;
        this.setupColorMap();
    }

    public void reloadWorkbookStyles() {
        Workbook workbook = this.spreadsheet.getWorkbook();
        this.spreadsheet.cellStyleToCSSStyle = this.spreadsheet.getCellStyleToCSSStyle();
        if (this.spreadsheet.cellStyleToCSSStyle == null) {
            this.spreadsheet.cellStyleToCSSStyle = new HashMap(workbook.getNumCellStyles());
        } else {
            this.spreadsheet.cellStyleToCSSStyle.clear();
        }
        this.shiftedBorderLeftStyles.clear();
        this.shiftedBorderTopStyles.clear();
        this.mergedCellBorders.clear();
        CellStyle cellStyle = workbook.getCellStyleAt(0);
        this.defaultTextAlign = cellStyle.getAlignment();
        StringBuilder sb = new StringBuilder();
        this.borderStyles(sb, cellStyle);
        this.defaultFontStyle(cellStyle, sb);
        this.colorConverter.defaultColorStyles(cellStyle, sb);
        this.spreadsheet.cellStyleToCSSStyle.put(Integer.valueOf(cellStyle.getIndex()), sb.toString());
        for (int i = 1; i < workbook.getNumCellStyles(); i = (int)((short)(i + 1))) {
            cellStyle = workbook.getCellStyleAt(i);
            this.addCellStyleCSS(cellStyle);
        }
        this.spreadsheet.setCellStyleToCSSStyle(this.spreadsheet.cellStyleToCSSStyle);
        this.reloadActiveSheetColumnRowStyles();
    }

    public void reloadActiveSheetColumnRowStyles() {
        int i;
        Workbook workbook = this.spreadsheet.getWorkbook();
        HashMap<Integer, Integer> _rowIndexToStyleIndex = this.spreadsheet.getRowIndexToStyleIndex();
        if (_rowIndexToStyleIndex == null) {
            _rowIndexToStyleIndex = new HashMap(workbook.getNumCellStyles());
        } else {
            _rowIndexToStyleIndex.clear();
        }
        HashMap<Integer, Integer> _columnIndexToStyleIndex = this.spreadsheet.getColumnIndexToStyleIndex();
        if (_columnIndexToStyleIndex == null) {
            _columnIndexToStyleIndex = new HashMap(workbook.getNumCellStyles());
        } else {
            _columnIndexToStyleIndex.clear();
        }
        Set<Integer> _lockedColumnIndexes = this.spreadsheet.getLockedColumnIndexes();
        if (_lockedColumnIndexes == null) {
            _lockedColumnIndexes = new HashSet<Integer>();
        } else {
            _lockedColumnIndexes.clear();
        }
        Set<Integer> _lockedRowIndexes = this.spreadsheet.getLockedRowIndexes();
        if (_lockedRowIndexes == null) {
            _lockedRowIndexes = new HashSet<Integer>();
        } else {
            _lockedRowIndexes.clear();
        }
        Sheet activeSheet = this.spreadsheet.getActiveSheet();
        for (i = 0; i < this.spreadsheet.getRows(); ++i) {
            Row row = activeSheet.getRow(i);
            if (row != null && row.getRowStyle() != null) {
                short styleIndex = row.getRowStyle().getIndex();
                _rowIndexToStyleIndex.put(i + 1, Integer.valueOf(styleIndex));
                if (!row.getRowStyle().getLocked()) continue;
                _lockedRowIndexes.add(i + 1);
                continue;
            }
            if (!this.spreadsheet.isActiveSheetProtected()) continue;
            _lockedRowIndexes.add(i + 1);
        }
        for (i = 0; i < this.spreadsheet.getColumns(); ++i) {
            if (activeSheet.getColumnStyle(i) == null) continue;
            short styleIndex = activeSheet.getColumnStyle(i).getIndex();
            _columnIndexToStyleIndex.put(i + 1, Integer.valueOf(styleIndex));
            if (!activeSheet.getColumnStyle(i).getLocked()) continue;
            _lockedColumnIndexes.add(i + 1);
        }
        this.spreadsheet.setLockedRowIndexes(_lockedRowIndexes);
        this.spreadsheet.setLockedColumnIndexes(_lockedColumnIndexes);
        this.spreadsheet.setColumnIndexToStyleIndex(_columnIndexToStyleIndex);
        this.spreadsheet.setRowIndexToStyleIndex(_rowIndexToStyleIndex);
    }

    public CellStyle createHyperlinkCellStyle() {
        Workbook wb = this.spreadsheet.getWorkbook();
        CellStyle hlink_style = wb.createCellStyle();
        Font hlink_font = wb.createFont();
        hlink_font.setFontName(this.defaultFont.getFontName());
        hlink_font.setFontHeightInPoints(this.defaultFontHeightInPoints);
        hlink_font.setUnderline((byte)1);
        hlink_font.setColor(IndexedColors.BLUE.getIndex());
        hlink_style.setFont(hlink_font);
        return hlink_style;
    }

    public void clearCellStyle(int oldRowIndex, int oldColumnIndex) {
        int index;
        String style;
        Map.Entry<Integer, String> entry;
        String cssSelector = ".col" + (oldColumnIndex + 1) + ".row" + (oldRowIndex + 1);
        ArrayList<Object> add = new ArrayList<Object>();
        ArrayList<String> _shiftedCellBorderStyles = this.spreadsheet.getShiftedCellBorderStyles();
        Iterator<String> iterator = _shiftedCellBorderStyles.iterator();
        while (iterator.hasNext()) {
            Object style2 = iterator.next();
            if (((String)style2).startsWith(cssSelector + "{")) {
                iterator.remove();
                continue;
            }
            if (!((String)style2).contains(cssSelector)) continue;
            iterator.remove();
            int n = ((String)style2).indexOf(cssSelector);
            if (n > 0) {
                style2 = ((String)style2).replace(cssSelector + ",", "");
                style2 = ((String)style2).replace("," + cssSelector + "{", "{");
            } else {
                style2 = ((String)style2).replace(cssSelector + ",", "");
                style2 = ((String)style2).replace(cssSelector + "{", "{");
            }
            if (((String)style2).startsWith("{")) continue;
            add.add(style2);
        }
        for (String string : add) {
            _shiftedCellBorderStyles.add(string);
        }
        HashMap<Integer, String> add2 = new HashMap<Integer, String>();
        Iterator<Map.Entry<Integer, String>> iterator2 = this.shiftedBorderLeftStyles.entrySet().iterator();
        while (iterator2.hasNext()) {
            entry = iterator2.next();
            style = entry.getValue();
            if (!style.contains(cssSelector)) continue;
            iterator2.remove();
            index = style.indexOf(cssSelector);
            if (index > 0) {
                style = style.replace(cssSelector + ",", "");
                style = style.replace("," + cssSelector + "{", "{");
            } else {
                style = style.replace(cssSelector + ",", "");
                style = style.replace(cssSelector + "{", "{");
            }
            add2.put(entry.getKey(), style);
        }
        this.shiftedBorderLeftStyles.putAll(add2);
        add2.clear();
        Iterator<Map.Entry<Integer, String>> iterator3 = this.shiftedBorderTopStyles.entrySet().iterator();
        while (iterator3.hasNext()) {
            entry = iterator3.next();
            style = entry.getValue();
            if (!style.contains(cssSelector)) continue;
            iterator3.remove();
            index = style.indexOf(cssSelector);
            if (index > 0) {
                style = style.replace(cssSelector + ",", "");
                style = style.replace("," + cssSelector + "{", "{");
            } else {
                style = style.replace(cssSelector + ",", "");
                style = style.replace(cssSelector + "{", "{");
            }
            add2.put(entry.getKey(), style);
        }
        this.shiftedBorderTopStyles.putAll(add2);
        add2.clear();
        if (this.mergedCellBorders.containsKey(cssSelector)) {
            String rules = this.mergedCellBorders.remove(cssSelector);
            _shiftedCellBorderStyles.remove(this.buildMergedCellBorderCSS(cssSelector, rules));
        }
        this.spreadsheet.setShiftedCellBorderStyles(_shiftedCellBorderStyles);
    }

    public void cellStyleUpdated(Cell cell, boolean updateCustomBorders) {
        Object style;
        String cssSelector = ".col" + (cell.getColumnIndex() + 1) + ".row" + (cell.getRowIndex() + 1);
        Integer key = cell.getCellStyle().getIndex();
        ArrayList<Object> add = new ArrayList<Object>();
        ArrayList<String> _shiftedCellBorderStyles = this.spreadsheet.getShiftedCellBorderStyles();
        Iterator<String> iterator = _shiftedCellBorderStyles.iterator();
        while (iterator.hasNext()) {
            style = iterator.next();
            if (((String)style).startsWith(cssSelector + "{")) {
                iterator.remove();
                continue;
            }
            if (!((String)style).contains(cssSelector)) continue;
            iterator.remove();
            int n = ((String)style).indexOf(cssSelector);
            if (n > 0) {
                style = ((String)style).replace(cssSelector + ",", "");
                style = ((String)style).replace("," + cssSelector + "{", "{");
            } else {
                style = ((String)style).replace(cssSelector + ",", "");
                style = ((String)style).replace(cssSelector + "{", "{");
            }
            if (((String)style).startsWith(",") || ((String)style).startsWith("{")) continue;
            add.add(style);
        }
        for (String string : add) {
            _shiftedCellBorderStyles.add(string);
        }
        if (this.shiftedBorderLeftStyles.containsKey(key)) {
            style = this.shiftedBorderLeftStyles.get(key);
            _shiftedCellBorderStyles.remove(style);
        }
        if (this.shiftedBorderTopStyles.containsKey(key)) {
            style = this.shiftedBorderTopStyles.get(key);
            _shiftedCellBorderStyles.remove(style);
        }
        if (this.mergedCellBorders.containsKey(cssSelector)) {
            style = this.buildMergedCellBorderCSS(cssSelector, this.mergedCellBorders.remove(cssSelector));
            _shiftedCellBorderStyles.remove(style);
        }
        CellStyle cellStyle = cell.getCellStyle();
        this.addCellStyleCSS(cellStyle);
        this.shiftedBorderTopStylesMap.clear();
        this.shiftedBorderLeftStylesMap.clear();
        this.doCellCustomStyling(cell);
        this.updateStyleMap(this.shiftedBorderLeftStylesMap, this.shiftedBorderLeftStyles);
        this.updateStyleMap(this.shiftedBorderTopStylesMap, this.shiftedBorderTopStyles);
        if (updateCustomBorders) {
            if (this.shiftedBorderLeftStyles.containsKey(key)) {
                String string = this.shiftedBorderLeftStyles.get(key);
                _shiftedCellBorderStyles.add(string);
            }
            if (this.shiftedBorderTopStyles.containsKey(key)) {
                String string = this.shiftedBorderTopStyles.get(key);
                _shiftedCellBorderStyles.add(string);
            }
            if (this.mergedCellBorders.containsKey(cssSelector)) {
                _shiftedCellBorderStyles.add(this.buildMergedCellBorderCSS(cssSelector, this.mergedCellBorders.get(cssSelector)));
            }
        }
        this.spreadsheet.setShiftedCellBorderStyles(_shiftedCellBorderStyles);
    }

    public void loadCustomBorderStylesToState() {
        ArrayList<String> _shiftedCellBorderStyles = this.spreadsheet.getShiftedCellBorderStyles();
        if (_shiftedCellBorderStyles != null) {
            _shiftedCellBorderStyles.clear();
        } else {
            _shiftedCellBorderStyles = new ArrayList();
        }
        for (String string : this.shiftedBorderLeftStyles.values()) {
            if (!string.startsWith(".col")) continue;
            _shiftedCellBorderStyles.add(string);
        }
        for (String string : this.shiftedBorderTopStyles.values()) {
            if (!string.startsWith(".col")) continue;
            _shiftedCellBorderStyles.add(string);
        }
        for (Map.Entry entry : this.mergedCellBorders.entrySet()) {
            _shiftedCellBorderStyles.add(this.buildMergedCellBorderCSS((String)entry.getKey(), (String)entry.getValue()));
        }
        this.spreadsheet.setShiftedCellBorderStyles(_shiftedCellBorderStyles);
    }

    public void reloadActiveSheetCellStyles() {
        for (Map.Entry<Integer, String> entry : this.shiftedBorderLeftStyles.entrySet()) {
            String string = entry.getValue();
            if (!string.startsWith(".col")) continue;
            this.shiftedBorderLeftStyles.put(entry.getKey(), string.substring(string.indexOf("{")));
        }
        for (Map.Entry<Integer, String> entry : this.shiftedBorderTopStyles.entrySet()) {
            String string = entry.getValue();
            if (!string.startsWith(".col")) continue;
            this.shiftedBorderTopStyles.put(entry.getKey(), string.substring(string.indexOf("{")));
        }
        this.mergedCellBorders.clear();
        ArrayList<String> _shiftedCellBorderStyles = this.spreadsheet.getShiftedCellBorderStyles();
        if (_shiftedCellBorderStyles == null) {
            _shiftedCellBorderStyles = new ArrayList();
        } else {
            _shiftedCellBorderStyles.clear();
        }
        this.shiftedBorderTopStylesMap.clear();
        this.shiftedBorderLeftStylesMap.clear();
        for (Row row : this.spreadsheet.getActiveSheet()) {
            for (Cell cell : row) {
                this.doCellCustomStyling(cell);
            }
        }
        this.updateStyleMap(this.shiftedBorderLeftStylesMap, this.shiftedBorderLeftStyles);
        this.updateStyleMap(this.shiftedBorderTopStylesMap, this.shiftedBorderTopStyles);
        for (String string : this.shiftedBorderLeftStyles.values()) {
            if (!string.startsWith(".col")) continue;
            _shiftedCellBorderStyles.add(string);
        }
        for (String string : this.shiftedBorderTopStyles.values()) {
            if (!string.startsWith(".col")) continue;
            _shiftedCellBorderStyles.add(string);
        }
        for (Map.Entry entry : this.mergedCellBorders.entrySet()) {
            _shiftedCellBorderStyles.add(this.buildMergedCellBorderCSS((String)entry.getKey(), (String)entry.getValue()));
        }
        this.spreadsheet.getConditionalFormatter().createConditionalFormatterRules();
        this.spreadsheet.setShiftedCellBorderStyles(_shiftedCellBorderStyles);
    }

    private static <K, V> Map<K, V> mapFor(Object ... mapping) {
        HashMap<Object, Object> map = new HashMap<Object, Object>();
        for (int i = 0; i < mapping.length; i += 2) {
            map.put(mapping[i], mapping[i + 1]);
        }
        return map;
    }

    private void addCellStyleCSS(CellStyle cellStyle) {
        if (cellStyle.getIndex() == 0) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        this.fontStyle(sb, cellStyle);
        this.colorConverter.colorStyles(cellStyle, sb);
        this.borderStyles(sb, cellStyle);
        if (cellStyle.getAlignment() != this.defaultTextAlign) {
            this.styleOut(sb, "text-align", cellStyle.getAlignment(), ALIGN);
        }
        this.styleOut(sb, "justify-content", cellStyle.getVerticalAlignment(), VERTICAL_ALIGN);
        if (cellStyle.getWrapText()) {
            sb.append("overflow:hidden;white-space:normal;word-wrap:break-word;");
        }
        if (cellStyle.getIndention() > 0) {
            sb.append("padding-left: " + cellStyle.getIndention() + "em;");
        }
        HashMap<Integer, String> _cellStyleToCSSStyle = this.spreadsheet.getCellStyleToCSSStyle();
        _cellStyleToCSSStyle.put(Integer.valueOf(cellStyle.getIndex()), sb.toString());
        this.spreadsheet.setCellStyleToCSSStyle(_cellStyleToCSSStyle);
    }

    private String buildMergedCellBorderCSS(String selector, String rules) {
        if (selector.endsWith(",")) {
            selector = selector.substring(0, selector.length() - 1);
        }
        if (selector.length() < 1) {
            selector = ".notusedselector";
        }
        StringBuilder sb = new StringBuilder(selector);
        sb.append("{");
        sb.append(rules);
        sb.append("}");
        return sb.toString();
    }

    private void doCellCustomStyling(Cell cell) {
        CellStyle cellStyle = cell.getCellStyle();
        Integer key = cellStyle.getIndex();
        if (key == 0) {
            return;
        }
        int columnIndex = cell.getColumnIndex();
        int rowIndex = cell.getRowIndex();
        if (this.spreadsheet.isColumnHidden(columnIndex) || this.spreadsheet.isRowHidden(rowIndex)) {
            return;
        }
        MergedRegion region = this.spreadsheet.mergedRegionContainer.getMergedRegion(columnIndex + 1, rowIndex + 1);
        if (region != null) {
            String borderRight = this.getBorderRightStyle(cellStyle);
            String borderBottom = this.getBorderBottomStyle(cellStyle);
            if (borderRight != null && !borderRight.isEmpty() || borderBottom != null && !borderBottom.isEmpty()) {
                String newBorders;
                StringBuilder sb = new StringBuilder(".col");
                sb.append(region.col1);
                sb.append(".row");
                sb.append(region.row1);
                String cssKey = sb.toString();
                String currentBorders = this.mergedCellBorders.get(cssKey);
                StringBuilder style = currentBorders != null && !currentBorders.isEmpty() ? new StringBuilder(currentBorders) : new StringBuilder();
                if (!(borderRight == null || borderRight.isEmpty() || currentBorders != null && currentBorders.contains("border-right"))) {
                    style.append(borderRight);
                }
                if (!(borderBottom == null || borderBottom.isEmpty() || currentBorders != null && currentBorders.contains("border-bottom"))) {
                    style.append(borderBottom);
                }
                if (!(newBorders = style.toString()).isEmpty()) {
                    this.mergedCellBorders.put(cssKey, newBorders);
                }
            }
        }
        if (region == null || region.col1 == columnIndex + 1 || region.col2 == columnIndex + 1 || region.row1 == rowIndex + 1 || region.row2 == rowIndex + 1) {
            MergedRegion previousRegion;
            if (this.shiftedBorderLeftStyles.containsKey(key) && columnIndex > 0) {
                int row;
                int col;
                int upperVisibleColumnIndex = columnIndex;
                while (this.spreadsheet.isColumnHidden(upperVisibleColumnIndex - 1)) {
                    --upperVisibleColumnIndex;
                }
                previousRegion = this.spreadsheet.mergedRegionContainer.getMergedRegion(upperVisibleColumnIndex, rowIndex + 1);
                if (previousRegion != null) {
                    col = previousRegion.col1;
                    row = previousRegion.row1;
                } else {
                    col = upperVisibleColumnIndex;
                    row = rowIndex + 1;
                }
                this.insertMapEntryIfNeeded(this.shiftedBorderLeftStylesMap, key, row, col);
            }
            if (this.shiftedBorderTopStyles.containsKey(key) && rowIndex > 0) {
                int row;
                int col;
                int prevVisibleRowIndex = rowIndex;
                while (this.spreadsheet.isRowHidden(prevVisibleRowIndex - 1)) {
                    --prevVisibleRowIndex;
                }
                previousRegion = this.spreadsheet.mergedRegionContainer.getMergedRegion(columnIndex + 1, prevVisibleRowIndex);
                if (previousRegion != null) {
                    col = previousRegion.col1;
                    row = previousRegion.row1;
                } else {
                    col = columnIndex + 1;
                    row = prevVisibleRowIndex;
                }
                this.insertMapEntryIfNeeded(this.shiftedBorderTopStylesMap, key, row, col);
            }
        }
    }

    private void insertMapEntryIfNeeded(HashMap<Integer, HashMap<Integer, HashSet<Integer>>> shiftedBorderStylesMap, int key, int row, int col) {
        HashSet<Integer> rows;
        HashMap<Integer, HashSet<Integer>> colToRowMap = shiftedBorderStylesMap.get(key);
        if (colToRowMap == null) {
            colToRowMap = new HashMap();
            shiftedBorderStylesMap.put(key, colToRowMap);
        }
        if ((rows = colToRowMap.get(col)) == null) {
            rows = new HashSet();
            colToRowMap.put(col, rows);
        }
        rows.add(row);
    }

    private void updateStyleMap(HashMap<Integer, HashMap<Integer, HashSet<Integer>>> shiftedBorderStylesMap, HashMap<Integer, String> shiftedBorderStyles) {
        for (Map.Entry<Integer, HashMap<Integer, HashSet<Integer>>> currentEntry : shiftedBorderStylesMap.entrySet()) {
            Integer key = currentEntry.getKey();
            HashMap<Integer, HashSet<Integer>> colToRows = currentEntry.getValue();
            if (colToRows == null) continue;
            String value = shiftedBorderStyles.get(key);
            StringBuilder sb = new StringBuilder();
            boolean somethingAdded = false;
            for (Map.Entry<Integer, HashSet<Integer>> colToRowEntry : colToRows.entrySet()) {
                Integer col = colToRowEntry.getKey();
                for (Integer row : colToRowEntry.getValue()) {
                    if (somethingAdded) {
                        sb.append(",");
                    } else {
                        somethingAdded = true;
                    }
                    sb.append(".col").append(col);
                    sb.append(".row").append(row);
                }
            }
            sb.append(value);
            shiftedBorderStyles.put(key, sb.toString());
        }
    }

    private void defaultFontStyle(CellStyle cellStyle, StringBuilder sb) {
        if (cellStyle.getIndex() == 0) {
            this.defaultFont = this.spreadsheet.getWorkbook().getFontAt(cellStyle.getFontIndexAsInt());
            this.defaultFontFamily = this.styleFontFamily(this.defaultFont);
            sb.append(this.defaultFontFamily);
            if (this.defaultFont.getBold()) {
                sb.append("font-weight:bold;");
            }
            if (this.defaultFont.getItalic()) {
                sb.append("font-style:italic;");
            }
            this.defaultFontHeightInPoints = this.defaultFont.getFontHeightInPoints();
            sb.append("font-size: var(--default-font-size);");
            sb.append("--default-font-size:");
            sb.append(this.defaultFontHeightInPoints);
            sb.append("pt;");
            if (this.defaultFont.getUnderline() != 0) {
                sb.append("text-decoration:underline;");
            } else if (this.defaultFont.getStrikeout()) {
                sb.append("text-decoration:overline;");
            }
        }
    }

    private void fontStyle(StringBuilder sb, CellStyle cellStyle) {
        try {
            short fontheight;
            Font font = this.spreadsheet.getWorkbook().getFontAt(cellStyle.getFontIndexAsInt());
            if (font.getIndexAsInt() == this.defaultFont.getIndexAsInt()) {
                return;
            }
            String fontFamily = this.styleFontFamily(font);
            if (!fontFamily.equals(this.defaultFontFamily)) {
                sb.append(fontFamily);
            }
            if (font.getBold()) {
                sb.append("font-weight:bold;");
            }
            if (font.getItalic()) {
                sb.append("font-style:italic;");
            }
            if ((fontheight = font.getFontHeightInPoints()) != this.defaultFontHeightInPoints) {
                sb.append("font-size:");
                sb.append(fontheight);
                sb.append("pt;");
            }
            if (font.getUnderline() != 0) {
                sb.append("text-decoration:underline;");
            } else if (font.getStrikeout()) {
                sb.append("text-decoration:overline;");
            }
        }
        catch (IndexOutOfBoundsException ioobe) {
            LOGGER.warn("Font missing, " + cellStyle.getFontIndexAsInt() + " / " + cellStyle.getClass() + ", " + ioobe.getMessage(), (Throwable)ioobe);
        }
    }

    private String styleFontFamily(Font font) {
        StringBuilder sb = new StringBuilder();
        sb.append("font-family: var(--default-font-family);");
        sb.append("--default-font-family:");
        String fontName = font.getFontName();
        if (fontName.contains(" ")) {
            sb.append("\"");
            sb.append(fontName);
            sb.append("\",");
        } else {
            sb.append(fontName);
            sb.append(",");
        }
        if (font instanceof XSSFFont) {
            FontFamily family = FontFamily.valueOf((int)((XSSFFont)font).getFamily());
            switch (family) {
                case ROMAN: {
                    sb.append("roman,");
                    break;
                }
                case SWISS: {
                    sb.append("swiss,");
                    break;
                }
                case MODERN: {
                    sb.append("modern,");
                    break;
                }
                case SCRIPT: {
                    sb.append("script,");
                    break;
                }
                case DECORATIVE: {
                    sb.append("decorative,");
                    break;
                }
                case NOT_APPLICABLE: {
                    break;
                }
            }
        }
        sb.append("Helvetica,arial;");
        return sb.toString();
    }

    private String getBorderRightStyle(CellStyle cellStyle) {
        StringBuilder sb = new StringBuilder();
        BorderStyle borderRight = BORDER.get(cellStyle.getBorderRight());
        if (cellStyle instanceof XSSFCellStyle && !((XSSFCellStyle)cellStyle).getCoreXf().getApplyBorder()) {
            CTXf _cellXf = ((XSSFCellStyle)cellStyle).getCoreXf();
            int idx = (int)_cellXf.getBorderId();
            CTBorder ct = ((XSSFWorkbook)this.spreadsheet.getWorkbook()).getStylesSource().getBorderAt(idx).getCTBorder();
            if (borderRight == BorderStyle.NONE) {
                STBorderStyle.Enum ptrn;
                STBorderStyle.Enum enum_ = ptrn = ct.isSetRight() ? ct.getRight().getStyle() : null;
                if (ptrn != null) {
                    Short key = (short)(ptrn.intValue() - 1);
                    borderRight = BORDER.get(org.apache.poi.ss.usermodel.BorderStyle.valueOf((short)key));
                }
            }
        }
        if (borderRight != BorderStyle.NONE) {
            sb.append("border-right:");
            sb.append(borderRight.getBorderAttributeValue());
            sb.append(this.colorConverter.getBorderColorCSS(XSSFCellBorder.BorderSide.RIGHT, "border-right-color", cellStyle));
        }
        return sb.toString();
    }

    private String getBorderBottomStyle(CellStyle cellStyle) {
        StringBuilder sb = new StringBuilder();
        BorderStyle borderBottom = BORDER.get(cellStyle.getBorderBottom());
        if (cellStyle instanceof XSSFCellStyle && !((XSSFCellStyle)cellStyle).getCoreXf().getApplyBorder()) {
            CTXf _cellXf = ((XSSFCellStyle)cellStyle).getCoreXf();
            int idx = (int)_cellXf.getBorderId();
            CTBorder ct = ((XSSFWorkbook)this.spreadsheet.getWorkbook()).getStylesSource().getBorderAt(idx).getCTBorder();
            if (borderBottom == BorderStyle.NONE) {
                STBorderStyle.Enum ptrn;
                STBorderStyle.Enum enum_ = ptrn = ct.isSetBottom() ? ct.getBottom().getStyle() : null;
                if (ptrn != null) {
                    Short key = (short)(ptrn.intValue() - 1);
                    borderBottom = BORDER.get(org.apache.poi.ss.usermodel.BorderStyle.valueOf((short)key));
                }
            }
        }
        if (borderBottom != BorderStyle.NONE) {
            sb.append("border-bottom:");
            sb.append(borderBottom.getBorderAttributeValue());
            sb.append(this.colorConverter.getBorderColorCSS(XSSFCellBorder.BorderSide.BOTTOM, "border-bottom-color", cellStyle));
        }
        return sb.toString();
    }

    private void borderStyles(StringBuilder sb, CellStyle cellStyle) {
        BorderStyle borderLeft = BORDER.get(cellStyle.getBorderLeft());
        BorderStyle borderRight = BORDER.get(cellStyle.getBorderRight());
        BorderStyle borderTop = BORDER.get(cellStyle.getBorderTop());
        BorderStyle borderBottom = BORDER.get(cellStyle.getBorderBottom());
        if (cellStyle instanceof XSSFCellStyle && !((XSSFCellStyle)cellStyle).getCoreXf().getApplyBorder()) {
            Short key;
            STBorderStyle.Enum ptrn;
            CTXf _cellXf = ((XSSFCellStyle)cellStyle).getCoreXf();
            int idx = (int)_cellXf.getBorderId();
            CTBorder ct = ((XSSFWorkbook)this.spreadsheet.getWorkbook()).getStylesSource().getBorderAt(idx).getCTBorder();
            if (borderLeft == BorderStyle.NONE) {
                STBorderStyle.Enum enum_ = ptrn = ct.isSetLeft() ? ct.getLeft().getStyle() : null;
                if (ptrn != null) {
                    key = (short)(ptrn.intValue() - 1);
                    borderLeft = BORDER.get(org.apache.poi.ss.usermodel.BorderStyle.valueOf((short)key));
                }
            }
            if (borderRight == BorderStyle.NONE) {
                STBorderStyle.Enum enum_ = ptrn = ct.isSetRight() ? ct.getRight().getStyle() : null;
                if (ptrn != null) {
                    key = (short)(ptrn.intValue() - 1);
                    borderRight = BORDER.get(org.apache.poi.ss.usermodel.BorderStyle.valueOf((short)key));
                }
            }
            if (borderBottom == BorderStyle.NONE) {
                STBorderStyle.Enum enum_ = ptrn = ct.isSetBottom() ? ct.getBottom().getStyle() : null;
                if (ptrn != null) {
                    key = (short)(ptrn.intValue() - 1);
                    borderBottom = BORDER.get(org.apache.poi.ss.usermodel.BorderStyle.valueOf((short)key));
                }
            }
            if (borderTop == BorderStyle.NONE) {
                STBorderStyle.Enum enum_ = ptrn = ct.isSetTop() ? ct.getTop().getStyle() : null;
                if (ptrn != null) {
                    key = (short)(ptrn.intValue() - 1);
                    borderTop = BORDER.get(org.apache.poi.ss.usermodel.BorderStyle.valueOf((short)key));
                }
            }
        }
        if (borderRight != BorderStyle.NONE) {
            sb.append("border-right:");
            sb.append(borderRight.getBorderAttributeValue());
            sb.append(this.colorConverter.getBorderColorCSS(XSSFCellBorder.BorderSide.RIGHT, "border-right-color", cellStyle));
        }
        if (borderBottom != BorderStyle.NONE) {
            sb.append("border-bottom:");
            sb.append(borderBottom.getBorderAttributeValue());
            sb.append(this.colorConverter.getBorderColorCSS(XSSFCellBorder.BorderSide.BOTTOM, "border-bottom-color", cellStyle));
        }
        if (borderTop != BorderStyle.NONE || borderLeft != BorderStyle.NONE) {
            StringBuilder sb2;
            if (borderTop != BorderStyle.NONE) {
                sb2 = new StringBuilder("{border-bottom:");
                sb2.append(borderTop.getBorderAttributeValue());
                sb2.append(this.colorConverter.getBorderColorCSS(XSSFCellBorder.BorderSide.TOP, "border-bottom-color", cellStyle));
                sb2.append("}");
                this.shiftedBorderTopStyles.put(Integer.valueOf(cellStyle.getIndex()), sb2.toString());
            }
            if (borderLeft != BorderStyle.NONE) {
                sb2 = new StringBuilder("{border-right:");
                sb2.append(borderLeft.getBorderAttributeValue());
                sb2.append(this.colorConverter.getBorderColorCSS(XSSFCellBorder.BorderSide.LEFT, "border-right-color", cellStyle));
                sb2.append("}");
                this.shiftedBorderLeftStyles.put(Integer.valueOf(cellStyle.getIndex()), sb2.toString());
            }
        }
    }

    private <K> void styleOut(StringBuilder sb, String attr, K key, Map<K, String> mapping) {
        String value = mapping.get(key);
        if (value != null) {
            sb.append(attr);
            sb.append(":");
            sb.append(value);
            sb.append(";");
        }
    }

    private void setupColorMap() {
        Workbook workbook = this.spreadsheet.getWorkbook();
        this.colorConverter = workbook instanceof HSSFWorkbook ? new HSSFColorConverter((HSSFWorkbook)workbook) : new XSSFColorConverter((XSSFWorkbook)workbook);
    }

    public static enum BorderStyle {
        SOLID_THIN("solid", 1, 1),
        DOTTED_THIN("dotted", 1, 1),
        DASHED_THIN("dashed", 1, 1),
        SOLID_MEDIUM("solid", 2, 2),
        DASHED_MEDIUM("dashed", 2, 2),
        SOLID_THICK("solid", 3, 4),
        DOUBLE("double", 3, 4),
        NONE("none", 0, 0);

        private final int size;
        private final String borderStyle;

        private BorderStyle(String borderStyle, int size, int adjustment) {
            this.borderStyle = borderStyle;
            this.size = size;
        }

        public String getValue() {
            return this.borderStyle;
        }

        public int getSize() {
            return this.size;
        }

        public String getBorderAttributeValue() {
            return this.borderStyle + " " + this.size + "pt;";
        }
    }
}

