/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.spreadsheet.client;

import com.fasterxml.jackson.annotation.JsonInclude;
import java.io.Serializable;

public class CellData
implements Serializable {
    public int row;
    public int col;
    @JsonInclude
    public String value;
    public String formulaValue;
    public String originalValue;
    public String cellStyle = "cs0";
    public String textColor;
    public boolean locked = false;
    public boolean needsMeasure;
    public boolean isPercentage;

    public int hashCode() {
        int factor = this.row + (this.col + 1) / 2;
        return 31 * (this.col + factor * factor);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CellData other = (CellData)obj;
        if (this.col != other.col) {
            return false;
        }
        return this.row == other.row;
    }

    public String toString() {
        return "r" + this.row + "c" + this.col + this.cellStyle + "tc" + this.textColor + "|" + this.value;
    }
}

