/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.spreadsheet.command;

import com.vaadin.flow.component.spreadsheet.Spreadsheet;
import com.vaadin.flow.component.spreadsheet.SpreadsheetUtil;
import com.vaadin.flow.component.spreadsheet.command.CellValueCommand;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.ss.util.CellRangeUtil;
import org.apache.poi.ss.util.CellReference;

public class CellShiftValuesCommand
extends CellValueCommand {
    private boolean undone;
    private boolean decrease;

    public CellShiftValuesCommand(Spreadsheet spreadsheet, boolean decrease) {
        super(spreadsheet);
        this.decrease = decrease;
    }

    @Override
    public void execute() {
        super.execute();
        this.undone = !this.undone;
    }

    @Override
    public CellReference getSelectedCellReference() {
        CellReference selectedCellReference = super.getSelectedCellReference();
        CellRangeAddress paintedCellRange = this.getPaintedCellRange();
        if (paintedCellRange == null || SpreadsheetUtil.isCellInRange(selectedCellReference, paintedCellRange)) {
            return selectedCellReference;
        }
        return new CellReference(paintedCellRange.getFirstRow(), paintedCellRange.getFirstColumn());
    }

    @Override
    public CellRangeAddress getPaintedCellRange() {
        CellRangeAddress paintedCellRange = super.getPaintedCellRange();
        if (this.undone || paintedCellRange == null) {
            return paintedCellRange;
        }
        CellValueCommand.CellRangeValue crv = (CellValueCommand.CellRangeValue)this.values.get(0);
        if (this.decrease) {
            int col2 = crv.col1 == paintedCellRange.getFirstColumn() ? crv.col2 : crv.col1 - 1;
            int row2 = crv.row1 == paintedCellRange.getFirstRow() ? crv.row2 : crv.row1 - 1;
            return new CellRangeAddress(paintedCellRange.getFirstRow(), row2, paintedCellRange.getFirstColumn(), col2);
        }
        return CellRangeUtil.mergeCellRanges((CellRangeAddress[])new CellRangeAddress[]{paintedCellRange, new CellRangeAddress(crv.row1, crv.row2, crv.col1, crv.col2)})[0];
    }
}

