/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.spreadsheet;

import com.vaadin.flow.component.spreadsheet.Spreadsheet;
import java.io.Serializable;
import java.util.WeakHashMap;
import org.apache.poi.ss.usermodel.Sheet;

class SheetState
implements Serializable {
    private final WeakHashMap<Sheet, String> selectedCells = new WeakHashMap();

    SheetState(final Spreadsheet spreadSheet) {
        spreadSheet.addSelectionChangeListener(new Spreadsheet.SelectionChangeListener(){

            @Override
            public void onSelectionChange(Spreadsheet.SelectionChangeEvent event) {
                String lastSelectionState = SheetState.this.extractStrCellRef(event);
                SheetState.this.selectedCells.put(spreadSheet.getActiveSheet(), lastSelectionState);
            }
        });
    }

    private String extractStrCellRef(Spreadsheet.SelectionChangeEvent event) {
        String lastSelectedRange;
        Object selectedCellRef = event.getSelectedCellReference().getCellRefParts()[2] + event.getSelectedCellReference().getCellRefParts()[1];
        if (!event.getCellRangeAddresses().isEmpty() && (((String)selectedCellRef).equals((lastSelectedRange = event.getCellRangeAddresses().get(event.getCellRangeAddresses().size() - 1).formatAsString()).substring(0, lastSelectedRange.indexOf(58))) || ((String)selectedCellRef).equals(lastSelectedRange.substring(lastSelectedRange.indexOf(58) + 1)))) {
            selectedCellRef = lastSelectedRange;
        }
        return selectedCellRef;
    }

    public String getSelectedCellsOnSheet(Sheet sheetIdx) {
        return this.selectedCells.get(sheetIdx);
    }

    public void clear() {
        this.selectedCells.clear();
    }
}

