/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.spreadsheet;

import com.vaadin.flow.component.AttachEvent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEvent;
import com.vaadin.flow.component.DomEvent;
import com.vaadin.flow.component.EventData;
import com.vaadin.flow.component.HasSize;
import com.vaadin.flow.component.HasStyle;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.dependency.JsModule;
import com.vaadin.flow.component.spreadsheet.CellSelectionManager;
import com.vaadin.flow.component.spreadsheet.CellSelectionShifter;
import com.vaadin.flow.component.spreadsheet.CellValueManager;
import com.vaadin.flow.component.spreadsheet.ConditionalFormatter;
import com.vaadin.flow.component.spreadsheet.ContextMenuManager;
import com.vaadin.flow.component.spreadsheet.DefaultHyperlinkCellClickHandler;
import com.vaadin.flow.component.spreadsheet.GroupingUtil;
import com.vaadin.flow.component.spreadsheet.PopupButton;
import com.vaadin.flow.component.spreadsheet.Serializer;
import com.vaadin.flow.component.spreadsheet.SheetOverlayWrapper;
import com.vaadin.flow.component.spreadsheet.SheetState;
import com.vaadin.flow.component.spreadsheet.SpreadsheetComponentFactory;
import com.vaadin.flow.component.spreadsheet.SpreadsheetEventListener;
import com.vaadin.flow.component.spreadsheet.SpreadsheetFactory;
import com.vaadin.flow.component.spreadsheet.SpreadsheetFilterTable;
import com.vaadin.flow.component.spreadsheet.SpreadsheetHandlerImpl;
import com.vaadin.flow.component.spreadsheet.SpreadsheetHistoryManager;
import com.vaadin.flow.component.spreadsheet.SpreadsheetStyleFactory;
import com.vaadin.flow.component.spreadsheet.SpreadsheetTable;
import com.vaadin.flow.component.spreadsheet.SpreadsheetUtil;
import com.vaadin.flow.component.spreadsheet.action.SpreadsheetDefaultActionHandler;
import com.vaadin.flow.component.spreadsheet.client.CellData;
import com.vaadin.flow.component.spreadsheet.client.MergedRegion;
import com.vaadin.flow.component.spreadsheet.client.MergedRegionUtil;
import com.vaadin.flow.component.spreadsheet.client.OverlayInfo;
import com.vaadin.flow.component.spreadsheet.client.SpreadsheetActionDetails;
import com.vaadin.flow.component.spreadsheet.command.SizeChangeCommand;
import com.vaadin.flow.component.spreadsheet.framework.Action;
import com.vaadin.flow.component.spreadsheet.framework.ReflectTools;
import com.vaadin.flow.component.spreadsheet.rpc.SpreadsheetClientRpc;
import com.vaadin.flow.component.spreadsheet.shared.GroupingData;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.function.SerializableConsumer;
import com.vaadin.flow.server.AbstractStreamResource;
import com.vaadin.flow.server.StreamResource;
import com.vaadin.flow.server.VaadinService;
import com.vaadin.flow.shared.Registration;
import com.vaadin.pro.licensechecker.LicenseChecker;
import elemental.json.JsonValue;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;
import java.util.WeakHashMap;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.formula.BaseFormulaEvaluator;
import org.apache.poi.ss.formula.ConditionalFormattingEvaluator;
import org.apache.poi.ss.formula.WorkbookEvaluatorProvider;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.ClientAnchor;
import org.apache.poi.ss.usermodel.Comment;
import org.apache.poi.ss.usermodel.DataFormatter;
import org.apache.poi.ss.usermodel.FormulaEvaluator;
import org.apache.poi.ss.usermodel.Hyperlink;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.SheetVisibility;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellAddress;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.ss.util.CellRangeUtil;
import org.apache.poi.ss.util.CellReference;
import org.apache.poi.ss.util.PaneInformation;
import org.apache.poi.xssf.usermodel.XSSFClientAnchor;
import org.apache.poi.xssf.usermodel.XSSFHyperlink;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.apache.xmlbeans.impl.values.XmlValueDisconnectedException;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTCol;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTCols;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTWorksheet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Tag(value="vaadin-spreadsheet")
@JsModule(value="./vaadin-spreadsheet/vaadin-spreadsheet.js")
public class Spreadsheet
extends Component
implements HasSize,
HasStyle,
Action.Container {
    private static final Logger LOGGER = LoggerFactory.getLogger(Spreadsheet.class);
    private Map<String, String> resources = new HashMap<String, String>();
    private int rowBufferSize = 200;
    private int columnBufferSize = 200;
    private int rows;
    private int cols;
    private List<GroupingData> colGroupingData;
    private int colGroupingMax;
    private int rowGroupingMax;
    private boolean colGroupingInversed;
    private boolean rowGroupingInversed;
    private float defRowH;
    private int defColW;
    private float[] rowH;
    private int[] colW;
    private boolean reload;
    private int sheetIndex = 1;
    private String[] sheetNames = null;
    protected HashMap<Integer, String> cellStyleToCSSStyle = null;
    private HashMap<Integer, Integer> rowIndexToStyleIndex = null;
    private HashMap<Integer, Integer> columnIndexToStyleIndex = null;
    private Set<Integer> lockedColumnIndexes = null;
    private Set<Integer> lockedRowIndexes = null;
    private ArrayList<String> shiftedCellBorderStyles = null;
    private HashMap<Integer, String> conditionalFormattingStyles = null;
    private ArrayList<Integer> hiddenColumnIndexes = null;
    private ArrayList<Integer> hiddenRowIndexes = null;
    private int[] verticalScrollPositions;
    private int[] horizontalScrollPositions;
    private boolean sheetProtected;
    private HashMap<String, String> cellKeysToEditorIdMap;
    private HashMap<String, String> componentIDtoCellKeysMap;
    private HashMap<String, String> hyperlinksTooltips;
    private HashMap<String, String> cellComments;
    private HashMap<String, String> cellCommentAuthors;
    private ArrayList<String> visibleCellComments;
    private Set<String> invalidFormulaCells;
    private HashMap<String, OverlayInfo> overlays;
    private ArrayList<MergedRegion> mergedRegions;
    private int verticalSplitPosition = 0;
    private int horizontalSplitPosition = 0;
    private String infoLabelValue;
    private boolean workbookChangeToggle;
    private Locale locale;
    public static final String HIDE_FUNCTION_BAR_STYLE = "hidefunctionbar";
    public static final String HIDE_TABSHEET_STYLE = "hidetabsheet";
    private FormulaEvaluator formulaEvaluator;
    private ConditionalFormattingEvaluator conditionalFormattingEvaluator;
    private static final int FILTER_BUTTON_PIXEL_WIDTH = 14;
    private static final int FILTER_BUTTON_PIXEL_PADDING = 2;
    private Map<CellReference, Integer> autofittedColumnWidths = new WeakHashMap<CellReference, Integer>();
    private SpreadsheetClientRpc clientRpc = new SpreadsheetClientRpc(){

        @Override
        public void updateBottomRightCellValues(ArrayList<CellData> cellData) {
            Spreadsheet.this.getElement().callJsFunction("updateBottomRightCellValues", new Serializable[]{Serializer.serialize(cellData)});
        }

        @Override
        public void updateTopLeftCellValues(ArrayList<CellData> cellData) {
            Spreadsheet.this.getElement().callJsFunction("updateTopLeftCellValues", new Serializable[]{Serializer.serialize(cellData)});
        }

        @Override
        public void updateTopRightCellValues(ArrayList<CellData> cellData) {
            Spreadsheet.this.getElement().callJsFunction("updateTopRightCellValues", new Serializable[]{Serializer.serialize(cellData)});
        }

        @Override
        public void updateBottomLeftCellValues(ArrayList<CellData> cellData) {
            Spreadsheet.this.getElement().callJsFunction("updateBottomLeftCellValues", new Serializable[]{Serializer.serialize(cellData)});
        }

        @Override
        public void updateFormulaBar(String possibleName, int col, int row) {
            Spreadsheet.this.getElement().callJsFunction("updateFormulaBar", new Serializable[]{possibleName, Integer.valueOf(col), Integer.valueOf(row)});
        }

        @Override
        public void invalidCellAddress() {
            Spreadsheet.this.getElement().callJsFunction("invalidCellAddress", new Serializable[0]);
        }

        @Override
        public void showSelectedCell(String name, int col, int row, String cellValue, boolean function, boolean locked, boolean initialSelection) {
            Spreadsheet.this.selectionManager.onCellSelected(row, col, initialSelection);
            Spreadsheet.this.getElement().callJsFunction("showSelectedCell", new Serializable[]{name, Integer.valueOf(col), Integer.valueOf(row), cellValue, Boolean.valueOf(function), Boolean.valueOf(locked), Boolean.valueOf(initialSelection)});
        }

        @Override
        public void showActions(ArrayList<SpreadsheetActionDetails> actionDetails) {
            Spreadsheet.this.getElement().callJsFunction("showActions", new Serializable[]{Serializer.serialize(actionDetails)});
        }

        @Override
        public void setSelectedCellAndRange(String name, int col, int row, int c1, int c2, int r1, int r2, boolean scroll) {
            Spreadsheet.this.getElement().callJsFunction("setSelectedCellAndRange", new Serializable[]{name, Integer.valueOf(col), Integer.valueOf(row), Integer.valueOf(c1), Integer.valueOf(c2), Integer.valueOf(r1), Integer.valueOf(r2), Boolean.valueOf(scroll)});
        }

        @Override
        public void cellsUpdated(ArrayList<CellData> cellData) {
            Spreadsheet.this.getElement().callJsFunction("cellsUpdated", new Serializable[]{Serializer.serialize(cellData)});
        }

        @Override
        public void refreshCellStyles() {
            Spreadsheet.this.getElement().callJsFunction("refreshCellStyles", new Serializable[0]);
        }

        @Override
        public void editCellComment(int col, int row) {
            Spreadsheet.this.getElement().callJsFunction("editCellComment", new Serializable[]{Integer.valueOf(col), Integer.valueOf(row)});
        }
    };
    private SpreadsheetStyleFactory styler;
    private HyperlinkCellClickHandler hyperlinkCellClickHandler;
    private SpreadsheetComponentFactory customComponentFactory;
    private final CellSelectionManager selectionManager = new CellSelectionManager(this);
    private final CellSelectionShifter cellShifter = new CellSelectionShifter(this);
    private final ContextMenuManager contextMenuManager = new ContextMenuManager(this);
    private final SpreadsheetHistoryManager historyManager = new SpreadsheetHistoryManager(this);
    private ConditionalFormatter conditionalFormatter;
    private CellValueManager valueManager;
    private int firstRow;
    private int lastRow;
    private int firstColumn;
    private int lastColumn;
    private boolean chartsEnabled = false;
    private boolean reloadCellDataOnNextScroll;
    private int defaultNewSheetRows = 200;
    private int defaultNewSheetColumns = 52;
    private boolean topLeftCellCommentsLoaded;
    private SpreadsheetDefaultActionHandler defaultActionHandler;
    protected int mergedRegionCounter;
    private Workbook workbook;
    private boolean tablesLoaded;
    private SheetState sheetState = new SheetState(this);
    private boolean reloadImageSizesFromPOI;
    private String defaultPercentageFormat = "0.00%";
    protected String initialSheetSelection = null;
    private Set<Component> customComponents = new HashSet<Component>();
    private Map<CellReference, PopupButton> sheetPopupButtons = new HashMap<CellReference, PopupButton>();
    private HashSet<PopupButton> attachedPopupButtons = new HashSet();
    private HashSet<SheetOverlayWrapper> sheetOverlays;
    private Set<Component> overlayComponents = new HashSet<Component>();
    private HashSet<SpreadsheetTable> tables;
    private final Map<Integer, HashSet<String>> invalidFormulas = new HashMap<Integer, HashSet<String>>();
    protected final MergedRegionUtil.MergedRegionContainer mergedRegionContainer = new MergedRegionUtil.MergedRegionContainer(){

        @Override
        public MergedRegion getMergedRegionStartingFrom(int column, int row) {
            ArrayList<MergedRegion> mergedRegions = Spreadsheet.this.getMergedRegions();
            if (mergedRegions != null) {
                for (MergedRegion region : mergedRegions) {
                    if (region.col1 != column || region.row1 != row) continue;
                    return region;
                }
            }
            return null;
        }

        @Override
        public MergedRegion getMergedRegion(int column, int row) {
            ArrayList<MergedRegion> mergedRegions = Spreadsheet.this.getMergedRegions();
            if (mergedRegions != null) {
                for (MergedRegion region : mergedRegions) {
                    if (region.col1 > column || region.row1 > row || region.col2 < column || region.row2 < row) continue;
                    return region;
                }
            }
            return null;
        }
    };
    private Set<Integer> rowsWithComponents;
    private int minimumRowHeightForComponents = 30;
    private CommentAuthorProvider commentAuthorProvider;

    public void setId(String id) {
        this.getElement().setProperty("id", id);
    }

    int getCols() {
        return this.cols;
    }

    private List<GroupingData> getColGroupingData() {
        return this.colGroupingData;
    }

    int getColGroupingMax() {
        return this.colGroupingMax;
    }

    int getRowGroupingMax() {
        return this.rowGroupingMax;
    }

    boolean isColGroupingInversed() {
        return this.colGroupingInversed;
    }

    boolean isRowGroupingInversed() {
        return this.rowGroupingInversed;
    }

    float getDefRowH() {
        return this.defRowH;
    }

    int getDefColW() {
        return this.defColW;
    }

    private float[] getRowH() {
        return this.rowH;
    }

    int[] getColW() {
        return this.colW;
    }

    private int getSheetIndex() {
        return this.sheetIndex;
    }

    String[] getSheetNames() {
        return this.sheetNames;
    }

    HashMap<Integer, String> getCellStyleToCSSStyle() {
        return this.cellStyleToCSSStyle;
    }

    HashMap<Integer, Integer> getRowIndexToStyleIndex() {
        return this.rowIndexToStyleIndex;
    }

    HashMap<Integer, Integer> getColumnIndexToStyleIndex() {
        return this.columnIndexToStyleIndex;
    }

    Set<Integer> getLockedColumnIndexes() {
        return this.lockedColumnIndexes;
    }

    Set<Integer> getLockedRowIndexes() {
        return this.lockedRowIndexes;
    }

    ArrayList<String> getShiftedCellBorderStyles() {
        return this.shiftedCellBorderStyles;
    }

    HashMap<Integer, String> getConditionalFormattingStyles() {
        return this.conditionalFormattingStyles;
    }

    private ArrayList<Integer> getHiddenColumnIndexes() {
        return this.hiddenColumnIndexes;
    }

    private ArrayList<Integer> getHiddenRowIndexes() {
        return this.hiddenRowIndexes;
    }

    int[] getVerticalScrollPositions() {
        return this.verticalScrollPositions;
    }

    int[] getHorizontalScrollPositions() {
        return this.horizontalScrollPositions;
    }

    private boolean isSheetProtected() {
        return this.sheetProtected;
    }

    private HashMap<String, String> getCellKeysToEditorIdMap() {
        return this.cellKeysToEditorIdMap;
    }

    HashMap<String, String> getComponentIDtoCellKeysMap() {
        return this.componentIDtoCellKeysMap;
    }

    private HashMap<String, String> getHyperlinksTooltips() {
        return this.hyperlinksTooltips;
    }

    private HashMap<String, String> getCellComments() {
        return this.cellComments;
    }

    private HashMap<String, String> getCellCommentAuthors() {
        return this.cellCommentAuthors;
    }

    private ArrayList<String> getVisibleCellComments() {
        return this.visibleCellComments;
    }

    private Set<String> getInvalidFormulaCells() {
        return this.invalidFormulaCells;
    }

    private HashMap<String, OverlayInfo> getOverlays() {
        return this.overlays;
    }

    private ArrayList<MergedRegion> getMergedRegions() {
        return this.mergedRegions;
    }

    private int getVerticalSplitPosition() {
        return this.verticalSplitPosition;
    }

    private int getHorizontalSplitPosition() {
        return this.horizontalSplitPosition;
    }

    private String getInfoLabelValue() {
        return this.infoLabelValue;
    }

    private boolean isWorkbookChangeToggle() {
        return this.workbookChangeToggle;
    }

    void setRows(int rows) {
        this.rows = rows;
        this.getElement().setProperty("rows", (double)rows);
    }

    void setCols(int cols) {
        this.cols = cols;
        this.getElement().setProperty("cols", (double)cols);
    }

    void setColGroupingData(List<GroupingData> colGroupingData) {
        this.colGroupingData = colGroupingData;
        this.getElement().setProperty("colGroupingData", Serializer.serialize(colGroupingData));
    }

    void setRowGroupingData(List<GroupingData> rowGroupingData) {
        this.getElement().setProperty("rowGroupingData", Serializer.serialize(rowGroupingData));
    }

    void setColGroupingMax(int colGroupingMax) {
        this.colGroupingMax = colGroupingMax;
        this.getElement().setProperty("colGroupingMax", (double)colGroupingMax);
    }

    void setRowGroupingMax(int rowGroupingMax) {
        this.rowGroupingMax = rowGroupingMax;
        this.getElement().setProperty("rowGroupingMax", (double)rowGroupingMax);
    }

    void setColGroupingInversed(boolean colGroupingInversed) {
        this.colGroupingInversed = colGroupingInversed;
        this.getElement().setProperty("colGroupingInversed", colGroupingInversed);
    }

    void setRowGroupingInversed(boolean rowGroupingInversed) {
        this.rowGroupingInversed = rowGroupingInversed;
        this.getElement().setProperty("rowGroupingInversed", rowGroupingInversed);
    }

    void setDefRowH(float defRowH) {
        this.defRowH = defRowH;
        this.getElement().setProperty("defRowH", (double)defRowH);
    }

    void setDefColW(int defColW) {
        this.defColW = defColW;
        this.getElement().setProperty("defColW", (double)defColW);
    }

    void setRowH(float[] rowH) {
        this.rowH = rowH;
        this.getElement().setProperty("rowH", Serializer.serialize(rowH));
    }

    void setColW(int[] colW) {
        this.colW = colW;
        this.getElement().setProperty("colW", Serializer.serialize(colW));
    }

    private void setReload(boolean reload) {
        if (reload) {
            this.getElement().setProperty("reload", (double)System.currentTimeMillis());
        }
    }

    private void setSheetIndex(int sheetIndex) {
        this.sheetIndex = sheetIndex;
        this.getElement().setProperty("sheetIndex", (double)sheetIndex);
    }

    private void setSheetNames(String[] sheetNames) {
        this.sheetNames = sheetNames;
        this.getElement().setProperty("sheetNames", Serializer.serialize(sheetNames));
    }

    void setCellStyleToCSSStyle(HashMap<Integer, String> cellStyleToCSSStyle) {
        this.cellStyleToCSSStyle = cellStyleToCSSStyle;
        this.getElement().setProperty("cellStyleToCSSStyle", Serializer.serialize(cellStyleToCSSStyle));
    }

    void setRowIndexToStyleIndex(HashMap<Integer, Integer> rowIndexToStyleIndex) {
        this.rowIndexToStyleIndex = rowIndexToStyleIndex;
        this.getElement().setProperty("rowIndexToStyleIndex", Serializer.serialize(rowIndexToStyleIndex));
    }

    void setColumnIndexToStyleIndex(HashMap<Integer, Integer> columnIndexToStyleIndex) {
        this.columnIndexToStyleIndex = columnIndexToStyleIndex;
        this.getElement().setProperty("columnIndexToStyleIndex", Serializer.serialize(columnIndexToStyleIndex));
    }

    void setLockedColumnIndexes(Set<Integer> lockedColumnIndexes) {
        this.lockedColumnIndexes = lockedColumnIndexes;
        this.getElement().setProperty("lockedColumnIndexes", Serializer.serialize(lockedColumnIndexes));
    }

    void setLockedRowIndexes(Set<Integer> lockedRowIndexes) {
        this.lockedRowIndexes = lockedRowIndexes;
        this.getElement().setProperty("lockedRowIndexes", Serializer.serialize(lockedRowIndexes));
    }

    void setShiftedCellBorderStyles(ArrayList<String> shiftedCellBorderStyles) {
        this.shiftedCellBorderStyles = shiftedCellBorderStyles;
        this.getElement().setProperty("shiftedCellBorderStyles", Serializer.serialize(shiftedCellBorderStyles));
    }

    void setConditionalFormattingStyles(HashMap<Integer, String> conditionalFormattingStyles) {
        this.conditionalFormattingStyles = conditionalFormattingStyles;
        this.getElement().setProperty("conditionalFormattingStyles", Serializer.serialize(conditionalFormattingStyles));
    }

    void setHiddenColumnIndexes(ArrayList<Integer> hiddenColumnIndexes) {
        this.hiddenColumnIndexes = hiddenColumnIndexes;
        this.getElement().setProperty("hiddenColumnIndexes", Serializer.serialize(hiddenColumnIndexes));
    }

    void setHiddenRowIndexes(ArrayList<Integer> hiddenRowIndexes) {
        this.hiddenRowIndexes = hiddenRowIndexes;
        this.getElement().setProperty("hiddenRowIndexes", Serializer.serialize(hiddenRowIndexes));
    }

    void setVerticalScrollPositions(int[] verticalScrollPositions) {
        this.verticalScrollPositions = verticalScrollPositions;
        this.getElement().setProperty("verticalScrollPositions", Serializer.serialize(verticalScrollPositions));
    }

    void setHorizontalScrollPositions(int[] horizontalScrollPositions) {
        this.horizontalScrollPositions = horizontalScrollPositions;
        this.getElement().setProperty("horizontalScrollPositions", Serializer.serialize(horizontalScrollPositions));
    }

    private void setSheetProtected(boolean sheetProtected) {
        this.sheetProtected = sheetProtected;
        this.getElement().setProperty("sheetProtected", sheetProtected);
    }

    private void setWorkbookProtected(boolean workbookProtected) {
        this.getElement().setProperty("workbookProtected", workbookProtected);
    }

    private void setCellKeysToEditorIdMap(HashMap<String, String> cellKeysToEditorIdMap) {
        this.cellKeysToEditorIdMap = cellKeysToEditorIdMap;
        this.getElement().setProperty("cellKeysToEditorIdMap", Serializer.serialize(cellKeysToEditorIdMap));
    }

    private void setComponentIDtoCellKeysMap(HashMap<String, String> componentIDtoCellKeysMap) {
        this.componentIDtoCellKeysMap = componentIDtoCellKeysMap;
        this.getElement().setProperty("componentIDtoCellKeysMap", Serializer.serialize(componentIDtoCellKeysMap));
    }

    private void setHyperlinksTooltips(HashMap<String, String> hyperlinksTooltips) {
        this.hyperlinksTooltips = hyperlinksTooltips;
        this.getElement().setProperty("hyperlinksTooltips", Serializer.serialize(hyperlinksTooltips));
    }

    private void setCellComments(HashMap<String, String> cellComments) {
        this.cellComments = cellComments;
        this.getElement().setProperty("cellComments", Serializer.serialize(cellComments));
    }

    private void setCellCommentAuthors(HashMap<String, String> cellCommentAuthors) {
        this.cellCommentAuthors = cellCommentAuthors;
        this.getElement().setProperty("cellCommentAuthors", Serializer.serialize(cellCommentAuthors));
    }

    private void setVisibleCellComments(ArrayList<String> visibleCellComments) {
        this.visibleCellComments = visibleCellComments;
        this.getElement().setProperty("visibleCellComments", Serializer.serialize(visibleCellComments));
    }

    private void setInvalidFormulaCells(Set<String> invalidFormulaCells) {
        this.invalidFormulaCells = invalidFormulaCells;
        this.getElement().setProperty("invalidFormulaCells", Serializer.serialize(invalidFormulaCells));
    }

    private void setHasActions(boolean hasActions) {
        this.getElement().setProperty("hasActions", hasActions);
    }

    private void setOverlays(HashMap<String, OverlayInfo> overlays) {
        this.overlays = overlays;
        this.getElement().setProperty("overlays", Serializer.serialize(overlays));
    }

    void setMergedRegions(ArrayList<MergedRegion> mergedRegions) {
        this.mergedRegions = mergedRegions;
        this.getElement().setProperty("mergedRegions", Serializer.serialize(mergedRegions));
    }

    private void setDisplayGridlines(boolean displayGridlines) {
        this.getElement().setProperty("displayGridlines", displayGridlines);
    }

    private void setDisplayRowColHeadings(boolean displayRowColHeadings) {
        this.getElement().setProperty("displayRowColHeadings", displayRowColHeadings);
    }

    void setVerticalSplitPosition(int verticalSplitPosition) {
        this.verticalSplitPosition = verticalSplitPosition;
        this.getElement().setProperty("verticalSplitPosition", (double)verticalSplitPosition);
    }

    void setHorizontalSplitPosition(int horizontalSplitPosition) {
        this.horizontalSplitPosition = horizontalSplitPosition;
        this.getElement().setProperty("horizontalSplitPosition", (double)horizontalSplitPosition);
    }

    private void setInfoLabelValue(String infoLabelValue) {
        this.infoLabelValue = infoLabelValue;
        this.getElement().setProperty("infoLabelValue", infoLabelValue);
    }

    private void setWorkbookChangeToggle(boolean workbookChangeToggle) {
        this.workbookChangeToggle = workbookChangeToggle;
        this.getElement().setProperty("workbookChangeToggle", workbookChangeToggle);
    }

    void setLockFormatColumns(boolean lockFormatColumns) {
        this.getElement().setProperty("lockFormatColumns", lockFormatColumns);
    }

    void setLockFormatRows(boolean lockFormatRows) {
        this.getElement().setProperty("lockFormatRows", lockFormatRows);
    }

    void setNamedRanges(List<String> namedRanges) {
        this.getElement().setProperty("namedRanges", Serializer.serialize(namedRanges));
    }

    void onPopupButtonClick(int row, int column) {
        PopupButton popup = this.sheetPopupButtons.get(SpreadsheetUtil.relativeToAbsolute(this, new CellReference(row - 1, column - 1)));
        if (popup != null) {
            popup.openPopup();
        }
    }

    void onPopupClose(int row, int column) {
        PopupButton popup = this.sheetPopupButtons.get(SpreadsheetUtil.relativeToAbsolute(this, new CellReference(row - 1, column - 1)));
        if (popup != null) {
            popup.closePopup();
        }
    }

    public Spreadsheet() {
        this(200, 52);
    }

    public Spreadsheet(int defaultRowCount, int defaultColumnCount) {
        this.init();
        this.setDefaultRowCount(defaultRowCount);
        this.setDefaultColumnCount(defaultColumnCount);
        SpreadsheetFactory.loadSpreadsheetWith(this, null, this.getDefaultRowCount(), this.getDefaultColumnCount());
    }

    public Spreadsheet(Workbook workbook) {
        this.init();
        SpreadsheetFactory.loadSpreadsheetWith(this, workbook, this.getDefaultRowCount(), this.getDefaultColumnCount());
    }

    public Spreadsheet(File file) throws IOException {
        this.init();
        SpreadsheetFactory.reloadSpreadsheetComponent(this, file);
    }

    public Spreadsheet(InputStream inputStream) throws IOException {
        this.init();
        SpreadsheetFactory.reloadSpreadsheetComponent(this, inputStream);
    }

    private void init() {
        this.updateAppId();
        this.valueManager = this.createCellValueManager();
        this.sheetOverlays = new HashSet();
        this.tables = new HashSet();
        this.registerRpc(new SpreadsheetHandlerImpl(this));
        this.defaultActionHandler = new SpreadsheetDefaultActionHandler();
        this.hyperlinkCellClickHandler = new DefaultHyperlinkCellClickHandler(this);
        this.addActionHandler(this.defaultActionHandler);
        this.setId(UUID.randomUUID().toString());
        this.customInit();
    }

    private void registerRpc(SpreadsheetHandlerImpl spreadsheetHandler) {
        this.addListener(SpreadsheetEvent.class, new SpreadsheetEventListener(spreadsheetHandler));
    }

    protected CellValueManager createCellValueManager() {
        return new CellValueManager(this);
    }

    private void updateAppId() {
        Optional.ofNullable(UI.getCurrent()).ifPresent(ui -> this.getElement().setProperty("appId", ui.getInternals().getAppId()));
    }

    protected void customInit() {
    }

    @Override
    public void addActionHandler(Action.Handler actionHandler) {
        this.contextMenuManager.addActionHandler(actionHandler);
        this.setHasActions(this.contextMenuManager.hasActionHandlers());
    }

    public void removeDefaultActionHandler() {
        this.removeActionHandler(this.defaultActionHandler);
    }

    @Override
    public void removeActionHandler(Action.Handler actionHandler) {
        this.contextMenuManager.removeActionHandler(actionHandler);
        this.setHasActions(this.contextMenuManager.hasActionHandlers());
    }

    public void setCellValueHandler(CellValueHandler customCellValueHandler) {
        this.getCellValueManager().setCustomCellValueHandler(customCellValueHandler);
    }

    public CellValueHandler getCellValueHandler() {
        return this.getCellValueManager().getCustomCellValueHandler();
    }

    public void setCellDeletionHandler(CellDeletionHandler customCellDeletionHandler) {
        this.getCellValueManager().setCustomCellDeletionHandler(customCellDeletionHandler);
    }

    public CellDeletionHandler getCellDeletionHandler() {
        return this.getCellValueManager().getCustomCellDeletionHandler();
    }

    public void setHyperlinkCellClickHandler(HyperlinkCellClickHandler handler) {
        this.hyperlinkCellClickHandler = handler;
    }

    public HyperlinkCellClickHandler getHyperlinkCellClickHandler() {
        return this.hyperlinkCellClickHandler;
    }

    public ContextMenuManager getContextMenuManager() {
        return this.contextMenuManager;
    }

    public CellSelectionManager getCellSelectionManager() {
        return this.selectionManager;
    }

    public CellValueManager getCellValueManager() {
        return this.valueManager;
    }

    protected CellSelectionShifter getCellShifter() {
        return this.cellShifter;
    }

    public SpreadsheetHistoryManager getSpreadsheetHistoryManager() {
        return this.historyManager;
    }

    protected MergedRegionUtil.MergedRegionContainer getMergedRegionContainer() {
        return this.mergedRegionContainer;
    }

    public int getFirstColumn() {
        return this.firstColumn;
    }

    public int getLastColumn() {
        return this.lastColumn;
    }

    public int getFirstRow() {
        return this.firstRow;
    }

    public int getLastRow() {
        return this.lastRow;
    }

    public int getLastFrozenRow() {
        return this.getVerticalSplitPosition();
    }

    public int getLastFrozenColumn() {
        return this.getHorizontalSplitPosition();
    }

    boolean isChartsEnabled() {
        return this.chartsEnabled;
    }

    void setChartsEnabled(boolean chartsEnabled) {
        this.chartsEnabled = chartsEnabled;
        this.clearSheetOverlays();
        this.loadOrUpdateOverlays();
    }

    public boolean isRerenderPending() {
        return this.reload;
    }

    protected void fireEvent(ComponentEvent event) {
        super.fireEvent(event);
    }

    protected void onSheetScroll(int firstRow, int firstColumn, int lastRow, int lastColumn) {
        if (this.reloadCellDataOnNextScroll || this.firstRow != firstRow || this.lastRow != lastRow || this.firstColumn != firstColumn || this.lastColumn != lastColumn) {
            this.firstRow = firstRow;
            this.lastRow = lastRow;
            this.firstColumn = firstColumn;
            this.lastColumn = lastColumn;
            this.loadCells(firstRow, firstColumn, lastRow, lastColumn);
        }
        if (this.initialSheetSelection != null) {
            this.selectionManager.onSheetAddressChanged(this.initialSheetSelection, true);
            this.initialSheetSelection = null;
        } else if (this.reloadCellDataOnNextScroll) {
            this.selectionManager.reloadCurrentSelection();
        }
        this.reloadCellDataOnNextScroll = false;
    }

    protected boolean isRangeEditable(CellRangeAddress cellRangeAddress) {
        return this.isRangeEditable(cellRangeAddress.getFirstRow(), cellRangeAddress.getFirstColumn(), cellRangeAddress.getLastRow(), cellRangeAddress.getLastColumn());
    }

    protected boolean isRangeEditable(int row1, int col1, int row2, int col2) {
        if (this.isActiveSheetProtected()) {
            for (int r = row1; r <= row2; ++r) {
                for (int c = col1; c <= col2; ++c) {
                    if (!this.isCellLocked(new CellAddress(r, c))) continue;
                    return false;
                }
            }
        }
        return true;
    }

    protected CellRangeAddress createCorrectCellRangeAddress(String addressString) {
        int c2;
        String[] split = addressString.split(":");
        CellReference cr1 = new CellReference(split[0]);
        CellReference cr2 = new CellReference(split[1]);
        int r1 = cr1.getRow() > cr2.getRow() ? cr2.getRow() : cr1.getRow();
        int r2 = cr1.getRow() > cr2.getRow() ? cr1.getRow() : cr2.getRow();
        int c1 = cr1.getCol() > cr2.getCol() ? cr2.getCol() : cr1.getCol();
        int n = c2 = cr1.getCol() > cr2.getCol() ? cr1.getCol() : cr2.getCol();
        if (r1 >= this.getRows()) {
            r1 = this.getRows() - 1;
        }
        if (r2 >= this.getRows()) {
            r2 = this.getRows() - 1;
        }
        if (c1 >= this.getCols()) {
            c1 = this.getCols() - 1;
        }
        if (c2 >= this.getCols()) {
            c2 = this.getCols() - 1;
        }
        return new CellRangeAddress(r1, r2, c1, c2);
    }

    protected CellRangeAddress createCorrectCellRangeAddress(int row1, int col1, int row2, int col2) {
        int c2;
        int r1 = row1 > row2 ? row2 : row1;
        int r2 = row1 > row2 ? row1 : row2;
        int c1 = col1 > col2 ? col2 : col1;
        int n = c2 = col1 > col2 ? col1 : col2;
        if (r1 >= this.getRows()) {
            r1 = this.getRows();
        }
        if (r2 >= this.getRows()) {
            r2 = this.getRows();
        }
        if (c1 >= this.getCols()) {
            c1 = this.getCols();
        }
        if (c2 >= this.getCols()) {
            c2 = this.getCols();
        }
        return new CellRangeAddress(r1 - 1, r2 - 1, c1 - 1, c2 - 1);
    }

    public void setLocale(Locale locale) {
        Objects.requireNonNull(locale, "Locale must not be null.");
        this.locale = locale;
        this.valueManager.updateLocale(locale);
        this.refreshAllCellValues();
    }

    public Locale getLocale() {
        if (this.locale != null) {
            return this.locale;
        }
        return super.getLocale();
    }

    protected void onAttach(AttachEvent attachEvent) {
        super.onAttach(attachEvent);
        this.valueManager.updateLocale(this.getLocale());
    }

    public void setSheetHidden(int sheetPOIIndex, SheetVisibility visibility) throws IllegalArgumentException {
        if (visibility != SheetVisibility.VISIBLE && SpreadsheetUtil.getNumberOfVisibleSheets(this.workbook) == 1 && !this.workbook.isSheetHidden(sheetPOIIndex) && !this.workbook.isSheetVeryHidden(sheetPOIIndex)) {
            throw new IllegalArgumentException("At least one sheet should be always visible.");
        }
        boolean isHidden = this.workbook.isSheetHidden(sheetPOIIndex);
        boolean isVeryHidden = this.workbook.isSheetVeryHidden(sheetPOIIndex);
        int activeSheetIndex = this.workbook.getActiveSheetIndex();
        this.workbook.setSheetVisibility(sheetPOIIndex, visibility);
        if (visibility == SheetVisibility.VISIBLE && (isHidden || isVeryHidden) || visibility != SheetVisibility.VISIBLE && !isHidden && !isVeryHidden) {
            if (sheetPOIIndex != activeSheetIndex) {
                this.reloadSheetNames();
                this.setSheetIndex(this.getSpreadsheetSheetIndex(activeSheetIndex) + 1);
            } else {
                int oldVisibleSheetIndex = this.getSheetIndex() - 1;
                if (visibility != SheetVisibility.VISIBLE && activeSheetIndex == this.workbook.getNumberOfSheets() - 1) {
                    --oldVisibleSheetIndex;
                }
                int newActiveSheetIndex = this.getVisibleSheetPOIIndex(oldVisibleSheetIndex);
                this.workbook.setActiveSheet(newActiveSheetIndex);
                this.reloadActiveSheetData();
                SpreadsheetFactory.reloadSpreadsheetData(this, this.getActiveSheet());
                this.getSpreadsheetStyleFactory().reloadActiveSheetCellStyles();
            }
        }
    }

    @Deprecated
    public void setSheetHidden(int sheetPOIIndex, int hidden) throws IllegalArgumentException {
        this.setSheetHidden(sheetPOIIndex, SheetVisibility.values()[hidden]);
    }

    public String[] getVisibleSheetNames() {
        String[] names = this.getSheetNames();
        return Arrays.copyOf(names, names.length);
    }

    public void setSheetName(int sheetIndex, String sheetName) throws IllegalArgumentException {
        if (sheetIndex < 0 || sheetIndex >= this.getSheetNames().length) {
            throw new IllegalArgumentException("Invalid Sheet index given.");
        }
        int poiSheetIndex = this.getVisibleSheetPOIIndex(sheetIndex);
        this.setSheetNameWithPOIIndex(poiSheetIndex, sheetName);
    }

    public void setSheetNameWithPOIIndex(int sheetIndex, String sheetName) throws IllegalArgumentException {
        if (sheetIndex < 0 || sheetIndex >= this.workbook.getNumberOfSheets()) {
            throw new IllegalArgumentException("Invalid POI Sheet index given.");
        }
        if (sheetName == null || sheetName.isEmpty()) {
            throw new IllegalArgumentException("Sheet Name cannot be null or an empty String, or contain backslash \\.");
        }
        if (this.isSheetNameExisting(sheetName)) {
            throw new IllegalArgumentException("Sheet name must be unique within the workbook.");
        }
        this.workbook.setSheetName(sheetIndex, sheetName);
        if (!this.workbook.isSheetVeryHidden(sheetIndex) && !this.workbook.isSheetHidden(sheetIndex)) {
            int ourIndex = this.getSpreadsheetSheetIndex(sheetIndex);
            String[] _sheetNames = Arrays.copyOf(this.getSheetNames(), this.getSheetNames().length);
            _sheetNames[ourIndex] = sheetName;
            this.setSheetNames(_sheetNames);
        }
    }

    public void setSheetProtected(int sheetPOIIndex, String password) {
        if (sheetPOIIndex < 0 || sheetPOIIndex >= this.workbook.getNumberOfSheets()) {
            throw new IllegalArgumentException("Invalid POI Sheet index given.");
        }
        this.workbook.getSheetAt(sheetPOIIndex).protectSheet(password);
        this.setSheetProtected(this.getActiveSheet().getProtect());
        if (sheetPOIIndex == this.workbook.getActiveSheetIndex()) {
            this.loadCustomComponents();
            this.selectionManager.reSelectSelectedCell();
        }
    }

    public void setActiveSheetProtected(String password) {
        this.setSheetProtected(this.workbook.getActiveSheetIndex(), password);
    }

    public void createNewSheet(String sheetName, int rows, int columns) throws IllegalArgumentException {
        if (sheetName != null && sheetName.isEmpty()) {
            throw new IllegalArgumentException("Sheet Name cannot be an empty String.");
        }
        if (sheetName != null && sheetName.length() > 31) {
            throw new IllegalArgumentException("Sheet Name cannot be longer than 31 characters");
        }
        if (sheetName != null && this.isSheetNameExisting(sheetName)) {
            throw new IllegalArgumentException("Sheet name must be unique within the workbook.");
        }
        Sheet previousSheet = this.getActiveSheet();
        SpreadsheetFactory.addNewSheet(this, this.workbook, sheetName, rows, columns);
        this.fireSheetChangeEvent(previousSheet, this.getActiveSheet());
    }

    public void deleteSheetWithPOIIndex(int poiSheetIndex) throws IllegalArgumentException {
        if (this.getNumberOfVisibleSheets() < 2) {
            throw new IllegalArgumentException("A workbook must contain at least one visible worksheet");
        }
        int removedVisibleIndex = this.getSpreadsheetSheetIndex(poiSheetIndex);
        this.workbook.removeSheetAt(poiSheetIndex);
        int oldIndex = this.getSheetIndex() - 1;
        if (removedVisibleIndex <= oldIndex) {
            if (oldIndex == this.getNumberOfVisibleSheets()) {
                this.workbook.setActiveSheet(this.getVisibleSheetPOIIndex(oldIndex - 1));
            } else {
                this.workbook.setActiveSheet(this.getVisibleSheetPOIIndex(oldIndex));
            }
        }
        this.reloadActiveSheetData();
    }

    public void deleteSheet(int sheetIndex) throws IllegalArgumentException {
        if (sheetIndex < 0 || sheetIndex >= this.getNumberOfVisibleSheets()) {
            throw new IllegalArgumentException("Invalid index for visible sheet given.");
        }
        this.deleteSheetWithPOIIndex(this.getVisibleSheetPOIIndex(sheetIndex));
    }

    public int getNumberOfVisibleSheets() {
        if (this.getSheetNames() != null) {
            return this.getSheetNames().length;
        }
        return 0;
    }

    public int getNumberOfSheets() {
        return this.workbook.getNumberOfSheets();
    }

    private boolean isSheetNameExisting(String sheetName) {
        for (int i = 0; i < this.workbook.getNumberOfSheets(); ++i) {
            if (!this.workbook.getSheetName(i).equals(sheetName)) continue;
            return true;
        }
        return false;
    }

    public int getActiveSheetIndex() {
        return this.getSheetIndex() - 1;
    }

    public int getActiveSheetPOIIndex() {
        return this.getVisibleSheetPOIIndex(this.getSheetIndex() - 1);
    }

    public void setActiveSheetIndex(int sheetIndex) throws IllegalArgumentException {
        if (sheetIndex < 0 || sheetIndex >= this.getSheetNames().length) {
            throw new IllegalArgumentException("Invalid Sheet index given.");
        }
        int POISheetIndex = this.getVisibleSheetPOIIndex(sheetIndex);
        this.setActiveSheetWithPOIIndex(POISheetIndex);
    }

    public void setActiveSheetWithPOIIndex(int sheetIndex) throws IllegalArgumentException {
        if (sheetIndex < 0 || sheetIndex >= this.workbook.getNumberOfSheets()) {
            throw new IllegalArgumentException("Invalid POI Sheet index given.");
        }
        if (this.workbook.isSheetHidden(sheetIndex) || this.workbook.isSheetVeryHidden(sheetIndex)) {
            throw new IllegalArgumentException("Cannot set a hidden or very hidden sheet as the active sheet. Given index: " + sheetIndex);
        }
        this.workbook.setActiveSheet(sheetIndex);
        this.workbook.setSelectedTab(sheetIndex);
        this.getFormulaEvaluator().clearAllCachedResultValues();
        this.getConditionalFormattingEvaluator().clearAllCachedValues();
        this.reloadActiveSheetData();
        SpreadsheetFactory.reloadSpreadsheetData(this, this.workbook.getSheetAt(sheetIndex));
        this.reloadActiveSheetStyles();
        this.loadPopupButtons();
    }

    protected void onSheetSelected(int tabIndex, int scrollLeft, int scrollTop) {
        int oldIndex = Math.abs(this.getSheetIndex()) - 1;
        int[] _verticalScrollPositions = Arrays.copyOf(this.getVerticalScrollPositions(), this.getVerticalScrollPositions().length);
        _verticalScrollPositions[oldIndex] = scrollTop;
        this.setVerticalScrollPositions(_verticalScrollPositions);
        int[] _horizontalScrollPositions = Arrays.copyOf(this.getHorizontalScrollPositions(), this.getHorizontalScrollPositions().length);
        _horizontalScrollPositions[oldIndex] = scrollLeft;
        this.setHorizontalScrollPositions(_horizontalScrollPositions);
        Sheet oldSheet = this.getActiveSheet();
        this.setActiveSheetIndex(tabIndex);
        Sheet newSheet = this.getActiveSheet();
        this.fireSheetChangeEvent(oldSheet, newSheet);
    }

    protected void onNewSheetCreated(int scrollLeft, int scrollTop) {
        int[] _verticalScrollPositions = Arrays.copyOf(this.getVerticalScrollPositions(), this.getVerticalScrollPositions().length);
        _verticalScrollPositions[this.getSheetIndex() - 1] = scrollTop;
        this.setVerticalScrollPositions(_verticalScrollPositions);
        int[] _horizontalScrollPositions = Arrays.copyOf(this.getHorizontalScrollPositions(), this.getHorizontalScrollPositions().length);
        _horizontalScrollPositions[this.getSheetIndex() - 1] = scrollLeft;
        this.setHorizontalScrollPositions(_horizontalScrollPositions);
        this.createNewSheet(null, this.defaultNewSheetRows, this.defaultNewSheetColumns);
    }

    protected void onSheetRename(int sheetIndex, String sheetName) {
        this.setSheetNameWithPOIIndex(this.getVisibleSheetPOIIndex(sheetIndex), sheetName);
    }

    public int getColumns() {
        return this.getCols();
    }

    public int getRows() {
        return this.rows;
    }

    public DataFormatter getDataFormatter() {
        return this.valueManager.getDataFormatter();
    }

    public Cell getCell(String cellAddress) {
        CellReference ref = new CellReference(cellAddress);
        Row r = this.workbook.getSheetAt(this.workbook.getActiveSheetIndex()).getRow(ref.getRow());
        if (r != null) {
            return r.getCell((int)ref.getCol());
        }
        return null;
    }

    public Cell getCell(int row, int col) {
        Sheet sheet = this.workbook.getSheetAt(this.workbook.getActiveSheetIndex());
        return this.getCell(row, col, sheet);
    }

    public Cell getCell(int row, int col, Sheet sheet) {
        Row r = sheet.getRow(row);
        if (r != null) {
            return r.getCell(col);
        }
        return null;
    }

    public Cell getCell(CellReference cellReference) {
        return cellReference == null ? null : this.getCell(cellReference.getSheetName(), cellReference.getRow(), cellReference.getCol());
    }

    public Cell getCell(String sheetName, int row, int column) {
        if (sheetName == null) {
            return this.getCell(row, column);
        }
        return this.getCell(row, column, this.workbook.getSheet(sheetName));
    }

    public Cell getCell(CellReference cellReference, Sheet sheet) {
        return cellReference == null ? null : this.getCell(cellReference.getRow(), (int)cellReference.getCol(), sheet);
    }

    public void deleteCell(int row, int col) {
        Sheet activeSheet = this.workbook.getSheetAt(this.workbook.getActiveSheetIndex());
        Cell cell = activeSheet.getRow(row).getCell(col);
        if (cell != null) {
            this.styler.cellStyleUpdated(cell, true);
            activeSheet.getRow(row).removeCell(cell);
            this.valueManager.cellDeleted(cell);
            this.refreshCells(cell);
        }
    }

    public void refreshCells(Cell ... cells) {
        if (cells != null) {
            for (Cell cell : cells) {
                this.markCellAsUpdated(cell, true);
            }
            this.updateMarkedCells();
        }
    }

    public void refreshCells(Collection<Cell> cells) {
        if (cells != null && !cells.isEmpty()) {
            for (Cell cell : cells) {
                this.markCellAsUpdated(cell, true);
            }
            this.updateMarkedCells();
        }
    }

    void markCellAsUpdated(Cell cell, boolean cellStyleUpdated) {
        this.valueManager.cellUpdated(cell);
        if (cellStyleUpdated) {
            this.styler.cellStyleUpdated(cell, true);
        }
    }

    public void markCellAsDeleted(Cell cell, boolean cellStyleUpdated) {
        this.valueManager.cellDeleted(cell);
        if (cellStyleUpdated) {
            this.styler.cellStyleUpdated(cell, true);
        }
        this.refreshCells(cell);
    }

    void updateMarkedCells() {
        this.conditionalFormatter.createConditionalFormatterRules();
        this.valueManager.updateMarkedCellValues();
        this.selectionManager.reSelectSelectedCell();
        this.loadCellComments();
        this.reloadVisibleCellContents();
    }

    public Cell createFormulaCell(int row, int col, String formula) throws IllegalArgumentException {
        Cell cell;
        Sheet activeSheet = this.workbook.getSheetAt(this.workbook.getActiveSheetIndex());
        Row r = activeSheet.getRow(row);
        if (r == null) {
            r = activeSheet.createRow(row);
        }
        if ((cell = r.getCell(col)) == null) {
            cell = r.createCell(col, CellType.FORMULA);
        } else {
            String key = SpreadsheetUtil.toKey(col + 1, row + 1);
            this.valueManager.clearCellCache(key);
        }
        cell.setCellFormula(formula);
        this.valueManager.cellUpdated(cell);
        return cell;
    }

    public Cell createCell(int row, int col, Object value) throws IllegalArgumentException {
        Cell cell;
        Sheet activeSheet = this.workbook.getSheetAt(this.workbook.getActiveSheetIndex());
        Row r = activeSheet.getRow(row);
        if (r == null) {
            r = activeSheet.createRow(row);
        }
        if ((cell = r.getCell(col)) == null) {
            cell = r.createCell(col);
        } else {
            String key = SpreadsheetUtil.toKey(col + 1, row + 1);
            this.valueManager.clearCellCache(key);
        }
        if (value instanceof Double) {
            cell.setCellValue(((Double)value).doubleValue());
        } else if (value instanceof Boolean) {
            cell.setCellValue(((Boolean)value).booleanValue());
        } else if (value instanceof Date) {
            cell.setCellValue((Date)value);
        } else if (value instanceof Calendar) {
            cell.setCellValue((Calendar)value);
        } else if (value != null) {
            cell.setCellValue(value.toString());
        }
        this.valueManager.cellUpdated(cell);
        if (row > this.getRows()) {
            this.setMaxRows(row);
        }
        return cell;
    }

    public void refreshAllCellValues() {
        this.getFormulaEvaluator().clearAllCachedResultValues();
        this.getConditionalFormattingEvaluator().clearAllCachedValues();
        this.valueManager.clearCachedContent();
        if (this.firstColumn == -1) {
            return;
        }
        this.updateRowAndColumnRangeCellData(1, 1, this.getRows(), this.getColumns());
        this.selectionManager.reSelectSelectedCell();
    }

    public void setMaxColumns(int cols) {
        if (this.getCols() != cols) {
            this.setCols(cols);
        }
    }

    public void setMaxRows(int rows) {
        if (this.getRows() != rows) {
            this.setRows(rows);
        }
    }

    public void setSheetMaxSize(int rows, int cols) {
        this.setCols(cols);
        this.setRows(rows);
    }

    public int getDefaultColumnWidth() {
        return this.getDefColW();
    }

    public void setDefaultColumnWidth(int widthPX) {
        if (widthPX <= 0) {
            throw new IllegalArgumentException("Default column width must be over 0, given value: " + widthPX);
        }
        this.setDefColW(widthPX);
    }

    public float getDefaultRowHeight() {
        return this.getDefRowH();
    }

    public void setDefaultRowHeight(float heightPT) {
        if (heightPT <= 0.0f) {
            throw new IllegalArgumentException("Default row height must be over 0, given value: " + heightPT);
        }
        this.getActiveSheet().setDefaultRowHeightInPoints(heightPT);
        this.setDefRowH(heightPT);
    }

    protected void onColumnAutofit(int columnIndex) {
        SizeChangeCommand command = new SizeChangeCommand(this, SizeChangeCommand.Type.COLUMN);
        command.captureValues(new Integer[]{columnIndex + 1});
        this.autofitColumn(columnIndex);
        this.historyManager.addCommand(command);
    }

    public void autofitColumn(int columnIndex) {
        Sheet activeSheet = this.getActiveSheet();
        try {
            activeSheet.autoSizeColumn(columnIndex);
        }
        catch (NullPointerException e) {
            LOGGER.trace("Poi threw NullPointerException when trying to autofit column", (Throwable)e);
            return;
        }
        int columnPixelWidth = this.getColumnAutofitPixelWidth(columnIndex, (int)activeSheet.getColumnWidthInPixels(columnIndex));
        int[] _colW = Arrays.copyOf(this.getColW(), this.getColW().length);
        _colW[columnIndex] = columnPixelWidth;
        this.setColW(_colW);
        this.getCellValueManager().clearCacheForColumn(columnIndex + 1);
        this.getCellValueManager().loadCellData(this.firstRow, columnIndex + 1, this.lastRow, columnIndex + 1);
        if (this.hasSheetOverlays()) {
            this.reloadImageSizesFromPOI = true;
            this.loadOrUpdateOverlays();
        }
    }

    public void shiftRows(int startRow, int endRow, int n) {
        this.shiftRows(startRow, endRow, n, false, false);
    }

    public void shiftRows(int startRow, int endRow, int n, boolean copyRowHeight, boolean resetOriginalRowHeight) {
        int lastAffectedRow;
        Sheet sheet = this.getActiveSheet();
        int lastNonBlankRow = this.getLastNonBlankRow(sheet);
        sheet.shiftRows(startRow, endRow, n, copyRowHeight, resetOriginalRowHeight);
        this.getFormulaEvaluator().clearAllCachedResultValues();
        this.getConditionalFormattingEvaluator().clearAllCachedValues();
        int start = n < 0 ? Math.max(lastNonBlankRow, startRow) : startRow;
        int end = n < 0 ? endRow : startRow + n - 1;
        this.valueManager.updateDeletedRowsInClientCache(start + 1, end + 1);
        int firstAffectedRow = n < 0 ? startRow + n : startRow;
        int n2 = lastAffectedRow = n < 0 ? endRow : endRow + n;
        if (copyRowHeight || resetOriginalRowHeight) {
            int oldLength = this.getRowH().length;
            int neededLength = endRow + n + 1;
            float[] _rowH = Arrays.copyOf(this.getRowH(), this.getRowH().length);
            if (n > 0 && oldLength < neededLength) {
                _rowH = Arrays.copyOf(_rowH, neededLength);
            }
            for (int i = firstAffectedRow; i <= lastAffectedRow; ++i) {
                Row row = sheet.getRow(i);
                if (row != null) {
                    if (row.getZeroHeight()) {
                        _rowH[i] = 0.0f;
                        continue;
                    }
                    _rowH[i] = row.getHeightInPoints();
                    continue;
                }
                _rowH[i] = sheet.getDefaultRowHeightInPoints();
            }
            this.setRowH(_rowH);
        }
        if (this.hasSheetOverlays()) {
            this.reloadImageSizesFromPOI = true;
        }
        ArrayList<Cell> cellsToUpdate = new ArrayList<Cell>();
        for (int r = firstAffectedRow - 1; r <= lastAffectedRow + 1; ++r) {
            int c;
            if (r < 0) {
                r = 0;
            }
            Row row = sheet.getRow(r);
            Integer rowIndex = new Integer(r + 1);
            ArrayList<Integer> _hiddenRowIndexes = new ArrayList<Integer>(this.getHiddenRowIndexes());
            if (row == null) {
                this.valueManager.updateDeletedRowsInClientCache(rowIndex, rowIndex);
                if (_hiddenRowIndexes.contains(rowIndex)) {
                    _hiddenRowIndexes.remove(rowIndex);
                }
                for (c = 0; c < this.getCols(); ++c) {
                    this.styler.clearCellStyle(r, c);
                }
            } else {
                if (row.getZeroHeight()) {
                    _hiddenRowIndexes.add(rowIndex);
                } else if (_hiddenRowIndexes.contains(rowIndex)) {
                    _hiddenRowIndexes.remove(rowIndex);
                }
                for (c = 0; c < this.getCols(); ++c) {
                    Cell cell = row.getCell(c);
                    if (cell == null) {
                        this.styler.clearCellStyle(r, c);
                        if (r > lastNonBlankRow + n) continue;
                        cell = row.createCell(c);
                        cellsToUpdate.add(cell);
                        continue;
                    }
                    cellsToUpdate.add(cell);
                }
            }
            this.setHiddenRowIndexes(_hiddenRowIndexes);
        }
        this.rowsMoved(firstAffectedRow, lastAffectedRow, n);
        for (Cell cell : cellsToUpdate) {
            this.styler.cellStyleUpdated(cell, false);
            this.markCellAsUpdated(cell, false);
        }
        this.styler.loadCustomBorderStylesToState();
        this.updateMarkedCells();
        this.updateRowAndColumnRangeCellData(this.firstRow, this.firstColumn, this.lastRow, this.lastColumn);
        this.updateMergedRegions();
        CellReference selectedCellReference = this.selectionManager.getSelectedCellReference();
        if (selectedCellReference != null && selectedCellReference.getRow() >= firstAffectedRow && selectedCellReference.getRow() <= lastAffectedRow) {
            this.selectionManager.onSheetAddressChanged(selectedCellReference.formatAsString(), false);
        }
    }

    private boolean hasSheetOverlays() {
        return this.sheetOverlays != null && this.sheetOverlays.size() > 0;
    }

    private int getColumnAutofitPixelWidth(int columnIndex, int autofitWidth) {
        List<SpreadsheetTable> tablesForActiveSheet = this.getTablesForActiveSheet();
        CellReference cr = new CellReference(this.getActiveSheet().getSheetName(), 0, columnIndex, true, true);
        this.autofittedColumnWidths.put(cr, autofitWidth);
        for (SpreadsheetTable st : tablesForActiveSheet) {
            SpreadsheetFilterTable ft;
            PopupButton popupButton;
            if (!(st instanceof SpreadsheetFilterTable) || (popupButton = (ft = (SpreadsheetFilterTable)st).getPopupButton(cr)) == null) continue;
            return autofitWidth + 14 + 2;
        }
        return autofitWidth;
    }

    private void rowsMoved(int first, int last, int n) {
        int activeSheetIndex;
        HashSet<String> original;
        int col;
        if (n < 0) {
            for (int row = first + n; row <= first; ++row) {
                Sheet sheet = this.getActiveSheet();
                for (int i = 0; i < sheet.getNumMergedRegions(); ++i) {
                    CellRangeAddress mergedRegion = sheet.getMergedRegion(i);
                    if (mergedRegion.getFirstRow() != row) continue;
                    this.removeMergedRegion(i);
                }
            }
        }
        if (!this.sheetPopupButtons.isEmpty()) {
            HashMap<CellReference, PopupButton> updated = new HashMap<CellReference, PopupButton>();
            for (PopupButton pbutton : this.sheetPopupButtons.values()) {
                CellReference cell = pbutton.getCellReference();
                this.unRegisterPopupButton(pbutton);
                int row = cell.getRow();
                if (this.rowWasRemoved(row, first, n)) continue;
                if (this.numberOfRowsAboveWasChanged(row, last, first)) {
                    int newRow = cell.getRow() + n;
                    col = cell.getCol();
                    CellReference newCell = new CellReference(newRow, col, true, true);
                    pbutton.setCellReference(newCell);
                    updated.put(newCell, pbutton);
                    continue;
                }
                updated.put(cell, pbutton);
            }
            this.sheetPopupButtons = updated;
        }
        if ((original = this.invalidFormulas.get(activeSheetIndex = this.workbook.getActiveSheetIndex())) != null) {
            HashSet<String> updated = new HashSet<String>();
            for (String key : original) {
                int row = SpreadsheetUtil.getRowFromKey(key) - 1;
                col = SpreadsheetUtil.getColumnIndexFromKey(key) - 1;
                if (this.rowWasRemoved(row, first, n)) continue;
                if (this.numberOfRowsAboveWasChanged(row, last, first)) {
                    updated.add(SpreadsheetUtil.toKey(col + 1, row + n + 1));
                    continue;
                }
                updated.add(key);
            }
            original.clear();
            this.invalidFormulas.put(activeSheetIndex, updated);
        }
    }

    private boolean numberOfRowsAboveWasChanged(int row, int last, int first) {
        return first <= row && row <= last;
    }

    private boolean rowWasRemoved(int row, int first, int n) {
        return n < 0 && first + n < row && row <= first;
    }

    public FormulaEvaluator getFormulaEvaluator() {
        return this.formulaEvaluator;
    }

    public ConditionalFormattingEvaluator getConditionalFormattingEvaluator() {
        return this.conditionalFormattingEvaluator;
    }

    private int getLastNonBlankRow(Sheet sheet) {
        for (int r = sheet.getLastRowNum(); r >= 0; --r) {
            Row row = sheet.getRow(r);
            if (row == null) continue;
            for (short c = row.getFirstCellNum(); c < row.getLastCellNum(); c = (short)(c + 1)) {
                Cell cell = row.getCell((int)c);
                if (cell == null || cell.getCellType() == CellType.BLANK) continue;
                return r;
            }
        }
        return 0;
    }

    private void updateMergedRegions() {
        int regions = this.getActiveSheet().getNumMergedRegions();
        if (regions > 0) {
            ArrayList<MergedRegion> _mergedRegions = new ArrayList<MergedRegion>();
            for (int i = 0; i < regions; ++i) {
                CellRangeAddress region = this.getActiveSheet().getMergedRegion(i);
                try {
                    MergedRegion mergedRegion = new MergedRegion();
                    mergedRegion.col1 = region.getFirstColumn() + 1;
                    mergedRegion.col2 = region.getLastColumn() + 1;
                    mergedRegion.row1 = region.getFirstRow() + 1;
                    mergedRegion.row2 = region.getLastRow() + 1;
                    ++this.mergedRegionCounter;
                    mergedRegion.id = mergedRegion.id;
                    _mergedRegions.add(i, mergedRegion);
                    continue;
                }
                catch (IndexOutOfBoundsException ioobe) {
                    this.createMergedRegionIntoSheet(region);
                }
            }
            while (regions < _mergedRegions.size()) {
                _mergedRegions.remove(_mergedRegions.size() - 1);
            }
            this.setMergedRegions(_mergedRegions);
        } else {
            this.setMergedRegions(null);
        }
    }

    public void deleteRows(int startRow, int endRow) {
        Sheet sheet = this.getActiveSheet();
        for (int i = startRow; i <= endRow; ++i) {
            Row row = sheet.getRow(i);
            if (row == null) continue;
            this.getActiveSheet().removeRow(row);
        }
        float[] _rowH = Arrays.copyOf(this.getRowH(), this.getRowH().length);
        for (int i = startRow; i <= endRow; ++i) {
            _rowH[i] = sheet.getDefaultRowHeightInPoints();
        }
        this.setRowH(_rowH);
        this.updateMergedRegions();
        this.valueManager.updateDeletedRowsInClientCache(startRow + 1, endRow + 1);
        if (this.hasSheetOverlays()) {
            this.reloadImageSizesFromPOI = true;
        }
        this.updateMarkedCells();
        CellReference selectedCellReference = this.getSelectedCellReference();
        if (selectedCellReference.getRow() >= startRow && selectedCellReference.getRow() <= endRow) {
            this.selectionManager.reSelectSelectedCell();
        }
    }

    public void addMergedRegion(String selectionRange) {
        this.addMergedRegion(CellRangeAddress.valueOf((String)selectionRange));
    }

    public void addMergedRegion(int row1, int col1, int row2, int col2) {
        this.addMergedRegion(new CellRangeAddress(row1, row2, col1, col2));
    }

    public void addMergedRegion(CellRangeAddress region) throws IllegalArgumentException {
        Sheet sheet = this.getActiveSheet();
        int index = 0;
        while (index < sheet.getNumMergedRegions()) {
            CellRangeAddress existingRegion = sheet.getMergedRegion(index);
            int intersect = CellRangeUtil.intersect((CellRangeAddress)region, (CellRangeAddress)existingRegion);
            if (intersect == 3) {
                this.deleteMergedRegion(index);
                continue;
            }
            if (intersect == 2 || intersect == 4) {
                throw new IllegalArgumentException("An existing region " + existingRegion + " " + (intersect == 2 ? "overlaps " : "encloses ") + "the given region " + region);
            }
            ++index;
        }
        this.createMergedRegionIntoSheet(region);
        this.selectionManager.mergedRegionAdded(region);
    }

    private void createMergedRegionIntoSheet(CellRangeAddress region) {
        Sheet sheet = this.getActiveSheet();
        sheet.addMergedRegion(region);
        MergedRegion mergedRegion = new MergedRegion();
        mergedRegion.col1 = region.getFirstColumn() + 1;
        mergedRegion.col2 = region.getLastColumn() + 1;
        mergedRegion.row1 = region.getFirstRow() + 1;
        mergedRegion.row2 = region.getLastRow() + 1;
        mergedRegion.id = this.mergedRegionCounter++;
        ArrayList<MergedRegion> _mergedRegions = this.getMergedRegions() != null ? new ArrayList<MergedRegion>(this.getMergedRegions()) : new ArrayList();
        _mergedRegions.add(mergedRegion);
        this.setMergedRegions(_mergedRegions);
        for (int r = mergedRegion.row1; r <= mergedRegion.row2 + 1; ++r) {
            Row row = sheet.getRow(r - 1);
            for (int c = mergedRegion.col1; c <= mergedRegion.col2 + 1; ++c) {
                Cell cell;
                if (row == null || (cell = row.getCell(c - 1)) == null) continue;
                this.styler.cellStyleUpdated(cell, false);
                if (c == mergedRegion.col1 && r == mergedRegion.row1 || c > mergedRegion.col2 || r > mergedRegion.row2) continue;
                this.getCellValueManager().markCellForRemove(cell);
            }
        }
        this.styler.loadCustomBorderStylesToState();
        this.updateMarkedCells();
    }

    public void removeMergedRegion(int index) {
        CellRangeAddress removedRegion = this.getActiveSheet().getMergedRegion(index);
        this.deleteMergedRegion(index);
        this.updateMarkedCells();
        this.selectionManager.mergedRegionRemoved(removedRegion);
    }

    private void deleteMergedRegion(int index) {
        Sheet sheet = this.getActiveSheet();
        sheet.removeMergedRegion(index);
        ArrayList<MergedRegion> _mergedRegions = new ArrayList<MergedRegion>(this.getMergedRegions());
        MergedRegion mergedRegion = _mergedRegions.remove(index);
        for (int r = mergedRegion.row1; r <= mergedRegion.row2 + 1; ++r) {
            Row row = sheet.getRow(r - 1);
            if (row == null) continue;
            for (int c = mergedRegion.col1; c <= mergedRegion.col2 + 1; ++c) {
                Cell cell = row.getCell(c - 1);
                if (cell != null) {
                    this.styler.cellStyleUpdated(cell, false);
                    this.valueManager.markCellForUpdate(cell);
                    continue;
                }
                this.styler.clearCellStyle(r, c);
            }
        }
        this.setMergedRegions(_mergedRegions);
        this.styler.loadCustomBorderStylesToState();
    }

    public void reloadAllMergedRegions() {
        SpreadsheetFactory.loadMergedRegions(this);
    }

    public void reloadActiveSheetStyles() {
        this.styler.reloadActiveSheetCellStyles();
    }

    public void setColumnHidden(int columnIndex, boolean hidden) {
        this.getActiveSheet().setColumnHidden(columnIndex, hidden);
        ArrayList<Integer> _hiddenColumnIndexes = new ArrayList<Integer>(this.getHiddenColumnIndexes());
        int[] _colW = Arrays.copyOf(this.getColW(), this.getColW().length);
        if (hidden && !_hiddenColumnIndexes.contains(columnIndex + 1)) {
            _hiddenColumnIndexes.add(columnIndex + 1);
            _colW[columnIndex] = 0;
        } else if (!hidden && _hiddenColumnIndexes.contains(columnIndex + 1)) {
            _hiddenColumnIndexes.remove(_hiddenColumnIndexes.indexOf(columnIndex + 1));
            _colW[columnIndex] = (int)this.getActiveSheet().getColumnWidthInPixels(columnIndex);
            this.getCellValueManager().clearCacheForColumn(columnIndex + 1);
            this.getCellValueManager().loadCellData(this.firstRow, columnIndex + 1, this.lastRow, columnIndex + 1);
        }
        this.setHiddenColumnIndexes(_hiddenColumnIndexes);
        this.setColW(_colW);
        if (this.hasSheetOverlays()) {
            this.reloadImageSizesFromPOI = true;
            this.loadOrUpdateOverlays();
        }
        this.getSpreadsheetStyleFactory().reloadActiveSheetCellStyles();
    }

    public boolean isColumnHidden(int columnIndex) {
        return this.getActiveSheet().isColumnHidden(columnIndex);
    }

    public void setRowHidden(int rowIndex, boolean hidden) {
        Sheet activeSheet = this.getActiveSheet();
        Row row = activeSheet.getRow(rowIndex);
        if (row == null) {
            row = activeSheet.createRow(rowIndex);
        }
        row.setZeroHeight(hidden);
        SpreadsheetFactory.calculateSheetSizes(this, this.getActiveSheet());
        if (this.hasSheetOverlays()) {
            this.reloadImageSizesFromPOI = true;
            this.loadOrUpdateOverlays();
        }
        this.getSpreadsheetStyleFactory().reloadActiveSheetCellStyles();
    }

    public boolean isRowHidden(int rowIndex) {
        Row row = this.getActiveSheet().getRow(rowIndex);
        return row == null ? false : row.getZeroHeight();
    }

    public void read(File file) throws IOException {
        SpreadsheetFactory.reloadSpreadsheetComponent(this, file);
    }

    public void read(InputStream inputStream) throws IOException {
        SpreadsheetFactory.reloadSpreadsheetComponent(this, inputStream);
    }

    public File write(String fileName) throws FileNotFoundException, IOException {
        return SpreadsheetFactory.write(this, fileName);
    }

    public void write(OutputStream outputStream) throws IOException {
        SpreadsheetFactory.write(this, outputStream);
    }

    public int getRowBufferSize() {
        return this.rowBufferSize;
    }

    public void setRowBufferSize(int rowBufferInPixels) {
        this.rowBufferSize = rowBufferInPixels;
        this.getElement().setProperty("rowBufferSize", (double)rowBufferInPixels);
    }

    public int getColBufferSize() {
        return this.columnBufferSize;
    }

    public void setColBufferSize(int colBufferInPixels) {
        this.columnBufferSize = colBufferInPixels;
        this.getElement().setProperty("columnBufferSize", (double)this.columnBufferSize);
    }

    public int getDefaultRowCount() {
        return this.defaultNewSheetRows;
    }

    public void setDefaultRowCount(int defaultRowCount) {
        this.defaultNewSheetRows = defaultRowCount;
    }

    public int getDefaultColumnCount() {
        return this.defaultNewSheetColumns;
    }

    public void setDefaultColumnCount(int defaultColumnCount) {
        this.defaultNewSheetColumns = defaultColumnCount;
    }

    public void reloadVisibleCellContents() {
        this.loadCustomComponents();
        this.updateRowAndColumnRangeCellData(this.firstRow, this.firstColumn, this.lastRow, this.lastColumn);
    }

    protected void setResource(String key, StreamResource resource) {
        if (resource == null) {
            this.resources.remove(key);
            this.getElement().removeAttribute("resource-" + key);
        } else {
            this.resources.put(key, resource.toString());
            this.getElement().setProperty("resources", Serializer.serialize(new ArrayList<String>(this.resources.keySet())));
            this.getElement().setAttribute("resource-" + key, (AbstractStreamResource)resource);
        }
    }

    void clearSheetServerSide() {
        this.workbook = null;
        this.styler = null;
        this.valueManager.clearCachedContent();
        this.selectionManager.clear();
        this.historyManager.clear();
        this.invalidFormulas.clear();
        this.sheetPopupButtons.clear();
        this.sheetState.clear();
        this.clearSheetOverlays();
    }

    private void clearSheetOverlays() {
        for (SheetOverlayWrapper image : this.sheetOverlays) {
            this.removeOverlayData(image);
        }
        this.sheetOverlays.clear();
    }

    void setInternalWorkbook(Workbook workbook) {
        this.workbook = workbook;
        this.formulaEvaluator = workbook.getCreationHelper().createFormulaEvaluator();
        this.conditionalFormattingEvaluator = new ConditionalFormattingEvaluator(workbook, (WorkbookEvaluatorProvider)((BaseFormulaEvaluator)this.formulaEvaluator));
        this.styler = this.createSpreadsheetStyleFactory();
        this.reloadActiveSheetData();
        if (workbook instanceof HSSFWorkbook) {
            this.setWorkbookProtected(((HSSFWorkbook)workbook).isWriteProtected());
        } else if (workbook instanceof XSSFWorkbook) {
            this.setWorkbookProtected(((XSSFWorkbook)workbook).isStructureLocked());
        }
        this.tables.clear();
        this.setVerticalScrollPositions(new int[this.getSheetNames().length]);
        this.setHorizontalScrollPositions(new int[this.getSheetNames().length]);
        this.conditionalFormatter = this.createConditionalFormatter();
        this.setWorkbookChangeToggle(!this.isWorkbookChangeToggle());
    }

    protected ConditionalFormatter createConditionalFormatter() {
        return new ConditionalFormatter(this);
    }

    protected SpreadsheetStyleFactory createSpreadsheetStyleFactory() {
        return new SpreadsheetStyleFactory(this);
    }

    protected void reloadActiveSheetData() {
        this.selectionManager.clear();
        this.valueManager.clearCachedContent();
        this.lastRow = -1;
        this.firstRow = -1;
        this.lastColumn = -1;
        this.firstColumn = -1;
        this.clearSheetOverlays();
        this.topLeftCellCommentsLoaded = false;
        Optional.ofNullable(UI.getCurrent()).ifPresent(ui -> ui.beforeClientResponse((Component)this, (SerializableConsumer & Serializable)e -> {
            if (this.reload) {
                this.updateReloadState();
            }
        }));
        this.reload = true;
        this.setSheetIndex(this.getSpreadsheetSheetIndex(this.workbook.getActiveSheetIndex()) + 1);
        this.setSheetProtected(this.getActiveSheet().getProtect());
        this.setCellKeysToEditorIdMap(null);
        this.setHyperlinksTooltips(null);
        this.setComponentIDtoCellKeysMap(null);
        this.setOverlays(null);
        this.setMergedRegions(null);
        this.setCellComments(null);
        this.setCellCommentAuthors(null);
        this.setVisibleCellComments(null);
        this.setInvalidFormulaCells(null);
        for (Component c : this.customComponents) {
            this.unRegisterCustomComponent(c);
        }
        this.customComponents.clear();
        if (this.attachedPopupButtons != null && !this.attachedPopupButtons.isEmpty()) {
            for (PopupButton sf : new ArrayList<PopupButton>(this.attachedPopupButtons)) {
                this.unRegisterPopupButton(sf);
            }
            this.attachedPopupButtons.clear();
        }
        this.tablesLoaded = false;
        this.reloadSheetNames();
        this.updateMergedRegions();
        this.styler.reloadActiveSheetColumnRowStyles();
        this.setDisplayGridlines(this.getActiveSheet().isDisplayGridlines());
        this.setDisplayRowColHeadings(this.getActiveSheet().isDisplayRowColHeadings());
        this.markAsDirty();
    }

    private void markAsDirty() {
        this.getElement().setProperty("dirty", (double)System.currentTimeMillis());
    }

    protected void loadCustomEditorOnSelectedCell() {
        CellReference selectedCellReference = this.selectionManager.getSelectedCellReference();
        if (selectedCellReference != null && this.customComponentFactory != null) {
            short col = selectedCellReference.getCol();
            int row = selectedCellReference.getRow();
            String key = SpreadsheetUtil.toKey(col + 1, row + 1);
            HashMap<String, String> cellKeysToEditorIdMap = new HashMap<String, String>(this.getCellKeysToEditorIdMap());
            if (cellKeysToEditorIdMap != null && cellKeysToEditorIdMap.containsKey(key) && this.customComponents != null) {
                String componentId = cellKeysToEditorIdMap.get(key);
                for (Component c : this.customComponents) {
                    if (!c.getId().orElse("").equals(componentId)) continue;
                    this.customComponentFactory.onCustomEditorDisplayed(this.getCell(row, col), row, col, this, this.getActiveSheet(), c);
                    return;
                }
            }
            this.setCellKeysToEditorIdMap(cellKeysToEditorIdMap);
        }
    }

    private void reloadSheetNames() {
        ArrayList<String> sheetNamesList = new ArrayList<String>();
        for (int i = 0; i < this.workbook.getNumberOfSheets(); ++i) {
            if (this.workbook.isSheetVeryHidden(i) || this.workbook.isSheetHidden(i)) continue;
            sheetNamesList.add(this.workbook.getSheetName(i));
        }
        this.setSheetNames(sheetNamesList.toArray(new String[sheetNamesList.size()]));
    }

    public int getVisibleSheetPOIIndex(int visibleSheetIndex) {
        int realIndex = -1;
        int i = -1;
        do {
            if (this.workbook.isSheetVeryHidden(++realIndex) || this.workbook.isSheetHidden(realIndex)) continue;
            ++i;
        } while (i < visibleSheetIndex && realIndex < this.workbook.getNumberOfSheets() - 1);
        return realIndex;
    }

    private int getSpreadsheetSheetIndex(int poiSheetIndex) {
        int ourIndex = -1;
        for (int i = 0; i <= poiSheetIndex; ++i) {
            if (this.workbook.isSheetVeryHidden(i) || this.workbook.isSheetHidden(i)) continue;
            ++ourIndex;
        }
        return ourIndex;
    }

    public boolean isSheetProtected(int poiSheetIndex) {
        return this.workbook.getSheetAt(poiSheetIndex).getProtect();
    }

    public boolean isActiveSheetProtected() {
        return this.isSheetProtected();
    }

    public boolean isCellHidden(Cell cell) {
        return this.isActiveSheetProtected() && cell.getCellStyle().getHidden();
    }

    @Deprecated(since="23.6", forRemoval=true)
    public boolean isCellLocked(Cell cell) {
        if (this.isActiveSheetProtected()) {
            if (cell != null) {
                if (cell.getCellStyle().getIndex() != 0) {
                    return cell.getCellStyle().getLocked();
                }
                return this.getLockedColumnIndexes().contains(cell.getColumnIndex() + 1) && this.getLockedRowIndexes().contains(cell.getRowIndex() + 1);
            }
            return true;
        }
        return false;
    }

    public boolean isCellLocked(CellAddress cellAddress) {
        Cell cell;
        if (!this.isActiveSheetProtected()) {
            return false;
        }
        Sheet sheet = this.getActiveSheet();
        Row row = sheet.getRow(cellAddress.getRow());
        Cell cell2 = cell = row != null ? row.getCell(cellAddress.getColumn()) : null;
        if (cell != null && cell.getCellStyle().getIndex() != 0) {
            return cell.getCellStyle().getLocked();
        }
        CellStyle rowStyle = row != null ? row.getRowStyle() : null;
        CellStyle columnStyle = sheet.getColumnStyle(cellAddress.getColumn());
        boolean rowLocked = rowStyle == null || rowStyle.getLocked();
        boolean columnLocked = columnStyle == null || columnStyle.getLocked();
        return rowLocked && columnLocked;
    }

    protected SpreadsheetClientRpc getRpcProxy() {
        return this.clientRpc;
    }

    private void updateReloadState() {
        if (this.reload) {
            this.setReload(this.reload);
            this.reload = false;
            if (this.initialSheetSelection == null) {
                this.initialSheetSelection = this.sheetState.getSelectedCellsOnSheet(this.getActiveSheet()) == null ? "A1" : this.sheetState.getSelectedCellsOnSheet(this.getActiveSheet());
            }
        } else {
            this.setReload(this.reload);
        }
    }

    public SpreadsheetStyleFactory getSpreadsheetStyleFactory() {
        return this.styler;
    }

    public Workbook getWorkbook() {
        return this.workbook;
    }

    public void setWorkbook(Workbook workbook) {
        if (workbook == null) {
            throw new NullPointerException("Cannot open a null workbook with Spreadsheet component.");
        }
        SpreadsheetFactory.reloadSpreadsheetComponent(this, workbook);
    }

    public Sheet getActiveSheet() {
        return this.workbook.getSheetAt(this.workbook.getActiveSheetIndex());
    }

    private void updateRowAndColumnRangeCellData(int r1, int c1, int r2, int c2) {
        this.loadHyperLinks();
        this.loadCellComments();
        this.loadOrUpdateOverlays();
        this.loadPopupButtons();
        this.valueManager.loadCellData(r1, c1, r2, c2);
    }

    protected void loadCells(int firstRow, int firstColumn, int lastRow, int lastColumn) {
        this.loadCustomComponents();
        this.loadHyperLinks();
        this.loadCellComments();
        this.loadOrUpdateOverlays();
        this.loadTables();
        this.loadPopupButtons();
        this.valueManager.loadCellData(firstRow, firstColumn, lastRow, lastColumn);
        this.loadCustomEditorOnSelectedCell();
    }

    void onLinkCellClick(int row, int column) {
        Cell cell = this.getActiveSheet().getRow(row - 1).getCell(column - 1);
        if (this.hyperlinkCellClickHandler != null) {
            this.hyperlinkCellClickHandler.onHyperLinkCellClick(cell, cell.getHyperlink());
        }
    }

    void onRowResized(Map<Integer, Float> newRowSizes, int row1, int col1, int row2, int col2) {
        SizeChangeCommand command = new SizeChangeCommand(this, SizeChangeCommand.Type.ROW);
        command.captureValues(newRowSizes.keySet().toArray(new Integer[newRowSizes.size()]));
        this.historyManager.addCommand(command);
        for (Map.Entry<Integer, Float> entry : newRowSizes.entrySet()) {
            int index = entry.getKey();
            float height = entry.getValue().floatValue();
            this.setRowHeight(index - 1, height);
        }
        if (this.hasSheetOverlays()) {
            this.reloadImageSizesFromPOI = true;
        }
        this.loadCells(row1, col1, row2, col2);
    }

    public void setRowHeight(int index, float height) {
        if (height == 0.0f) {
            this.setRowHidden(index, true);
        } else {
            Row row = this.getActiveSheet().getRow(index);
            ArrayList<Integer> _hiddenRowIndexes = new ArrayList<Integer>(this.getHiddenRowIndexes());
            if (_hiddenRowIndexes.contains(index + 1)) {
                _hiddenRowIndexes.remove((Object)(index + 1));
                if (row != null && row.getZeroHeight()) {
                    row.setZeroHeight(false);
                }
            }
            if (row == null) {
                row = this.getActiveSheet().createRow(index);
            }
            row.setHeightInPoints(height);
            this.setHiddenRowIndexes(_hiddenRowIndexes);
            SpreadsheetFactory.calculateSheetSizes(this, this.getActiveSheet());
        }
    }

    void onColumnResized(Map<Integer, Integer> newColumnSizes, int row1, int col1, int row2, int col2) {
        SizeChangeCommand command = new SizeChangeCommand(this, SizeChangeCommand.Type.COLUMN);
        command.captureValues(newColumnSizes.keySet().toArray(new Integer[newColumnSizes.size()]));
        this.historyManager.addCommand(command);
        for (Map.Entry<Integer, Integer> entry : newColumnSizes.entrySet()) {
            int index = entry.getKey();
            int width = entry.getValue();
            this.setColumnWidth(index - 1, width);
        }
        if (this.hasSheetOverlays()) {
            this.reloadImageSizesFromPOI = true;
        }
        this.loadCells(row1, col1, row2, col2);
    }

    public void setColumnWidth(int index, int width) {
        if (width == 0) {
            this.setColumnHidden(index, true);
        } else {
            ArrayList<Integer> _hiddenColumnIndexes = new ArrayList<Integer>(this.getHiddenColumnIndexes());
            int[] _colW = Arrays.copyOf(this.getColW(), this.getColW().length);
            if (_hiddenColumnIndexes.contains(index + 1)) {
                _hiddenColumnIndexes.remove((Object)(index + 1));
            }
            if (this.getActiveSheet().isColumnHidden(index)) {
                this.getActiveSheet().setColumnHidden(index, false);
            }
            _colW[index] = width;
            this.setColW(_colW);
            this.setHiddenColumnIndexes(_hiddenColumnIndexes);
            this.getActiveSheet().setColumnWidth(index, (int)SpreadsheetUtil.pixel2WidthUnits(width));
            if (this.getActiveSheet() instanceof XSSFSheet) {
                ((XSSFSheet)this.getActiveSheet()).getColumnHelper().cleanColumns();
            }
            this.getCellValueManager().clearCacheForColumn(index + 1);
            this.getCellValueManager().loadCellData(this.firstRow, index + 1, this.lastRow, index + 1);
        }
    }

    void loadHyperLinks() {
        HashMap<String, String> _hyperlinksTooltips;
        HashMap<String, String> hashMap = _hyperlinksTooltips = this.getHyperlinksTooltips() != null ? new HashMap<String, String>(this.getHyperlinksTooltips()) : null;
        if (_hyperlinksTooltips == null) {
            _hyperlinksTooltips = new HashMap();
        } else {
            _hyperlinksTooltips.clear();
        }
        this.setHyperlinksTooltips(_hyperlinksTooltips);
        if (this.getLastFrozenRow() > 0 && this.getLastFrozenColumn() > 0) {
            this.loadHyperLinks(1, 1, this.getLastFrozenRow(), this.getLastFrozenColumn());
        }
        if (this.getLastFrozenRow() > 0) {
            this.loadHyperLinks(1, this.firstColumn, this.getLastFrozenRow(), this.lastColumn);
        }
        if (this.getLastFrozenColumn() > 0) {
            this.loadHyperLinks(this.firstRow, 1, this.lastRow, this.getLastFrozenColumn());
        }
        this.loadHyperLinks(this.firstRow, this.firstColumn, this.lastRow, this.lastColumn);
    }

    private void loadHyperLinks(int r1, int c1, int r2, int c2) {
        HashMap<String, String> _hyperlinksTooltips = this.getHyperlinksTooltips();
        for (int r = r1 - 1; r < r2; ++r) {
            Row row = this.getActiveSheet().getRow(r);
            if (row == null) continue;
            for (int c = c1 - 1; c < c2; ++c) {
                Cell cell = row.getCell(c);
                if (cell == null) continue;
                try {
                    Hyperlink link = cell.getHyperlink();
                    if (link != null) {
                        if (link instanceof XSSFHyperlink) {
                            String tooltip = ((XSSFHyperlink)link).getTooltip();
                            if (tooltip == null) {
                                tooltip = link.getAddress();
                            }
                            _hyperlinksTooltips.put(SpreadsheetUtil.toKey(c + 1, r + 1), tooltip);
                            continue;
                        }
                        _hyperlinksTooltips.put(SpreadsheetUtil.toKey(c + 1, r + 1), link.getAddress());
                        continue;
                    }
                    if (!DefaultHyperlinkCellClickHandler.isHyperlinkFormulaCell(cell) || this.hyperlinkCellClickHandler == null) continue;
                    _hyperlinksTooltips.put(SpreadsheetUtil.toKey(c + 1, r + 1), this.hyperlinkCellClickHandler.getHyperlinkFunctionTarget(cell));
                    continue;
                }
                catch (XmlValueDisconnectedException exc) {
                    LOGGER.trace(exc.getMessage(), (Throwable)exc);
                }
            }
        }
        this.setHyperlinksTooltips(_hyperlinksTooltips);
    }

    private void loadOrUpdateOverlays() {
        if (!this.hasSheetOverlays()) {
            SpreadsheetFactory.loadSheetOverlays(this);
        }
        if (this.hasSheetOverlays()) {
            if (this.reloadImageSizesFromPOI) {
                this.clearSheetOverlays();
                SpreadsheetFactory.loadSheetOverlays(this);
                this.reloadImageSizesFromPOI = false;
            }
            for (SheetOverlayWrapper overlay : this.sheetOverlays) {
                if (this.isOverlayVisible(overlay)) {
                    this.addOverlayData(overlay);
                    overlay.setVisible(true);
                    continue;
                }
                if (!overlay.isVisible()) continue;
                this.removeOverlayData(overlay);
                overlay.setVisible(false);
            }
        }
    }

    private void addOverlayData(SheetOverlayWrapper overlay) {
        if (overlay.getComponent(true) != null) {
            this.registerCustomComponent(overlay.getComponent(true));
            this.overlayComponents.add(overlay.getComponent(true));
        }
        if (overlay.getId() != null && overlay.getResource() != null) {
            this.setResource(overlay.getId(), overlay.getResource());
        }
        if (overlay.getId() != null) {
            HashMap<String, OverlayInfo> _overlays = this.getOverlays() != null ? new HashMap<String, OverlayInfo>(this.getOverlays()) : new HashMap();
            _overlays.put(overlay.getId(), this.createOverlayInfo(overlay));
            this.setOverlays(_overlays);
            overlay.setOverlayChangeListener(new SheetOverlayWrapper.OverlayChangeListener(){

                @Override
                public void overlayChanged() {
                    Spreadsheet.this.loadOrUpdateOverlays();
                }
            });
        }
    }

    private void removeOverlayData(SheetOverlayWrapper overlay) {
        if (overlay.getId() != null) {
            if (this.getOverlays() != null) {
                HashMap<String, OverlayInfo> _overlays = this.getOverlays();
                _overlays.remove(overlay.getId());
                this.setOverlays(_overlays);
            }
            this.setResource(overlay.getId(), null);
        }
        if (overlay.getComponent(false) != null) {
            this.overlayComponents.remove(overlay.getComponent(false));
            this.unRegisterCustomComponent(overlay.getComponent(false));
        }
    }

    private boolean isOverlayVisible(SheetOverlayWrapper overlay) {
        boolean isType2;
        ClientAnchor anchor = overlay.getAnchor();
        if (ClientAnchor.AnchorType.DONT_MOVE_AND_RESIZE.equals((Object)anchor.getAnchorType()) && anchor instanceof XSSFClientAnchor) {
            return true;
        }
        short col1 = anchor.getCol1();
        short col2 = anchor.getCol2();
        int row1 = anchor.getRow1();
        int row2 = anchor.getRow2();
        boolean bl = isType2 = col2 == 0 && row2 == 0;
        if (!isType2 && (this.isColumnRangeHidden(col1, col2) || this.isRowRangeHidden(row1, row2))) {
            return false;
        }
        int horizontalSplitPosition = this.getLastFrozenColumn();
        int verticalSplitPosition = this.getLastFrozenRow();
        boolean visibleInArea1 = horizontalSplitPosition > 0 && verticalSplitPosition > 0 && overlay.isVisible(1, 1, verticalSplitPosition, horizontalSplitPosition);
        boolean visibleInArea2 = horizontalSplitPosition > 0 && overlay.isVisible(this.firstRow, 1, this.lastRow, horizontalSplitPosition);
        boolean visibleInArea3 = verticalSplitPosition > 0 && overlay.isVisible(1, this.firstColumn, verticalSplitPosition, this.lastColumn);
        boolean visibleInArea4 = overlay.isVisible(this.firstRow, this.firstColumn, this.lastRow, this.lastColumn);
        return visibleInArea1 || visibleInArea2 || visibleInArea3 || visibleInArea4;
    }

    private boolean isRowRangeHidden(int row1, int row2) {
        for (int row = row1; row <= row2; ++row) {
            if (this.isRowHidden(row)) continue;
            return false;
        }
        return true;
    }

    private boolean isColumnRangeHidden(int col1, int col2) {
        for (int col = col1; col <= col2; ++col) {
            if (this.isColumnHidden(col)) continue;
            return false;
        }
        return true;
    }

    private OverlayInfo createOverlayInfo(SheetOverlayWrapper overlayWrapper) {
        OverlayInfo info = new OverlayInfo(overlayWrapper.getType());
        Sheet sheet = this.getActiveSheet();
        ClientAnchor anchor = overlayWrapper.getAnchor();
        if (ClientAnchor.AnchorType.DONT_MOVE_AND_RESIZE.equals((Object)anchor.getAnchorType()) && anchor instanceof XSSFClientAnchor) {
            info.col = 1;
            info.row = 1;
            XSSFClientAnchor xssfAnchor = (XSSFClientAnchor)anchor;
            info.dx = (Long)xssfAnchor.getPosition().getX() / 9525L;
            info.dy = (Long)xssfAnchor.getPosition().getY() / 12700L;
            info.width = xssfAnchor.getSize().getCx() / 9525L;
            info.height = xssfAnchor.getSize().getCy() / 12700L;
            return info;
        }
        int col = anchor.getCol1();
        while (this.isColumnHidden(col)) {
            ++col;
        }
        int row = anchor.getRow1();
        while (this.isRowHidden(row)) {
            ++row;
        }
        info.col = col + 1;
        info.row = row + 1;
        info.height = overlayWrapper.getHeight(sheet, this.getRowH());
        info.width = overlayWrapper.getWidth(sheet, this.getColW(), this.getDefColW());
        if (col == anchor.getCol1()) {
            info.dx = overlayWrapper.getDx1(sheet);
        }
        if (row == anchor.getRow1()) {
            info.dy = overlayWrapper.getDy1(sheet);
        }
        return info;
    }

    private void loadCellComments() {
        HashSet<String> _invalidFormulaCells;
        ArrayList<String> _visibleCellComments;
        HashMap<String, String> _cellCommentAuthors;
        HashMap<String, String> _cellComments;
        if (this.firstColumn == -1) {
            return;
        }
        HashMap<String, String> hashMap = _cellComments = this.getCellComments() != null ? new HashMap<String, String>(this.getCellComments()) : null;
        if (_cellComments == null) {
            _cellComments = new HashMap();
        } else {
            _cellComments.clear();
        }
        this.setCellComments(_cellComments);
        HashMap<String, String> hashMap2 = _cellCommentAuthors = this.getCellCommentAuthors() != null ? new HashMap<String, String>(this.getCellCommentAuthors()) : null;
        if (_cellCommentAuthors == null) {
            _cellCommentAuthors = new HashMap();
        } else {
            _cellCommentAuthors.clear();
        }
        this.setCellCommentAuthors(_cellCommentAuthors);
        ArrayList<String> arrayList = _visibleCellComments = this.getVisibleCellComments() != null ? new ArrayList<String>(this.getVisibleCellComments()) : null;
        if (_visibleCellComments == null) {
            _visibleCellComments = new ArrayList();
        } else {
            _visibleCellComments.clear();
        }
        this.setVisibleCellComments(_visibleCellComments);
        HashSet<String> hashSet = _invalidFormulaCells = this.getInvalidFormulaCells() != null ? new HashSet<String>(this.getInvalidFormulaCells()) : null;
        if (_invalidFormulaCells == null) {
            _invalidFormulaCells = new HashSet();
        } else {
            _invalidFormulaCells.clear();
        }
        this.setInvalidFormulaCells(_invalidFormulaCells);
        if (this.getLastFrozenRow() > 0 && this.getLastFrozenColumn() > 0 && !this.topLeftCellCommentsLoaded) {
            this.loadCellComments(1, 1, this.getLastFrozenRow(), this.getLastFrozenColumn());
        }
        if (this.getLastFrozenRow() > 0) {
            this.loadCellComments(1, this.firstColumn, this.getLastFrozenRow(), this.lastColumn);
        }
        if (this.getLastFrozenColumn() > 0) {
            this.loadCellComments(this.firstRow, 1, this.lastRow, this.getLastFrozenColumn());
        }
        this.loadCellComments(this.firstRow, this.firstColumn, this.lastRow, this.lastColumn);
    }

    private void loadCellComments(int r1, int c1, int r2, int c2) {
        Sheet sheet = this.getActiveSheet();
        HashMap<String, String> _cellComments = new HashMap<String, String>(this.getCellComments());
        HashMap<String, String> _cellCommentAuthors = new HashMap<String, String>(this.getCellCommentAuthors());
        ArrayList<String> _visibleCellComments = new ArrayList<String>(this.getVisibleCellComments());
        HashSet<String> _invalidFormulaCells = new HashSet<String>(this.getInvalidFormulaCells());
        for (int r = r1 - 1; r < r2; ++r) {
            Row row = sheet.getRow(r);
            if (row != null && row.getZeroHeight()) continue;
            for (int c = c1 - 1; c < c2; ++c) {
                if (sheet.isColumnHidden(c)) continue;
                int c_one_based = c + 1;
                int row_one_based = r + 1;
                MergedRegion region = this.mergedRegionContainer.getMergedRegion(c_one_based, row_one_based);
                if (region == null || region.col1 == c_one_based && region.row1 == row_one_based) {
                    Comment comment = sheet.getCellComment(new CellAddress(r, c));
                    String key = SpreadsheetUtil.toKey(c_one_based, row_one_based);
                    if (comment != null) {
                        _cellComments.put(key, comment.getString().getString());
                        _cellCommentAuthors.put(key, comment.getAuthor());
                        if (comment.isVisible()) {
                            _visibleCellComments.add(key);
                        }
                    }
                    if (!this.isMarkedAsInvalidFormula(c_one_based, row_one_based)) continue;
                    _invalidFormulaCells.add(key);
                    continue;
                }
                c = region.col2 - 1;
            }
        }
        this.setCellComments(_cellComments);
        this.setCellCommentAuthors(_cellCommentAuthors);
        this.setVisibleCellComments(_visibleCellComments);
        this.setInvalidFormulaCells(_invalidFormulaCells);
    }

    private void loadCustomComponents() {
        if (this.customComponentFactory != null) {
            HashMap<String, String> _componentIDtoCellKeysMap;
            HashMap<String, String> _cellKeysToEditorIdMap;
            HashMap<String, String> hashMap = _cellKeysToEditorIdMap = this.getCellKeysToEditorIdMap() != null ? new HashMap<String, String>(this.getCellKeysToEditorIdMap()) : null;
            if (_cellKeysToEditorIdMap == null) {
                _cellKeysToEditorIdMap = new HashMap();
            } else {
                _cellKeysToEditorIdMap.clear();
            }
            this.setCellKeysToEditorIdMap(_cellKeysToEditorIdMap);
            HashMap<String, String> hashMap2 = _componentIDtoCellKeysMap = this.getComponentIDtoCellKeysMap() != null ? new HashMap<String, String>(this.getComponentIDtoCellKeysMap()) : null;
            if (_componentIDtoCellKeysMap == null) {
                _componentIDtoCellKeysMap = new HashMap();
            } else {
                _componentIDtoCellKeysMap.clear();
            }
            this.setComponentIDtoCellKeysMap(_componentIDtoCellKeysMap);
            if (this.customComponents == null) {
                this.customComponents = new HashSet<Component>();
            }
            HashSet<Component> newCustomComponents = new HashSet<Component>();
            HashSet<Integer> rowsWithComponents = new HashSet<Integer>();
            int verticalSplitPosition = this.getLastFrozenRow();
            int horizontalSplitPosition = this.getLastFrozenColumn();
            if (verticalSplitPosition > 0 && horizontalSplitPosition > 0) {
                this.loadRangeComponents(newCustomComponents, rowsWithComponents, 1, 1, verticalSplitPosition, horizontalSplitPosition);
            }
            if (verticalSplitPosition > 0) {
                this.loadRangeComponents(newCustomComponents, rowsWithComponents, 1, this.firstColumn, verticalSplitPosition, this.lastColumn);
            }
            if (horizontalSplitPosition > 0) {
                this.loadRangeComponents(newCustomComponents, rowsWithComponents, this.firstRow, 1, this.lastRow, horizontalSplitPosition);
            }
            this.loadRangeComponents(newCustomComponents, rowsWithComponents, this.firstRow, this.firstColumn, this.lastRow, this.lastColumn);
            Iterator<Component> i = this.customComponents.iterator();
            while (i.hasNext()) {
                Component c = i.next();
                if (newCustomComponents.contains(c)) continue;
                this.unRegisterCustomComponent(c);
                i.remove();
            }
            this.customComponents = newCustomComponents;
            if (!rowsWithComponents.isEmpty()) {
                this.handleRowSizes(rowsWithComponents);
            }
        } else {
            this.setCellKeysToEditorIdMap(null);
            this.setComponentIDtoCellKeysMap(null);
            if (this.customComponents != null && !this.customComponents.isEmpty()) {
                for (Component c : this.customComponents) {
                    this.unRegisterCustomComponent(c);
                }
                this.customComponents.clear();
            }
            this.handleRowSizes(new HashSet<Integer>());
        }
    }

    void loadRangeComponents(HashSet<Component> newCustomComponents, Set<Integer> rowsWithComponents, int row1, int col1, int row2, int col2) {
        HashMap<String, String> _componentIDtoCellKeysMap = this.getComponentIDtoCellKeysMap();
        HashMap<String, String> _cellKeysToEditorIdMap = this.getCellKeysToEditorIdMap();
        for (int r = row1 - 1; r < row2; ++r) {
            Row row = this.getActiveSheet().getRow(r);
            for (int c = col1 - 1; c < col2; ++c) {
                MergedRegion region = this.mergedRegionContainer.getMergedRegion(c + 1, r + 1);
                if (region == null || region.col1 == c + 1 && region.row1 == r + 1) {
                    Component customEditor;
                    Component customComponent;
                    Cell cell = null;
                    if (row != null) {
                        cell = row.getCell(c);
                    }
                    if ((customComponent = this.customComponentFactory.getCustomComponentForCell(cell, r, c, this, this.getActiveSheet())) != null) {
                        String key = SpreadsheetUtil.toKey(c + 1, r + 1);
                        if (!this.customComponents.contains(customComponent)) {
                            this.registerCustomComponent(customComponent);
                        }
                        _componentIDtoCellKeysMap.put(customComponent.getId().orElse(""), key);
                        newCustomComponents.add(customComponent);
                        rowsWithComponents.add(r);
                    } else if (!this.isCellLocked(new CellAddress(r, c)) && (customEditor = this.customComponentFactory.getCustomEditorForCell(cell, r, c, this, this.getActiveSheet())) != null) {
                        String key = SpreadsheetUtil.toKey(c + 1, r + 1);
                        if (!newCustomComponents.contains(customEditor) && !this.customComponents.contains(customEditor)) {
                            this.registerCustomComponent(customEditor);
                        }
                        _cellKeysToEditorIdMap.put(key, customEditor.getId().orElse(""));
                        newCustomComponents.add(customEditor);
                        rowsWithComponents.add(r);
                    }
                }
                if (region == null) continue;
                c = region.col2 - 1;
            }
        }
        this.setCellKeysToEditorIdMap(_cellKeysToEditorIdMap);
        this.setComponentIDtoCellKeysMap(_componentIDtoCellKeysMap);
    }

    private void handleRowSizes(Set<Integer> rowsWithComponents) {
        float[] _rowH = Arrays.copyOf(this.getRowH(), this.getRowH().length);
        for (Integer row : rowsWithComponents) {
            float currentHeight;
            if (this.isRowHidden(row) || !((currentHeight = _rowH[row]) < (float)this.getMinimumRowHeightForComponents())) continue;
            _rowH[row.intValue()] = this.getMinimumRowHeightForComponents();
        }
        if (this.rowsWithComponents != null) {
            Sheet activeSheet = this.getActiveSheet();
            for (Integer row : this.rowsWithComponents) {
                if (rowsWithComponents.contains(row)) continue;
                if (this.isRowHidden(row)) {
                    _rowH[row.intValue()] = 0.0f;
                    continue;
                }
                Row r = activeSheet.getRow(row.intValue());
                if (r == null) {
                    _rowH[row.intValue()] = activeSheet.getDefaultRowHeightInPoints();
                    continue;
                }
                _rowH[row.intValue()] = r.getHeightInPoints();
            }
        }
        this.setRowH(_rowH);
        this.rowsWithComponents = rowsWithComponents;
    }

    private boolean isCellVisible(int row, int col) {
        int verticalSplitPosition = this.getLastFrozenRow();
        int horizontalSplitPosition = this.getLastFrozenColumn();
        return col >= this.firstColumn && col <= this.lastColumn && row >= this.firstRow && row <= this.lastRow || col >= 1 && col <= horizontalSplitPosition && row >= 1 && row <= verticalSplitPosition || col >= this.firstColumn && col <= this.lastColumn && row >= 1 && row <= verticalSplitPosition || col >= 1 && col <= horizontalSplitPosition && row >= this.firstRow && row <= this.lastRow;
    }

    private void registerPopupButton(PopupButton button) {
        this.attachedPopupButtons.add(button);
        this.registerCustomComponent(button);
        if (!this.getElement().equals((Object)button.getElement().getParent())) {
            this.getElement().appendVirtualChild(new Element[]{button.getElement()});
        }
    }

    private void unRegisterPopupButton(PopupButton button) {
        this.attachedPopupButtons.remove((Object)button);
        this.unRegisterCustomComponent(button);
        if (this.getElement().equals((Object)button.getElement().getParent())) {
            this.getElement().removeVirtualChild(new Element[]{button.getElement()});
        }
    }

    private void registerCustomComponent(PopupButton component) {
        this.getElement().callJsFunction("addPopupButton", new Serializable[]{Serializer.serialize(component.getState())});
    }

    private void registerCustomComponent(Component component) {
        if (!this.equals(component.getParent())) {
            // empty if block
        }
    }

    private void unRegisterCustomComponent(PopupButton component) {
        this.getElement().callJsFunction("removePopupButton", new Serializable[]{Serializer.serialize(component.getState())});
    }

    private void unRegisterCustomComponent(Component component) {
    }

    void setSpreadsheetComponentFactory(SpreadsheetComponentFactory customComponentFactory) {
        this.customComponentFactory = customComponentFactory;
        if (this.firstRow != -1) {
            this.loadCustomComponents();
            this.loadCustomEditorOnSelectedCell();
        } else {
            this.setCellKeysToEditorIdMap(null);
            if (this.customComponents != null && !this.customComponents.isEmpty()) {
                for (Component c : this.customComponents) {
                    this.unRegisterCustomComponent(c);
                }
                this.customComponents.clear();
            }
        }
    }

    SpreadsheetComponentFactory getSpreadsheetComponentFactory() {
        return this.customComponentFactory;
    }

    public void setPopup(String cellAddress, PopupButton popupButton) {
        this.setPopup(new CellReference(cellAddress), popupButton);
    }

    public void setPopup(int row, int col, PopupButton popupButton) {
        this.setPopup(new CellReference(row, col), popupButton);
    }

    public void setPopup(CellReference cellReference, PopupButton popupButton) {
        this.removePopupButton(cellReference);
        if (popupButton != null) {
            CellReference absoluteCellReference = SpreadsheetUtil.relativeToAbsolute(this, cellReference);
            popupButton.setCellReference(absoluteCellReference);
            this.sheetPopupButtons.put(absoluteCellReference, popupButton);
            if (this.isCellVisible(absoluteCellReference.getRow() + 1, absoluteCellReference.getCol() + 1)) {
                this.registerPopupButton(popupButton);
                this.markAsDirty();
            }
        }
    }

    private void removePopupButton(CellReference cellReference) {
        CellReference absoluteCellReference = SpreadsheetUtil.relativeToAbsolute(this, cellReference);
        PopupButton oldButton = this.sheetPopupButtons.get(absoluteCellReference);
        if (oldButton != null) {
            this.unRegisterPopupButton(oldButton);
            this.sheetPopupButtons.remove(absoluteCellReference);
            this.markAsDirty();
        }
    }

    private void loadPopupButtons() {
        if (this.sheetPopupButtons != null) {
            for (PopupButton popupButton : this.sheetPopupButtons.values()) {
                if (!this.getActiveSheet().getSheetName().equals(popupButton.getCellReference().getSheetName())) continue;
                int column = popupButton.getColumn() + 1;
                int row = popupButton.getRow() + 1;
                if (this.isCellVisible(row, column)) {
                    this.registerPopupButton(popupButton);
                    continue;
                }
                this.unRegisterPopupButton(popupButton);
            }
        }
    }

    public void registerTable(SpreadsheetTable table) {
        this.tables.add(table);
        if (table instanceof SpreadsheetFilterTable) {
            this.updateAutofittedColumns((SpreadsheetFilterTable)table);
        }
    }

    private void updateAutofittedColumns(SpreadsheetFilterTable table) {
        Sheet filteredSheet = table.getSheet();
        CellRangeAddress fullTableRegion = table.getFullTableRegion();
        int firstColumn = fullTableRegion.getFirstColumn();
        int lastColumn = fullTableRegion.getLastColumn();
        for (int i = firstColumn; i <= lastColumn; ++i) {
            CellReference cr = new CellReference(filteredSheet.getSheetName(), 0, i, true, true);
            if (!this.autofittedColumnWidths.containsKey(cr)) continue;
            Integer autofittedWidth = this.autofittedColumnWidths.get(cr);
            int currentWidth = (int)filteredSheet.getColumnWidthInPixels((int)cr.getCol());
            if (currentWidth != autofittedWidth) continue;
            this.autofitColumn(cr.getCol());
        }
    }

    public void unregisterTable(SpreadsheetTable table) {
        this.tables.remove(table);
    }

    public void deleteTable(SpreadsheetTable table) {
        this.unregisterTable(table);
        if (table.isTableSheetCurrentlyActive()) {
            for (PopupButton popupButton : table.getPopupButtons()) {
                this.removePopupButton(popupButton.getCellReference());
            }
            if (table instanceof SpreadsheetFilterTable) {
                ((SpreadsheetFilterTable)table).clearAllFilters();
            }
            table.clear();
        }
    }

    public HashSet<SpreadsheetTable> getTables() {
        return this.tables;
    }

    public List<SpreadsheetTable> getTablesForActiveSheet() {
        ArrayList<SpreadsheetTable> temp = new ArrayList<SpreadsheetTable>();
        for (SpreadsheetTable table : this.tables) {
            if (!table.getSheet().equals(this.getActiveSheet())) continue;
            temp.add(table);
        }
        return temp;
    }

    private void loadTables() {
        if (!this.tablesLoaded) {
            for (SpreadsheetTable table : this.tables) {
                if (!table.getSheet().equals(this.getActiveSheet())) continue;
                table.reload();
            }
            this.tablesLoaded = true;
        }
    }

    public final String getCellValue(Cell cell) {
        return this.valueManager.getDataFormatter().formatCellValue(cell, this.valueManager.getFormulaEvaluator(), this.getConditionalFormattingEvaluator());
    }

    public boolean isGridlinesVisible() {
        if (this.getActiveSheet() != null) {
            return this.getActiveSheet().isDisplayGridlines();
        }
        return true;
    }

    public void setGridlinesVisible(boolean visible) {
        if (this.getActiveSheet() == null) {
            throw new NullPointerException("no active sheet");
        }
        this.getActiveSheet().setDisplayGridlines(visible);
        this.setDisplayGridlines(visible);
    }

    public boolean isRowColHeadingsVisible() {
        if (this.getActiveSheet() != null) {
            return this.getActiveSheet().isDisplayRowColHeadings();
        }
        return true;
    }

    public void setRowColHeadingsVisible(boolean visible) {
        if (this.getActiveSheet() == null) {
            throw new NullPointerException("no active sheet");
        }
        this.getActiveSheet().setDisplayRowColHeadings(visible);
        this.setDisplayRowColHeadings(visible);
    }

    private static Set<CellReference> getAllSelectedCells(CellReference selectedCellReference, List<CellReference> individualSelectedCells, List<CellRangeAddress> cellRangeAddresses) {
        HashSet<CellReference> cells = new HashSet<CellReference>();
        for (CellReference r : individualSelectedCells) {
            cells.add(r);
        }
        cells.add(selectedCellReference);
        if (cellRangeAddresses != null) {
            for (CellRangeAddress a : cellRangeAddresses) {
                for (int x = a.getFirstColumn(); x <= a.getLastColumn(); ++x) {
                    for (int y = a.getFirstRow(); y <= a.getLastRow(); ++y) {
                        cells.add(new CellReference(y, x));
                    }
                }
            }
        }
        return cells;
    }

    public Registration addSelectionChangeListener(SelectionChangeListener listener) {
        return this.addListener(SelectionChangeEvent.class, listener::onSelectionChange);
    }

    public Registration addCellValueChangeListener(CellValueChangeListener listener) {
        return this.addListener(CellValueChangeEvent.class, listener::onCellValueChange);
    }

    public Registration addFormulaValueChangeListener(FormulaValueChangeListener listener) {
        return this.addListener(FormulaValueChangeEvent.class, listener::onFormulaValueChange);
    }

    public Registration addProtectedEditListener(ProtectedEditListener listener) {
        return this.addListener(ProtectedEditEvent.class, listener::writeAttempted);
    }

    public void createFreezePane(int rowSplit, int colSplit) {
        this.getActiveSheet().createFreezePane(colSplit, rowSplit);
        SpreadsheetFactory.loadFreezePane(this);
        this.reloadActiveSheetData();
    }

    public void removeFreezePane() {
        PaneInformation paneInformation = this.getActiveSheet().getPaneInformation();
        if (paneInformation != null && paneInformation.isFreezePane()) {
            this.getActiveSheet().createFreezePane(0, 0);
            SpreadsheetFactory.loadFreezePane(this);
            this.reloadActiveSheetData();
        }
    }

    public CellReference getSelectedCellReference() {
        return this.selectionManager.getSelectedCellReference();
    }

    public Set<CellReference> getSelectedCellReferences() {
        SelectionChangeEvent event = this.selectionManager.getLatestSelectionEvent();
        if (event == null) {
            return new HashSet<CellReference>();
        }
        return event.getAllSelectedCells();
    }

    public Registration addSheetChangeListener(SheetChangeListener listener) {
        return this.addListener(SheetChangeEvent.class, listener::onSheetChange);
    }

    private void fireSheetChangeEvent(Sheet previousSheet, Sheet newSheet) {
        int newSheetPOIIndex = this.workbook.getActiveSheetIndex();
        this.fireEvent(new SheetChangeEvent(this, newSheet, previousSheet, this.getSpreadsheetSheetIndex(newSheetPOIIndex), newSheetPOIIndex));
    }

    protected void onConnectorInit() {
        this.reloadCellDataOnNextScroll = true;
        this.valueManager.clearCachedContent();
    }

    public void reload() {
        this.setWorkbook(this.getWorkbook());
    }

    public void setStatusLabelValue(String value) {
        this.setInfoLabelValue(value);
    }

    public String getStatusLabelValue() {
        return this.getInfoLabelValue();
    }

    public void setSelection(int row, int col) {
        this.setSelectionRange(row, col, row, col);
    }

    public void setSelectionRange(int row1, int col1, int row2, int col2) {
        CellRangeAddress cra = new CellRangeAddress(row1, row2, col1, col2);
        this.selectionManager.handleCellRangeSelection(cra);
    }

    public void setSelection(String selectionRange) {
        this.selectionManager.handleCellRangeSelection(SpreadsheetUtil.getRangeForReference(selectionRange, this, true));
    }

    public ConditionalFormatter getConditionalFormatter() {
        return this.conditionalFormatter;
    }

    public void reset() {
        SpreadsheetFactory.loadNewXLSXSpreadsheet(this);
    }

    public String getDefaultPercentageFormat() {
        return this.defaultPercentageFormat;
    }

    public void setDefaultPercentageFormat(String defaultPercentageFormat) {
        this.defaultPercentageFormat = defaultPercentageFormat;
    }

    public void setCommentAuthorProvider(CommentAuthorProvider commentAuthorProvider) {
        this.commentAuthorProvider = commentAuthorProvider;
    }

    public CommentAuthorProvider getCommentAuthorProvider() {
        return this.commentAuthorProvider;
    }

    public void editCellComment(CellReference cr) {
        this.getRpcProxy().editCellComment(cr.getCol(), cr.getRow());
    }

    public void setFunctionBarVisible(boolean functionBarVisible) {
        if (functionBarVisible) {
            this.removeClassName(HIDE_FUNCTION_BAR_STYLE);
        } else {
            this.addClassName(HIDE_FUNCTION_BAR_STYLE);
        }
    }

    public boolean isFunctionBarVisible() {
        return !this.getClassNames().contains((Object)HIDE_FUNCTION_BAR_STYLE);
    }

    public void setSheetSelectionBarVisible(boolean sheetSelectionBarVisible) {
        if (sheetSelectionBarVisible) {
            this.removeClassName(HIDE_TABSHEET_STYLE);
        } else {
            this.addClassName(HIDE_TABSHEET_STYLE);
        }
    }

    public boolean isSheetSelectionBarVisible() {
        return !this.getClassNames().contains((Object)HIDE_TABSHEET_STYLE);
    }

    public void setReportStyle(boolean reportStyle) {
        this.setFunctionBarVisible(!reportStyle);
        this.setSheetSelectionBarVisible(!reportStyle);
    }

    public boolean isReportStyle() {
        return !this.isSheetSelectionBarVisible() && !this.isFunctionBarVisible();
    }

    public void setInvalidFormulaErrorMessage(String invalidFormulaErrorMessage) {
        this.getElement().setProperty("invalidFormulaErrorMessage", invalidFormulaErrorMessage);
    }

    protected void setGroupingCollapsed(boolean isCols, int index, boolean collapsed) {
        XSSFSheet activeSheet = (XSSFSheet)this.getActiveSheet();
        if (isCols) {
            if (collapsed) {
                GroupingUtil.collapseColumn(activeSheet, index);
            } else {
                short expandLevel = GroupingUtil.expandColumn(activeSheet, index);
                this.updateExpandedRegion(activeSheet, index, expandLevel);
            }
        } else if (collapsed) {
            GroupingUtil.collapseRow(activeSheet, index);
        } else {
            GroupingUtil.expandRow(activeSheet, index);
        }
        SpreadsheetFactory.calculateSheetSizes(this, (Sheet)activeSheet);
        SpreadsheetFactory.loadGrouping(this);
        this.reloadActiveSheetStyles();
        if (this.hasSheetOverlays()) {
            this.reloadImageSizesFromPOI = true;
            this.loadOrUpdateOverlays();
        }
        this.updateMarkedCells();
    }

    private void updateExpandedRegion(XSSFSheet sheet, int columnIndex, int expandLevel) {
        if (expandLevel < 0) {
            return;
        }
        int endIndex = -1;
        for (GroupingData data : this.getColGroupingData()) {
            if (data.level != expandLevel || data.startIndex > columnIndex || columnIndex > data.endIndex) continue;
            endIndex = data.endIndex;
            break;
        }
        if (endIndex < 0) {
            return;
        }
        int firstRowNum = sheet.getFirstRowNum();
        int lastRowNum = sheet.getLastRowNum();
        for (int r = firstRowNum; r <= lastRowNum; ++r) {
            XSSFRow row = sheet.getRow(r);
            if (row == null) continue;
            for (int c = columnIndex; c <= endIndex; ++c) {
                Cell cell = row.getCell(c);
                if (cell == null) continue;
                this.valueManager.markCellForUpdate(cell);
            }
        }
    }

    protected void levelHeaderClicked(boolean isCols, int level) {
        if (this.getActiveSheet() instanceof HSSFSheet) {
            return;
        }
        XSSFSheet xsheet = (XSSFSheet)this.getActiveSheet();
        CTWorksheet ctWorksheet = xsheet.getCTWorksheet();
        if (isCols) {
            CTCols ctCols = (CTCols)ctWorksheet.getColsList().get(0);
            List colList = ctCols.getColList();
            for (CTCol col : colList) {
                short l = col.getOutlineLevel();
                if (l >= 0 && l < level) {
                    if (!col.isSetHidden()) continue;
                    col.unsetHidden();
                    continue;
                }
                col.setHidden(true);
            }
        } else {
            short lastlevel = 0;
            for (int i = 0; i < this.getRows(); ++i) {
                XSSFRow row = xsheet.getRow(i);
                if (row == null) {
                    lastlevel = 0;
                    continue;
                }
                short l = row.getCTRow().getOutlineLevel();
                if (l == lastlevel) continue;
                int end = (int)GroupingUtil.findEndOfRowGroup(this, i, row, l);
                long uniqueIndex = GroupingUtil.findUniqueRowIndex(this, i, end, l);
                if (l > 0 && l < level) {
                    GroupingUtil.expandRow(xsheet, (int)uniqueIndex);
                } else if (l >= level) {
                    GroupingUtil.collapseRow(xsheet, (int)uniqueIndex);
                }
                lastlevel = l;
            }
        }
        SpreadsheetFactory.reloadSpreadsheetComponent(this, this.workbook);
    }

    void markInvalidFormula(int col, int row) {
        int activeSheetIndex = this.workbook.getActiveSheetIndex();
        if (!this.invalidFormulas.containsKey(activeSheetIndex)) {
            this.invalidFormulas.put(activeSheetIndex, new HashSet());
        }
        this.invalidFormulas.get(activeSheetIndex).add(SpreadsheetUtil.toKey(col, row));
    }

    boolean isMarkedAsInvalidFormula(int col, int row) {
        int activeSheetIndex = this.workbook.getActiveSheetIndex();
        if (this.invalidFormulas.containsKey(activeSheetIndex)) {
            return this.invalidFormulas.get(activeSheetIndex).contains(SpreadsheetUtil.toKey(col, row));
        }
        return false;
    }

    void removeInvalidFormulaMark(int col, int row) {
        int activeSheetIndex = this.workbook.getActiveSheetIndex();
        if (this.invalidFormulas.containsKey(activeSheetIndex)) {
            this.invalidFormulas.get(activeSheetIndex).remove(SpreadsheetUtil.toKey(col, row));
        }
    }

    public void addSheetOverlay(SheetOverlayWrapper image) {
        this.sheetOverlays.add(image);
    }

    public int getMinimumRowHeightForComponents() {
        return this.minimumRowHeightForComponents;
    }

    public void setMinimumRowHeightForComponents(int minimumRowHeightForComponents) {
        this.minimumRowHeightForComponents = minimumRowHeightForComponents;
    }

    protected void onRowHeaderDoubleClick(int rowIndex) {
        this.fireRowHeaderDoubleClick(rowIndex);
    }

    private void fireRowHeaderDoubleClick(int rowIndex) {
        this.fireEvent(new RowHeaderDoubleClickEvent(this, rowIndex));
    }

    public Registration addRowHeaderDoubleClickListener(RowHeaderDoubleClickListener listener) {
        return this.addListener(RowHeaderDoubleClickEvent.class, listener::onRowHeaderDoubleClick);
    }

    static {
        VaadinService service = VaadinService.getCurrent();
        Properties properties = new Properties();
        try {
            properties.load(Spreadsheet.class.getResourceAsStream("spreadsheet.properties"));
        }
        catch (Exception e) {
            LOGGER.warn("Unable to read Spreadsheet properties file", (Throwable)e);
            throw new ExceptionInInitializerError(e);
        }
        String version = properties.getProperty("spreadsheet.version");
        if (service != null && !service.getDeploymentConfiguration().isProductionMode()) {
            LicenseChecker.checkLicenseFromStaticBlock((String)"vaadin-spreadsheet-flow", (String)version);
        }
    }

    public static interface RowHeaderDoubleClickListener
    extends Serializable {
        public static final Method ON_ROW_ON_ROW_HEADER_DOUBLE_CLICK = ReflectTools.findMethod(RowHeaderDoubleClickListener.class, "onRowHeaderDoubleClick", RowHeaderDoubleClickEvent.class);

        public void onRowHeaderDoubleClick(RowHeaderDoubleClickEvent var1);
    }

    public static class RowHeaderDoubleClickEvent
    extends ComponentEvent<Component> {
        private final int rowIndex;

        public RowHeaderDoubleClickEvent(Component source, int row) {
            super(source, false);
            this.rowIndex = row;
        }

        public int getRowIndex() {
            return this.rowIndex;
        }
    }

    public static interface CommentAuthorProvider
    extends Serializable {
        public String getAuthorForComment(CellReference var1);
    }

    public static interface SheetChangeListener
    extends Serializable {
        public static final Method SHEET_CHANGE_METHOD = ReflectTools.findMethod(SheetChangeListener.class, "onSheetChange", SheetChangeEvent.class);

        public void onSheetChange(SheetChangeEvent var1);
    }

    public static class SheetChangeEvent
    extends ComponentEvent<Component> {
        private final Sheet newSheet;
        private final Sheet previousSheet;
        private final int newSheetVisibleIndex;
        private final int newSheetPOIIndex;

        public SheetChangeEvent(Component source, Sheet newSheet, Sheet previousSheet, int newSheetVisibleIndex, int newSheetPOIIndex) {
            super(source, false);
            this.newSheet = newSheet;
            this.previousSheet = previousSheet;
            this.newSheetVisibleIndex = newSheetVisibleIndex;
            this.newSheetPOIIndex = newSheetPOIIndex;
        }

        public Sheet getNewSheet() {
            return this.newSheet;
        }

        public Sheet getPreviousSheet() {
            return this.previousSheet;
        }

        public int getNewSheetVisibleIndex() {
            return this.newSheetVisibleIndex;
        }

        public int getNewSheetPOIIndex() {
            return this.newSheetPOIIndex;
        }
    }

    public static interface ProtectedEditListener
    extends Serializable {
        public static final Method SELECTION_CHANGE_METHOD = ReflectTools.findMethod(ProtectedEditListener.class, "writeAttempted", ProtectedEditEvent.class);

        public void writeAttempted(ProtectedEditEvent var1);
    }

    public static class ProtectedEditEvent
    extends ComponentEvent<Component> {
        public ProtectedEditEvent(Component source) {
            super(source, false);
        }
    }

    public static interface FormulaValueChangeListener
    extends Serializable {
        public static final Method FORMULA_VALUE_CHANGE_METHOD = ReflectTools.findMethod(FormulaValueChangeListener.class, "onFormulaValueChange", FormulaValueChangeEvent.class);

        public void onFormulaValueChange(FormulaValueChangeEvent var1);
    }

    public static interface CellValueChangeListener
    extends Serializable {
        public static final Method CELL_VALUE_CHANGE_METHOD = ReflectTools.findMethod(CellValueChangeListener.class, "onCellValueChange", CellValueChangeEvent.class);

        public void onCellValueChange(CellValueChangeEvent var1);
    }

    public static interface SelectionChangeListener
    extends Serializable {
        public static final Method SELECTION_CHANGE_METHOD = ReflectTools.findMethod(SelectionChangeListener.class, "onSelectionChange", SelectionChangeEvent.class);

        public void onSelectionChange(SelectionChangeEvent var1);
    }

    public static class SelectionChangeEvent
    extends ComponentEvent<Component> {
        private final CellReference selectedCellReference;
        private final List<CellReference> individualSelectedCells;
        private final CellRangeAddress selectedCellMergedRegion;
        private final List<CellRangeAddress> cellRangeAddresses;

        public SelectionChangeEvent(Component source, CellReference selectedCellReference, List<CellReference> individualSelectedCells, CellRangeAddress selectedCellMergedRegion, List<CellRangeAddress> cellRangeAddresses) {
            super(source, false);
            this.selectedCellReference = selectedCellReference;
            this.individualSelectedCells = individualSelectedCells;
            this.selectedCellMergedRegion = selectedCellMergedRegion;
            this.cellRangeAddresses = cellRangeAddresses;
        }

        public Spreadsheet getSpreadsheet() {
            return (Spreadsheet)this.getSource();
        }

        public CellReference getSelectedCellReference() {
            return this.selectedCellReference;
        }

        public List<CellReference> getIndividualSelectedCells() {
            return this.individualSelectedCells;
        }

        public CellRangeAddress getSelectedCellMergedRegion() {
            return this.selectedCellMergedRegion;
        }

        public List<CellRangeAddress> getCellRangeAddresses() {
            return this.cellRangeAddresses;
        }

        public Set<CellReference> getAllSelectedCells() {
            return Spreadsheet.getAllSelectedCells(this.selectedCellReference, this.individualSelectedCells, this.cellRangeAddresses);
        }
    }

    public static class FormulaValueChangeEvent
    extends ValueChangeEvent {
        public FormulaValueChangeEvent(Component source, Set<CellReference> changedCells) {
            super(source, changedCells);
        }
    }

    public static class CellValueChangeEvent
    extends ValueChangeEvent {
        public CellValueChangeEvent(Component source, Set<CellReference> changedCells) {
            super(source, changedCells);
        }
    }

    public static abstract class ValueChangeEvent
    extends ComponentEvent<Component> {
        private final Set<CellReference> changedCells;

        public ValueChangeEvent(Component source, Set<CellReference> changedCells) {
            super(source, false);
            this.changedCells = changedCells;
        }

        public Set<CellReference> getChangedCells() {
            return this.changedCells;
        }
    }

    public static interface HyperlinkCellClickHandler
    extends Serializable {
        public void onHyperLinkCellClick(Cell var1, Hyperlink var2);

        public String getHyperlinkFunctionTarget(Cell var1);
    }

    public static interface CellDeletionHandler
    extends Serializable {
        public boolean cellDeleted(Cell var1, Sheet var2, int var3, int var4, FormulaEvaluator var5, DataFormatter var6, ConditionalFormattingEvaluator var7);

        public boolean individualSelectedCellsDeleted(List<CellReference> var1, Sheet var2, FormulaEvaluator var3, DataFormatter var4, ConditionalFormattingEvaluator var5);

        public boolean cellRangeDeleted(List<CellRangeAddress> var1, Sheet var2, FormulaEvaluator var3, DataFormatter var4, ConditionalFormattingEvaluator var5);
    }

    public static interface CellValueHandler
    extends Serializable {
        public boolean cellValueUpdated(Cell var1, Sheet var2, int var3, int var4, String var5, FormulaEvaluator var6, DataFormatter var7, ConditionalFormattingEvaluator var8);
    }

    @DomEvent(value="spreadsheet-event")
    public static class SpreadsheetEvent
    extends ComponentEvent<Spreadsheet> {
        private final String type;
        private final JsonValue data;

        public SpreadsheetEvent(Spreadsheet source, boolean fromClient, @EventData(value="event.detail.type") String type, @EventData(value="event.detail.data") JsonValue data) {
            super((Component)source, fromClient);
            this.type = type;
            this.data = data;
        }

        public String getType() {
            return this.type;
        }

        public JsonValue getData() {
            return this.data;
        }
    }
}

