/*
 * Copyright 2000-2026 Vaadin Ltd.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.vaadin.flow.component.slider.testbench;

import java.util.Collections;

import com.vaadin.testbench.HasClearButton;
import com.vaadin.testbench.HasHelper;
import com.vaadin.testbench.HasLabel;
import com.vaadin.testbench.HasPlaceholder;
import com.vaadin.testbench.HasValidation;
import com.vaadin.testbench.TestBenchElement;
import com.vaadin.testbench.elementsbase.Element;

/**
 * A TestBench element representing a <code>&lt;vaadin-slider&gt;</code>
 * element.
 */
@Element("vaadin-slider")
public class SliderElement extends TestBenchElement implements HasLabel,
        HasPlaceholder, HasHelper, HasClearButton, HasValidation {

    /**
     * Sets the value of the slider, emulating user input. The emulation is done
     * by setting the value property to the given value and then triggering
     * synthetic {@code input} and {@code change} DOM events to synchronize the
     * value with the server side.
     */
    public void setValue(double value) {
        setProperty("value", value);
        dispatchEvent("input", Collections.singletonMap("bubbles", true));
        dispatchEvent("change", Collections.singletonMap("bubbles", true));
    }

    /**
     * Gets the current value of the slider.
     *
     * @return the current value
     */
    public double getValue() {
        return getPropertyDouble("value");
    }

    /**
     * Gets the minimum value of the slider.
     *
     * @return the minimum value
     */
    public double getMin() {
        return getPropertyDouble("min");
    }

    /**
     * Gets the maximum value of the slider.
     *
     * @return the maximum value
     */
    public double getMax() {
        return getPropertyDouble("max");
    }

    /**
     * Gets the step value of the slider.
     *
     * @return the step value
     */
    public double getStep() {
        return getPropertyDouble("step");
    }
}
