/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.slider;

import com.vaadin.experimental.FeatureFlags;
import com.vaadin.flow.component.AbstractField;
import com.vaadin.flow.component.AbstractSinglePropertyField;
import com.vaadin.flow.component.AttachEvent;
import com.vaadin.flow.component.Focusable;
import com.vaadin.flow.component.KeyNotifier;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.shared.HasValidationProperties;
import com.vaadin.flow.component.shared.InputField;
import com.vaadin.flow.component.slider.ExperimentalFeatureException;
import com.vaadin.flow.component.slider.SliderFeatureFlagProvider;
import com.vaadin.flow.function.SerializableBiFunction;
import com.vaadin.flow.server.VaadinContext;

abstract class SliderBase<TComponent extends SliderBase<TComponent, TValue>, TValue>
extends AbstractSinglePropertyField<TComponent, TValue>
implements InputField<AbstractField.ComponentValueChangeEvent<TComponent, TValue>, TValue>,
HasValidationProperties,
Focusable<TComponent>,
KeyNotifier {
    <TPresentation> SliderBase(double min, double max, double step, TValue value, Class<TPresentation> presentationType, SerializableBiFunction<TComponent, TPresentation, TValue> presentationToModel, SerializableBiFunction<TComponent, TValue, TPresentation> modelToPresentation) {
        super("value", null, presentationType, presentationToModel, modelToPresentation);
        this.setSynchronizedEvent("change");
        this.getElement().setProperty("manualValidation", true);
        this.setInvalid(false);
        this.setValue(value, min, max, step);
    }

    protected void onAttach(AttachEvent attachEvent) {
        super.onAttach(attachEvent);
        this.checkFeatureFlag(attachEvent.getUI());
    }

    private void checkFeatureFlag(UI ui) {
        FeatureFlags featureFlags = FeatureFlags.get((VaadinContext)ui.getSession().getService().getContext());
        boolean enabled = featureFlags.isEnabled(SliderFeatureFlagProvider.SLIDER_COMPONENT);
        if (!enabled) {
            throw new ExperimentalFeatureException();
        }
    }

    double getMinDouble() {
        return this.getElement().getProperty("min", 0.0);
    }

    double getMaxDouble() {
        return this.getElement().getProperty("max", 100.0);
    }

    double getStepDouble() {
        return this.getElement().getProperty("step", 1.0);
    }

    void setMinDouble(double min) {
        this.getElement().setProperty("min", min);
    }

    void setMaxDouble(double max) {
        this.getElement().setProperty("max", max);
    }

    void setStepDouble(double step) {
        this.getElement().setProperty("step", step);
    }

    public void setValue(TValue value) {
        this.setValue(value, this.getMinDouble(), this.getMaxDouble(), this.getStepDouble());
    }

    public void setValue(TValue value, double min, double max) {
        this.setValue(value, min, max, this.getStepDouble());
    }

    public void setValue(TValue value, double min, double max, double step) {
        this.requireValidStep(step);
        this.requireValidMinMax(min, max);
        this.requireValidValue(min, max, step, value);
        this.setMinDouble(min);
        this.setMaxDouble(max);
        this.setStepDouble(step);
        super.setValue(value);
    }

    void requireValidMinMax(double min, double max) {
        if (min > max) {
            throw new IllegalArgumentException("Max must be greater than or equal to min");
        }
    }

    void requireValidStep(double step) {
        if (step <= 0.0) {
            throw new IllegalArgumentException("Step must be positive");
        }
    }

    void requireValidValue(TValue value) {
        this.requireValidValue(this.getMinDouble(), this.getMaxDouble(), this.getStepDouble(), value);
    }

    abstract void requireValidValue(double var1, double var3, double var5, TValue var7);
}

