/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.slider;

import com.vaadin.flow.component.AbstractField;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.dependency.JsModule;
import com.vaadin.flow.component.dependency.NpmPackage;
import com.vaadin.flow.component.slider.SliderBase;
import com.vaadin.flow.function.SerializableBiFunction;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Objects;

@Tag(value="vaadin-slider")
@NpmPackage(value="@vaadin/slider", version="25.1.0-alpha6")
@JsModule(value="@vaadin/slider/src/vaadin-slider.js")
public class Slider
extends SliderBase<Slider, Double> {
    private static final double DEFAULT_MIN = 0.0;
    private static final double DEFAULT_MAX = 100.0;
    private static final double DEFAULT_STEP = 1.0;
    private static final SerializableBiFunction<Slider, Double, Double> PARSER = (SerializableBiFunction & Serializable)(component, value) -> {
        try {
            component.requireValidValue(value);
        }
        catch (IllegalArgumentException | NullPointerException e) {
            return (Double)component.getValue();
        }
        return value;
    };
    private static final SerializableBiFunction<Slider, Double, Double> FORMATTER = (SerializableBiFunction & Serializable)(component, value) -> {
        component.requireValidValue(value);
        return value;
    };

    public Slider() {
        this(0.0, 100.0, 1.0, 0.0);
    }

    public Slider(HasValue.ValueChangeListener<? super AbstractField.ComponentValueChangeEvent<Slider, Double>> listener) {
        this(0.0, 100.0, 1.0, 0.0, listener);
    }

    public Slider(double min, double max, double value) {
        this(min, max, 1.0, value);
    }

    public Slider(double min, double max, double value, HasValue.ValueChangeListener<? super AbstractField.ComponentValueChangeEvent<Slider, Double>> listener) {
        this(min, max, 1.0, value, listener);
    }

    public Slider(double min, double max, double step, double value) {
        super(min, max, step, value, Double.class, PARSER, FORMATTER);
    }

    public Slider(double min, double max, double step, double value, HasValue.ValueChangeListener<? super AbstractField.ComponentValueChangeEvent<Slider, Double>> listener) {
        this(min, max, step, value);
        this.addValueChangeListener(listener);
    }

    public Slider(String label) {
        this();
        this.setLabel(label);
    }

    public Slider(String label, HasValue.ValueChangeListener<? super AbstractField.ComponentValueChangeEvent<Slider, Double>> listener) {
        this(listener);
        this.setLabel(label);
    }

    public Slider(String label, double min, double max, double value) {
        this(min, max, value);
        this.setLabel(label);
    }

    public Slider(String label, double min, double max, double value, HasValue.ValueChangeListener<? super AbstractField.ComponentValueChangeEvent<Slider, Double>> listener) {
        this(min, max, value, listener);
        this.setLabel(label);
    }

    public Slider(String label, double min, double max, double step, double value) {
        this(min, max, step, value);
        this.setLabel(label);
    }

    public Slider(String label, double min, double max, double step, double value, HasValue.ValueChangeListener<? super AbstractField.ComponentValueChangeEvent<Slider, Double>> listener) {
        this(min, max, step, value, listener);
        this.setLabel(label);
    }

    public double getMin() {
        return super.getMinDouble();
    }

    public void setMin(double min) {
        this.requireValidMinMax(min, this.getMax());
        this.setMinDouble(min);
        double adjustedValue = Math.max((Double)this.getValue(), min);
        this.setValue((Object)adjustedValue);
    }

    public double getMax() {
        return super.getMaxDouble();
    }

    public void setMax(double max) {
        this.requireValidMinMax(this.getMin(), max);
        this.setMaxDouble(max);
        double adjustedValue = Math.min((Double)this.getValue(), max);
        this.setValue((Object)adjustedValue);
    }

    public double getStep() {
        return super.getStepDouble();
    }

    public void setStep(double step) {
        this.requireValidStep(step);
        this.setStepDouble(step);
        BigDecimal minBd = BigDecimal.valueOf(this.getMin());
        BigDecimal maxBd = BigDecimal.valueOf(this.getMax());
        BigDecimal stepBd = BigDecimal.valueOf(step);
        BigDecimal valueBd = BigDecimal.valueOf((Double)this.getValue());
        BigDecimal stepsFromMinBd = valueBd.subtract(minBd).divide(stepBd, 0, RoundingMode.HALF_UP);
        BigDecimal adjustedValue = minBd.add(stepsFromMinBd.multiply(stepBd)).min(maxBd);
        this.setValue((Object)adjustedValue.doubleValue());
    }

    public void clear() {
        this.setValue((Object)this.getMin());
    }

    @Override
    void requireValidValue(double min, double max, double step, Double value) {
        Objects.requireNonNull(value, "Value cannot be null");
        if (value < min || value > max) {
            throw new IllegalArgumentException("Value must be between min and max");
        }
        if (BigDecimal.valueOf(value).remainder(BigDecimal.valueOf(step)).compareTo(BigDecimal.ZERO) != 0) {
            throw new IllegalArgumentException("Value is not aligned with step");
        }
    }
}

