/*
 * Copyright (C) 2000-2026 Vaadin Ltd
 *
 * This program is available under Vaadin Commercial License and Service Terms.
 *
 * See <https://vaadin.com/commercial-license-and-service-terms> for the full
 * license.
 */
package com.vaadin.osgi.resources;

/**
 * Used to declare a Vaadin Widgetset for use in OSGi. The widgetset is expected
 * to be in the same OSGi bundle as the class implementing this interface, under
 * the path "/VAADIN/widgetsets/{widgetsetName}" where {widgetsetName} is what
 * is returned by {@link OsgiVaadinWidgetset#getName()}.
 * <p>
 * To publish a widgetset, an implementation of this interface needs to be
 * registered as an OSGi service, which makes
 * <code>VaadinResourceTrackerComponent</code> automatically publish the
 * widgetset with the given name.
 *
 * @author Vaadin Ltd.
 *
 * @since 8.1
 */
public interface OsgiVaadinWidgetset extends OsgiVaadinResource {
    /**
     * Return the widgetset name to publish for OSGi.
     *
     * @return widgetset name, not null
     */
    @Override
    public String getName();

    public static OsgiVaadinWidgetset create(final String name) {
        return new OsgiVaadinWidgetset() {
            @Override
            public String getName() {
                return name;
            }
        };
    }
}
