/*
 * Copyright (C) 2000-2026 Vaadin Ltd
 *
 * This program is available under Vaadin Commercial License and Service Terms.
 *
 * See <https://vaadin.com/commercial-license-and-service-terms> for the full
 * license.
 */
package com.vaadin.shared.ui.dnd;

import java.io.Serializable;

/**
 * Contains parameters of a file. Used for transferring information about
 * dropped files from the client to the server.
 *
 * @author Vaadin Ltd
 * @since 8.1
 */
public class FileParameters implements Serializable {
    private String name;
    private long size;
    private String mime;

    /**
     * Creates a file parameters object.
     */
    public FileParameters() {
    }

    /**
     * Creates a file parameters object.
     *
     * @param name
     *            Name of the file.
     * @param size
     *            Size of the file.
     * @param mime
     *            Mime type of the file.
     */
    public FileParameters(String name, long size, String mime) {
        this.name = name;
        this.size = size;
        this.mime = mime;
    }

    /**
     * Gets the file name.
     *
     * @return Name of the file.
     */
    public String getName() {
        return name;
    }

    /**
     * Sets the file name.
     *
     * @param name
     *            Name of the file.
     */
    public void setName(String name) {
        this.name = name;
    }

    /**
     * Gets the file size.
     *
     * @return Size of the file.
     */
    public long getSize() {
        return size;
    }

    /**
     * Sets the file size.
     *
     * @param size
     *            Size of the file.
     */
    public void setSize(long size) {
        this.size = size;
    }

    /**
     * Gets the mime type.
     *
     * @return Mime type of the file.
     */
    public String getMime() {
        return mime;
    }

    /**
     * Sets the mime type.
     *
     * @param mime
     *            Mime type of the file.
     */
    public void setMime(String mime) {
        this.mime = mime;
    }
}
