/*
 * Copyright (C) 2000-2026 Vaadin Ltd
 *
 * This program is available under Vaadin Commercial License and Service Terms.
 *
 * See <https://vaadin.com/commercial-license-and-service-terms> for the full
 * license.
 */
package com.vaadin.shared.ui.dnd;

import java.util.Map;

import com.vaadin.shared.communication.ServerRpc;

/**
 * RPC for requesting upload URLs for files dropped on the file drop target.
 *
 * @author Vaadin Ltd
 * @since 8.1
 */
public interface FileDropTargetRpc extends ServerRpc {

    /**
     * Called when files are dropped onto the file drop target.
     *
     * @param fileParams
     *            Generated file IDs and file parameters of dropped files.
     */
    public void drop(Map<String, FileParameters> fileParams);

    /**
     * Called to poll the server for changes when the upload is complete.
     */
    public void poll();
}
