/*
 * Copyright (C) 2000-2026 Vaadin Ltd
 *
 * This program is available under Vaadin Commercial License and Service Terms.
 *
 * See <https://vaadin.com/commercial-license-and-service-terms> for the full
 * license.
 */
package com.vaadin.shared.ui.dnd;

import java.util.Map;

import com.vaadin.shared.communication.ClientRpc;

/**
 * RPC for sending the upload URLs to the client for uploading files.
 *
 * @author Vaadin Ltd
 * @since 8.1
 */
public interface FileDropTargetClientRpc extends ClientRpc {

    /**
     * Sends the of upload URLs mapped to the generated file ID.
     *
     * @param urls
     *            File IDs and URLs for uploading files to the server.
     */
    void sendUploadUrl(Map<String, String> urls);
}
