/*
 * Copyright (C) 2000-2026 Vaadin Ltd
 *
 * This program is available under Vaadin Commercial License and Service Terms.
 *
 * See <https://vaadin.com/commercial-license-and-service-terms> for the full
 * license.
 */
package com.vaadin.osgi.resources;

/**
 * Used to declare a Vaadin Resource for use in OSGi. The resource is expected
 * to be in the same OSGi bundle as the class implementing this interface, under
 * the path "/VAADIN/{resourceName}" where {resourceName} is what is returned by
 * {@link OsgiVaadinResource#getName()}.
 * <p>
 * To publish a resource, an implementation of this interface needs to be
 * registered as an OSGi service, which makes
 * <code>VaadinResourceTrackerComponent</code> automatically publish the
 * resource with the given name.
 *
 * @since 8.6.0
 */
public interface OsgiVaadinResource {
    /**
     * Return the theme name to publish for OSGi.
     *
     * @return theme name, not null
     */
    String getName();

    public static OsgiVaadinResource create(final String name) {
        return new OsgiVaadinResource() {
            @Override
            public String getName() {
                return name;
            }
        };
    }
}
